/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetJobDetailTableDefineBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridHeaderJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for get header list
 * 
 * @version 1.0
 * @since 2011/12/14
 **/
public class GetJobDetailTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -6712416036223172058L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetJobDetailTableDefineServlet.class);

    /**
     * Get header list
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        // 中間変数を宣言
        CommonJson result = new CommonJson();
        try {
            ArrayList<TableColumnInfoJs> tblDefine = doLoadTableDefine(request
                    .getLocale());

            setModelProperties(tblDefine);

            result = doConvertToJson(tblDefine);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        return result;
    }

    /**
     * Get header list
     * 
     * @return ArrayList<TableColumnInfoJs>
     * @throws HinemosWebHeaderInvalidException
     * @throws IOException
     */
    private ArrayList<TableColumnInfoJs> doLoadTableDefine(Locale locale)
            throws HinemosWebException {
        return new GetJobDetailTableDefineBusiness()
                .getJobDetailTableDefine(locale);
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        tblDefine.get(JobDetailTableDefine.TREE).setClasses(
                CssClass.GRID_TREE_ONLY_ICON);

        tblDefine.get(JobDetailTableDefine.STATUS).setFormatter(
                JsConstant.GRID_FMATTER_RUN_STATUS);

        tblDefine.get(JobDetailTableDefine.END_STATUS).setFormatter(
                JsConstant.GRID_FMATTER_END_STATUS);

        tblDefine.get(JobDetailTableDefine.JOB_TYPE).setFormatter(
                JsConstant.GRID_FMATTER_JOB);

        TableColumnInfoJs scope = tblDefine.get(JobDetailTableDefine.SCOPE);
        scope.setFormatter(JsConstant.GRID_FMATTER_SCOPE_TYPE);
        Map<String, Object> scopeFmtOpt = new HashMap<String, Object>();
        scopeFmtOpt.put(JsConstant.GRID_FMATTER_SCOPE_TYPE_POSITION,
                JobDetailTableDefine.FACILITY_ID);
        scope.setFormatoptions(scopeFmtOpt);

        tblDefine.get(JobDetailTableDefine.START_RERUN_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        tblDefine.get(JobDetailTableDefine.END_SUSPEND_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        // Add a column more to store key
        TableColumnInfoJs keyColumn = new TableColumnInfoJs(
                JsConstant.TREE_GRID_KEY_COLUMN_NAME, TableColumnInfoJs.NONE,
                0, SWT.LEFT, JsConstant.TREE_GRID_KEY_COLUMN_NAME, false);
        keyColumn.setKey(true);
        tblDefine.add(keyColumn);
    }

    /**
     * Convert data to JSON structure
     * 
     * @param tblDefine
     *            : ArrayList<TableColumnInfoJs>
     * @return GridHeaderJson
     */
    private GridHeaderJson doConvertToJson(
            ArrayList<TableColumnInfoJs> tblDefine) {
        GetJobDetailTableDefineBusiness business = new GetJobDetailTableDefineBusiness();
        return business.doConvertToJson(tblDefine);
    }

}