/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidRequestParameterException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetJobDetailBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.JobDetailForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for get Job Detail info
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetJobDetailServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetJobDetailServlet.class);

    /**
     * Get Job Detail info
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException 
     */
    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException, HinemosWebAccessException {

        CommonJson result = new CommonJson();
        try {
            // NammingContextを取得する
            NamingContext namingContext = doLoadNamingContext(request);

            // Get table tree
            result = doLoadListInfoData(request, namingContext);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        
        return result;
    }

    /**
     * Get Job Detail info
     * 
     * @param request
     *            : HttpServletRequest
     * @param namingContext
     *            : NamingContext
     * @return GridDataJson
     * @throws HinemosWebException
     */
    private GridDataJson doLoadListInfoData(HttpServletRequest request,
            NamingContext namingContext) throws HinemosWebException {
        //
        JobDetailForm form = new JobDetailForm();
        PopulateBeanUtils.populateBean(form, request);

        // Check parameters of request
        if (!isValidRequestParam(form)) {
            throw new HinemosWebInvalidRequestParameterException();
        }

        GetJobDetailBusiness business = new GetJobDetailBusiness();

        List<CommonTableTreeItem> listItem = business.doLoadListInfoData(form,
                namingContext);

        return doLoadDataJson(form, listItem);
    }

    /**
     * Check valid parameter
     * 
     * @param form
     *            : JobDetailForm
     * @return boolean
     */
    private boolean isValidRequestParam(JobDetailForm form) {
        boolean isValid = true;
        String sessionId = form.getSessionId();

        // Check request sessionId (manager)
        // http リクエストからユーザID判定する
        if (sessionId == null || sessionId.equals("")) {
            isValid = false;
            logUtils.error("sessionId is invalid", sessionId);
        }

        return isValid;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param form
     *            : JobDetailForm
     * @param listItem
     *            : ArrayList<CommonTableTreeItem>
     * @return GridDataJson
     */
    private GridDataJson doLoadDataJson(JobDetailForm form,
            List<CommonTableTreeItem> listItem) throws HinemosWebException {
        GetJobDetailBusiness business = new GetJobDetailBusiness();
        return business.doConvertToJson(form, listItem);
    }
}