/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.form.GridForm;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetSchedule;
import com.necsoft.hinemos.webclient.jobmanagement.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

/**
 * This class used for get Schedule
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetScheduleBusiness {

    /**
     * Get Forward File list
     * 
     * @param namingContext
     *            : NamingContext
     * @param form
     *            : GridForm
     * @return ArrayList<JobSchedule>
     * @throws HinemosWebException
     */
    public List<List<Object>> getSchedule(GridForm form,
            NamingContext namingContext) throws HinemosWebException {

        GetSchedule getSchedule = new GetSchedule();
        getSchedule.setNamingContext(namingContext);
        ArrayList<JobSchedule> listInfoData = null;
        listInfoData = getSchedule.getSchedule();

        List<List<Object>> list = ConvertListUtil
                .jobScheduleListToArrayList(listInfoData);

        doSortListInfoData(form, list);

        ConvertListUtil.sanitizeScheduleList(list);
        return list;
    }

    /**
     * Sort data
     * 
     * @param form
     *            : GridForm
     * @param listItem
     *            : ArrayList<JobSchedule>
     */
    private void doSortListInfoData(GridForm form, List<List<Object>> list) {

        // Get sorting parameter
        int sortColumnIndex = ScheduleTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = ScheduleTableDefine.SORT_ORDER;
        if (form.getSidx() != null && !("").equals(form.getSidx().trim())) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !("").equals(form.getSord().trim())) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }

        // データをソート
        Collections.sort(list, new CommonTableViewerSorter(sortColumnIndex, -1,
                sortOrder));
    }

    /**
     * Convert data to JSON structure
     * 
     * @param listInfoData
     *            : ArrayList<JobSchedule>
     * @return GridDataJson
     */
    public GridDataJson doConvertToJson(List<List<Object>> list) {
        // Create JSON
        GridDataJson result = new GridDataJson();

        // Set rows
        for (int countRow = 0; countRow < list.size();) {
            List<Object> arrData = list.get(countRow);
            result.addRow(arrData, String.valueOf(++countRow));
        }

        // Set other content
        result.setRecords(list.size());
        return result;
    }
}
