/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetRunSchedule;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetRunScheduleTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.form.RunScheduleForm;
import com.necsoft.hinemos.webclient.util.ConvertListUtil;

/**
 * This class used for get Schedule list
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetRunScheduleBusiness {

    private List<String> colNames;

    /**
     * Get Schedule list
     * 
     * @param namingContext
     *            : NamingContext
     * @param base
     *            : Date
     * @return ArrayList<ArrayList<Object>>
     * @throws HinemosWebException
     */
    public ArrayList<ArrayList<Object>> doLoadListInfoData(Date base,
            NamingContext namingContext) throws HinemosWebException {

        GetRunSchedule getRunSchedule = new GetRunSchedule();
        getRunSchedule.setNamingContext(namingContext);
        ArrayList<ArrayList<Object>> listInfoData = null;
        listInfoData = getRunSchedule.get(base);
        doSortListInfoData(listInfoData);
        return listInfoData;
    }

    /**
     * Sort data
     * 
     * @param listInfoData
     *            : ArrayList
     * @return ArrayList<JobHistory>
     */
    private void doSortListInfoData(ArrayList<ArrayList<Object>> listInfoData) {
        // Get sorting parameter
        int sortOrder = RunScheduleListTableDefine.SORT_ORDER;
        // データをソート
        Collections.sort(listInfoData, new CommonTableViewerSorter(0, -1,
                sortOrder));
    }

    /**
     * Convert data to JSON structure
     * 
     * @param form
     *            : RunScheduleForm
     * @param listInfoData
     *            : ArrayList<ArrayList<Object>>
     * @return GridDataJson
     */
    public List<Map<String, Object>> doConvertToJson(
            ArrayList<ArrayList<Object>> listInfoData, RunScheduleForm form,
            Locale locale) {
        // Create JSON
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();

        Date today = DataProcess.getToDay();

        // Set rows
        for (int countRow = 0; countRow < listInfoData.size(); countRow++) {
            List<Object> runScheduleList = listInfoData.get(countRow);
            int size = runScheduleList.size();

            Map<String, Object> rowData = new HashMap<String, Object>();

            for (int count = 0; count < size; count++) {
                Object value;
                if (count == 0) {
                    if (runScheduleList.get(0) == null) {
                        value = null;
                    } else {
                        value = StringEscapeUtils.escapeHtml(runScheduleList
                                .get(0).toString());
                    }
                } else {
                    if (runScheduleList.get(count) == null) {
                        value = null;
                    } else {
                        Date obj = (Date) runScheduleList.get(count);
                        value = DataProcess.getViewerSchedule(obj, today);
                    }
                }

                rowData.put(JsConstant.getColNameValue(count), value);
            }

            result.add(rowData);
        }

        // Check whether update column names
        if (form.isUpdateHeader()) {
            setColNames(new Date(form.getBase()), locale);
        }

        return result;
    }

    public List<String> getColNames() {
        return colNames;
    }

    public void setColNames(Date base, Locale locale) {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;

        // Run Schedule table define を取得
        tblDefine = GetRunScheduleTableDefine.get(base, locale);

        colNames = ConvertListUtil.columnInfoToColNames(tblDefine);
    }
}
