/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.Locale;

import com.clustercontrol.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetHistoryFilterProperty;
import com.necsoft.hinemos.webclient.json.TreeGridJson;

/**
 * This class used for get History property
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetHistoryFilterPropertyBusiness {

    /**
     * Get History property
     * 
     * @param namingContext
     *            : NamingContext
     * @return Property
     * @throws HinemosWebException
     */
    public Property getHistoryFilterProperty(Locale locale)
            throws HinemosWebException {
        // 中間変数を宣言
        Property propertyHistory = null;

        // Get history property
        GetHistoryFilterProperty historyProperty = new GetHistoryFilterProperty();
        propertyHistory = historyProperty.getProperty(locale);
        if (propertyHistory == null) {
            throw new HinemosWebException("Can not get Property");
        }
        return propertyHistory;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param propertyHistory
     *            : Property
     * @return TreeGridJson
     */
    public TreeGridJson doConvertToJson(Property propertyHistory) {
        // Create JSON
        TreeGridJson result = new TreeGridJson();
        Object[] propertiesL0 = propertyHistory.getChildren();
        Integer lengtL0 = propertiesL0.length;

        // Create data
        for (int cntL0 = 0; cntL0 < lengtL0; cntL0++) {
            Property propertyL0 = (Property) propertiesL0[cntL0];
            // Set data row
            result.addData(DataProcess.getRowFromProperty(propertyL0));
            Object[] propertiesL1 = propertyL0.getChildren();
            if ((propertiesL1 != null) && (propertiesL1.length > 0)) {
                Integer lengtL1 = propertiesL1.length;
                for (int cntL1 = 0; cntL1 < lengtL1; cntL1++) {
                    Property propertyL1 = (Property) propertiesL1[cntL1];
                    result.addData(DataProcess
                            .getRowFromProperty(propertyL1, 1));
                }
            }
        }
        return result;
    }
}