/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import com.clustercontrol.calendar.bean.ScheduleTableConstant;
import com.clustercontrol.jobmanagement.bean.RunScheduleDetailTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;

/**
 * ジョブ[実行予定詳細]ビューの右側のテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、右側のテーブル定義を取得する
 * 
 */
public class GetRunScheduleDetailTableDefine {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ジョブ[実行予定詳細]ビューの右側のテーブル定義を取得する
     * 
     * @return テーブル定義情報 （{@link com.clustercontrol.bean.TableColumnInfoJs}のリスト）
     */
    public static ArrayList<TableColumnInfoJs> get(Date base, Locale locale) {
        // テーブル定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        tableDefine.add(RunScheduleDetailTableDefine.TREE,
                new TableColumnInfoJs("", TableColumnInfoJs.NONE, 0, SWT.LEFT,
                        false));
        tableDefine.add(RunScheduleDetailTableDefine.JOB_ID,
                new TableColumnInfoJs("", TableColumnInfoJs.NONE, 0, SWT.LEFT,
                        false));
        for (int i = 0; i < ScheduleTableConstant.DAYS; i++) {
            Calendar baseCalendar = Calendar.getInstance();
            baseCalendar.setTime(base);
            baseCalendar.add(Calendar.DAY_OF_MONTH, i);
            Date work = baseCalendar.getTime();
            tableDefine.add(i + 2, new TableColumnInfoJs(DateFormat
                    .getDateInstance(DateFormat.SHORT, locale).format(work),
                    TableColumnInfoJs.SCHEDULE_ON_OFF, 70, SWT.LEFT, false));
        }

        return tableDefine;
    }
}