/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.jobmanagement.bean.JobTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[一覧]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 * 
 */
public class GetJobTableDefine {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ジョブ[一覧]ビューのテーブル定義を取得する
     * 
     * @return テーブル定義情報 （{@link com.clustercontrol.bean.TableColumnInfoJs}のリスト）
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        // テーブル定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        tableDefine.add(
                JobTableDefine.JOB_ID,
                new TableColumnInfoJs(WebMessages.getString("job.id", locale),
                        TableColumnInfoJs.NONE, 100, SWT.LEFT, JobMappingUtil
                                .getJobName(JobTableDefine.JOB_ID)));
        tableDefine.add(
                JobTableDefine.JOB_NAME,
                new TableColumnInfoJs(
                        WebMessages.getString("job.name", locale),
                        TableColumnInfoJs.NONE, 150, SWT.LEFT, JobMappingUtil
                                .getJobName(JobTableDefine.JOB_NAME)));
        tableDefine.add(
                JobTableDefine.JOB_TYPE,
                new TableColumnInfoJs(WebMessages.getString("type", locale),
                        TableColumnInfoJs.JOB, 110, SWT.LEFT, JobMappingUtil
                                .getJobName(JobTableDefine.JOB_TYPE)));
        tableDefine.add(
                JobTableDefine.FACILITY_ID,
                new TableColumnInfoJs(WebMessages.getString("facility.id",
                        locale), TableColumnInfoJs.NONE, 100, SWT.LEFT,
                        JobMappingUtil.getJobName(JobTableDefine.FACILITY_ID)));
        tableDefine.add(JobTableDefine.SCOPE,
                new TableColumnInfoJs(WebMessages.getString("scope", locale),
                        TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                        JobMappingUtil.getJobName(JobTableDefine.SCOPE)));
        tableDefine.add(
                JobTableDefine.WAIT_RULE,
                new TableColumnInfoJs(WebMessages
                        .getString("wait.rule", locale),
                        TableColumnInfoJs.WAIT_RULE, 120, SWT.LEFT,
                        JobMappingUtil.getJobName(JobTableDefine.WAIT_RULE)));
        tableDefine.add(
                JobTableDefine.CREATE_USER,
                new TableColumnInfoJs(WebMessages.getString("creator.name",
                        locale), TableColumnInfoJs.NONE, 80, SWT.LEFT,
                        JobMappingUtil.getJobName(JobTableDefine.CREATE_USER)));
        tableDefine.add(
                JobTableDefine.CREATE_TIME,
                new TableColumnInfoJs(WebMessages.getString("create.time",
                        locale), TableColumnInfoJs.NONE, 150, SWT.LEFT,
                        JobMappingUtil.getJobName(JobTableDefine.CREATE_TIME)));
        tableDefine.add(
                JobTableDefine.UPDATE_USER,
                new TableColumnInfoJs(WebMessages.getString("modifier.name",
                        locale), TableColumnInfoJs.NONE, 80, SWT.LEFT,
                        JobMappingUtil.getJobName(JobTableDefine.UPDATE_USER)));
        tableDefine.add(
                JobTableDefine.UPDATE_TIME,
                new TableColumnInfoJs(WebMessages.getString("update.time",
                        locale), TableColumnInfoJs.NONE, 150, SWT.LEFT,
                        JobMappingUtil.getJobName(JobTableDefine.UPDATE_TIME)));

        return tableDefine;
    }
}