/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.JobInfoNotFoundException;
import com.clustercontrol.jobmanagement.bean.JobForwardFile;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.util.EjbConnectionManager;

/**
 * ファイル[ファイル転送]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、ファイル転送一覧情報を取得する
 * 
 */
public class GetForwardFile {

    // ----- instance メソッド ----- //
    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     *@param namingContext
     *@return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、ファイル転送一覧情報を取得する
     * 
     * @param sessionId
     *            セッションID
     * @param jobunitId
     *            所属ジョブユニットのジョブID
     * @param jobId
     *            ジョブID
     * @return ファイル転送一覧情報
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.jobmanagement.ejb.session.JobController
     * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
     * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean
     *      #getForwardFileList(String, String, String)
     */
    @SuppressWarnings("unchecked")
    public ArrayList<JobForwardFile> getForwardFileList(String sessionId,
            String jobunitId, String jobId) throws HinemosWebException {
        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        JobController job = ejbConnectionManager.getJobController();

        ArrayList<JobForwardFile> records = null;

        try {
            records = job.getForwardFileList(sessionId, jobunitId, jobId);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.job.forwardfile.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException("exception.job.forwardfile.remote", e);
        } catch (JobInfoNotFoundException e) {
            throw new HinemosWebException("exception.job.forwardfile.action", e);
        } catch (HinemosUnknownException e) {
            throw new HinemosWebException("exception.job.forwardfile.action", e);
        }

        return records;
    }
}