/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.composite;

import java.util.Comparator;
import com.clustercontrol.bean.FacilityTreeItem;

/**
 * FacilityItem配列をソートするクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class FacilityTreeViewerSorter implements Comparator<Object> {

    /**
     * 比較処理
     * 
     * @param viewer
     * @param e1
     * @param e2
     * @return 比較結果。ソート順位・ファシリティIDの値でソートする
     * @since 1.0.0
     */
    public int compare(Object e1, Object e2) {
        if (e1 instanceof FacilityTreeItem && e2 instanceof FacilityTreeItem) {
            int order1 = ((FacilityTreeItem) e1).getData()
                    .getDisplaySortOrder();
            int order2 = ((FacilityTreeItem) e2).getData()
                    .getDisplaySortOrder();

            if (order1 == order2) {
                String object1 = ((FacilityTreeItem) e1).getData()
                        .getFacilityId();
                String object2 = ((FacilityTreeItem) e2).getData()
                        .getFacilityId();

                return object1.compareTo(object2);
            } else {
                return (order1 - order2);
            }
        }
        return 0;
    }
}