/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Common dialogs
 */
(function(__){
	/************************************************************
	 * Declare perspective dialog
	 */
	// Cache variants
	var $pers_dlg = $("<div class='dlg-container'></div>");
	
	/************************************************************
	 * Construct perspective dialog
	 */
	// Declare content of dialog
	var $ul    = $("<ul class=\"ul-list-dlg\"></ul>")
	,list_pers = __.getPersTitle()
	;
	
	// Create content
	for(var li_id in list_pers){
		var value = list_pers[li_id];
		if(value){
			var $li = $(["<li id='"
					,li_id
					,"' class='list-perspective'>"
					,__.getIconStr("ui-icon-hnm-perspective")
					,"<span>"
					,value
					,"</span></li>"
				].join(""));
			
			// Bind actions mouse moving
			$li.mouseover(function(){
				$(this).addClass("list-mouse-over");
			}).mouseout(function(){
				$(this).removeClass("list-mouse-over");
			});
			
			$li.click(function(){
				$(this).addClass("li-active-status")
					.siblings().removeClass("li-active-status")
				;
				
				$pers_dlg.siblings("div.ui-dialog-buttonpane").find("#btn_ok:first")
					.attr("disabled", false)
					.removeClass("ui-state-disabled")
				;
			})
			.dblclick(function(){
				$pers_dlg.dialog("close");
				__.addTab(this.id);
			})
			;
			
			$ul.append($li);
			delete $li;
		}
	}
	delete value;
	delete li;

	$ul.appendTo($pers_dlg);
	delete $ul;
	delete list_pers;
	
	$("body").append($pers_dlg);
	$pers_dlg.dialog({
		title     : __.getIconStrTitle(__.getLang("open_perspective_title"))
		,autoOpen : false
		,modal    : true
		,resizable: true
		,width    : 300
		,height   : 350
		,buttons  : [
			{
				id    : "btn_ok"
				,text : __.getLang("ok_o")
				,click: function(){
					var active = $(this).find("li.li-active-status");
					$(this).dialog("close");
					__.addTab(active.attr("id"));
				}
			}
			,{
				text  : __.getLang("cancel")
				,click: function(){
					$(this).dialog("close");
				}
			}
		]
		,open     : function(){
			$(this).siblings("div.ui-dialog-buttonpane").find("#btn_ok:first")
				.attr("disabled", true)
				.addClass("ui-state-disabled")
			;
			
			$(this).find("li.li-active-status")
				.removeClass("li-active-status")
			;
		}
	});

	// Declare function for open dialogs
	__.openPersDlg = function(){
		$pers_dlg.dialog("open");
	}
	
})(cm);