/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.CollectiveRunNotFound;
import com.clustercontrol.fault.FacilityNotFound;
import com.clustercontrol.collectiverun.model.CrunCmdMstEntity;
import com.clustercontrol.collectiverun.model.CrunSessionEntity;
import com.clustercontrol.collectiverun.util.QueryUtil;

/**
 * パラメータ用プロパティ作成クラス
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class SelectParameter {
	private static Log m_log = LogFactory.getLog( SelectParameter.class );

	/**
	 * 種別ID取得処理
	 * 
	 * セッションIDから種別IDを取得する
	 * 
	 * @param sessionId
	 * @return
	 * @throws FacilityNotFound
	 */
	public String getTypeId(String sessionId) throws FacilityNotFound {
		String ret = null;
		//セッションIDからセッション(実行履歴)を取得
		CrunSessionEntity session = null;
		try {
			session = QueryUtil.getCrunSessionPK(sessionId);
		} catch (CollectiveRunNotFound e) {
			FacilityNotFound e1 = new FacilityNotFound("CrunSessionEntity.findByPrimaryKey, "
					+ "sessionId = " + sessionId);
			throw e1;
		}
		//コマンドIDからコマンドマスタを取得
		CrunCmdMstEntity cmd = null;
		try {
			cmd = QueryUtil.getCrunCmdMstPK(session.getCommandId());
		} catch (CollectiveRunNotFound e) {
			FacilityNotFound e1 = new FacilityNotFound("CrunCmdMstEntity.findByPrimaryKey, "
					+ "commandId = " + session.getCommandId());
			throw e1;
		}
		ret = cmd.getCrunTypeMstEntity() == null ? null : cmd.getCrunTypeMstEntity().getTypeId();
		return ret;
	}
	//
	//	/**
	//	 * FacilityTreeItemの取得（再帰呼び出し）
	//	 *
	//	 * @param item
	//	 * @param facilityId
	//	 * @param list
	//	 */
	//	@SuppressWarnings("unchecked")
	//	private static void getFacilityTreeItem(FacilityTreeItem item, String facilityId, ArrayList list) {
	//
	//		//ファシリティIDが一致するFacilityTreeItemをリストに追加
	//		if(facilityId != null && item.getData().getFacilityId() != null){
	//			if(facilityId.compareTo(item.getData().getFacilityId()) == 0){
	//				list.add(item);
	//			}
	//		}
	//
	//		//子FacilityTreeItemを取得
	//		Object[] childrens = item.getChildrenArray();
	//
	//		for(int i = 0; i < childrens.length; i++){
	//			FacilityTreeItem children1 = (FacilityTreeItem)childrens[i];
	//			getFacilityTreeItem(children1, facilityId, list);
	//		}
	//	}


}
