/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.notify.bean.NotifyRequestMessage;
import com.clustercontrol.notify.util.SendMail;
import com.clustercontrol.plugin.api.AsyncTaskFactory;

public class NotifyMailTaskFactory implements AsyncTaskFactory {

	public static final Log log = LogFactory.getLog(NotifyMailTaskFactory.class);

	private static final SendMail _sendMail = new SendMail();

	@Override
	public Runnable createTask(Object param) {
		return new NotifyMailTask(param);
	}

	public class NotifyMailTask implements Runnable {

		private final NotifyRequestMessage msg;

		public NotifyMailTask(Object param) {
			if (param instanceof NotifyRequestMessage) {
				msg = (NotifyRequestMessage)param;
			} else {
				msg = null;
			}
		}

		@Override
		public void run() {

			if (msg == null) {
				log.warn("message is not assigned.");
				return;
			}
			log.debug("run() message : " + msg);

			JpaTransactionManager jtm = null;

			try {
				jtm = new JpaTransactionManager();
				jtm.begin();

				_sendMail.notify(msg);

				jtm.commit();
			} catch (Exception e) {
				jtm.rollback();
				log.warn("asynchronous task failure.", e);
			} finally {
				jtm.close();
			}

		}

		@Override
		public String toString() {
			if (msg == null) {
				return this.getClass().getSimpleName() + "[NotifyRequestMessage = null]";
			} else {
				return this.getClass().getSimpleName() + "[NotifyRequestMessage = " + msg
						+ "[" + msg.getOutputInfo() + "]]";
			}

		}

	}

}
