--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: cc_cal_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_info (
    calendar_id character varying(64) NOT NULL,
    calendar_name character varying(256) NOT NULL,
    description character varying(256),
    start_time time without time zone,
    valid_time_from timestamp without time zone NOT NULL,
    valid_time_to timestamp without time zone NOT NULL,
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_cal_info OWNER TO hinemos;

--
-- Name: cc_cal_detail_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_detail_info (
    calendar_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    description character varying(256),
    year_no smallint NOT NULL,
    month_no smallint NOT NULL,
    day_type smallint NOT NULL,
    week_no smallint,
    week_xth smallint,
    day_no smallint,
    calendar_pattern_id character varying(64),
    after_day smallint,
    start_time timestamp without time zone,
    end_time timestamp without time zone,
    execute_flg smallint NOT NULL
);


ALTER TABLE public.cc_cal_detail_info OWNER TO hinemos;

--
-- Name: cc_cal_pattern_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_pattern_info (
    calendar_pattern_id character varying(64) NOT NULL,
    calendar_pattern_name character varying(128) NOT NULL,
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_cal_pattern_info OWNER TO hinemos;


--
-- Name: cc_cal_pattern_detail_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_pattern_detail_info (
    calendar_pattern_id character varying(64) NOT NULL,
    year_no smallint NOT NULL,
    month_no smallint NOT NULL,
    day_no smallint NOT NULL
);


ALTER TABLE public.cc_cal_pattern_detail_info OWNER TO hinemos;



--
-- Name: cc_calculated_data; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_calculated_data (
    collectorid character varying(256) NOT NULL,
    item_code character varying(64) NOT NULL,
    display_name character varying(256) NOT NULL,
    date_time timestamp without time zone NOT NULL,
    facilityid character varying(64) NOT NULL,
    value double precision
);


ALTER TABLE public.cc_calculated_data OWNER TO hinemos;

--
-- Name: cc_cfg_facility; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_facility (
    facility_id character varying(64) NOT NULL,
    facility_name character varying(128) NOT NULL,
    facility_type integer NOT NULL,
    description character varying(256) NOT NULL,
    display_sort_order integer NOT NULL,
    icon_image character varying(256) NOT NULL,
    valid smallint NOT NULL,
    owner_role_id character varying(64),
    create_user_id character varying(64) NOT NULL,
    create_datetime timestamp without time zone NOT NULL,
    modify_user_id character varying(64) NOT NULL,
    modify_datetime timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_cfg_facility OWNER TO hinemos;

--
-- Name: cc_cfg_facility_relation; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_facility_relation (
    parent_facility_id character varying(64) NOT NULL,
    child_facility_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_cfg_facility_relation OWNER TO hinemos;

--
-- Name: cc_cfg_node; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node (
    facility_id character varying(64) NOT NULL,
    platform_family character varying(128) NOT NULL,
    sub_platform_family character varying(128) NOT NULL,
    hardware_type character varying(128) NOT NULL,
    ip_address_version smallint NOT NULL,
    ip_address_v4 character varying(16) NOT NULL,
    ip_address_v6 character varying(40) NOT NULL,
    node_name character varying(128) NOT NULL,
    os_name character varying(256) NOT NULL,
    os_release character varying(256) NOT NULL,
    os_version character varying(256) NOT NULL,
    character_set character varying(16) NOT NULL,
    agent_awake_port integer NOT NULL,
    job_priority integer NOT NULL,
    job_multiplicity integer NOT NULL,
    snmp_port integer NOT NULL,
    snmp_community character varying(64) NOT NULL,
    snmp_version character varying(8) NOT NULL,
    snmp_timeout integer NOT NULL,
    snmp_retry_count integer NOT NULL,
    wbem_user character varying(64) NOT NULL,
    wbem_user_password character varying(64) NOT NULL,
    wbem_port integer NOT NULL,
    wbem_protocol character varying(32) NOT NULL,
    wbem_timeout integer NOT NULL,
    wbem_retry_count integer NOT NULL,
    ipmi_ip_address character varying(1024) NOT NULL,
    ipmi_port integer NOT NULL,
    ipmi_user character varying(64) NOT NULL,
    ipmi_user_password character varying(64) NOT NULL,
    ipmi_timeout integer NOT NULL,
    ipmi_retry_count integer NOT NULL,
    ipmi_protocol character varying(32) NOT NULL,
    ipmi_level character varying(32) NOT NULL,
    winrm_user character varying(64) NOT NULL,
    winrm_user_password character varying(64) NOT NULL,
    winrm_version character varying(64) NOT NULL,
    winrm_port integer NOT NULL,
    winrm_protocol character varying(32) NOT NULL,
    winrm_timeout integer NOT NULL,
    winrm_retry_count integer NOT NULL,
    vm_node_type character varying(64) NOT NULL,
    vm_management_node character varying(64) NOT NULL,
    vm_name character varying(128) NOT NULL,
    vm_id character varying(256) NOT NULL,
    vm_user character varying(64) NOT NULL,
    vm_user_password character varying(64) NOT NULL,
    vm_protocol character varying(32) NOT NULL,
    vnet_switch_type character varying(64) NOT NULL,
    vnet_host_node character varying(64) NOT NULL,
    openflow_data_path_id character varying(1024) NOT NULL,
    openflow_ctrl_ip_address character varying(1024) NOT NULL,
    cloud_node_type character varying(64) NOT NULL,
    cloud_service character varying(64) NOT NULL,
    cloud_account_resource character varying(64) NOT NULL,
    cloud_resource_type character varying(64) NOT NULL,
    cloud_resource_id character varying(64) NOT NULL,
    cloud_region character varying(64) NOT NULL,
    cloud_zone character varying(64) NOT NULL,
    administrator character varying(256) NOT NULL,
    contact character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node OWNER TO hinemos;

--
-- Name: cc_cfg_node_device; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node_device (
    facility_id character varying(64) NOT NULL,
    device_index integer NOT NULL,
    device_type character varying(32) NOT NULL,
    device_name character varying(128) NOT NULL,
    device_display_name character varying(256) NOT NULL,
    device_size integer NOT NULL,
    device_size_unit character varying(64) NOT NULL,
    device_description character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node_device OWNER TO hinemos;

--
-- Name: cc_cfg_node_cpu; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_cfg_node_cpu (
    facility_id character varying(64) NOT NULL,
    device_index integer NOT NULL,
    device_type character varying(32) NOT NULL,
    device_name character varying(128) NOT NULL,
    device_display_name character varying(256) NOT NULL,
    device_size integer NOT NULL,
    device_size_unit character varying(64) NOT NULL,
    device_description character varying(1024) NOT NULL
);

ALTER TABLE public.cc_cfg_node_cpu OWNER TO hinemos;

--
-- Name: cc_cfg_node_memory; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_cfg_node_memory (
    facility_id character varying(64) NOT NULL,
    device_index integer NOT NULL,
    device_type character varying(32) NOT NULL,
    device_name character varying(128) NOT NULL,
    device_display_name character varying(256) NOT NULL,
    device_size integer NOT NULL,
    device_size_unit character varying(64) NOT NULL,
    device_description character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node_memory OWNER TO hinemos;

--
-- Name: cc_cfg_node_network_interface; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_cfg_node_network_interface (
    facility_id character varying(64) NOT NULL,
    device_index integer NOT NULL,
    device_type character varying(32) NOT NULL,
    device_name character varying(128) NOT NULL,
    device_display_name character varying(256) NOT NULL,
    device_size integer NOT NULL,
    device_size_unit character varying(64) NOT NULL,
    device_description character varying(1024) NOT NULL,
    device_nic_ip_address character varying(1024) NOT NULL,
    device_nic_mac_address character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node_network_interface OWNER TO hinemos;

--
-- Name: cc_cfg_node_disk; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_cfg_node_disk (
    facility_id character varying(64) NOT NULL,
    device_index integer NOT NULL,
    device_type character varying(32) NOT NULL,
    device_name character varying(128) NOT NULL,
    device_display_name character varying(256) NOT NULL,
    device_size integer NOT NULL,
    device_size_unit character varying(64) NOT NULL,
    device_description character varying(1024) NOT NULL,
    device_disk_rpm integer NOT NULL
);


ALTER TABLE public.cc_cfg_node_disk OWNER TO hinemos;

--
-- Name: cc_cfg_node_filesystem; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_cfg_node_filesystem (
    facility_id character varying(64) NOT NULL,
    device_index integer NOT NULL,
    device_type character varying(32) NOT NULL,
    device_name character varying(128) NOT NULL,
    device_display_name character varying(256) NOT NULL,
    device_size integer NOT NULL,
    device_size_unit character varying(64) NOT NULL,
    device_description character varying(1024) NOT NULL,
    device_filesystem_type character varying(64) NOT NULL
);


ALTER TABLE public.cc_cfg_node_filesystem OWNER TO hinemos;

--
-- Name: cc_cfg_node_variable; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_cfg_node_variable (
    facility_id character varying(64) NOT NULL,
    node_variable_name character varying(128) NOT NULL,
    node_variable_value character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node_variable OWNER TO hinemos;

--
-- Name: cc_cfg_node_hostname; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node_hostname (
    facility_id character varying(64) NOT NULL,
    hostname character varying(128) NOT NULL
);


ALTER TABLE public.cc_cfg_node_hostname OWNER TO hinemos;

--
-- Name: cc_cfg_node_note; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node_note (
    facility_id character varying(64) NOT NULL,
    note_id integer NOT NULL,
    note character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node_note OWNER TO hinemos;

--
-- Name: cc_cfg_user; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_user (
    user_id character varying(64) NOT NULL,
    user_name character varying(128) NOT NULL,
    password character varying(64) NOT NULL,
    user_type character varying(16) NOT NULL,
    description character varying(256),
    create_user_id character varying(64) NOT NULL,
    create_datetime timestamp without time zone NOT NULL,
    modify_user_id character varying(64) NOT NULL,
    modify_datetime timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_cfg_user OWNER TO hinemos;

--
-- Name: cc_cfg_role; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_role (
    role_id character varying(64) NOT NULL,
    role_name character varying(128) NOT NULL,
    role_type character varying(16) NOT NULL,
    description character varying(256),
    create_user_id character varying(64) NOT NULL,
    create_datetime timestamp without time zone NOT NULL,
    modify_user_id character varying(64) NOT NULL,
    modify_datetime timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_cfg_role OWNER TO hinemos;


--
-- Name: cc_cfg_user_role_relation; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_user_role_relation (
    role_id character varying(64) NOT NULL,
    user_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_cfg_user_role_relation OWNER TO hinemos;


--
-- Name: cc_system_privilege; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_system_privilege (
    role_id character varying(64) NOT NULL,
    system_function character varying(64) NOT NULL,
    system_privilege character varying(64) NOT NULL
);


ALTER TABLE public.cc_system_privilege OWNER TO hinemos;


--
-- Name: cc_object_privilege; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_object_privilege (
    object_type character varying(64) NOT NULL,
    object_id character varying(64) NOT NULL,
    role_id character varying(64) NOT NULL,
    object_privilege character varying(64) NOT NULL,
    create_user_id character varying(64) NOT NULL,
    create_datetime timestamp without time zone NOT NULL,
    modify_user_id character varying(64) NOT NULL,
    modify_datetime timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_object_privilege OWNER TO hinemos;


--
-- Name: cc_collector_calc_method_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_calc_method_mst (
    calc_method character varying(256) NOT NULL,
    class_name character varying(256),
    expression text
);


ALTER TABLE public.cc_collector_calc_method_mst OWNER TO hinemos;

--
-- Name: cc_collector_category_collect_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_category_collect_mst (
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    category_code character varying(64) NOT NULL,
    collect_method character varying(64) NOT NULL
);


ALTER TABLE public.cc_collector_category_collect_mst OWNER TO hinemos;

--
-- Name: cc_collector_category_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_category_mst (
    category_code character varying(64) NOT NULL,
    category_name character varying(256)
);


ALTER TABLE public.cc_collector_category_mst OWNER TO hinemos;

--
-- Name: cc_collector_item_calc_method_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_item_calc_method_mst (
    collect_method character varying(64) NOT NULL,
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    item_code character varying(64) NOT NULL,
    calc_method character varying(256) NOT NULL
);


ALTER TABLE public.cc_collector_item_calc_method_mst OWNER TO hinemos;

--
-- Name: cc_collector_item_code_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_item_code_mst (
    item_code character varying(64) NOT NULL,
    category_code character varying(64) NOT NULL,
    parent_item_code character varying(256),
    item_name character varying(256) NOT NULL,
    measure character varying(64),
    device_support smallint NOT NULL,
    device_type character varying(64),
    graph_range smallint NOT NULL
);


ALTER TABLE public.cc_collector_item_code_mst OWNER TO hinemos;

--
-- Name: cc_collector_platform_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_platform_mst (
    platform_id character varying(64) NOT NULL,
    platform_name character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_collector_platform_mst OWNER TO hinemos;

--
-- Name: cc_collector_sub_platform_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_sub_platform_mst (
    sub_platform_id character varying(64) NOT NULL,
    sub_platform_name character varying(256) NOT NULL,
    type character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_collector_sub_platform_mst OWNER TO hinemos;

--
-- Name: cc_collector_polling_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_polling_mst (
    collect_method character varying(64) NOT NULL,
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    item_code character varying(64) NOT NULL,
    variable_id character varying(64) NOT NULL,
    entry_key character varying(1024) NOT NULL,
    value_type character varying(64) NOT NULL,
    polling_target character varying(1024) NOT NULL,
    failure_value character varying(256)
);


ALTER TABLE public.cc_collector_polling_mst OWNER TO hinemos;

--
-- Name: cc_crun_cmd_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_cmd_mst (
    command_id character varying(64) NOT NULL,
    type_id character varying(64),
    order_no smallint NOT NULL,
    name_id character varying(256),
    command_type smallint NOT NULL,
    command character varying(256)
);


ALTER TABLE public.cc_crun_cmd_mst OWNER TO hinemos;

--
-- Name: cc_crun_cmd_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_cmd_param_mst (
    command_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    param_prefix character varying(64)
);


ALTER TABLE public.cc_crun_cmd_param_mst OWNER TO hinemos;

--
-- Name: cc_crun_end_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_end_mst (
    command_id character varying(64) NOT NULL,
    end_status integer NOT NULL,
    end_value_from integer NOT NULL,
    end_value_to integer NOT NULL
);


ALTER TABLE public.cc_crun_end_mst OWNER TO hinemos;

--
-- Name: cc_crun_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_param_mst (
    param_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    param_type smallint NOT NULL
);


ALTER TABLE public.cc_crun_param_mst OWNER TO hinemos;

--
-- Name: cc_crun_param_select_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_param_select_mst (
    param_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    name_id character varying(256) NOT NULL,
    param_value character varying(4096)
);


ALTER TABLE public.cc_crun_param_select_mst OWNER TO hinemos;

--
-- Name: cc_crun_session; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session (
    session_id character varying(64) NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    type_id character varying(64) NOT NULL,
    command_id character varying(64),
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256),
    node_cnt smallint NOT NULL,
    wait_cnt smallint NOT NULL,
    running_cnt smallint NOT NULL,
    end_nomal_cnt smallint NOT NULL,
    end_warning_cnt smallint NOT NULL,
    end_abnomal_cnt smallint NOT NULL,
    status smallint NOT NULL
);


ALTER TABLE public.cc_crun_session OWNER TO hinemos;

--
-- Name: cc_crun_session_detail; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session_detail (
    session_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    facility_name character varying(256),
    message text,
    error_message text,
    status smallint NOT NULL,
    end_status integer,
    end_value integer
);


ALTER TABLE public.cc_crun_session_detail OWNER TO hinemos;

--
-- Name: cc_crun_session_param; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session_param (
    session_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_value character varying(4096)
);


ALTER TABLE public.cc_crun_session_param OWNER TO hinemos;

--
-- Name: cc_crun_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_type_mst (
    type_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_crun_type_mst OWNER TO hinemos;

--
-- Name: cc_event_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_event_log (
    monitor_id character varying(64) NOT NULL,
    monitor_detail_id character varying(1024) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    generation_date timestamp without time zone NOT NULL,
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256) NOT NULL,
    application character varying(64) NOT NULL,
    message_id character varying(64) NOT NULL,
    message character varying(256) NOT NULL,
    message_org text,
    priority smallint NOT NULL,
    confirm_flg smallint NOT NULL,
    confirm_date timestamp without time zone,
    confirm_user character varying(64),
    duplication_count bigint NOT NULL,
    output_date timestamp without time zone NOT NULL,
    inhibited_flg smallint NOT NULL,
    comment_date timestamp without time zone,
    comment_user character varying(64),
    comment character varying(2048) NOT NULL,
    owner_role_id character varying(64)
);


ALTER TABLE public.cc_event_log OWNER TO hinemos;

--
-- Name: cc_job_end_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_end_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    end_status integer NOT NULL,
    end_value integer NOT NULL,
    end_value_from integer NOT NULL,
    end_value_to integer NOT NULL
);


ALTER TABLE public.cc_job_end_info OWNER TO hinemos;

--
-- Name: cc_job_end_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_end_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    end_status integer NOT NULL,
    end_value integer NOT NULL,
    end_value_from integer NOT NULL,
    end_value_to integer NOT NULL
);


ALTER TABLE public.cc_job_end_mst OWNER TO hinemos;

--
-- Name: cc_job_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    job_name character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    job_type smallint NOT NULL,
    facility_id character varying(64),
    process_mode smallint,
    start_command character varying(1024),
    stop_type smallint,
    stop_command character varying(1024),
    specify_user smallint,
    effective_user character varying(64),
    error_end_flg smallint,
    error_end_value integer,
    argument_job_id character varying(64),
    argument character varying(1024),
    condition_type smallint,
    suspend smallint,
    skip smallint,
    skip_end_status integer,
    skip_end_value integer,
    unmatch_end_flg smallint,
    unmatch_end_status integer,
    unmatch_end_value integer,
    calendar smallint,
    calendar_id character varying(64),
    calendar_end_status integer,
    calendar_end_value integer,
    start_delay smallint,
    start_delay_session smallint,
    start_delay_session_value smallint,
    start_delay_time smallint,
    start_delay_time_value timestamp without time zone,
    start_delay_condition_type smallint,
    start_delay_notify smallint,
    start_delay_notify_priority smallint,
    start_delay_operation smallint,
    start_delay_operation_type smallint,
    start_delay_operation_end_status integer,
    start_delay_operation_end_value integer,
    end_delay smallint,
    end_delay_session smallint,
    end_delay_session_value smallint,
    end_delay_job smallint,
    end_delay_job_value smallint,
    end_delay_time smallint,
    end_delay_time_value timestamp without time zone,
    end_delay_condition_type smallint,
    end_delay_notify smallint,
    end_delay_notify_priority smallint,
    end_delay_operation smallint,
    end_delay_operation_type smallint,
    end_delay_operation_end_status integer,
    end_delay_operation_end_value integer,
    multiplicity_notify smallint,
    multiplicity_notify_priority smallint,
    multiplicity_operation smallint,
    multiplicity_end_value integer,
    message_retry smallint,
    src_facility_id character varying(64),
    dest_facility_id character varying(64),
    src_file character varying(4096),
    src_work_dir character varying(4096),
    dest_directory character varying(4096),
    dest_work_dir character varying(4096),
    compression_flg smallint,
    check_flg smallint,
    start_time timestamp without time zone,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_info OWNER TO hinemos;

--
-- Name: cc_job_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    job_name character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    job_type smallint NOT NULL,
    facility_id character varying(64),
    process_mode smallint,
    start_command character varying(1024),
    stop_type smallint,
    stop_command character varying(1024),
    specify_user smallint,
    effective_user character varying(64),
    error_end_flg smallint,
    error_end_value integer,
    argument_job_id character varying(64),
    argument character varying(1024),
    condition_type smallint,
    suspend smallint,
    skip smallint,
    skip_end_status integer,
    skip_end_value integer,
    unmatch_end_flg smallint,
    unmatch_end_status integer,
    unmatch_end_value integer,
    calendar smallint,
    calendar_id character varying(64),
    calendar_end_status integer,
    calendar_end_value integer,
    start_delay smallint,
    start_delay_session smallint,
    start_delay_session_value smallint,
    start_delay_time smallint,
    start_delay_time_value timestamp without time zone,
    start_delay_condition_type smallint,
    start_delay_notify smallint,
    start_delay_notify_priority smallint,
    start_delay_operation smallint,
    start_delay_operation_type smallint,
    start_delay_operation_end_status integer,
    start_delay_operation_end_value integer,
    end_delay smallint,
    end_delay_session smallint,
    end_delay_session_value smallint,
    end_delay_job smallint,
    end_delay_job_value smallint,
    end_delay_time smallint,
    end_delay_time_value timestamp without time zone,
    end_delay_condition_type smallint,
    end_delay_notify smallint,
    end_delay_notify_priority smallint,
    end_delay_operation smallint,
    end_delay_operation_type smallint,
    end_delay_operation_end_status integer,
    end_delay_operation_end_value integer,
    multiplicity_notify smallint,
    multiplicity_notify_priority smallint,
    multiplicity_operation smallint,
    multiplicity_end_value integer,
    message_retry smallint,
    src_facility_id character varying(64),
    dest_facility_id character varying(64),
    src_file character varying(4096),
    src_work_dir character varying(4096),
    dest_directory character varying(4096),
    dest_work_dir character varying(4096),
    compression_flg smallint,
    check_flg smallint,
    start_time timestamp without time zone,
    parent_jobunit_id character varying(64),
    parent_job_id character varying(64),
    refer_jobunit_id character varying(64),
    refer_job_id character varying(64),
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_mst OWNER TO hinemos;

--
-- Name: cc_job_notice_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_notice_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    notice_type smallint NOT NULL,
    priority smallint NOT NULL,
    notify_group_id character varying(1024)
);


ALTER TABLE public.cc_job_notice_info OWNER TO hinemos;

--
-- Name: cc_job_notice_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_notice_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    notice_type smallint NOT NULL,
    priority smallint NOT NULL,
    notify_group_id character varying(1024)
);


ALTER TABLE public.cc_job_notice_mst OWNER TO hinemos;

--
-- Name: cc_job_param_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_param_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_type smallint NOT NULL,
    description character varying(256),
    value text
);


ALTER TABLE public.cc_job_param_info OWNER TO hinemos;

--
-- Name: cc_job_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_param_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_type smallint NOT NULL,
    description character varying(256),
    value text
);


ALTER TABLE public.cc_job_param_mst OWNER TO hinemos;

--
-- Name: cc_job_session; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    schedule_date timestamp without time zone,
    operation_flg smallint NOT NULL,
    trigger_type smallint NOT NULL,
    trigger_info character varying(256) NOT NULL,
    filename character varying(256)
);


ALTER TABLE public.cc_job_session OWNER TO hinemos;

--
-- Name: cc_job_session_job; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session_job (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    scope_text character varying(256),
    status smallint NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    end_value integer,
    end_status integer,
    result character varying(1024),
    end_staus_check_flg smallint,
    delay_notify_flg smallint,
    parent_jobunit_id character varying(64),
    parent_job_id character varying(64),
    owner_role_id character varying(64)
);


ALTER TABLE public.cc_job_session_job OWNER TO hinemos;

--
-- Name: cc_job_session_node; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session_node (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    node_name character varying(256),
    status integer NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    end_value integer,
    message text,
    retry_count smallint,
    result character varying(1024)
);


ALTER TABLE public.cc_job_session_node OWNER TO hinemos;

--
-- Name: cc_job_start_job_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_job_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    target_jobunit_id character varying(64) NOT NULL,
    target_job_id character varying(64) NOT NULL,
    target_job_type smallint NOT NULL,
    target_job_end_value integer NOT NULL
);


ALTER TABLE public.cc_job_start_job_info OWNER TO hinemos;

--
-- Name: cc_job_start_job_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_job_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    target_jobunit_id character varying(64) NOT NULL,
    target_job_id character varying(64) NOT NULL,
    target_job_type smallint NOT NULL,
    target_job_end_value integer NOT NULL
);


ALTER TABLE public.cc_job_start_job_mst OWNER TO hinemos;


--
-- Name: cc_mail_template_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_mail_template_info (
    mail_template_id character varying(64) NOT NULL,
    description character varying(256),
    subject character varying(256),
    body text,
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_mail_template_info OWNER TO hinemos;

--
-- Name: cc_map_association; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_association (
    map_id character varying(64) NOT NULL,
    source character varying(64) NOT NULL,
    target character varying(64) NOT NULL
);


ALTER TABLE public.cc_map_association OWNER TO hinemos;

--
-- Name: cc_map_bg_image; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_bg_image (
    filename character varying(64) NOT NULL,
    filedata bytea NOT NULL
);


ALTER TABLE public.cc_map_bg_image OWNER TO hinemos;

--
-- Name: cc_map_icon_image; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_icon_image (
    filename character varying(64) NOT NULL,
    filedata bytea NOT NULL
);


ALTER TABLE public.cc_map_icon_image OWNER TO hinemos;

--
-- Name: cc_map_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_info (
    map_id character varying(64) NOT NULL,
    background_image character varying(64)
);


ALTER TABLE public.cc_map_info OWNER TO hinemos;

--
-- Name: cc_map_position; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_position (
    map_id character varying(64) NOT NULL,
    element_id character varying(64) NOT NULL,
    x integer,
    y integer
);


ALTER TABLE public.cc_map_position OWNER TO hinemos;


--
-- Name: cc_monitor_http_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_http_info (
    monitor_id character varying(64) NOT NULL,
    request_url character varying(2083) NOT NULL,
    url_replace smallint,
    proxy_set smallint,
    proxy_host character varying(64),
    proxy_port smallint,
    timeout integer NOT NULL
);


ALTER TABLE public.cc_monitor_http_info OWNER TO hinemos;


--
-- Name: cc_monitor_custom_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_custom_info (
    monitor_id character varying(64) NOT NULL,
    execute_type smallint NOT NULL,
    selected_facility_id character varying(64) DEFAULT NULL,
    specify_user smallint,
    effective_user character varying(64),
    command character varying(1024) NOT NULL, 
    timeout integer NOT NULL
);


ALTER TABLE public.cc_monitor_custom_info OWNER TO hinemos;


--
-- Name: cc_monitor_logfile_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_logfile_info (
    monitor_id character varying(64) NOT NULL,
    directory character varying(1024) NOT NULL,
    file_name character varying(1024) NOT NULL
);


ALTER TABLE public.cc_monitor_logfile_info OWNER TO hinemos;


--
-- Name: cc_monitor_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_info (
    monitor_id character varying(64) NOT NULL,
    monitor_type_id character varying(64) NOT NULL,
    monitor_type smallint NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    run_interval smallint,
    delay_time integer,
    trigger_type character varying(64),
    calendar_id character varying(64),
    failure_priority smallint,
    notify_group_id character varying(1024),
    application character varying(64),
    monitor_flg smallint,
    collector_flg smallint,
    item_name character varying(64),
    measure character varying(64),
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_monitor_info OWNER TO hinemos;

--
-- Name: cc_monitor_numeric_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_numeric_value_info (
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    threshold_upper_limit double precision NOT NULL,
    threshold_lower_limit double precision NOT NULL,
    message_id character varying(64),
    message character varying(256)
);


ALTER TABLE public.cc_monitor_numeric_value_info OWNER TO hinemos;

--
-- Name: cc_monitor_perf_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_perf_info (
    monitor_id character varying(64) NOT NULL,
    item_code character varying(256) NOT NULL,
    device_display_name character varying(256) NOT NULL,
    breakdown_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_perf_info OWNER TO hinemos;

--
-- Name: cc_monitor_ping_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_ping_info (
    monitor_id character varying(64) NOT NULL,
    run_count smallint,
    run_interval smallint,
    timeout integer
);


ALTER TABLE public.cc_monitor_ping_info OWNER TO hinemos;

--
-- Name: cc_monitor_plugin_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_plugin_info (
    monitor_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_monitor_plugin_info OWNER TO hinemos;

--
-- Name: cc_monitor_plugin_numeric_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_plugin_numeric_info (
    monitor_id character varying(64) NOT NULL,
    key character varying(64) NOT NULL,
    value numeric
);


ALTER TABLE public.cc_monitor_plugin_numeric_info OWNER TO hinemos;

--
-- Name: cc_monitor_plugin_string_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_plugin_string_info (
    monitor_id character varying(64) NOT NULL,
    key character varying(64) NOT NULL,
    value text
);


ALTER TABLE public.cc_monitor_plugin_string_info OWNER TO hinemos;

--
-- Name: cc_monitor_port_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_port_info (
    monitor_id character varying(64) NOT NULL,
    port_number integer,
    run_count smallint,
    run_interval smallint,
    timeout integer NOT NULL,
    service_id character varying(64)
);


ALTER TABLE public.cc_monitor_port_info OWNER TO hinemos;

--
-- Name: cc_monitor_process_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_process_info (
    monitor_id character varying(64) NOT NULL,
    command character varying(256) NOT NULL,
    param character varying(256),
    case_sensitivity_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_process_info OWNER TO hinemos;

--
-- Name: cc_monitor_process_method_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_process_method_mst (
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    collect_method character varying(64) NOT NULL
);


ALTER TABLE public.cc_monitor_process_method_mst OWNER TO hinemos;

--
-- Name: cc_monitor_process_polling_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_process_polling_mst (
    collect_method character varying(64) NOT NULL,
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    variable_id character varying(64) NOT NULL,
    entry_key character varying(1024) NOT NULL,
    polling_target character varying(1024) NOT NULL
);


ALTER TABLE public.cc_monitor_process_polling_mst OWNER TO hinemos;

--
-- Name: cc_monitor_protocol_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_protocol_mst (
    service_id character varying(64) NOT NULL,
    service_name character varying(64) NOT NULL,
    description character varying(256),
    default_port_number integer,
    class_name character varying(256)
);


ALTER TABLE public.cc_monitor_protocol_mst OWNER TO hinemos;

--
-- Name: cc_monitor_snmp_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_snmp_info (
    monitor_id character varying(64) NOT NULL,
    snmp_oid character varying(1024) NOT NULL,
    convert_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_snmp_info OWNER TO hinemos;

--
-- Name: cc_monitor_snmp_value; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_snmp_value (
    monitor_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    value double precision NOT NULL,
    get_date timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_monitor_snmp_value OWNER TO hinemos;

--
-- Name: cc_monitor_sql_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_sql_info (
    monitor_id character varying(64) NOT NULL,
    connection_url character varying(256) NOT NULL,
    connection_user character varying(64) NOT NULL,
    connection_password character varying(64) NOT NULL,
    query character varying(1024) NOT NULL,
    jdbc_driver character varying(256) NOT NULL
);


ALTER TABLE public.cc_monitor_sql_info OWNER TO hinemos;

--
-- Name: cc_monitor_status; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_status (
    facility_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    sub_key text NOT NULL,
    priority smallint NOT NULL,
    last_update timestamp without time zone NOT NULL,
    counter bigint NOT NULL
);


ALTER TABLE public.cc_monitor_status OWNER TO hinemos;

--
-- Name: cc_monitor_string_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_string_value_info (
    monitor_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    description character varying(256),
    process_type smallint NOT NULL,
    pattern character varying(1024) NOT NULL,
    priority smallint NOT NULL,
    message character varying(256),
    case_sensitivity_flg smallint NOT NULL,
    valid_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_string_value_info OWNER TO hinemos;

--
-- Name: cc_monitor_trap_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_trap_info (
    monitor_id character varying(64),
    community_name character varying(64),
    check_mode smallint,
    community_check smallint,
    charset_convert smallint,
    charset_name character varying(64)
);


ALTER TABLE public.cc_monitor_trap_info OWNER TO hinemos;

--
-- Name: cc_monitor_trap_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_trap_value_info (
    monitor_id character varying(64),
    mib character varying(1024),
    trap_oid character varying(1024),
    generic_id smallint,
    specific_id integer,
    uei text,
    valid_flg smallint,
    priority smallint,
    logmsg text,
    descr text
);


ALTER TABLE public.cc_monitor_trap_value_info OWNER TO hinemos;

--
-- Name: cc_monitor_truth_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_truth_value_info (
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    truth_value smallint NOT NULL,
    message_id character varying(64),
    message character varying(256)
);


ALTER TABLE public.cc_monitor_truth_value_info OWNER TO hinemos;

--
-- Name: cc_monitor_winservice_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_winservice_info (
    monitor_id character varying(64) NOT NULL,
    service_name character varying(1024) NOT NULL
);


ALTER TABLE public.cc_monitor_winservice_info OWNER TO hinemos;


--
-- Name: cc_monitor_winevent_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_winevent_info (
    monitor_id character varying(64) NOT NULL,
    level_critical bool NOT NULL,
    level_warning bool NOT NULL,
    level_verbose bool NOT NULL,
    level_error bool NOT NULL,
    level_informational bool NOT NULL
);


ALTER TABLE public.cc_monitor_winevent_info OWNER TO hinemos;

--
-- Name: cc_monitor_winevent_log_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_winevent_log_info (
    monitor_id character varying(64) NOT NULL,
    log_name character varying(256) NOT NULL
);


ALTER TABLE public.cc_monitor_winevent_log_info OWNER TO hinemos;

--
-- Name: cc_monitor_winevent_source_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_winevent_source_info (
    monitor_id character varying(64) NOT NULL,
    source character varying(256) NOT NULL
);


ALTER TABLE public.cc_monitor_winevent_source_info OWNER TO hinemos;

--
-- Name: cc_monitor_winevent_id_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_winevent_id_info (
    monitor_id character varying(64) NOT NULL,
    event_id smallint NOT NULL
);


ALTER TABLE public.cc_monitor_winevent_id_info OWNER TO hinemos;

--
-- Name: cc_monitor_winevent_category_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_winevent_category_info (
    monitor_id character varying(64) NOT NULL,
    category smallint NOT NULL
);


ALTER TABLE public.cc_monitor_winevent_category_info OWNER TO hinemos;

--
-- Name: cc_monitor_winevent_keyword_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_monitor_winevent_keyword_info (
    monitor_id character varying(64) NOT NULL,
    keyword bigint NOT NULL
);


ALTER TABLE public.cc_monitor_winevent_keyword_info OWNER TO hinemos;

--
-- Name: cc_notify_command_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_command_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    valid_flg smallint NOT NULL,
    command character varying(1024),
    effective_user character varying(64),
    set_environment smallint NOT NULL,
    command_timeout bigint NOT NULL
);


ALTER TABLE public.cc_notify_command_info OWNER TO hinemos;

--
-- Name: cc_notify_event_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_event_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    event_normal_flg smallint NOT NULL,
    event_normal_state smallint NOT NULL
);


ALTER TABLE public.cc_notify_event_info OWNER TO hinemos;

--
-- Name: cc_notify_history; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_history (
    facility_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    notify_id character varying(64) NOT NULL,
    sub_key text NOT NULL,
    priority smallint NOT NULL,
    last_notify timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_notify_history OWNER TO hinemos;

--
-- Name: cc_notify_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_info (
    notify_id character varying(64) NOT NULL,
    description character varying(256),
    notify_type smallint NOT NULL,
    initial_count smallint NOT NULL,
    renotify_type smallint NOT NULL,
    renotify_period smallint,
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64),
    valid_flg smallint
);


ALTER TABLE public.cc_notify_info OWNER TO hinemos;

--
-- Name: cc_notify_job_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_job_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    job_run smallint NOT NULL,
    jobunit_id character varying(64),
    job_id character varying(64),
    job_failure_priority smallint,
    job_exec_facility_flg smallint,
    job_exec_facility character varying(64)
);


ALTER TABLE public.cc_notify_job_info OWNER TO hinemos;

--
-- Name: cc_notify_log_escalate_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_log_escalate_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    escalate_flg smallint NOT NULL,
    escalate_message character varying(1024),
    syslog_priority smallint,
    syslog_facility smallint,
    escalate_facility_flg smallint,
    escalate_facility character varying(64),
    escalate_port integer
);


ALTER TABLE public.cc_notify_log_escalate_info OWNER TO hinemos;

--
-- Name: cc_notify_mail_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_mail_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    mail_template_id character varying(64),
    mail_flg smallint NOT NULL,
    mail_address character varying(1024)
);


ALTER TABLE public.cc_notify_mail_info OWNER TO hinemos;

--
-- Name: cc_notify_relation_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_relation_info (
    notify_group_id character varying(1024) NOT NULL,
    notify_id character varying(64) NOT NULL,
    notify_type smallint,
    notify_flg smallint
);


ALTER TABLE public.cc_notify_relation_info OWNER TO hinemos;

--
-- Name: cc_notify_status_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_status_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    status_flg smallint NOT NULL,
    status_valid_period smallint,
    status_invalid_flg smallint,
    status_update_priority smallint
);


ALTER TABLE public.cc_notify_status_info OWNER TO hinemos;

--
-- Name: cc_priority_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_priority_info (
    judgment_id character varying(64) NOT NULL,
    description character varying(256),
    pattern_01 smallint,
    pattern_02 smallint,
    pattern_03 smallint,
    pattern_04 smallint,
    pattern_05 smallint,
    pattern_06 smallint,
    pattern_07 smallint,
    pattern_08 smallint,
    pattern_09 smallint,
    pattern_10 smallint,
    pattern_11 smallint,
    pattern_12 smallint,
    pattern_13 smallint,
    pattern_14 smallint,
    pattern_15 smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_priority_info OWNER TO hinemos;

--
-- Name: cc_snmp_trap_mib_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_mib_mst (
    mib character varying(64) NOT NULL,
    order_no smallint,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_snmp_trap_mib_mst OWNER TO hinemos;

--
-- Name: cc_snmp_trap_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_mst (
    mib character varying(1024) NOT NULL,
    trap_oid character varying(1024) NOT NULL,
    generic_id smallint NOT NULL,
    specific_id integer NOT NULL,
    uei text,
    logmsg text,
    descr text,
    priority smallint
);


ALTER TABLE public.cc_snmp_trap_mst OWNER TO hinemos;

--
-- Name: cc_snmp_value_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_value_type_mst (
    value_type character varying(64) NOT NULL
);


ALTER TABLE public.cc_snmp_value_type_mst OWNER TO hinemos;

--
-- Name: cc_status_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_status_info (
    facility_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    monitor_detail_id character varying(1024) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    application character varying(64) NOT NULL,
    message_id character varying(64) NOT NULL,
    message character varying(256) NOT NULL,
    priority smallint NOT NULL,
    generation_date timestamp without time zone NOT NULL,
    output_date timestamp without time zone NOT NULL,
    expiration_flg smallint,
    expiration_date timestamp without time zone,
    owner_role_id character varying(64)
);


ALTER TABLE public.cc_status_info OWNER TO hinemos;

--
-- Name: cc_system_notify_event_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_system_notify_event_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    event_normal_flg smallint NOT NULL,
    event_normal_state smallint NOT NULL,
    event_inhibition_flg smallint NOT NULL,
    event_inhibition_state smallint,
    mail_flg smallint NOT NULL,
    mail_address character varying(1024)
);


ALTER TABLE public.cc_system_notify_event_info OWNER TO hinemos;

--
-- Name: cc_system_notify_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_system_notify_info (
    notify_id character varying(64) NOT NULL,
    description character varying(256),
    status_flg smallint NOT NULL,
    status_valid_period smallint,
    status_invalid_flg smallint,
    status_update_priority smallint,
    event_flg smallint NOT NULL,
    inhibition_flg smallint NOT NULL,
    inhibition_frequency smallint,
    inhibition_period smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    mail_template_id character varying(64)
);


ALTER TABLE public.cc_system_notify_info OWNER TO hinemos;

--
-- Name: cc_vm_protocol_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_vm_protocol_mst (
    sub_platform_id character varying(64) NOT NULL,
    protocol character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_vm_protocol_mst OWNER TO hinemos;

--
-- Name: cc_maintenance_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_maintenance_info (
    maintenance_id character varying(64) NOT NULL,
    description character varying(256),
    type_id character varying(64) NOT NULL,
    data_retention_period smallint,
    calendar_id character varying(64),
    schedule_type int NOT NULL,
    month int,
    day int,
    week int,
    hour int,
    minute int NOT NULL,
    notify_group_id character varying(1024),
    application character varying(64),
    valid_flg smallint NOT NULL,
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(256),
    update_user character varying(256)
);


ALTER TABLE public.cc_maintenance_info OWNER TO hinemos;

--
-- Name: cc_maintenance_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_maintenance_type_mst (
    type_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_maintenance_type_mst OWNER TO hinemos;


CREATE TABLE qrtz_job_details
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    JOB_NAME  VARCHAR(200) NOT NULL,
    JOB_GROUP VARCHAR(200) NOT NULL,
    DESCRIPTION VARCHAR(250) NULL,
    JOB_CLASS_NAME   VARCHAR(250) NOT NULL, 
    IS_DURABLE BOOL NOT NULL,
    IS_NONCONCURRENT BOOL NOT NULL,
    IS_UPDATE_DATA BOOL NOT NULL,
    REQUESTS_RECOVERY BOOL NOT NULL,
    JOB_DATA BYTEA NULL,
    PRIMARY KEY (SCHED_NAME,JOB_NAME,JOB_GROUP)
);

CREATE TABLE qrtz_triggers
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    JOB_NAME  VARCHAR(200) NOT NULL, 
    JOB_GROUP VARCHAR(200) NOT NULL,
    DESCRIPTION VARCHAR(250) NULL,
    NEXT_FIRE_TIME BIGINT NULL,
    PREV_FIRE_TIME BIGINT NULL,
    PRIORITY INTEGER NULL,
    TRIGGER_STATE VARCHAR(16) NOT NULL,
    TRIGGER_TYPE VARCHAR(8) NOT NULL,
    START_TIME BIGINT NOT NULL,
    END_TIME BIGINT NULL,
    CALENDAR_NAME VARCHAR(200) NULL,
    MISFIRE_INSTR SMALLINT NULL,
    JOB_DATA BYTEA NULL,
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,JOB_NAME,JOB_GROUP) 
	REFERENCES QRTZ_JOB_DETAILS(SCHED_NAME,JOB_NAME,JOB_GROUP) 
);

CREATE TABLE qrtz_simple_triggers
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    REPEAT_COUNT BIGINT NOT NULL,
    REPEAT_INTERVAL BIGINT NOT NULL,
    TIMES_TRIGGERED BIGINT NOT NULL,
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
	REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
);

CREATE TABLE qrtz_cron_triggers
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    CRON_EXPRESSION VARCHAR(120) NOT NULL,
    TIME_ZONE_ID VARCHAR(80),
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
	REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
);

CREATE TABLE qrtz_simprop_triggers
  (          
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512) NULL,
    STR_PROP_2 VARCHAR(512) NULL,
    STR_PROP_3 VARCHAR(512) NULL,
    INT_PROP_1 INT NULL,
    INT_PROP_2 INT NULL,
    LONG_PROP_1 BIGINT NULL,
    LONG_PROP_2 BIGINT NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 BOOL NULL,
    BOOL_PROP_2 BOOL NULL,
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
    REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
);

CREATE TABLE qrtz_blob_triggers
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    BLOB_DATA BYTEA NULL,
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
        REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
);

CREATE TABLE qrtz_calendars
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    CALENDAR_NAME  VARCHAR(200) NOT NULL, 
    CALENDAR BYTEA NOT NULL,
    PRIMARY KEY (SCHED_NAME,CALENDAR_NAME)
);


CREATE TABLE qrtz_paused_trigger_grps
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_GROUP  VARCHAR(200) NOT NULL, 
    PRIMARY KEY (SCHED_NAME,TRIGGER_GROUP)
);

CREATE TABLE qrtz_fired_triggers 
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    ENTRY_ID VARCHAR(95) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    INSTANCE_NAME VARCHAR(200) NOT NULL,
    FIRED_TIME BIGINT NOT NULL,
    PRIORITY INTEGER NOT NULL,
    STATE VARCHAR(16) NOT NULL,
    JOB_NAME VARCHAR(200) NULL,
    JOB_GROUP VARCHAR(200) NULL,
    IS_NONCONCURRENT BOOL NULL,
    REQUESTS_RECOVERY BOOL NULL,
    PRIMARY KEY (SCHED_NAME,ENTRY_ID)
);

CREATE TABLE qrtz_scheduler_state 
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    INSTANCE_NAME VARCHAR(200) NOT NULL,
    LAST_CHECKIN_TIME BIGINT NOT NULL,
    CHECKIN_INTERVAL BIGINT NOT NULL,
    PRIMARY KEY (SCHED_NAME,INSTANCE_NAME)
);

CREATE TABLE qrtz_locks
  (
    SCHED_NAME VARCHAR(120) NOT NULL,
    LOCK_NAME  VARCHAR(40) NOT NULL, 
    PRIMARY KEY (SCHED_NAME,LOCK_NAME)
);


--
-- Name: cc_job_schedule; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_job_schedule (
    schedule_id character varying(64) NOT NULL,
    schedule_name character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    calendar_id character varying(64),
    schedule_type int NOT NULL,
    week int,
    hour int,
    minute int,
    from_x_minutes int,
    every_x_minutes int,
    valid_flg smallint NOT NULL,
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_schedule OWNER TO hinemos;

--
-- Name: cc_job_file_check; Type: TABLE; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_job_file_check (
    schedule_id character varying(64) NOT NULL,
    schedule_name character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    calendar_id character varying(64),
    facility_id character varying(64) NOT NULL,
    directory character varying(1024) NOT NULL,
    file_name character varying(64) NOT NULL,
    event_type int NOT NULL,
    modify_type int,
    valid_flg smallint NOT NULL,
    owner_role_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_file_check OWNER TO hinemos;


CREATE TABLE cc_log_async_task (worker varchar(255) not null, task_id bigint, param bytea not null, create_datetime timestamp not null);

--
-- Name: cc_job_edit; Type: Table; Schema: public; Owner: hinemos; Tablespace:
--

CREATE TABLE cc_job_edit (
    jobunit_id character varying(64) NOT NULL,
    lock_user character varying(64),
    lock_ip_address character varying(64),
    edit_session int
);


ALTER TABLE public.cc_job_edit OWNER TO hinemos;


--
-- Name: public; Type: ACL; Schema: -; Owner: hinemos
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM hinemos;
GRANT ALL ON SCHEMA public TO hinemos;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

