--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

--
-- Data for Name: cc_calculated_data; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_calculated_data (collectorid, item_code, display_name, date_time, facilityid, value) FROM stdin;
\.


--
-- Data for Name: cc_cfg_facility; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_facility (facility_id, facility_name, facility_type, description, display_sort_order, icon_image, valid, owner_role_id, create_user_id, create_datetime, modify_user_id, modify_datetime) FROM stdin;
INTERNAL	Hinemos Internal	0	The Scope that Hinemos internal messages is stored	10000		1	INTERNAL		2012-04-01 00:00:00		2012-04-01 00:00:00
REGISTERED	Registered Nodes	0	The Scope that is registered all nodes on Hinemos	11000		1	ADMINISTRATORS		2012-04-01 00:00:00		2012-04-01 00:00:00
UNREGISTERED	Unregistered Nodes	0	The Scope that is not registered nodes on Hinemo	12000		1	ADMINISTRATORS		2012-04-01 00:00:00		2012-04-01 00:00:00
OWNER_SCOPE	Owner Scope	0	The Scope which manages the node according to owner 	10000		1	ADMINISTRATORS		2012-04-01 00:00:00		2012-04-01 00:00:00
ALL_USERS	All Users Role	0	The Scope for ALL_USERS role	400		1	ALL_USERS		2012-04-01 00:00:00		2012-04-01 00:00:00
ADMINISTRATORS	Administrators Role	0	The Scope for ADMINISTRATORS role	400		1	ADMINISTRATORS		2012-04-01 00:00:00		2012-04-01 00:00:00
\.


--
-- Data for Name: cc_cfg_facility_relation; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_facility_relation (parent_facility_id, child_facility_id) FROM stdin;
OWNER_SCOPE	ALL_USERS
OWNER_SCOPE	ADMINISTRATORS
\.


--
-- Data for Name: cc_cfg_node_hostname; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_node_hostname (facility_id, hostname) FROM stdin;
\.


--
-- Data for Name: cc_cfg_node_note; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_node_note (facility_id, note_id, note) FROM stdin;
\.


--
-- Data for Name: cc_cfg_user; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_user (user_id, user_name, password, user_type, description, create_user_id, create_datetime, modify_user_id, modify_datetime) FROM stdin;
HINEMOS_AGENT	Hinemos Agent User	aUsvyaFgjwrB+HX2n+07RA==	2	Hinemos System User for Hinemos Agent	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
HINEMOS_HA	Hinemos HA User	fB4OHupwOti+MazP5G78nw==	2	Hinemos System User for Hinemos HA	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
HINEMOS_CLI	Hinemos CLI User	GTnjpvWNldUN0sVdzcbPgw==	2	Hinemos Cli User for mngctl	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
hinemos	Hinemos Administrator	A+s8VNabt46y5IlsF/bhpA==	0	Hinemos Administrator	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
\.


--
-- Data for Name: cc_cfg_role; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_role (role_id, role_name, role_type, description, create_user_id, create_datetime, modify_user_id, modify_datetime) FROM stdin;
ALL_USERS	All Users Role	0	All Users Role	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
INTERNAL	Hinemos Internal	0	Hinemos Internal	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
ADMINISTRATORS	Hinemos Administrators Role	0	Hinemos Administrators Role	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
HINEMOS_MODULE	Hinemos Module's Role	2	Hinemos Module's Role	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
\.


--
-- Data for Name: cc_cfg_user_role_relation; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_cfg_user_role_relation (role_id, user_id) FROM stdin;
ALL_USERS	hinemos
INTERNAL	hinemos
ADMINISTRATORS	hinemos
HINEMOS_MODULE	HINEMOS_AGENT
HINEMOS_MODULE	HINEMOS_HA
HINEMOS_MODULE	HINEMOS_CLI
\.


--
-- Data for Name: cc_collector_calc_method_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_calc_method_mst (calc_method, class_name, expression) FROM stdin;
R0	com.clustercontrol.performance.operator.RevercePorlishNotation	var0
R0_div_8	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 8.0 /
R0_div_100	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 100.0 /
R0_div_1000	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 1000.0 /
R0_div_1024	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 1024.0 /
R0_mul_8	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 8.0 *
R0_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 100.0 *
R0_mul_1000	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 1000.0 *
R0_mul_1024	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 1024.0 *
R0_add_R1	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 var1 +
R0_div_R1_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 var1 / 100.0 *
[R0_sub_R2]_div_[R0_add_R1]_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	var0 var2 - var0 var1 + / 100.0 *
[D1_add_D2]_div_D0_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	delta(var1) delta(var2) + delta(var0) / 100.0 *
D1_div_D0	com.clustercontrol.performance.operator.RevercePorlishNotation	delta(var1) delta(var0) /
D1_div_D0_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	delta(var1) delta(var0) / 100.0 *
D1_div_D0_mul_1024	com.clustercontrol.performance.operator.RevercePorlishNotation	delta(var1) delta(var0) / 1024.0 *
[D1_sub_D2]_div_D0_mul_1024	com.clustercontrol.performance.operator.RevercePorlishNotation	delta(var1) delta(var2) - delta(var0) / 1024.0 *
[D0_add_D1]_mul_R2_div_D3	com.clustercontrol.performance.operator.RevercePorlishNotation	delta(var0) delta(var1) + var2 * delta(var3) /
D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	delta(var0) delta(var0) delta(var1) + delta(var2) + delta(var3) + delta(var4) + / 100.0 *
100_sub_R0_div_R1_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	100.0 var0 var1 / 100.0 * -
100_sub_R0_div_[R1_add_R2]_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	100.0 var0 var1 var2 + / 100.0 * -
100_sub_[R0_add_R1]_div_[R2_add_R3]_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	100.0 var0 var1 + var2 var3 + / 100.0 * -
100_sub_[R1_add_R2_add_R3]_div_R0_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	100.0 var1 var2 + var3 + var0 / 100.0 * -
100_sub_D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100	com.clustercontrol.performance.operator.RevercePorlishNotation	100.0 delta(var0) delta(var0) delta(var1) + delta(var2) + delta(var3) + delta(var4) + / 100.0 * -
\.


--
-- Data for Name: cc_collector_category_collect_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_category_collect_mst (platform_id, sub_platform_id, category_code, collect_method) FROM stdin;
LINUX		C000_CPU	SNMP
LINUX		C001_MEM	SNMP
LINUX		C002_DSK	SNMP
LINUX		C003_NET	SNMP
LINUX		C004_FS	SNMP
NW_EQUIPMENT		C003_NET	SNMP
WINDOWS		C000_CPU	SNMP
WINDOWS		C001_MEM	SNMP
WINDOWS		C002_DSK	SNMP
WINDOWS		C003_NET	SNMP
WINDOWS		C004_FS	SNMP
\.


--
-- Data for Name: cc_collector_category_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_category_mst (category_code, category_name) FROM stdin;
C000_CPU	CPU
C001_MEM	Memory
C002_DSK	Disk
C003_NET	Network
C004_FS	FileSystem
C010_MON	Monitor
\.


--
-- Data for Name: cc_collector_item_calc_method_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_item_calc_method_mst (collect_method, platform_id, sub_platform_id, item_code, calc_method) FROM stdin;
SNMP	LINUX		CPU0100_CPU_UTIL	100_sub_D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
SNMP	LINUX		CPU0101_CPU_UTIL_USR	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
SNMP	LINUX		CPU0200_INTERRUPT_RATE	D1_div_D0_mul_100
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	D1_div_D0_mul_100
SNMP	LINUX		CPU0400_LOAD_AVE_1M	R0_div_100
SNMP	LINUX		CPU0500_LOAD_AVE_5M	R0_div_100
SNMP	LINUX		CPU0600_LOAD_AVE_15M	R0_div_100
SNMP	LINUX		DSK0100_DVC_IO_CNT	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	D1_div_D0_mul_100
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	D1_div_D0_mul_100
SNMP	LINUX		DSK0200_DVC_IO_BYTE	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	D1_div_D0_mul_100
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	D1_div_D0_mul_100
SNMP	LINUX		FS_0100_DVC_UTIL	R0_div_R1_mul_100
SNMP	LINUX		FS_0200_DVC_UTIL	R0
SNMP	LINUX		MEM0100_MEM_UTIL	100_sub_R0_div_[R1_add_R2]_mul_100
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	[R0_sub_R2]_div_[R0_add_R1]_mul_100
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	[R0_sub_R2]_div_[R0_add_R1]_mul_100
SNMP	LINUX		MEM0200_SWAP_SPACE	100_sub_R0_div_R1_mul_100
SNMP	LINUX		MEM0300_PHYS_UTIL	100_sub_R0_div_R1_mul_100
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	100_sub_[R1_add_R2_add_R3]_div_R0_mul_100
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	R0_div_R1_mul_100
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	R0_div_R1_mul_100
SNMP	LINUX		MEM0400_SWAP_IO	R0_add_R1
SNMP	LINUX		MEM0401_SWAP_IO_IN	R0
SNMP	LINUX		MEM0402_SWAP_IO_OUT	R0
SNMP	LINUX		MEM0600_SWAP_BLK	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		MEM0601_SWAP_BLK_IN	D1_div_D0_mul_100
SNMP	LINUX		MEM0602_SWAP_BLK_OUT	D1_div_D0_mul_100
SNMP	LINUX		NET0100_PACKET	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		NET0101_PACKET_RCV	D1_div_D0_mul_100
SNMP	LINUX		NET0102_PACKET_SNT	D1_div_D0_mul_100
SNMP	LINUX		NET0200_DVC_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		NET0201_DVC_PCK_RCV	D1_div_D0_mul_100
SNMP	LINUX		NET0202_DVC_PCK_SNT	D1_div_D0_mul_100
SNMP	LINUX		NET0300_ERR_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		NET0301_ERR_PCK_RCV	D1_div_D0_mul_100
SNMP	LINUX		NET0302_ERR_PCK_SNT	D1_div_D0_mul_100
SNMP	LINUX		NET0400_DVC_ERR_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	D1_div_D0_mul_100
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	D1_div_D0_mul_100
SNMP	LINUX		NET0500_BYTE	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		NET0501_BYTE_RCV	D1_div_D0_mul_100
SNMP	LINUX		NET0502_BYTE_SNT	D1_div_D0_mul_100
SNMP	LINUX		NET0600_DVC_BYTE	[D1_add_D2]_div_D0_mul_100
SNMP	LINUX		NET0601_DVC_BYTE_RCV	D1_div_D0_mul_100
SNMP	LINUX		NET0602_DVC_BYTE_SNT	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0100_PACKET	[D1_add_D2]_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0500_BYTE	[D1_add_D2]_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	[D1_add_D2]_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	D1_div_D0_mul_100
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	D1_div_D0_mul_100
SNMP	WINDOWS		CPU0100_CPU_UTIL	100_sub_D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	D1_div_D0_mul_100
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	D1_div_D0_mul_100
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	[D1_add_D2]_div_D0_mul_100
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	D1_div_D0_mul_100
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	D1_div_D0_mul_100
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	[D1_add_D2]_div_D0_mul_100
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	D1_div_D0_mul_100
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	D1_div_D0_mul_100
SNMP	WINDOWS		FS_0100_DVC_UTIL	R0_div_R1_mul_100
SNMP	WINDOWS		MEM0100_MEM_UTIL	100_sub_R0_div_[R1_add_R2]_mul_100
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	[R0_sub_R2]_div_[R0_add_R1]_mul_100
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	[R0_sub_R2]_div_[R0_add_R1]_mul_100
SNMP	WINDOWS		MEM0200_SWAP_SPACE	100_sub_R0_div_R1_mul_100
SNMP	WINDOWS		MEM0300_PHYS_UTIL	100_sub_R0_div_R1_mul_100
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	100_sub_[R1_add_R2_add_R3]_div_R0_mul_100
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	R0_div_R1_mul_100
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	R0_div_R1_mul_100
SNMP	WINDOWS		MEM0400_SWAP_IO	R0_add_R1
SNMP	WINDOWS		MEM0401_SWAP_IO_IN	R0
SNMP	WINDOWS		MEM0402_SWAP_IO_OUT	R0
SNMP	WINDOWS		NET0100_PACKET	[D1_add_D2]_div_D0_mul_100
SNMP	WINDOWS		NET0101_PACKET_RCV	D1_div_D0_mul_100
SNMP	WINDOWS		NET0102_PACKET_SNT	D1_div_D0_mul_100
SNMP	WINDOWS		NET0200_DVC_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	D1_div_D0_mul_100
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	D1_div_D0_mul_100
SNMP	WINDOWS		NET0300_ERR_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	D1_div_D0_mul_100
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	D1_div_D0_mul_100
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	[D1_add_D2]_div_D0_mul_100
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	D1_div_D0_mul_100
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	D1_div_D0_mul_100
SNMP	WINDOWS		NET0500_BYTE	[D1_add_D2]_div_D0_mul_100
SNMP	WINDOWS		NET0501_BYTE_RCV	D1_div_D0_mul_100
SNMP	WINDOWS		NET0502_BYTE_SNT	D1_div_D0_mul_100
SNMP	WINDOWS		NET0600_DVC_BYTE	[D1_add_D2]_div_D0_mul_100
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	D1_div_D0_mul_100
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	D1_div_D0_mul_100
WBEM	LINUX		CPU0100_CPU_UTIL	100_sub_D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
WBEM	LINUX		CPU0101_CPU_UTIL_USR	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	D0_div_[D0_add_D1_add_D2_add_D3_add_D4]_mul_100
WBEM	LINUX		DSK0100_DVC_IO_CNT	D1_div_D0
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	D1_div_D0
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	D1_div_D0
WBEM	LINUX		DSK0200_DVC_IO_BYTE	D1_div_D0_mul_1024
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	D1_div_D0_mul_1024
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	[D1_sub_D2]_div_D0_mul_1024
WBEM	LINUX		FS_0101_DVC_UTIL	100_sub_R0_div_R1_mul_100
WBEM	LINUX		FS_0102_DVC_UTIL	100_sub_R0_div_R1_mul_100
WBEM	LINUX		MEM0100_MEM_UTIL	100_sub_[R0_add_R1]_div_[R2_add_R3]_mul_100
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	[R0_sub_R2]_div_[R0_add_R1]_mul_100
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	[R0_sub_R2]_div_[R0_add_R1]_mul_100
WBEM	LINUX		MEM0200_SWAP_SPACE	100_sub_R0_div_R1_mul_100
WBEM	LINUX		MEM0300_PHYS_UTIL	100_sub_R0_div_R1_mul_100
WBEM	LINUX		MEM0400_SWAP_IO	R0
SNMP	LINUX		CPU0110_DVC_CPU_UTIL	R0
SNMP	WINDOWS		CPU0110_DVC_CPU_UTIL	R0
\.


--
-- Data for Name: cc_collector_item_code_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_item_code_mst (item_code, category_code, parent_item_code, item_name, measure, device_support, device_type, graph_range) FROM stdin;
CPU0100_CPU_UTIL	C000_CPU	\N	CPU Usage	%	0		1
CPU0101_CPU_UTIL_USR	C000_CPU	CPU0100_CPU_UTIL	CPU Usage(User)	%	0		1
CPU0102_CPU_UTIL_SYS	C000_CPU	CPU0100_CPU_UTIL	CPU Usage(System)	%	0		1
CPU0103_CPU_UTIL_NCE	C000_CPU	CPU0100_CPU_UTIL	CPU Usage(Nice)	%	0		1
CPU0104_CPU_UTIL_IOW	C000_CPU	CPU0100_CPU_UTIL	CPU Usage(IOWait)	%	0		1
CPU0200_INTERRUPT_RATE	C000_CPU	\N	Interrupt Rate	counts/s	0		0
CPU0300_CONTEXT_SWITCH	C000_CPU	\N	Context Switches	counts/s	0		0
CPU0400_LOAD_AVE_1M	C000_CPU	\N	1 Minute Load Averages	counts/s	0		0
CPU0500_LOAD_AVE_5M	C000_CPU	\N	5 Minute Load Averages	counts/s	0		0
CPU0600_LOAD_AVE_15M	C000_CPU	\N	15 Minute Load Averages	counts/s	0		0
CPU0700_CPU_MHZ	C000_CPU	\N	CPU Usage MHz	Mhz	0		0
CPU0800_CPU_READY	C000_CPU	\N	CPU Ready	msec	0		0
DSK0100_DVC_IO_CNT	C002_DSK	\N	Disk I/O Counts For Each Device	counts/s	1	disk	0
DSK0101_DVC_IO_CNT_IN	C002_DSK	DSK0100_DVC_IO_CNT	Disk I/O Counts For Each Device(Read)	counts/s	1	disk	0
DSK0102_DVC_IO_CNT_OUT	C002_DSK	DSK0100_DVC_IO_CNT	Disk I/O Counts For Each Device(Write)	counts/s	1	disk	0
DSK0200_DVC_IO_BYTE	C002_DSK	\N	Disk I/O Bytes For Each Device	byte/s	1	disk	0
DSK0201_DVC_IO_BYTE_IN	C002_DSK	DSK0200_DVC_IO_BYTE	Disk I/O Bytes For Each Device(Read)	byte/s	1	disk	0
DSK0202_DVC_IO_BYTE_OUT	C002_DSK	DSK0200_DVC_IO_BYTE	Disk I/O Bytes For Each Device(Write)	byte/s	1	disk	0
FS_0100_DVC_UTIL	C004_FS	\N	File System Usage	%	1	filesystem	1
FS_0101_DVC_UTIL	C004_FS	\N	File System Usage(ext3)	%	1	filesystem	1
FS_0102_DVC_UTIL	C004_FS	\N	File System Usage(ext4)	%	1	filesystem	1
FS_0200_DVC_UTIL	C004_FS	\N	File System Usage (Large file support)	%	1	filesystem	1
MEM0100_MEM_UTIL	C001_MEM	\N	Memory Usage	%	0		1
MEM0101_MEM_UTIL_SWAP	C001_MEM	MEM0100_MEM_UTIL	Memory Usage(Swap)	%	0		1
MEM0102_MEM_UTIL_PHYS	C001_MEM	MEM0100_MEM_UTIL	Memory Usage(Physical)	%	0		1
MEM0200_SWAP_SPACE	C001_MEM	\N	Swap Space Usage	%	0		1
MEM0300_PHYS_UTIL	C001_MEM	\N	Physical Memory Usage	%	0		1
MEM0301_PHYS_UTIL_USR	C001_MEM	MEM0300_PHYS_UTIL	Physical Memory Usage(User)	%	0		1
MEM0302_PHYS_UTIL_BUF	C001_MEM	MEM0300_PHYS_UTIL	Physical Memory Usage(Buffer)	%	0		1
MEM0303_PHYS_UTIL_CAC	C001_MEM	MEM0300_PHYS_UTIL	Physical Memory Usage(Cached)	%	0		1
MEM0400_SWAP_IO	C001_MEM	\N	Swap I/O	kB/s	0		0
MEM0401_SWAP_IO_IN	C001_MEM	MEM0400_SWAP_IO	Swap I/O(In)	kB/s	0		0
MEM0402_SWAP_IO_OUT	C001_MEM	MEM0400_SWAP_IO	Swap I/O(Out)	kB/s	0		0
MEM0500_MEM_MB	C001_MEM	\N	Memory Usage MB	MB	0		0
MEM0600_SWAP_BLK	C001_MEM	\N	Swap Block Usage	blocks/s	0		0
MEM0601_SWAP_BLK_IN	C001_MEM	MEM0600_SWAP_BLK	Swap Block Usage(In)	blocks/s	0		0
MEM0602_SWAP_BLK_OUT	C001_MEM	MEM0600_SWAP_BLK	Swap Block Usage(Out)	blocks/s	0		0
MEM0700_SWAP_MB	C001_MEM	\N	Swap Usage	MB	0		0
NET0100_PACKET	C003_NET	\N	Total Packets	counts/s	0		0
NET0101_PACKET_RCV	C003_NET	NET0100_PACKET	Packets(Received)	counts/s	0		0
NET0102_PACKET_SNT	C003_NET	NET0100_PACKET	Packets(Sent)	counts/s	0		0
NET0200_DVC_PCK	C003_NET	\N	Packets For Each Device	counts/s	1	nic	0
NET0201_DVC_PCK_RCV	C003_NET	NET0200_DVC_PCK	Packets For Each Device(Received)	counts/s	1	nic	0
NET0202_DVC_PCK_SNT	C003_NET	NET0200_DVC_PCK	Packets For Each Device(Sent)	counts/s	1	nic	0
NET0300_ERR_PCK	C003_NET	\N	Total Error Packets	counts/s	0		0
NET0301_ERR_PCK_RCV	C003_NET	NET0300_ERR_PCK	Error Packets(Received)	counts/s	0		0
NET0302_ERR_PCK_SNT	C003_NET	NET0300_ERR_PCK	Error Packets(Sent)	counts/s	0		0
NET0400_DVC_ERR_PCK	C003_NET	\N	Error Packets For Each Device	counts/s	1	nic	0
NET0401_DVC_ERR_PCK_RCV	C003_NET	NET0400_DVC_ERR_PCK	Error Packets For Each Device(Received)	counts/s	1	nic	0
NET0402_DVC_ERR_PCK_SNT	C003_NET	NET0400_DVC_ERR_PCK	Error Packets For Each Device(Sent)	counts/s	1	nic	0
NET0500_BYTE	C003_NET	\N	Network Bytes	byte/s	0		0
NET0501_BYTE_RCV	C003_NET	NET0500_BYTE	Network Bytes(Received)	byte/s	0		0
NET0502_BYTE_SNT	C003_NET	NET0500_BYTE	Network Bytes(Sent)	byte/s	0		0
NET0600_DVC_BYTE	C003_NET	\N	Network Bytes For Each Device	byte/s	1	nic	0
NET0601_DVC_BYTE_RCV	C003_NET	NET0600_DVC_BYTE	Network Bytes For Each Device(Received)	byte/s	1	nic	0
NET0602_DVC_BYTE_SNT	C003_NET	NET0600_DVC_BYTE	Network Bytes For Each Device(Sent)	byte/s	1	nic	0
CPU0110_DVC_CPU_UTIL	C000_CPU	\N	CPU Usage(Core)	%	1	cpu	1
\.


--
-- Data for Name: cc_collector_platform_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_platform_mst (platform_id, platform_name, order_no) FROM stdin;
LINUX	Linux	0
NW_EQUIPMENT	Network Equipment	100
OTHER	Other	1000
WINDOWS	Windows	20
\.


--
-- Data for Name: cc_collector_polling_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_collector_polling_mst (collect_method, platform_id, sub_platform_id, item_code, variable_id, entry_key, value_type, polling_target, failure_value) FROM stdin;
SNMP	LINUX		CPU0100_CPU_UTIL	var0	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0100_CPU_UTIL	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0100_CPU_UTIL	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0100_CPU_UTIL	var3	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0100_CPU_UTIL	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var0	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var1	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var2	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var0	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var0	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var2	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var0	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var3	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var4	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	LINUX		CPU0200_INTERRUPT_RATE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		CPU0200_INTERRUPT_RATE	var1	.1.3.6.1.4.1.2021.11.59.0	Counter32	.1.3.6.1.4.1.2021.11.59	\N
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	var1	.1.3.6.1.4.1.2021.11.60.0	Counter32	.1.3.6.1.4.1.2021.11.60	\N
SNMP	LINUX		CPU0400_LOAD_AVE_1M	var0	.1.3.6.1.4.1.2021.10.1.5.1	Integer32	.1.3.6.1.4.1.2021.10.1.5	\N
SNMP	LINUX		CPU0500_LOAD_AVE_5M	var0	.1.3.6.1.4.1.2021.10.1.5.2	Integer32	.1.3.6.1.4.1.2021.10.1.5	\N
SNMP	LINUX		CPU0600_LOAD_AVE_15M	var0	.1.3.6.1.4.1.2021.10.1.5.3	Integer32	.1.3.6.1.4.1.2021.10.1.5	\N
SNMP	LINUX		DSK0100_DVC_IO_CNT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0100_DVC_IO_CNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0100_DVC_IO_CNT	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.5	\N
SNMP	LINUX		DSK0100_DVC_IO_CNT	var2	.1.3.6.1.4.1.2021.13.15.1.1.6.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.6	\N
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.5	\N
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.6.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.6	\N
SNMP	LINUX		DSK0200_DVC_IO_BYTE	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.3	\N
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var2	.1.3.6.1.4.1.2021.13.15.1.1.4.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.4	\N
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.3	\N
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.4.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.4	\N
SNMP	LINUX		FS_0100_DVC_UTIL	key	.1.3.6.1.2.1.25.2.3.1.3.?	String	.1.3.6.1.2.1.25.2.3.1.3	\N
SNMP	LINUX		FS_0100_DVC_UTIL	var0	.1.3.6.1.2.1.25.2.3.1.6.?	Integer32	.1.3.6.1.2.1.25.2.3.1.6	\N
SNMP	LINUX		FS_0100_DVC_UTIL	var1	.1.3.6.1.2.1.25.2.3.1.5.?	Integer32	.1.3.6.1.2.1.25.2.3.1.5	\N
SNMP	LINUX		FS_0200_DVC_UTIL	key	.1.3.6.1.4.1.2021.9.1.2.?	String	.1.3.6.1.4.1.2021.9.1.2	\N
SNMP	LINUX		FS_0200_DVC_UTIL	var0	.1.3.6.1.4.1.2021.9.1.9.?	Integer32	.1.3.6.1.4.1.2021.9.1.9	\N
SNMP	LINUX		MEM0100_MEM_UTIL	var0	.1.3.6.1.4.1.2021.4.11.0	Integer32	.1.3.6.1.4.1.2021.4.11	\N
SNMP	LINUX		MEM0100_MEM_UTIL	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	LINUX		MEM0100_MEM_UTIL	var2	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var0	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var2	.1.3.6.1.4.1.2021.4.4.0	Integer32	.1.3.6.1.4.1.2021.4.4	\N
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var0	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var2	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	LINUX		MEM0200_SWAP_SPACE	var0	.1.3.6.1.4.1.2021.4.4.0	Integer32	.1.3.6.1.4.1.2021.4.4	\N
SNMP	LINUX		MEM0200_SWAP_SPACE	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	LINUX		MEM0300_PHYS_UTIL	var0	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	LINUX		MEM0300_PHYS_UTIL	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var0	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var1	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var2	.1.3.6.1.4.1.2021.4.14.0	Integer32	.1.3.6.1.4.1.2021.4.14	\N
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var3	.1.3.6.1.4.1.2021.4.15.0	Integer32	.1.3.6.1.4.1.2021.4.15	\N
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	var0	.1.3.6.1.4.1.2021.4.14.0	Integer32	.1.3.6.1.4.1.2021.4.14	\N
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	var0	.1.3.6.1.4.1.2021.4.15.0	Integer32	.1.3.6.1.4.1.2021.4.15	\N
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	LINUX		MEM0400_SWAP_IO	var0	.1.3.6.1.4.1.2021.11.3.0	Integer32	.1.3.6.1.4.1.2021.11.3	\N
SNMP	LINUX		MEM0400_SWAP_IO	var1	.1.3.6.1.4.1.2021.11.4.0	Integer32	.1.3.6.1.4.1.2021.11.4	\N
SNMP	LINUX		MEM0401_SWAP_IO_IN	var0	.1.3.6.1.4.1.2021.11.3.0	Integer32	.1.3.6.1.4.1.2021.11.3	\N
SNMP	LINUX		MEM0402_SWAP_IO_OUT	var0	.1.3.6.1.4.1.2021.11.4.0	Integer32	.1.3.6.1.4.1.2021.11.4	\N
SNMP	LINUX		MEM0600_SWAP_BLK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		MEM0600_SWAP_BLK	var1	.1.3.6.1.4.1.2021.11.62.0	Counter32	.1.3.6.1.4.1.2021.11.62	\N
SNMP	LINUX		MEM0600_SWAP_BLK	var2	.1.3.6.1.4.1.2021.11.63.0	Counter32	.1.3.6.1.4.1.2021.11.63	\N
SNMP	LINUX		MEM0601_SWAP_BLK_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		MEM0601_SWAP_BLK_IN	var1	.1.3.6.1.4.1.2021.11.62.0	Counter32	.1.3.6.1.4.1.2021.11.62	\N
SNMP	LINUX		MEM0602_SWAP_BLK_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		MEM0602_SWAP_BLK_OUT	var1	.1.3.6.1.4.1.2021.11.63.0	Counter32	.1.3.6.1.4.1.2021.11.63	\N
SNMP	LINUX		NET0100_PACKET	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	LINUX		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	LINUX		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	LINUX		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	LINUX		NET0200_DVC_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	LINUX		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	LINUX		NET0201_DVC_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	LINUX		NET0202_DVC_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	LINUX		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	LINUX		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	LINUX		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	LINUX		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	LINUX		NET0400_DVC_ERR_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	LINUX		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	LINUX		NET0500_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	LINUX		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	LINUX		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	LINUX		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	LINUX		NET0600_DVC_BYTE	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	LINUX		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	LINUX		NET0601_DVC_BYTE_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	LINUX		NET0602_DVC_BYTE_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	LINUX		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	LINUX		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	NW_EQUIPMENT		NET0100_PACKET	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	NW_EQUIPMENT		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	NW_EQUIPMENT		NET0500_BYTE	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	NW_EQUIPMENT		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.1.3.0	TimeTicks	.1.3.6.1.2.1.1.3	\N
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	WINDOWS		CPU0100_CPU_UTIL	var0	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	WINDOWS		CPU0100_CPU_UTIL	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	WINDOWS		CPU0100_CPU_UTIL	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	WINDOWS		CPU0100_CPU_UTIL	var3	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	WINDOWS		CPU0100_CPU_UTIL	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var0	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var1	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var2	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var0	.1.3.6.1.4.1.2021.11.52.0	Counter32	.1.3.6.1.4.1.2021.11.52	\N
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var1	.1.3.6.1.4.1.2021.11.50.0	Counter32	.1.3.6.1.4.1.2021.11.50	\N
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var2	.1.3.6.1.4.1.2021.11.51.0	Counter32	.1.3.6.1.4.1.2021.11.51	0
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var3	.1.3.6.1.4.1.2021.11.53.0	Counter32	.1.3.6.1.4.1.2021.11.53	\N
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var4	.1.3.6.1.4.1.2021.11.54.0	Counter32	.1.3.6.1.4.1.2021.11.54	\N
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	var1	.1.3.6.1.4.1.2021.11.59.0	Counter32	.1.3.6.1.4.1.2021.11.59	\N
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	var1	.1.3.6.1.4.1.2021.11.60.0	Counter32	.1.3.6.1.4.1.2021.11.60	\N
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.5	\N
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var2	.1.3.6.1.4.1.2021.13.15.1.1.6.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.6	\N
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.5	\N
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.6.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.6	\N
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.3	\N
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var2	.1.3.6.1.4.1.2021.13.15.1.1.4.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.4	\N
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.3	\N
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	key	.1.3.6.1.4.1.2021.13.15.1.1.2.?	String	.1.3.6.1.4.1.2021.13.15.1.1.2	\N
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.4.?	Counter32	.1.3.6.1.4.1.2021.13.15.1.1.4	\N
SNMP	WINDOWS		FS_0100_DVC_UTIL	key	.1.3.6.1.2.1.25.2.3.1.3.?	String	.1.3.6.1.2.1.25.2.3.1.3	\N
SNMP	WINDOWS		FS_0100_DVC_UTIL	var0	.1.3.6.1.2.1.25.2.3.1.6.?	Integer32	.1.3.6.1.2.1.25.2.3.1.6	\N
SNMP	WINDOWS		FS_0100_DVC_UTIL	var1	.1.3.6.1.2.1.25.2.3.1.5.?	Integer32	.1.3.6.1.2.1.25.2.3.1.5	\N
SNMP	WINDOWS		MEM0100_MEM_UTIL	var0	.1.3.6.1.4.1.2021.4.11.0	Integer32	.1.3.6.1.4.1.2021.4.11	\N
SNMP	WINDOWS		MEM0100_MEM_UTIL	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	WINDOWS		MEM0100_MEM_UTIL	var2	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var0	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var2	.1.3.6.1.4.1.2021.4.4.0	Integer32	.1.3.6.1.4.1.2021.4.4	\N
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var0	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var2	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	WINDOWS		MEM0200_SWAP_SPACE	var0	.1.3.6.1.4.1.2021.4.4.0	Integer32	.1.3.6.1.4.1.2021.4.4	\N
SNMP	WINDOWS		MEM0200_SWAP_SPACE	var1	.1.3.6.1.4.1.2021.4.3.0	Integer32	.1.3.6.1.4.1.2021.4.3	\N
SNMP	WINDOWS		MEM0300_PHYS_UTIL	var0	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	WINDOWS		MEM0300_PHYS_UTIL	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var0	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var1	.1.3.6.1.4.1.2021.4.6.0	Integer32	.1.3.6.1.4.1.2021.4.6	\N
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var2	.1.3.6.1.4.1.2021.4.14.0	Integer32	.1.3.6.1.4.1.2021.4.14	\N
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var3	.1.3.6.1.4.1.2021.4.15.0	Integer32	.1.3.6.1.4.1.2021.4.15	\N
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	var0	.1.3.6.1.4.1.2021.4.14.0	Integer32	.1.3.6.1.4.1.2021.4.14	\N
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	var0	.1.3.6.1.4.1.2021.4.15.0	Integer32	.1.3.6.1.4.1.2021.4.15	\N
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	var1	.1.3.6.1.4.1.2021.4.5.0	Integer32	.1.3.6.1.4.1.2021.4.5	\N
SNMP	WINDOWS		MEM0400_SWAP_IO	var0	.1.3.6.1.4.1.2021.11.3.0	Integer32	.1.3.6.1.4.1.2021.11.3	\N
SNMP	WINDOWS		MEM0400_SWAP_IO	var1	.1.3.6.1.4.1.2021.11.4.0	Integer32	.1.3.6.1.4.1.2021.11.4	\N
SNMP	WINDOWS		MEM0401_SWAP_IO_IN	var0	.1.3.6.1.4.1.2021.11.3.0	Integer32	.1.3.6.1.4.1.2021.11.3	\N
SNMP	WINDOWS		MEM0402_SWAP_IO_OUT	var0	.1.3.6.1.4.1.2021.11.4.0	Integer32	.1.3.6.1.4.1.2021.11.4	\N
SNMP	WINDOWS		NET0100_PACKET	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	WINDOWS		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	WINDOWS		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	WINDOWS		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	WINDOWS		NET0200_DVC_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	WINDOWS		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	Counter32	.1.3.6.1.2.1.2.2.1.11	\N
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	Counter32	.1.3.6.1.2.1.2.2.1.17	\N
SNMP	WINDOWS		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	WINDOWS		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	Counter32	.1.3.6.1.2.1.2.2.1.14	\N
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	Counter32	.1.3.6.1.2.1.2.2.1.20	\N
SNMP	WINDOWS		NET0500_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	WINDOWS		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	WINDOWS		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	WINDOWS		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	WINDOWS		NET0600_DVC_BYTE	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	WINDOWS		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	Counter32	.1.3.6.1.2.1.2.2.1.10	\N
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	key	.1.3.6.1.2.1.2.2.1.2.?	String	.1.3.6.1.2.1.2.2.1.2	\N
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	TimeTicks	.1.3.6.1.2.1.25.1.1	\N
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	Counter32	.1.3.6.1.2.1.2.2.1.16	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var0	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var2	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var3	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0100_CPU_UTIL	var4		Uint64		0
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var0	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var1	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var2	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var4		Uint64		0
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var0	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var2	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var4		Uint64		0
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var0		Uint64		0
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var1	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var2	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var3	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var4	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var0	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUUserTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var2	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Uint64	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var4		Uint64		0
WBEM	LINUX		DSK0100_DVC_IO_CNT	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0100_DVC_IO_CNT	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0100_DVC_IO_CNT	var1	Linux_BlockStorageStatisticalData.TotalIOs.?	Uint64	Linux_BlockStorageStatisticalData.TotalIOs	\N
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	var1	Linux_BlockStorageStatisticalData.ReadIOs.?	Uint64	Linux_BlockStorageStatisticalData.ReadIOs	\N
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	var1	Linux_BlockStorageStatisticalData.WriteIOs.?	Uint64	Linux_BlockStorageStatisticalData.WriteIOs	\N
WBEM	LINUX		DSK0200_DVC_IO_BYTE	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0200_DVC_IO_BYTE	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0200_DVC_IO_BYTE	var1	Linux_BlockStorageStatisticalData.KBytesTransfered.?	Uint64	Linux_BlockStorageStatisticalData.KBytesTransfered	\N
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	var1	Linux_BlockStorageStatisticalData.KBytesRead.?	Uint64	Linux_BlockStorageStatisticalData.KBytesRead	\N
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	key	Linux_BlockStorageStatisticalData.ElementName.?	String	Linux_BlockStorageStatisticalData.ElementName	\N
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var0	PG_OperatingSystem.SystemUpTime.0	Uint64	PG_OperatingSystem.SystemUpTime	\N
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var1	Linux_BlockStorageStatisticalData.KBytesTransfered.?	Uint64	Linux_BlockStorageStatisticalData.KBytesTransfered	\N
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var2	Linux_BlockStorageStatisticalData.KBytesRead.?	Uint64	Linux_BlockStorageStatisticalData.KBytesRead	\N
WBEM	LINUX		FS_0101_DVC_UTIL	key	Linux_Ext3FileSystem.Root.?	String	Linux_Ext3FileSystem.Root	\N
WBEM	LINUX		FS_0101_DVC_UTIL	var0	Linux_Ext3FileSystem.AvailableSpace.?	Uint64	Linux_Ext3FileSystem.AvailableSpace	\N
WBEM	LINUX		FS_0101_DVC_UTIL	var1	Linux_Ext3FileSystem.FileSystemSize.?	Uint64	Linux_Ext3FileSystem.FileSystemSize	\N
WBEM	LINUX		FS_0102_DVC_UTIL	key	Linux_Ext4FileSystem.Root.?	String	Linux_Ext4FileSystem.Root	\N
WBEM	LINUX		FS_0102_DVC_UTIL	var0	Linux_Ext4FileSystem.AvailableSpace.?	Uint64	Linux_Ext4FileSystem.AvailableSpace	\N
WBEM	LINUX		FS_0102_DVC_UTIL	var1	Linux_Ext4FileSystem.FileSystemSize.?	Uint64	Linux_Ext4FileSystem.FileSystemSize	\N
WBEM	LINUX		MEM0100_MEM_UTIL	var0	PG_OperatingSystem.FreePhysicalMemory.0	Uint64	PG_OperatingSystem.FreePhysicalMemory	\N
WBEM	LINUX		MEM0100_MEM_UTIL	var1	PG_OperatingSystem.FreeVirtualMemory.0	Uint64	PG_OperatingSystem.FreeVirtualMemory	\N
WBEM	LINUX		MEM0100_MEM_UTIL	var2	PG_OperatingSystem.TotalVisibleMemorySize.0	Uint64	PG_OperatingSystem.TotalVisibleMemorySize	\N
WBEM	LINUX		MEM0100_MEM_UTIL	var3	PG_OperatingSystem.TotalSwapSpaceSize.0	Uint64	PG_OperatingSystem.TotalSwapSpaceSize	\N
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var0	PG_OperatingSystem.TotalSwapSpaceSize.0	Uint64	PG_OperatingSystem.TotalSwapSpaceSize	\N
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var1	PG_OperatingSystem.TotalVisibleMemorySize.0	Uint64	PG_OperatingSystem.TotalVisibleMemorySize	\N
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var2	PG_OperatingSystem.FreeVirtualMemory.0	Uint64	PG_OperatingSystem.FreeVirtualMemory	\N
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var0	PG_OperatingSystem.TotalVisibleMemorySize.0	Uint64	PG_OperatingSystem.TotalVisibleMemorySize	\N
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var1	PG_OperatingSystem.TotalSwapSpaceSize.0	Uint64	PG_OperatingSystem.TotalSwapSpaceSize	\N
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var2	PG_OperatingSystem.FreePhysicalMemory.0	Uint64	PG_OperatingSystem.FreePhysicalMemory	\N
WBEM	LINUX		MEM0200_SWAP_SPACE	var0	PG_OperatingSystem.FreeVirtualMemory.0	Uint64	PG_OperatingSystem.FreeVirtualMemory	\N
WBEM	LINUX		MEM0200_SWAP_SPACE	var1	PG_OperatingSystem.TotalSwapSpaceSize.0	Uint64	PG_OperatingSystem.TotalSwapSpaceSize	\N
WBEM	LINUX		MEM0300_PHYS_UTIL	var0	PG_OperatingSystem.FreePhysicalMemory.0	Uint64	PG_OperatingSystem.FreePhysicalMemory	\N
WBEM	LINUX		MEM0300_PHYS_UTIL	var1	PG_OperatingSystem.TotalVisibleMemorySize.0	Uint64	PG_OperatingSystem.TotalVisibleMemorySize	\N
WBEM	LINUX		MEM0400_SWAP_IO	var0	Linux_OperatingSystem.TotalSwapSpaceSize.0	Uint64	Linux_OperatingSystem.TotalSwapSpaceSize	\N
SNMP	LINUX		CPU0110_DVC_CPU_UTIL	key	.1.3.6.1.2.1.25.3.2.1.1.?	String	.1.3.6.1.2.1.25.3.2.1.1	\N
SNMP	LINUX		CPU0110_DVC_CPU_UTIL	var0	.1.3.6.1.2.1.25.3.3.1.2.?	Integer32	.1.3.6.1.2.1.25.3.3.1.2	\N
SNMP	WINDOWS		CPU0110_DVC_CPU_UTIL	key	.1.3.6.1.2.1.25.3.2.1.1.?	String	.1.3.6.1.2.1.25.3.2.1.1	\N
SNMP	WINDOWS		CPU0110_DVC_CPU_UTIL	var0	.1.3.6.1.2.1.25.3.3.1.2.?	Integer32	.1.3.6.1.2.1.25.3.3.1.2	\N
\.


--
-- Data for Name: cc_crun_cmd_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) FROM stdin;
ADD_USER	USER	0	add.user	1	/opt/hinemos/lib/cr/useradd.sh
AGENT_INSTALL	AGENT	0	agent.installation	1	/opt/hinemos/lib/cr/agent_install.sh
COPY_FILE	FILE	0	copy.file	1	/opt/hinemos/lib/cr/cp.sh
DELETE_USER	USER	2	delete.user	0	/usr/sbin/userdel -r
FILEJOB_SETTING	AGENT	1	setting.file.transfer	1	/opt/hinemos/lib/cr/file_transfer_setting.sh
MAKE_DIRECTORY	FILE	1	make.directory	1	/opt/hinemos/lib/cr/mkdir.sh
MODIFY_USER	USER	1	modify.user	1	/opt/hinemos/lib/cr/usermod.sh
REBOOT_LINUX	START_STOP	0	reboot.linux	0	/sbin/reboot
REMOVE_FILE	FILE	2	remove.file.directory	1	/opt/hinemos/lib/cr/rm.sh
RPM_INSTALL	INSTALL	0	rpm.installation	1	/opt/hinemos/lib/cr/rpminstall.sh
SHUTDOWN_LINUX	START_STOP	1	shutdown.linux	0	/sbin/poweroff
START_APACHE	START_STOP	2	start.apache	0	/etc/init.d/httpd start
STOP_APACHE	START_STOP	3	stop.apache	0	/etc/init.d/httpd stop
\.


--
-- Data for Name: cc_crun_cmd_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) FROM stdin;
ADD_USER	GROUP_NAME	3	-g
ADD_USER	HOME_DIRECTORY	6	-d
ADD_USER	LOGIN_SHELL	5	-s
ADD_USER	PASSWORD	2	-p
ADD_USER	SECONDARY_GROUP_NAME	4	-G
ADD_USER	UID	0	-u
ADD_USER	USER_NAME	1	\N
AGENT_INSTALL	AGENT_PATH	4	-a
AGENT_INSTALL	AGENT_PLACE	5	-w
AGENT_INSTALL	JRE_LICENSE	6	-j
AGENT_INSTALL	MANAGER_ADDRESS	1	-m
AGENT_INSTALL	MANAGER_IP	2	-i
AGENT_INSTALL	MANAGER_ROOT_PASSWORD	3	-p
COPY_FILE	DESTINATION	1	-d
COPY_FILE	FILE_PERMISSION	4	-m
COPY_FILE	GROUP_NAME	3	-g
COPY_FILE	SOURCE_FILE	0	\N
COPY_FILE	USER_NAME	2	-u
DELETE_USER	USER_NAME	0	\N
FILEJOB_SETTING	FILE_TRANSFER_USER	2	-u
FILEJOB_SETTING	ROOT_PASSWORD	1	-r
FILEJOB_SETTING	TRANSFER_IP	0	-i
FILEJOB_SETTING	TRANSFER_PASSWORD	3	-p
MAKE_DIRECTORY	DIRECTORY_NAME	0	\N
MAKE_DIRECTORY	DIRECTORY_PERMISSION	3	-m
MAKE_DIRECTORY	GROUP_NAME	2	-g
MAKE_DIRECTORY	USER_NAME	1	-u
MODIFY_USER	GROUP_NAME	2	-g
MODIFY_USER	LOGIN_SHELL	4	-s
MODIFY_USER	PASSWORD	1	-p
MODIFY_USER	SECONDARY_GROUP_NAME	3	-G
MODIFY_USER	USER_NAME	0	\N
REMOVE_FILE	FILE_DIRECTORY	0	\N
REMOVE_FILE	USER_NAME	1	-u
RPM_INSTALL	FILE	0	\N
\.


--
-- Data for Name: cc_crun_end_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) FROM stdin;
ADD_USER	0	0	0
ADD_USER	1	1	2
AGENT_INSTALL	0	0	0
AGENT_INSTALL	1	1	9
COPY_FILE	0	0	0
COPY_FILE	1	1	9
DELETE_USER	0	0	0
FILEJOB_SETTING	0	0	0
FILEJOB_SETTING	1	1	9
MAKE_DIRECTORY	0	0	0
MAKE_DIRECTORY	1	1	9
MODIFY_USER	0	0	0
MODIFY_USER	1	1	2
REBOOT_LINUX	0	0	0
REMOVE_FILE	0	0	0
RPM_INSTALL	0	0	0
RPM_INSTALL	1	1	9
SHUTDOWN_LINUX	0	0	0
START_APACHE	0	0	0
STOP_APACHE	0	0	0
\.


--
-- Data for Name: cc_crun_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_param_mst (param_id, name_id, param_type) FROM stdin;
AGENT_PATH	agent.path	0
AGENT_PLACE	agent.place	0
DESTINATION	destination	0
DIRECTORY_NAME	directory.name	0
DIRECTORY_PERMISSION	file.access.permission	2
FILE	file	0
FILE_DIRECTORY	file.directory	0
FILE_PERMISSION	file.access.permission	2
FILE_TRANSFER_USER	file.transfer.user	0
GROUP_NAME	group.name	0
HOME_DIRECTORY	home.directory	0
JRE_LICENSE	jre.license	2
LOGIN_SHELL	login.shell	2
MANAGER_ADDRESS	manager.hinemos.address	0
MANAGER_IP	manager.ip.address	0
MANAGER_ROOT_PASSWORD	manager.root.password	1
PASSWORD	password	1
ROOT_PASSWORD	transfer.root.password	1
SECONDARY_GROUP_NAME	secondary.group.name	0
SOURCE_FILE	source.file	0
TRANSFER_IP	transfer.ip.address	0
TRANSFER_PASSWORD	file.transfer.password	1
UID	uid	0
USER_NAME	user.name	0
\.


--
-- Data for Name: cc_crun_param_select_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_param_select_mst (param_id, order_no, name_id, param_value) FROM stdin;
DIRECTORY_PERMISSION	0	rwx------	700
DIRECTORY_PERMISSION	1	rwxrwx---	770
DIRECTORY_PERMISSION	2	rwxr-x---	750
DIRECTORY_PERMISSION	3	rwxr-xr-x	755
DIRECTORY_PERMISSION	4	r-x------	500
DIRECTORY_PERMISSION	5	r-xr-x---	550
DIRECTORY_PERMISSION	6	r-xr-xr-x	555
FILE_PERMISSION	0	rwx------	700
FILE_PERMISSION	1	rwxrwx---	770
FILE_PERMISSION	2	rwxr-x---	750
FILE_PERMISSION	3	rwxr-xr-x	755
FILE_PERMISSION	4	rw-------	600
FILE_PERMISSION	5	rw-rw----	660
FILE_PERMISSION	6	rw-r-----	640
FILE_PERMISSION	7	rw-r--r--	644
FILE_PERMISSION	8	r--------	400
FILE_PERMISSION	9	r--r-----	440
FILE_PERMISSION	10	r--r--r--	444
JRE_LICENSE	0	YES	yes
JRE_LICENSE	1	NO	no
LOGIN_SHELL	0	/bin/sh	/bin/sh
LOGIN_SHELL	1	/bin/bash	/bin/bash
LOGIN_SHELL	2	/bin/ksh	/bin/ksh
LOGIN_SHELL	3	/bin/tcsh	/bin/tcsh
LOGIN_SHELL	4	/bin/csh	/bin/csh
\.


--
-- Data for Name: cc_crun_session; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session (session_id, start_date, end_date, type_id, command_id, facility_id, scope_text, node_cnt, wait_cnt, running_cnt, end_nomal_cnt, end_warning_cnt, end_abnomal_cnt, status) FROM stdin;
\.


--
-- Data for Name: cc_crun_session_detail; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session_detail (session_id, facility_id, start_date, end_date, facility_name, message, error_message, status, end_status, end_value) FROM stdin;
\.


--
-- Data for Name: cc_crun_session_param; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_session_param (session_id, param_id, param_value) FROM stdin;
\.


--
-- Data for Name: cc_crun_type_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_crun_type_mst (type_id, name_id, order_no) FROM stdin;
AGENT	agent.management	4
FILE	filesystem.management	0
INSTALL	installation.management	1
START_STOP	start.stop.management	2
USER	user.management	3
\.


--
-- Data for Name: cc_event_log; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_event_log (monitor_id, monitor_detail_id, plugin_id, generation_date, facility_id, scope_text, application, message_id, message, message_org, priority, confirm_flg, confirm_date, confirm_user, duplication_count, output_date, inhibited_flg) FROM stdin;
\.


--
-- Data for Name: cc_job_end_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_end_info (session_id, jobunit_id, job_id, end_status, end_value, end_value_from, end_value_to) FROM stdin;
\.


--
-- Data for Name: cc_job_end_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_end_mst (jobunit_id, job_id, end_status, end_value, end_value_from, end_value_to) FROM stdin;
\.


--
-- Data for Name: cc_job_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_info (session_id, jobunit_id, job_id, job_name, description, job_type, facility_id, process_mode, start_command, stop_type, stop_command, specify_user, effective_user, error_end_flg, error_end_value, argument_job_id, argument, condition_type, suspend, skip, skip_end_status, skip_end_value, unmatch_end_flg, unmatch_end_status, unmatch_end_value, calendar, calendar_id, calendar_end_status, calendar_end_value, start_delay, start_delay_session, start_delay_session_value, start_delay_time, start_delay_time_value, start_delay_condition_type, start_delay_notify, start_delay_notify_priority, start_delay_operation, start_delay_operation_type, start_delay_operation_end_status, start_delay_operation_end_value, end_delay, end_delay_session, end_delay_session_value, end_delay_job, end_delay_job_value, end_delay_time, end_delay_time_value, end_delay_condition_type, end_delay_notify, end_delay_notify_priority, end_delay_operation, end_delay_operation_type, end_delay_operation_end_status, end_delay_operation_end_value, multiplicity_notify, multiplicity_notify_priority, multiplicity_operation, multiplicity_end_value, message_retry, src_facility_id, dest_facility_id, src_file, src_work_dir, dest_directory, dest_work_dir, compression_flg, check_flg, start_time, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_job_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_mst (jobunit_id, job_id, job_name, description, job_type, facility_id, process_mode, start_command, stop_type, stop_command, specify_user, effective_user, error_end_flg, error_end_value, argument_job_id, argument, condition_type, suspend, skip, skip_end_status, skip_end_value, unmatch_end_flg, unmatch_end_status, unmatch_end_value, calendar, calendar_id, calendar_end_status, calendar_end_value, start_delay, start_delay_session, start_delay_session_value, start_delay_time, start_delay_time_value, start_delay_condition_type, start_delay_notify, start_delay_notify_priority, start_delay_operation, start_delay_operation_type, start_delay_operation_end_status, start_delay_operation_end_value, end_delay, end_delay_session, end_delay_session_value, end_delay_job, end_delay_job_value, end_delay_time, end_delay_time_value, end_delay_condition_type, end_delay_notify, end_delay_notify_priority, end_delay_operation, end_delay_operation_type, end_delay_operation_end_status, end_delay_operation_end_value, multiplicity_notify, multiplicity_notify_priority, multiplicity_operation, multiplicity_end_value, message_retry, src_facility_id, dest_facility_id, src_file, src_work_dir, dest_directory, dest_work_dir, compression_flg, check_flg, start_time, parent_jobunit_id, parent_job_id, owner_role_id, reg_date, update_date, reg_user, update_user) FROM stdin;
ROOT	TOP			0	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	ALL_USERS	2012-04-01 00:00:00	2012-04-01 00:00:00		
\.


--
-- Data for Name: cc_job_notice_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_notice_info (session_id, jobunit_id, job_id, notice_type, priority, notify_group_id) FROM stdin;
\.


--
-- Data for Name: cc_job_notice_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_notice_mst (jobunit_id, job_id, notice_type, priority, notify_group_id) FROM stdin;
\.


--
-- Data for Name: cc_job_param_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_param_info (session_id, jobunit_id, job_id, param_id, param_type, description, value) FROM stdin;
\.


--
-- Data for Name: cc_job_param_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_param_mst (jobunit_id, job_id, param_id, param_type, description, value) FROM stdin;
\.


--
-- Data for Name: cc_job_session; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session (session_id, jobunit_id, job_id, schedule_date, operation_flg, trigger_type, trigger_info) FROM stdin;
\.


--
-- Data for Name: cc_job_session_job; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session_job (session_id, jobunit_id, job_id, scope_text, status, start_date, end_date, end_value, end_status, result, end_staus_check_flg, delay_notify_flg, parent_jobunit_id, parent_job_id) FROM stdin;
\.


--
-- Data for Name: cc_job_session_node; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_session_node (session_id, jobunit_id, job_id, facility_id, node_name, status, start_date, end_date, end_value, message, retry_count, result) FROM stdin;
\.


--
-- Data for Name: cc_job_start_job_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_job_info (session_id, jobunit_id, job_id, target_jobunit_id, target_job_id, target_job_type, target_job_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_start_job_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_job_start_job_mst (jobunit_id, job_id, target_jobunit_id, target_job_id, target_job_type, target_job_end_value) FROM stdin;
\.


--
-- Data for Name: cc_job_edit; Type: TABLE DATA; Schema: public; Owner:hinemos
--

COPY cc_job_edit (jobunit_id, lock_user, lock_ip_address, edit_session) FROM stdin;
\.


--
-- Data for Name: cc_mail_template_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_mail_template_info (mail_template_id, description, subject, body, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_map_association; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_association (map_id, source, target) FROM stdin;
\.


--
-- Data for Name: cc_map_bg_image; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_bg_image (filename, filedata) FROM stdin;
\.


--
-- Data for Name: cc_map_icon_image; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_icon_image (filename, filedata) FROM stdin;
\.


--
-- Data for Name: cc_map_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_info (map_id, background_image) FROM stdin;
\.


--
-- Data for Name: cc_map_position; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_map_position (map_id, element_id, x, y) FROM stdin;
\.


--
-- Data for Name: cc_monitor_http_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_http_info (monitor_id, request_url, url_replace, proxy_set, proxy_host, proxy_port, timeout) FROM stdin;
\.


--
-- Data for Name: cc_monitor_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_info (monitor_id, monitor_type_id, monitor_type, description, facility_id, run_interval, calendar_id, failure_priority, notify_group_id, application, monitor_flg, collector_flg, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_monitor_numeric_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_numeric_value_info (monitor_id, priority, threshold_upper_limit, threshold_lower_limit, message_id, message) FROM stdin;
\.


--
-- Data for Name: cc_monitor_perf_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_perf_info (monitor_id, item_code, device_display_name, breakdown_flg) FROM stdin;
\.


--
-- Data for Name: cc_monitor_ping_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_ping_info (monitor_id, run_count, run_interval, timeout) FROM stdin;
\.


--
-- Data for Name: cc_monitor_port_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_port_info (monitor_id, port_number, run_count, run_interval, timeout, service_id) FROM stdin;
\.


--
-- Data for Name: cc_monitor_process_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_process_info (monitor_id, command, param) FROM stdin;
\.


--
-- Data for Name: cc_monitor_process_method_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_process_method_mst (platform_id, sub_platform_id, collect_method) FROM stdin;
LINUX		SNMP
NW_EQUIPMENT		SNMP
OTHER		SNMP
WINDOWS		SNMP
\.


--
-- Data for Name: cc_monitor_process_polling_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_process_polling_mst (collect_method, platform_id, sub_platform_id, variable_id, entry_key, polling_target) FROM stdin;
SNMP	LINUX		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	LINUX		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	LINUX		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	NW_EQUIPMENT		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	NW_EQUIPMENT		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	NW_EQUIPMENT		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	OTHER		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	OTHER		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	OTHER		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	WINDOWS		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	WINDOWS		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	WINDOWS		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
WBEM	LINUX		param	Linux_UnixProcess.Parameters.*	Linux_UnixProcess.Parameters
\.


--
-- Data for Name: cc_monitor_protocol_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_protocol_mst (service_id, service_name, description, default_port_number, class_name) FROM stdin;
001	TCP	TCP connection establishment(3-way handshake)	\N	com.clustercontrol.port.protocol.ReachAddressTCP
002	FTP	File Transfer Protocol	21	com.clustercontrol.port.protocol.ReachAddressFTP
003	SMTP	Simple Mail Transfer Protocol	25	com.clustercontrol.port.protocol.ReachAddressSMTP
004	SMTPS	Simple Mail Transfer Protocol over SSL	465	com.clustercontrol.port.protocol.ReachAddressSMTPS
005	POP3	Post Office Protocol Version 3	110	com.clustercontrol.port.protocol.ReachAddressPOP3
006	POP3S	Post Office Protocol Version 3 over SSL	995	com.clustercontrol.port.protocol.ReachAddressPOP3S
007	IMAP	Internet Message Access Protocol	143	com.clustercontrol.port.protocol.ReachAddressIMAP
008	IMAPS	Internet Message Access Protocol over SSL	993	com.clustercontrol.port.protocol.ReachAddressIMAPS
009	NTP	Network Time Protocol	123	com.clustercontrol.port.protocol.ReachAddressNTP
010	DNS	Domain Name System	53	com.clustercontrol.port.protocol.ReachAddressDNS
\.


--
-- Data for Name: cc_monitor_snmp_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_snmp_info (monitor_id, snmp_oid, convert_flg) FROM stdin;
\.


--
-- Data for Name: cc_monitor_snmp_value; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_snmp_value (monitor_id, facility_id, value, get_date) FROM stdin;
\.


--
-- Data for Name: cc_monitor_sql_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_sql_info (monitor_id, connection_url, connection_user, connection_password, query, jdbc_driver) FROM stdin;
\.


--
-- Data for Name: cc_monitor_status; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_status (facility_id, plugin_id, monitor_id, priority, last_update, counter) FROM stdin;
\.


--
-- Data for Name: cc_monitor_string_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_string_value_info (monitor_id, order_no, description, process_type, pattern, priority, message, case_sensitivity_flg, valid_flg) FROM stdin;
\.


--
-- Data for Name: cc_monitor_truth_value_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_monitor_truth_value_info (monitor_id, priority, truth_value, message_id, message) FROM stdin;
\.


--
-- Data for Name: cc_notify_command_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_command_info (notify_id, priority, valid_flg, command, effective_user, set_environment, command_timeout) FROM stdin;
COMMAND_FOR_POLLING	0	1	logger ERROR	hinemos	1	15000
COMMAND_FOR_POLLING	1	1	logger UNKNOWN	hinemos	1	15000
COMMAND_FOR_POLLING	2	1	logger WARN	hinemos	1	15000
COMMAND_FOR_POLLING	3	1	logger INFO	hinemos	1	15000
COMMAND_FOR_TRAP	0	1	logger ERROR	hinemos	1	15000
COMMAND_FOR_TRAP	1	1	logger UNKNOWN	hinemos	1	15000
COMMAND_FOR_TRAP	2	1	logger WARN	hinemos	1	15000
COMMAND_FOR_TRAP	3	1	logger INFO	hinemos	1	15000
\.


--
-- Data for Name: cc_notify_event_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_event_info (notify_id, priority, event_normal_flg, event_normal_state) FROM stdin;
EVENT_FOR_POLLING	0	1	0
EVENT_FOR_POLLING	1	1	0
EVENT_FOR_POLLING	2	1	0
EVENT_FOR_POLLING	3	1	0
EVENT_FOR_TRAP	0	1	0
EVENT_FOR_TRAP	1	1	0
EVENT_FOR_TRAP	2	1	0
EVENT_FOR_TRAP	3	1	0
\.


--
-- Data for Name: cc_notify_history; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_history (facility_id, plugin_id, monitor_id, notify_id, last_notify) FROM stdin;
\.


--
-- Data for Name: cc_notify_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_info (notify_id, description, notify_type, initial_count, renotify_type, renotify_period, reg_date, update_date, reg_user, update_user, valid_flg, owner_role_id) FROM stdin;
COMMAND_FOR_POLLING	for polling monitor (ping, process, sql, etc.)	5	2	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	0	ALL_USERS
COMMAND_FOR_TRAP	for log Monitor, SNMPTRAP Monitor	5	1	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	0	ALL_USERS
EVENT_FOR_POLLING	for polling monitor (ping, process, sql, etc.)	1	2	2	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	1	ALL_USERS
EVENT_FOR_TRAP	for log Monitor, SNMPTRAP Monitor	1	1	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	1	ALL_USERS
MAIL_FOR_POLLING	for polling monitor (ping, process, sql, etc.)	2	2	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	0	ALL_USERS
MAIL_FOR_TRAP	for log Monitor, SNMPTRAP Monitor	2	1	1	30	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	0	ALL_USERS
STATUS_FOR_POLLING	for polling monitor (ping, process, sql, etc.)	0	2	0	\N	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	1	ALL_USERS
STATUS_FOR_TRAP	for log Monitor, SNMPTRAP Monitor	0	1	0	\N	2012-04-01 00:00:00	2012-04-01 00:00:00	hinemos	hinemos	1	ALL_USERS
\.


--
-- Data for Name: cc_notify_job_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_job_info (notify_id, priority, job_run, jobunit_id, job_id, job_failure_priority, job_exec_facility_flg, job_exec_facility) FROM stdin;
\.


--
-- Data for Name: cc_notify_log_escalate_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_log_escalate_info (notify_id, priority, escalate_flg, escalate_message, syslog_priority, syslog_facility, escalate_facility_flg, escalate_facility, escalate_port) FROM stdin;
\.


--
-- Data for Name: cc_notify_mail_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_mail_info (notify_id, priority, mail_template_id, mail_flg, mail_address) FROM stdin;
MAIL_FOR_POLLING	0	\N	1	hinemos@hinemos.info
MAIL_FOR_POLLING	1	\N	1	hinemos@hinemos.info
MAIL_FOR_POLLING	2	\N	1	hinemos@hinemos.info
MAIL_FOR_POLLING	3	\N	1	hinemos@hinemos.info
MAIL_FOR_TRAP	0	\N	1	hinemos@hinemos.info
MAIL_FOR_TRAP	1	\N	1	hinemos@hinemos.info
MAIL_FOR_TRAP	2	\N	1	hinemos@hinemos.info
MAIL_FOR_TRAP	3	\N	1	hinemos@hinemos.info
\.


--
-- Data for Name: cc_notify_relation_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_relation_info (notify_group_id, notify_id, notify_type, notify_flg) FROM stdin;
MON_SYSLOG_RESISTERED_ALL-0	EVENT_FOR_TRAP	1	0
MON_SYSLOG_RESISTERED_ALL-0	STATUS_FOR_TRAP	0	0
MON_SYSLOG_UNRESISTERED_ALL-0	EVENT_FOR_TRAP	1	0
MON_SYSLOG_UNRESISTERED_ALL-0	STATUS_FOR_TRAP	0	0
\.


--
-- Data for Name: cc_notify_status_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_notify_status_info (notify_id, priority, status_flg, status_valid_period, status_invalid_flg, status_update_priority) FROM stdin;
STATUS_FOR_POLLING	3	0	30	11	1
STATUS_FOR_POLLING	2	1	30	11	1
STATUS_FOR_POLLING	0	1	30	11	1
STATUS_FOR_POLLING	1	1	30	11	1
STATUS_FOR_TRAP	3	0	30	11	1
STATUS_FOR_TRAP	2	1	30	11	1
STATUS_FOR_TRAP	0	1	30	11	1
STATUS_FOR_TRAP	1	1	30	11	1
\.


--
-- Data for Name: cc_priority_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_priority_info (judgment_id, description, pattern_01, pattern_02, pattern_03, pattern_04, pattern_05, pattern_06, pattern_07, pattern_08, pattern_09, pattern_10, pattern_11, pattern_12, pattern_13, pattern_14, pattern_15, reg_date, update_date, reg_user, update_user) FROM stdin;
DEFAULT	\N	3	1	2	1	2	1	0	0	0	0	0	0	0	0	1	\N	2006-06-07 14:58:31.156	\N	hinemos
\.


--
-- Data for Name: cc_snmp_trap_mib_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_trap_mib_mst (mib, order_no, description, reg_date, update_date, reg_user, update_user) FROM stdin;
\.


--
-- Data for Name: cc_snmp_trap_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_trap_mst (mib, trap_oid, generic_id, specific_id, uei, logmsg, descr, priority) FROM stdin;
\.


--
-- Data for Name: cc_snmp_value_type_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_snmp_value_type_mst (value_type) FROM stdin;
Counter32
Counter64
DateTime
Gauge32
Integer32
String
TimeTicks
Uint16
Uint64
Uint8
\.


--
-- Data for Name: cc_status_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_status_info (facility_id, monitor_id, monitor_detail_id, plugin_id, application, message_id, message, priority, generation_date, output_date, expiration_flg, expiration_date) FROM stdin;
\.


--
-- Data for Name: cc_system_notify_event_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_system_notify_event_info (notify_id, priority, event_normal_flg, event_normal_state, event_inhibition_flg, event_inhibition_state, mail_flg, mail_address) FROM stdin;
\.


--
-- Data for Name: cc_system_notify_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_system_notify_info (notify_id, description, status_flg, status_valid_period, status_invalid_flg, status_update_priority, event_flg, inhibition_flg, inhibition_frequency, inhibition_period, reg_date, update_date, mail_template_id) FROM stdin;
\.


--
-- Data for Name: cc_vm_protocol_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_vm_protocol_mst (sub_platform_id, protocol, order_no) FROM stdin;
\.


--
-- Data for Name: cc_maintenance_info; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_maintenance_info (maintenance_id, description, type_id, data_retention_period, calendar_id, schedule_type, month, day, week, hour, minute, notify_group_id, application, valid_flg, owner_role_id, reg_date, update_date, reg_user, update_user) FROM stdin;
MT-CRN-DEFAULT	Batch control history deletion	DELETE_CRUN_HISTORY_ALL	31	\N	1	\N	\N	\N	5	50	SYS_MTN-MT-CRN-DEFAULT-0	MT-CRN-DEFAULT	1	ADMINISTRATORS	2013-01-01 00:00:00.000	2013-01-01 00:00:00.000	hinemos	hinemos
MT-EVE-DEFAULT	Event history deletion	DELETE_EVENT_LOG_ALL	31	\N	1	\N	\N	\N	5	40	SYS_MTN-MT-EVE-DEFAULT-0	MT-EVE-DEFAULT	1	ADMINISTRATORS	2013-01-01 00:00:00.000	2013-01-01 00:00:00.000	hinemos	hinemos
MT-JOB-DEFAULT	Job history deletion	DELETE_JOB_HISTORY_ALL	31	\N	1	\N	\N	\N	5	30	SYS_MTN-MT-JOB-DEFAULT-0	MT-JOB-DEFAULT	1	ADMINISTRATORS	2013-01-01 00:00:00.000	2013-01-01 00:00:00.000	hinemos	hinemos
MT-PRF-DEFAULT	Performance history deletion	DELETE_RERF_DATA_ALL	31	\N	1	\N	\N	\N	5	20	SYS_MTN-MT-PRF-DEFAULT-0	MT-PRF-DEFAULT	1	ADMINISTRATORS	2013-01-01 00:00:00.000	2013-01-01 00:00:00.000	hinemos	hinemos
\.


--
-- Data for Name: cc_maintenance_type_mst; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_maintenance_type_mst (type_id, name_id, order_no) FROM stdin;
DELETE_CRUN_HISTORY	maintenance.delete_crun_history	21
DELETE_CRUN_HISTORY_ALL	maintenance.delete_crun_history_all	20
DELETE_EVENT_LOG	maintenance.delete_event_log	1
DELETE_EVENT_LOG_ALL	maintenance.delete_event_log_all	0
DELETE_JOB_HISTORY	maintenance.delete_job_history	11
DELETE_JOB_HISTORY_ALL	maintenance.delete_job_history_all	10
DELETE_RERF_DATA	maintenance.delete_perf_data	31
DELETE_RERF_DATA_ALL	maintenance.delete_perf_data_all	30
\.

--
--Date for Name: cc_cal_pattern_info; Type: TABLE DATE; Schema: public; Owner: hinemos
--

COPY cc_cal_pattern_info (calendar_pattern_id, calendar_pattern_name, owner_role_id, reg_date, update_date, reg_user, update_user) FROM stdin;
holiday2013-2020	holiday2013-2020	ALL_USERS	2013-01-01 00:00:00.000	2013-01-01 00:00:00.000	hinemos	hinemos
\.

--Date for Name: cc_cal_pattern_detail_info; Type: TABLE DATE; Schema: public; Owner: hinemos
--

COPY cc_cal_pattern_detail_info (calendar_pattern_id, year_no, month_no, day_no) FROM stdin;
holiday2013-2020	2013	1	1
holiday2013-2020	2013	1	14
holiday2013-2020	2013	2	11
holiday2013-2020	2013	3	20
holiday2013-2020	2013	4	29
holiday2013-2020	2013	5	3
holiday2013-2020	2013	5	4
holiday2013-2020	2013	5	5
holiday2013-2020	2013	5	6
holiday2013-2020	2013	7	15
holiday2013-2020	2013	9	16
holiday2013-2020	2013	9	23
holiday2013-2020	2013	10	14
holiday2013-2020	2013	11	3
holiday2013-2020	2013	11	4
holiday2013-2020	2013	11	23
holiday2013-2020	2013	12	23
holiday2013-2020	2014	1	1
holiday2013-2020	2014	1	13
holiday2013-2020	2014	2	11
holiday2013-2020	2014	3	21
holiday2013-2020	2014	4	29
holiday2013-2020	2014	5	3
holiday2013-2020	2014	5	4
holiday2013-2020	2014	5	5
holiday2013-2020	2014	5	6
holiday2013-2020	2014	7	21
holiday2013-2020	2014	9	15
holiday2013-2020	2014	9	23
holiday2013-2020	2014	10	13
holiday2013-2020	2014	11	03
holiday2013-2020	2014	11	23
holiday2013-2020	2014	11	24
holiday2013-2020	2014	12	23
holiday2013-2020	2015	1	1
holiday2013-2020	2015	1	12
holiday2013-2020	2015	2	11
holiday2013-2020	2015	4	29
holiday2013-2020	2015	5	3
holiday2013-2020	2015	5	4
holiday2013-2020	2015	5	5
holiday2013-2020	2015	5	6
holiday2013-2020	2015	7	20
holiday2013-2020	2015	9	21
holiday2013-2020	2015	10	12
holiday2013-2020	2015	11	3
holiday2013-2020	2015	11	23
holiday2013-2020	2015	12	23
holiday2013-2020	2016	1	1
holiday2013-2020	2016	1	11
holiday2013-2020	2016	2	11
holiday2013-2020	2016	4	29
holiday2013-2020	2016	5	3
holiday2013-2020	2016	5	4
holiday2013-2020	2016	5	5
holiday2013-2020	2016	7	18
holiday2013-2020	2016	9	19
holiday2013-2020	2016	10	10
holiday2013-2020	2016	11	3
holiday2013-2020	2016	11	23
holiday2013-2020	2016	12	23
holiday2013-2020	2017	1	1
holiday2013-2020	2017	1	2
holiday2013-2020	2017	1	9
holiday2013-2020	2017	2	11
holiday2013-2020	2017	4	29
holiday2013-2020	2017	5	3
holiday2013-2020	2017	5	4
holiday2013-2020	2017	5	5
holiday2013-2020	2017	7	17
holiday2013-2020	2017	9	18
holiday2013-2020	2017	10	9
holiday2013-2020	2017	11	3
holiday2013-2020	2017	11	23
holiday2013-2020	2017	12	23
holiday2013-2020	2018	1	1
holiday2013-2020	2018	1	8
holiday2013-2020	2018	2	11
holiday2013-2020	2018	2	12
holiday2013-2020	2018	4	29
holiday2013-2020	2018	4	30
holiday2013-2020	2018	5	3
holiday2013-2020	2018	5	4
holiday2013-2020	2018	5	5
holiday2013-2020	2018	7	16
holiday2013-2020	2018	9	17
holiday2013-2020	2018	10	8
holiday2013-2020	2018	11	3
holiday2013-2020	2018	11	23
holiday2013-2020	2018	12	23
holiday2013-2020	2018	12	24
holiday2013-2020	2019	1	1
holiday2013-2020	2019	1	14
holiday2013-2020	2019	2	11
holiday2013-2020	2019	4	29
holiday2013-2020	2019	5	3
holiday2013-2020	2019	5	4
holiday2013-2020	2019	5	5
holiday2013-2020	2019	5	6
holiday2013-2020	2019	7	15
holiday2013-2020	2019	9	16
holiday2013-2020	2019	10	14
holiday2013-2020	2019	11	3
holiday2013-2020	2019	11	4
holiday2013-2020	2019	11	23
holiday2013-2020	2019	12	23
holiday2013-2020	2020	1	1
holiday2013-2020	2020	1	13
holiday2013-2020	2020	2	11
holiday2013-2020	2020	4	29
holiday2013-2020	2020	5	3
holiday2013-2020	2020	5	4
holiday2013-2020	2020	5	5
holiday2013-2020	2020	5	6
holiday2013-2020	2020	7	20
holiday2013-2020	2020	9	21
holiday2013-2020	2020	10	12
holiday2013-2020	2020	11	3
holiday2013-2020	2020	11	23
holiday2013-2020	2020	12	23
\.


--
-- Data for Name: qrtz_job_details; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_job_details (sched_name, job_name, job_group, description, job_class_name, is_durable, is_nonconcurrent, is_update_data, requests_recovery, job_data) FROM stdin;
DBMSScheduler	MT-CRN-DEFAULT	MAINTENANCE	\N	com.clustercontrol.commons.quartz.job.ReflectionInvokerJob	t	f	f	f	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000574000441524753757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c02000078700000000274000e4d542d43524e2d44454641554c5470740009415247535f54595045757200125b4c6a6176612e6c616e672e436c6173733bab16d7aecbcd5a99020000787000000002767200106a6176612e6c616e672e537472696e67a0f0a4387a3bb342020000787071007e000f74001052455345545f4f4e5f52455354415254737200116a6176612e6c616e672e426f6f6c65616ecd207280d59cfaee0200015a000576616c756578700174000a434c4153535f4e414d45740040636f6d2e636c7573746572636f6e74726f6c2e6d61696e74656e616e63652e73657373696f6e2e4d61696e74656e616e6365436f6e74726f6c6c65724265616e74000b4d4554484f445f4e414d457400167363686564756c6552756e4d61696e74656e616e63657800
DBMSScheduler	MT-EVE-DEFAULT	MAINTENANCE	\N	com.clustercontrol.commons.quartz.job.ReflectionInvokerJob	t	f	f	f	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000574000441524753757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c02000078700000000274000e4d542d4556452d44454641554c5470740009415247535f54595045757200125b4c6a6176612e6c616e672e436c6173733bab16d7aecbcd5a99020000787000000002767200106a6176612e6c616e672e537472696e67a0f0a4387a3bb342020000787071007e000f74001052455345545f4f4e5f52455354415254737200116a6176612e6c616e672e426f6f6c65616ecd207280d59cfaee0200015a000576616c756578700174000a434c4153535f4e414d45740040636f6d2e636c7573746572636f6e74726f6c2e6d61696e74656e616e63652e73657373696f6e2e4d61696e74656e616e6365436f6e74726f6c6c65724265616e74000b4d4554484f445f4e414d457400167363686564756c6552756e4d61696e74656e616e63657800
DBMSScheduler	MT-JOB-DEFAULT	MAINTENANCE	\N	com.clustercontrol.commons.quartz.job.ReflectionInvokerJob	t	f	f	f	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000574000441524753757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c02000078700000000274000e4d542d4a4f422d44454641554c5470740009415247535f54595045757200125b4c6a6176612e6c616e672e436c6173733bab16d7aecbcd5a99020000787000000002767200106a6176612e6c616e672e537472696e67a0f0a4387a3bb342020000787071007e000f74001052455345545f4f4e5f52455354415254737200116a6176612e6c616e672e426f6f6c65616ecd207280d59cfaee0200015a000576616c756578700174000a434c4153535f4e414d45740040636f6d2e636c7573746572636f6e74726f6c2e6d61696e74656e616e63652e73657373696f6e2e4d61696e74656e616e6365436f6e74726f6c6c65724265616e74000b4d4554484f445f4e414d457400167363686564756c6552756e4d61696e74656e616e63657800
DBMSScheduler	MT-PRF-DEFAULT	MAINTENANCE	\N	com.clustercontrol.commons.quartz.job.ReflectionInvokerJob	t	f	f	f	\\xaced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000574000441524753757200135b4c6a6176612e6c616e672e4f626a6563743b90ce589f1073296c02000078700000000274000e4d542d5052462d44454641554c5470740009415247535f54595045757200125b4c6a6176612e6c616e672e436c6173733bab16d7aecbcd5a99020000787000000002767200106a6176612e6c616e672e537472696e67a0f0a4387a3bb342020000787071007e000f74001052455345545f4f4e5f52455354415254737200116a6176612e6c616e672e426f6f6c65616ecd207280d59cfaee0200015a000576616c756578700174000a434c4153535f4e414d45740040636f6d2e636c7573746572636f6e74726f6c2e6d61696e74656e616e63652e73657373696f6e2e4d61696e74656e616e6365436f6e74726f6c6c65724265616e74000b4d4554484f445f4e414d457400167363686564756c6552756e4d61696e74656e616e63657800
\.


--
-- Data for Name: qrtz_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_triggers (sched_name, trigger_name, trigger_group, job_name, job_group, description, next_fire_time, prev_fire_time, priority, trigger_state, trigger_type, start_time, end_time, calendar_name, misfire_instr, job_data) FROM stdin;
DBMSScheduler	MT-CRN-DEFAULT	MAINTENANCE	MT-CRN-DEFAULT	MAINTENANCE	\N	946652400000	-1	5	WAITING	CRON	946652400000	0	\N	2	\\x
DBMSScheduler	MT-EVE-DEFAULT	MAINTENANCE	MT-EVE-DEFAULT	MAINTENANCE	\N	946652400000	-1	5	WAITING	CRON	946652400000	0	\N	2	\\x
DBMSScheduler	MT-JOB-DEFAULT	MAINTENANCE	MT-JOB-DEFAULT	MAINTENANCE	\N	946652400000	-1	5	WAITING	CRON	946652400000	0	\N	2	\\x
DBMSScheduler	MT-PRF-DEFAULT	MAINTENANCE	MT-PRF-DEFAULT	MAINTENANCE	\N	946652400000	-1	5	WAITING	CRON	946652400000	0	\N	2	\\x
\.

--
-- Data for Name: qrtz_cron_triggers; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY qrtz_cron_triggers (sched_name, trigger_name, trigger_group, cron_expression, time_zone_id) FROM stdin;
DBMSScheduler	MT-CRN-DEFAULT	MAINTENANCE	0 50 5 * * ? *	Asia/Tokyo
DBMSScheduler	MT-EVE-DEFAULT	MAINTENANCE	0 40 5 * * ? *	Asia/Tokyo
DBMSScheduler	MT-JOB-DEFAULT	MAINTENANCE	0 30 5 * * ? *	Asia/Tokyo
DBMSScheduler	MT-PRF-DEFAULT	MAINTENANCE	0 20 5 * * ? *	Asia/Tokyo
\.

--
-- Data for Name: cc_system_privilege; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_system_privilege (role_id, system_function, system_privilege) FROM stdin;
HINEMOS_MODULE	HinemosAgent	READ
HINEMOS_MODULE	HinemosAgent	WRITE
HINEMOS_MODULE	HinemosHA	READ
HINEMOS_MODULE	HinemosHA	WRITE
HINEMOS_MODULE	HinemosCLI	READ
HINEMOS_MODULE	HinemosCLI	WRITE
INTERNAL	AccessControl	READ
INTERNAL	AccessControl	WRITE
INTERNAL	AccessControl	ADD
INTERNAL	Calendar	READ
INTERNAL	Calendar	WRITE
INTERNAL	Calendar	ADD
INTERNAL	CollectiveRun	EXEC
INTERNAL	CollectiveRun	READ
INTERNAL	CollectiveRun	WRITE
INTERNAL	CollectiveRun	ADD
INTERNAL	JobManagement	EXEC
INTERNAL	JobManagement	READ
INTERNAL	JobManagement	WRITE
INTERNAL	JobManagement	ADD
INTERNAL	Maintenance	READ
INTERNAL	Maintenance	WRITE
INTERNAL	Maintenance	ADD
INTERNAL	MonitorResult	READ
INTERNAL	MonitorResult	WRITE
INTERNAL	MonitorSetting	READ
INTERNAL	MonitorSetting	WRITE
INTERNAL	MonitorSetting	ADD
INTERNAL	Notify	READ
INTERNAL	Notify	WRITE
INTERNAL	Notify	ADD
INTERNAL	Performance	READ
INTERNAL	Repository	EXEC
INTERNAL	Repository	READ
INTERNAL	Repository	WRITE
INTERNAL	Repository	ADD
INTERNAL	VmManagement	EXEC
INTERNAL	VmManagement	READ
INTERNAL	VmManagement	WRITE
INTERNAL	VmManagement	ADD
INTERNAL	CloudManagement	EXEC
INTERNAL	CloudManagement	READ
INTERNAL	CloudManagement	WRITE
INTERNAL	CloudManagement	ADD
ADMINISTRATORS	AccessControl	READ
ADMINISTRATORS	AccessControl	WRITE
ADMINISTRATORS	AccessControl	ADD
ADMINISTRATORS	Calendar	READ
ADMINISTRATORS	Calendar	WRITE
ADMINISTRATORS	Calendar	ADD
ADMINISTRATORS	CollectiveRun	EXEC
ADMINISTRATORS	CollectiveRun	READ
ADMINISTRATORS	CollectiveRun	WRITE
ADMINISTRATORS	CollectiveRun	ADD
ADMINISTRATORS	JobManagement	EXEC
ADMINISTRATORS	JobManagement	READ
ADMINISTRATORS	JobManagement	WRITE
ADMINISTRATORS	JobManagement	ADD
ADMINISTRATORS	Maintenance	READ
ADMINISTRATORS	Maintenance	WRITE
ADMINISTRATORS	Maintenance	ADD
ADMINISTRATORS	MonitorResult	READ
ADMINISTRATORS	MonitorResult	WRITE
ADMINISTRATORS	MonitorSetting	READ
ADMINISTRATORS	MonitorSetting	WRITE
ADMINISTRATORS	MonitorSetting	ADD
ADMINISTRATORS	Notify	READ
ADMINISTRATORS	Notify	WRITE
ADMINISTRATORS	Notify	ADD
ADMINISTRATORS	Performance	READ
ADMINISTRATORS	Repository	EXEC
ADMINISTRATORS	Repository	READ
ADMINISTRATORS	Repository	WRITE
ADMINISTRATORS	Repository	ADD
ADMINISTRATORS	VmManagement	EXEC
ADMINISTRATORS	VmManagement	READ
ADMINISTRATORS	VmManagement	WRITE
ADMINISTRATORS	VmManagement	ADD
ADMINISTRATORS	CloudManagement	EXEC
ADMINISTRATORS	CloudManagement	READ
ADMINISTRATORS	CloudManagement	WRITE
ADMINISTRATORS	CloudManagement	ADD
ALL_USERS	AccessControl	READ
ALL_USERS	AccessControl	WRITE
ALL_USERS	AccessControl	ADD
ALL_USERS	Calendar	READ
ALL_USERS	Calendar	WRITE
ALL_USERS	Calendar	ADD
ALL_USERS	CollectiveRun	EXEC
ALL_USERS	CollectiveRun	READ
ALL_USERS	CollectiveRun	WRITE
ALL_USERS	CollectiveRun	ADD
ALL_USERS	JobManagement	EXEC
ALL_USERS	JobManagement	READ
ALL_USERS	JobManagement	WRITE
ALL_USERS	JobManagement	ADD
ALL_USERS	Maintenance	READ
ALL_USERS	Maintenance	WRITE
ALL_USERS	Maintenance	ADD
ALL_USERS	MonitorResult	READ
ALL_USERS	MonitorResult	WRITE
ALL_USERS	MonitorSetting	READ
ALL_USERS	MonitorSetting	WRITE
ALL_USERS	MonitorSetting	ADD
ALL_USERS	Notify	READ
ALL_USERS	Notify	WRITE
ALL_USERS	Notify	ADD
ALL_USERS	Performance	READ
ALL_USERS	Repository	EXEC
ALL_USERS	Repository	READ
ALL_USERS	Repository	WRITE
ALL_USERS	Repository	ADD
ALL_USERS	VmManagement	EXEC
ALL_USERS	VmManagement	READ
ALL_USERS	VmManagement	WRITE
ALL_USERS	VmManagement	ADD
ALL_USERS	CloudManagement	EXEC
ALL_USERS	CloudManagement	READ
ALL_USERS	CloudManagement	WRITE
ALL_USERS	CloudManagement	ADD
\.

--
-- Data for Name: cc_object_privilege; Type: TABLE DATA; Schema: public; Owner: hinemos
--

COPY cc_object_privilege (object_type, object_id, role_id, object_privilege, create_user_id, create_datetime, modify_user_id, modify_datetime) FROM stdin;
PLT_REP	INTERNAL	ALL_USERS	READ	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	INTERNAL	ALL_USERS	WRITE	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	INTERNAL	ALL_USERS	EXEC	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	REGISTERED	ALL_USERS	READ	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	REGISTERED	ALL_USERS	WRITE	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	REGISTERED	ALL_USERS	EXEC	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	UNREGISTERED	ALL_USERS	READ	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	UNREGISTERED	ALL_USERS	WRITE	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	UNREGISTERED	ALL_USERS	EXEC	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	OWNER_SCOPE	ALL_USERS	READ	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	OWNER_SCOPE	ALL_USERS	WRITE	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
PLT_REP	OWNER_SCOPE	ALL_USERS	EXEC	hinemos	2012-04-01 00:00:00	hinemos	2012-04-01 00:00:00
\.

--
-- PostgreSQL database dump complete
--

