package com.clustercontrol.snmptrap.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.sql.Timestamp;
import java.util.List;


/**
 * The persistent class for the cc_snmp_trap_mib_mst database table.
 * 
 */
@Entity
@Table(name="cc_snmp_trap_mib_mst")
@Cacheable(true)
public class SnmpTrapMibMstEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String mib;
	private String description;
	private Integer orderNo;
	private Timestamp regDate;
	private String regUser;
	private Timestamp updateDate;
	private String updateUser;
	private List<SnmpTrapMstEntity> snmpTrapMstEntities;

	@Deprecated
	public SnmpTrapMibMstEntity() {
	}

	public SnmpTrapMibMstEntity(String mib) {
		this.setMib(mib);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
	}


	@Id
	public String getMib() {
		return this.mib;
	}

	public void setMib(String mib) {
		this.mib = mib;
	}


	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}


	@Column(name="order_no")
	public Integer getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}


	@Column(name="reg_date")
	public Timestamp getRegDate() {
		return this.regDate;
	}

	public void setRegDate(Timestamp regDate) {
		this.regDate = regDate;
	}


	@Column(name="reg_user")
	public String getRegUser() {
		return this.regUser;
	}

	public void setRegUser(String regUser) {
		this.regUser = regUser;
	}


	@Column(name="update_date")
	public Timestamp getUpdateDate() {
		return this.updateDate;
	}

	public void setUpdateDate(Timestamp updateDate) {
		this.updateDate = updateDate;
	}


	@Column(name="update_user")
	public String getUpdateUser() {
		return this.updateUser;
	}

	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}


	//bi-directional many-to-one association to SnmpTrapMstEntity
	@OneToMany(mappedBy="snmpTrapMibMstEntity", fetch=FetchType.LAZY)
	public List<SnmpTrapMstEntity> getSnmpTrapMstEntities() {
		return this.snmpTrapMstEntities;
	}

	public void setSnmpTrapMstEntities(List<SnmpTrapMstEntity> snmpTrapMstEntities) {
		this.snmpTrapMstEntities = snmpTrapMstEntities;
	}

}