/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMappingInformation
implements MappingInformation {
    private String persistenceUnitName;
    private Map<String, String> namedQueries = new HashMap<String, String>();
    private Map<Class<?>, ClassMappingInformation> entityTypeMappings = new HashMap();
    private Map<String, ClassMappingInformation> entityNameMappings;
    private ExceptionFactory exceptionFactory;

    public DefaultMappingInformation(String persistenceUnitName, Map<Class<?>, ? extends ClassMappingInformation> entityTypeMappings, Map<String, String> namedQueries, ExceptionFactory exceptionFactory) {
        this.persistenceUnitName = persistenceUnitName;
        this.entityTypeMappings = entityTypeMappings;
        this.namedQueries = namedQueries;
        this.exceptionFactory = exceptionFactory;
    }

    @Override
    public String getSecurityUnitName() {
        return this.persistenceUnitName;
    }

    @Override
    public Set<String> getNamedQueryNames() {
        return Collections.unmodifiableSet(this.namedQueries.keySet());
    }

    @Override
    public String getNamedQuery(String name) {
        return this.namedQueries.get(name);
    }

    @Override
    public Collection<Class<?>> getSecureClasses() {
        return Collections.unmodifiableSet(this.entityTypeMappings.keySet());
    }

    @Override
    public boolean containsClassMapping(Class<?> entityType) {
        while (entityType != null) {
            if (this.entityTypeMappings.containsKey(entityType)) {
                return true;
            }
            entityType = entityType.getSuperclass();
        }
        return false;
    }

    @Override
    public ClassMappingInformation getClassMapping(Class<?> type) {
        Class<?> entityType;
        ClassMappingInformation classMapping = this.entityTypeMappings.get(entityType);
        for (entityType = type; classMapping == null && entityType != null; entityType = entityType.getSuperclass()) {
            classMapping = this.entityTypeMappings.get(entityType);
        }
        if (classMapping == null) {
            throw this.exceptionFactory.createTypeNotFoundException(type);
        }
        return classMapping;
    }

    @Override
    public boolean containsClassMapping(String entityName) {
        if (this.entityNameMappings == null) {
            this.initializeEntityNameMappings();
        }
        return this.entityNameMappings.containsKey(entityName);
    }

    @Override
    public ClassMappingInformation getClassMapping(String entityName) {
        ClassMappingInformation classMapping;
        if (this.entityNameMappings == null) {
            this.initializeEntityNameMappings();
        }
        if ((classMapping = this.entityNameMappings.get(entityName)) == null) {
            throw this.exceptionFactory.createTypeNotFoundException(entityName);
        }
        return classMapping;
    }

    @Override
    public Collection<ClassMappingInformation> resolveClassMappings(Class<?> type) {
        HashSet<ClassMappingInformation> resolvedMappings = new HashSet<ClassMappingInformation>();
        for (Map.Entry<Class<?>, ClassMappingInformation> classMappingEntry : this.entityTypeMappings.entrySet()) {
            if (!type.isAssignableFrom(classMappingEntry.getKey())) continue;
            resolvedMappings.add(classMappingEntry.getValue());
        }
        return Collections.unmodifiableCollection(resolvedMappings);
    }

    @Override
    public <T> Class<T> getType(String path, Set<TypeDefinition> typeDefinitions) {
        String[] entries = path.split("\\.");
        Class<?> type = this.getAliasType(new Alias(entries[0]), typeDefinitions);
        for (int i = 1; i < entries.length; ++i) {
            type = this.getClassMapping(type).getPropertyMapping(entries[i]).getProperyType();
        }
        return type;
    }

    private void initializeEntityNameMappings() {
        this.entityNameMappings = new HashMap<String, ClassMappingInformation>();
        for (ClassMappingInformation classMapping : this.entityTypeMappings.values()) {
            this.entityNameMappings.put(classMapping.getEntityName(), classMapping);
            this.entityNameMappings.put(classMapping.getEntityType().getName(), classMapping);
        }
    }

    private Class<?> getAliasType(Alias alias, Set<TypeDefinition> typeDefinitions) {
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!alias.equals(typeDefinition.getAlias())) continue;
            return typeDefinition.getType();
        }
        throw new TypeNotPresentException(alias.getName(), null);
    }
}

