/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.jpasecurity.CascadeType;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.FetchType;
import net.sf.jpasecurity.SecurityUnit;
import net.sf.jpasecurity.mapping.AbstractPropertyMappingInformation;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.CollectionValuedRelationshipMappingInformation;
import net.sf.jpasecurity.mapping.DefaultClassMappingInformation;
import net.sf.jpasecurity.mapping.DefaultMappingInformation;
import net.sf.jpasecurity.mapping.EntityLifecycleMethods;
import net.sf.jpasecurity.mapping.EntityListener;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.PropertyAccessStrategy;
import net.sf.jpasecurity.mapping.PropertyAccessStrategyFactory;
import net.sf.jpasecurity.mapping.RelationshipMappingInformation;
import net.sf.jpasecurity.mapping.SimplePropertyMappingInformation;
import net.sf.jpasecurity.mapping.SingleValuedRelationshipMappingInformation;
import net.sf.jpasecurity.util.Types;
import net.sf.jpasecurity.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecurityUnitParser {
    private static final String CLASS_ENTRY_SUFFIX = ".class";
    private static final String IS_PROPERTY_PREFIX = "is";
    private static final String GET_PROPERTY_PREFIX = "get";
    private static final String SET_PROPERTY_PREFIX = "set";
    protected final PropertyAccessStrategyFactory propertyAccessStrategyFactory;
    protected final ExceptionFactory exceptionFactory;
    private SecurityUnit securityUnit;
    private Map<Class<?>, DefaultClassMappingInformation> classMappings;
    private Map<String, String> namedQueries;
    private List<EntityListener> defaultEntityListeners;
    private ClassLoader classLoader;

    public AbstractSecurityUnitParser(SecurityUnit securityUnit, PropertyAccessStrategyFactory propertyAccessStrategyFactory, ExceptionFactory exceptionFactory) {
        Validate.notNull(SecurityUnit.class, securityUnit);
        Validate.notNull(PropertyAccessStrategyFactory.class, propertyAccessStrategyFactory);
        Validate.notNull(ExceptionFactory.class, exceptionFactory);
        this.securityUnit = securityUnit;
        this.propertyAccessStrategyFactory = propertyAccessStrategyFactory;
        this.exceptionFactory = exceptionFactory;
    }

    protected SecurityUnit getSecurityUnit() {
        return this.securityUnit;
    }

    protected PropertyAccessStrategyFactory getPropertyAccessStrategyFactory() {
        return this.propertyAccessStrategyFactory;
    }

    protected ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    public MappingInformation parse() {
        this.classMappings = new HashMap();
        this.namedQueries = new HashMap<String, String>();
        this.defaultEntityListeners = new ArrayList<EntityListener>();
        this.classLoader = this.findClassLoader(this.securityUnit);
        this.parseSecurityUnit(this.securityUnit);
        String securityUnitName = this.securityUnit.getSecurityUnitName();
        return new DefaultMappingInformation(securityUnitName, this.classMappings, this.namedQueries, this.exceptionFactory);
    }

    protected void parseSecurityUnit(SecurityUnit securityUnit) {
        if (!securityUnit.excludeUnlistedClasses() && securityUnit.getSecurityUnitRootUrl() != null) {
            this.parse(securityUnit.getSecurityUnitRootUrl());
        }
        for (URL url : securityUnit.getJarFileUrls()) {
            this.parse(url);
        }
        for (String className : securityUnit.getManagedClassNames()) {
            this.parse(this.getClass(className));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(URL url) {
        try {
            InputStream in = url.openStream();
            try {
                ZipInputStream zipStream = new ZipInputStream(in);
                ZipEntry entry = zipStream.getNextEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(CLASS_ENTRY_SUFFIX)) {
                        this.parse(this.getClass(this.convertFileToClassname(entry.getName())));
                    }
                    zipStream.closeEntry();
                    entry = zipStream.getNextEntry();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw this.exceptionFactory.createRuntimeException(e);
        }
    }

    private String convertFileToClassname(String name) {
        return name.substring(0, name.length() - CLASS_ENTRY_SUFFIX.length()).replace('/', '.');
    }

    protected ClassMappingInformation parse(Class<?> mappedClass) {
        return this.parse(mappedClass, false, false);
    }

    protected ClassMappingInformation parse(Class<?> mappedClass, boolean derivedFieldAccess, boolean override) {
        Class<?> idClass;
        DefaultClassMappingInformation classMapping = this.classMappings.get(mappedClass);
        if (classMapping != null && !override) {
            return classMapping;
        }
        Class<?> superclass = mappedClass.getSuperclass();
        ClassMappingInformation superclassMapping = null;
        if (superclass != null) {
            superclassMapping = this.parse(mappedClass.getSuperclass(), derivedFieldAccess, override);
        }
        if (!this.isMapped(mappedClass)) {
            return superclassMapping;
        }
        this.parseNamedQueries(mappedClass);
        boolean usesFieldAccess = this.isFieldAccessDerived(mappedClass) ? derivedFieldAccess : (superclassMapping != null ? superclassMapping.usesFieldAccess() : this.usesFieldAccess(mappedClass));
        ClassMappingInformation idClassMapping = null;
        if ((superclassMapping == null || superclassMapping.getIdClassMapping() == null) && (idClass = this.getIdClass(mappedClass, usesFieldAccess)) != null) {
            idClassMapping = this.parse(idClass, derivedFieldAccess, override);
        }
        String entityName = this.getEntityName(mappedClass);
        boolean metadataComplete = this.isMetadataComplete(mappedClass);
        if (classMapping == null) {
            classMapping = new DefaultClassMappingInformation(entityName, mappedClass, (DefaultClassMappingInformation)superclassMapping, idClassMapping, this.isEmbeddable(mappedClass), usesFieldAccess, metadataComplete, this.exceptionFactory);
            this.classMappings.put(mappedClass, classMapping);
        } else {
            classMapping.setEntityName(entityName);
            classMapping.setIdClassMapping(idClassMapping);
            classMapping.setFieldAccess(usesFieldAccess);
            classMapping.setMetadataComplete(metadataComplete);
        }
        if (metadataComplete) {
            classMapping.clearPropertyMappings();
        }
        if (!this.excludeDefaultEntityListeners(mappedClass)) {
            classMapping.setDefaultEntityListeners(Collections.unmodifiableList(this.defaultEntityListeners));
        }
        this.parseEntityListeners(classMapping);
        classMapping.setSuperclassEntityListenersExcluded(this.excludeSuperclassEntityListeners(mappedClass));
        this.parseEntityLifecycleMethods(classMapping);
        if (usesFieldAccess) {
            for (Field field : mappedClass.getDeclaredFields()) {
                if (!this.isMappable(field)) continue;
                this.parse(classMapping, field);
            }
        } else {
            for (Method method : mappedClass.getDeclaredMethods()) {
                if (!this.isPropertyGetter(method)) continue;
                this.parse(classMapping, method);
            }
        }
        return classMapping;
    }

    protected Class<?> getClass(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw this.exceptionFactory.createRuntimeException(e);
        }
    }

    protected Enumeration<URL> getResources(String name) {
        try {
            return this.classLoader.getResources(name);
        }
        catch (IOException e) {
            throw this.exceptionFactory.createRuntimeException(e);
        }
    }

    private void parse(DefaultClassMappingInformation classMapping, Member property) {
        String name = this.getName(property);
        Class<?> type = this.getType(property);
        boolean isSingleValuedRelationshipProperty = this.isSingleValuedRelationshipProperty(property);
        boolean isCollectionValuedRelationshipProperty = this.isCollectionValuedRelationshipProperty(property);
        boolean createPropertyMapping = !classMapping.containsPropertyMapping(name);
        AbstractPropertyMappingInformation propertyMapping = null;
        if (!createPropertyMapping) {
            propertyMapping = classMapping.getPropertyMapping(name);
        }
        if (isSingleValuedRelationshipProperty || isCollectionValuedRelationshipProperty) {
            if (propertyMapping != null) {
                CascadeType[] cascadeTypes;
                RelationshipMappingInformation relationshipMapping = (RelationshipMappingInformation)propertyMapping;
                if (this.isFetchTypePresent(property)) {
                    relationshipMapping.setFetchType(this.getFetchType(property));
                }
                if ((cascadeTypes = this.getCascadeTypes(property)).length > 0) {
                    relationshipMapping.setCascadeTypes(this.getCascadeTypes(property));
                }
            } else {
                if (isSingleValuedRelationshipProperty) {
                    ClassMappingInformation typeMapping = this.parse(type, classMapping.usesFieldAccess(), false);
                    PropertyAccessStrategy propertyAccessStrategy = this.propertyAccessStrategyFactory.createPropertyAccessStrategy(classMapping, name);
                    propertyMapping = new SingleValuedRelationshipMappingInformation(name, typeMapping, classMapping, propertyAccessStrategy, this.exceptionFactory, this.getFetchType(property), this.getCascadeTypes(property));
                } else if (isCollectionValuedRelationshipProperty) {
                    ClassMappingInformation targetMapping = this.parse(this.getTargetType(property), classMapping.usesFieldAccess(), false);
                    PropertyAccessStrategy propertyAccessStrategy = this.propertyAccessStrategyFactory.createPropertyAccessStrategy(classMapping, name);
                    propertyMapping = new CollectionValuedRelationshipMappingInformation(name, type, targetMapping, classMapping, propertyAccessStrategy, this.exceptionFactory, this.getFetchType(property), this.getCascadeTypes(property));
                }
                classMapping.addPropertyMapping(propertyMapping);
            }
        } else if (propertyMapping == null && (Types.isSimplePropertyType(type) || type instanceof Serializable)) {
            PropertyAccessStrategy propertyAccessStrategy = this.propertyAccessStrategyFactory.createPropertyAccessStrategy(classMapping, name);
            propertyMapping = new SimplePropertyMappingInformation(name, type, classMapping, propertyAccessStrategy, this.exceptionFactory);
            classMapping.addPropertyMapping(propertyMapping);
        } else if (propertyMapping == null) {
            String error = "could not determine mapping for property \"" + name + "\" of class " + property.getDeclaringClass().getName();
            throw this.exceptionFactory.createMappingException(error);
        }
        if (this.isIdProperty(property)) {
            propertyMapping.setIdProperty(true);
        }
        if (this.isVersionProperty(property)) {
            propertyMapping.setVersionProperty(true);
        }
        if (this.isGeneratedValue(property)) {
            propertyMapping.setGeneratedValue(true);
        }
    }

    protected ClassMappingInformation getMapping(Class<?> type) {
        return this.classMappings.get(type);
    }

    protected String getEntityName(Class<?> entityClass) {
        return entityClass.getSimpleName();
    }

    protected String getName(Member property) {
        if (property instanceof Field) {
            return property.getName();
        }
        String name = property.getName();
        if (name.startsWith(GET_PROPERTY_PREFIX)) {
            return Introspector.decapitalize(name.substring(GET_PROPERTY_PREFIX.length()));
        }
        if (property.getName().startsWith(IS_PROPERTY_PREFIX)) {
            return Introspector.decapitalize(name.substring(IS_PROPERTY_PREFIX.length()));
        }
        throw new IllegalArgumentException("Illegal method name for property-read-method, must start either with 'get' or 'is'");
    }

    protected Class<?> getType(Member property) {
        if (property instanceof Method) {
            return ((Method)property).getReturnType();
        }
        return ((Field)property).getType();
    }

    protected Class<?> getTargetType(Member property) {
        Type genericTypeArgument;
        Type genericType = property instanceof Method ? ((Method)property).getGenericReturnType() : ((Field)property).getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw this.exceptionFactory.createTargetEntityNotFoundException(property);
        }
        Type[] genericTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
        if (genericTypeArguments.length == 1) {
            genericTypeArgument = genericTypeArguments[0];
        } else if (genericTypeArguments.length == 2) {
            genericTypeArgument = genericTypeArguments[1];
        } else {
            throw this.exceptionFactory.createTargetEntityNotFoundException(property);
        }
        if (genericTypeArgument instanceof Class) {
            return (Class)genericTypeArgument;
        }
        Type[] bounds = null;
        if (genericTypeArgument instanceof TypeVariable) {
            bounds = ((TypeVariable)genericTypeArgument).getBounds();
        } else if (genericTypeArgument instanceof WildcardType) {
            bounds = ((WildcardType)genericTypeArgument).getUpperBounds();
        }
        if (bounds != null) {
            for (Type bound : ((TypeVariable)genericTypeArgument).getBounds()) {
                if (!(bound instanceof Class)) continue;
                return (Class)bound;
            }
        }
        throw this.exceptionFactory.createTargetEntityNotFoundException(property);
    }

    protected boolean isFieldAccessDerived(Class<?> mappedClass) {
        return this.isEmbeddable(mappedClass);
    }

    protected boolean usesFieldAccess(Class<?> mappedClass) {
        Field[] fields;
        for (Field field : fields = mappedClass.getDeclaredFields()) {
            if (!this.isIdProperty(field)) continue;
            return true;
        }
        return false;
    }

    protected void parseNamedQueries(Class<?> mappedClass) {
    }

    protected void addNamedQuery(String name, String query) {
        this.namedQueries.put(name, query);
    }

    protected void addDefaultEntityListener(EntityListener entityListener) {
        this.defaultEntityListeners.add(entityListener);
    }

    protected abstract boolean isMapped(Class<?> var1);

    protected abstract boolean isMapped(Member var1);

    protected abstract boolean isMetadataComplete(Class<?> var1);

    protected abstract boolean excludeDefaultEntityListeners(Class<?> var1);

    protected abstract boolean excludeSuperclassEntityListeners(Class<?> var1);

    protected abstract void parseEntityListeners(DefaultClassMappingInformation var1);

    protected abstract void parseEntityLifecycleMethods(DefaultClassMappingInformation var1);

    protected void addEntityListener(DefaultClassMappingInformation classMappingInformation, Class<?> type, EntityListener entityListener) {
        classMappingInformation.addEntityListener(type, entityListener);
    }

    protected void setEntityLifecycleMethods(DefaultClassMappingInformation classMappingInformation, EntityLifecycleMethods entityLifecycleMethods) {
        classMappingInformation.setEntityLifecycleMethods(entityLifecycleMethods);
    }

    protected abstract Class<?> getIdClass(Class<?> var1, boolean var2);

    protected boolean isMappable(Member member) {
        return !Modifier.isStatic(member.getModifiers()) && !Modifier.isTransient(member.getModifiers());
    }

    protected abstract boolean isEmbeddable(Class<?> var1);

    protected abstract boolean isIdProperty(Member var1);

    protected abstract boolean isVersionProperty(Member var1);

    protected abstract boolean isGeneratedValue(Member var1);

    protected abstract boolean isFetchTypePresent(Member var1);

    protected FetchType getFetchType(Member property) {
        Class<?> type = this.getType(property);
        if (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
            return FetchType.LAZY;
        }
        return FetchType.EAGER;
    }

    protected abstract CascadeType[] getCascadeTypes(Member var1);

    protected boolean isRelationshipProperty(Member property) {
        return this.isSingleValuedRelationshipProperty(property) || this.isCollectionValuedRelationshipProperty(property);
    }

    protected abstract boolean isSingleValuedRelationshipProperty(Member var1);

    protected abstract boolean isCollectionValuedRelationshipProperty(Member var1);

    private boolean isPropertyGetter(Method method) {
        if (!method.getName().startsWith(GET_PROPERTY_PREFIX) && !method.getName().startsWith(IS_PROPERTY_PREFIX) || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || !this.isMappable(method)) {
            return false;
        }
        String propertyName = this.getName(method);
        String propertySetterName = SET_PROPERTY_PREFIX + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Class<?> entityClass = method.getDeclaringClass();
        Class<?> propertyType = method.getReturnType();
        return this.hasPropertySetter(entityClass, propertySetterName, propertyType);
    }

    private boolean hasPropertySetter(Class<?> entityClass, String propertySetterName, Class<?> propertyType) {
        if (entityClass == null) {
            return false;
        }
        for (Method method : entityClass.getDeclaredMethods()) {
            if (!method.getName().equals(propertySetterName) || method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) continue;
            return method.getParameterTypes()[0].isAssignableFrom(propertyType);
        }
        return this.hasPropertySetter(entityClass.getSuperclass(), propertySetterName, propertyType);
    }

    private ClassLoader findClassLoader(SecurityUnit securityUnitInformation) {
        ClassLoader classLoader = securityUnitInformation.getClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

