/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.configuration.AccessRule;
import net.sf.jpasecurity.configuration.AccessRulesProvider;
import net.sf.jpasecurity.configuration.Configuration;
import net.sf.jpasecurity.configuration.ConfigurationReceiver;
import net.sf.jpasecurity.configuration.SecurityContext;
import net.sf.jpasecurity.configuration.SecurityContextReceiver;
import net.sf.jpasecurity.jpql.compiler.MappingEvaluator;
import net.sf.jpasecurity.jpql.compiler.QueryPreparator;
import net.sf.jpasecurity.jpql.parser.JpqlAccessRule;
import net.sf.jpasecurity.jpql.parser.JpqlParser;
import net.sf.jpasecurity.jpql.parser.ParseException;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.MappingInformationReceiver;
import net.sf.jpasecurity.security.rules.AccessRulesCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAccessRulesProvider
implements AccessRulesProvider,
MappingInformationReceiver,
ConfigurationReceiver,
SecurityContextReceiver {
    private MappingInformation persistenceMapping;
    private Map<String, Object> persistenceProperties;
    private Configuration configuration;
    private SecurityContext securityContext;
    private List<AccessRule> accessRules;

    public MappingInformation getPersistenceMapping() {
        return this.persistenceMapping;
    }

    @Override
    public final void setMappingInformation(MappingInformation persistenceMapping) {
        this.persistenceMapping = persistenceMapping;
    }

    public Map<String, Object> getPersistenceProperties() {
        return this.persistenceProperties;
    }

    @Override
    public final void setMappingProperties(Map<String, Object> properties) {
        this.persistenceProperties = properties;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public final void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public final void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Override
    public final List<AccessRule> getAccessRules() {
        if (this.accessRules == null) {
            this.initializeAccessRules();
            this.checkAccessRules();
        }
        return this.accessRules;
    }

    protected void initializeAccessRules() {
    }

    protected void compileRules(Collection<String> rules) {
        if (this.persistenceMapping == null) {
            throw new IllegalStateException("persistenceMapping not initialized");
        }
        if (this.accessRules != null) {
            throw new IllegalStateException("access rules are already compiled");
        }
        JpqlParser jpqlParser = new JpqlParser();
        ExceptionFactory exceptionFactory = this.configuration.getExceptionFactory();
        AccessRulesCompiler compiler = new AccessRulesCompiler(this.persistenceMapping, exceptionFactory);
        this.accessRules = new ArrayList<AccessRule>();
        try {
            for (String accessRule : rules) {
                JpqlAccessRule parsedRule = jpqlParser.parseRule(accessRule);
                Collection<AccessRule> compiledRules = compiler.compile(parsedRule);
                this.accessRules.addAll(compiledRules);
            }
        }
        catch (ParseException e) {
            throw this.configuration.getExceptionFactory().createRuntimeException(e);
        }
    }

    private void checkAccessRules() {
        ExceptionFactory exceptionFactory = this.configuration.getExceptionFactory();
        MappingEvaluator evaluator = new MappingEvaluator(this.persistenceMapping, this.securityContext, exceptionFactory);
        QueryPreparator preparator = new QueryPreparator();
        for (AccessRule accessRule : this.accessRules) {
            evaluator.evaluate(preparator.createPath(accessRule.getSelectedPath()), accessRule.getTypeDefinitions());
            if (accessRule.getWhereClause() == null) continue;
            evaluator.evaluate(accessRule.getWhereClause(), accessRule.getTypeDefinitions());
        }
    }
}

