/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import net.sf.jpasecurity.jpql.JpqlCompiledStatement;
import net.sf.jpasecurity.jpql.parser.JpqlAbstractSchemaName;
import net.sf.jpasecurity.jpql.parser.JpqlAnd;
import net.sf.jpasecurity.jpql.parser.JpqlBooleanLiteral;
import net.sf.jpasecurity.jpql.parser.JpqlBrackets;
import net.sf.jpasecurity.jpql.parser.JpqlEquals;
import net.sf.jpasecurity.jpql.parser.JpqlExists;
import net.sf.jpasecurity.jpql.parser.JpqlFrom;
import net.sf.jpasecurity.jpql.parser.JpqlFromItem;
import net.sf.jpasecurity.jpql.parser.JpqlIdentificationVariable;
import net.sf.jpasecurity.jpql.parser.JpqlIdentificationVariableDeclaration;
import net.sf.jpasecurity.jpql.parser.JpqlIdentifier;
import net.sf.jpasecurity.jpql.parser.JpqlIn;
import net.sf.jpasecurity.jpql.parser.JpqlIntegerLiteral;
import net.sf.jpasecurity.jpql.parser.JpqlNamedInputParameter;
import net.sf.jpasecurity.jpql.parser.JpqlNot;
import net.sf.jpasecurity.jpql.parser.JpqlNotEquals;
import net.sf.jpasecurity.jpql.parser.JpqlOr;
import net.sf.jpasecurity.jpql.parser.JpqlPath;
import net.sf.jpasecurity.jpql.parser.JpqlSelectClause;
import net.sf.jpasecurity.jpql.parser.JpqlSelectExpression;
import net.sf.jpasecurity.jpql.parser.JpqlSelectExpressions;
import net.sf.jpasecurity.jpql.parser.JpqlSubselect;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.jpql.parser.JpqlWhere;
import net.sf.jpasecurity.jpql.parser.JpqlWith;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.jpql.parser.SimpleNode;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.ClassMappingInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryPreparator {
    private final PathReplacer pathReplacer = new PathReplacer();

    public void appendToWhereClause(JpqlSubselect subselect, JpqlWith with) {
        JpqlWhere where = new JpqlCompiledStatement(subselect).getWhereClause();
        with.jjtGetParent().jjtRemoveChild(2);
        Node condition = with.jjtGetChild(0);
        if (where == null) {
            where = this.createWhere(condition);
            this.appendChildren(subselect, where);
        } else {
            this.append(where, condition);
        }
    }

    public void append(JpqlWhere where, Node node) {
        Node clause = where.jjtGetChild(0);
        if (!(clause instanceof JpqlBrackets)) {
            clause = this.createBrackets(clause);
            clause.jjtSetParent(where);
        }
        Node and = this.createAnd(clause, node);
        and.jjtSetParent(where);
        where.jjtSetChild(and, 0);
    }

    public Node append(Node node, String alias, JpqlCompiledStatement statement) {
        Node in = this.createBrackets(this.createIn(alias, statement));
        Node or = this.createOr(node, in);
        return or;
    }

    public JpqlPath prepend(Alias alias, JpqlPath path) {
        return this.prepend(new String[]{alias.getName()}, path);
    }

    public JpqlPath prepend(String[] pathComponents, JpqlPath path) {
        int i;
        if (pathComponents.length == 0) {
            return path;
        }
        for (i = path.jjtGetNumChildren() - 1; i >= 0; --i) {
            path.jjtAddChild(path.jjtGetChild(i), i + pathComponents.length);
        }
        if (path.jjtGetNumChildren() > pathComponents.length) {
            Node oldVariable = path.jjtGetChild(pathComponents.length);
            path.jjtSetChild(this.createIdentifier(oldVariable.getValue()), pathComponents.length);
        }
        path.jjtAddChild(this.createVariable(pathComponents[0]), 0);
        for (i = 1; i < pathComponents.length; ++i) {
            path.jjtAddChild(this.createIdentifier(pathComponents[i]), i);
        }
        return path;
    }

    public JpqlWhere createWhere(Node child) {
        JpqlWhere where = new JpqlWhere(38);
        child.jjtSetParent(where);
        where.jjtAddChild(child, 0);
        return where;
    }

    public JpqlBooleanLiteral createBoolean(boolean value) {
        JpqlBooleanLiteral bool = new JpqlBooleanLiteral(91);
        bool.setValue(Boolean.toString(value));
        return bool;
    }

    public JpqlIntegerLiteral createNumber(int value) {
        JpqlIntegerLiteral integer = new JpqlIntegerLiteral(89);
        integer.setValue(Integer.toString(value));
        return integer;
    }

    public JpqlIdentificationVariable createVariable(String value) {
        JpqlIdentificationVariable variable = new JpqlIdentificationVariable(88);
        variable.setValue(value);
        return variable;
    }

    public JpqlNamedInputParameter createNamedParameter(String name) {
        JpqlNamedInputParameter parameter = new JpqlNamedInputParameter(93);
        parameter.setValue(name);
        return parameter;
    }

    public Node createAnd(Node node1, Node node2) {
        return this.appendChildren(new JpqlAnd(44), node1, node2);
    }

    public Node createOr(Node node1, Node node2) {
        return this.appendChildren(new JpqlOr(43), node1, node2);
    }

    public Node createNot(Node node) {
        return this.appendChildren(new JpqlNot(45), node);
    }

    public Node createEquals(Node node1, Node node2) {
        return this.appendChildren(new JpqlEquals(21), node1, node2);
    }

    public Node createNotEquals(Node node1, Node node2) {
        return this.appendChildren(new JpqlNotEquals(55), node1, node2);
    }

    public <N extends Node> N appendChildren(N parent, Node ... children) {
        for (int i = 0; i < children.length; ++i) {
            parent.jjtAddChild(children[i], i);
            children[i].jjtSetParent(parent);
        }
        return parent;
    }

    public Node createIn(String alias, JpqlCompiledStatement statement) {
        JpqlIn in = new JpqlIn(47);
        Node path = this.createPath(alias);
        path.jjtSetParent(in);
        in.jjtAddChild(path, 0);
        Node subselect = this.createSubselect(statement);
        subselect.jjtSetParent(in);
        in.jjtAddChild(subselect, 1);
        return this.createBrackets(in);
    }

    public Node createBrackets(Node node) {
        JpqlBrackets brackets = new JpqlBrackets(41);
        brackets.jjtAddChild(node, 0);
        node.jjtSetParent(brackets);
        return brackets;
    }

    public Node createPath(String pathString) {
        String[] pathComponents = pathString.split("\\.");
        JpqlIdentifier identifier = this.createIdentifier(pathComponents[0]);
        JpqlPath path = this.appendChildren(new JpqlPath(17), identifier);
        for (int i = 1; i < pathComponents.length; ++i) {
            JpqlIdentificationVariable identificationVariable = new JpqlIdentificationVariable(88);
            identificationVariable.setValue(pathComponents[i]);
            identificationVariable.jjtSetParent(path);
            path.jjtAddChild(identifier, i - 1);
        }
        return path;
    }

    public Node createSubselect(JpqlCompiledStatement statement) {
        if (statement.getSelectedPaths().size() > 1) {
            throw new IllegalArgumentException("Cannot create subselect from statements with scalar select-clause");
        }
        JpqlSelectClause select = this.createSelectClause(statement.getSelectedPaths().get(0));
        JpqlFrom from = statement.getFromClause();
        JpqlWhere where = statement.getWhereClause();
        return this.appendChildren(new JpqlSubselect(42), select, from, where);
    }

    public JpqlSelectClause createSelectClause(String selectedPath) {
        JpqlSelectExpression expression = new JpqlSelectExpression(25);
        expression = this.appendChildren(expression, this.createPath(selectedPath));
        JpqlSelectExpressions expressions = new JpqlSelectExpressions(24);
        expressions = this.appendChildren(expressions, expression);
        return this.appendChildren(new JpqlSelectClause(23), expressions);
    }

    public JpqlFrom createFrom(ClassMappingInformation classMapping, String alias) {
        JpqlIdentificationVariableDeclaration declaration = new JpqlIdentificationVariableDeclaration(8);
        declaration = this.appendChildren(declaration, this.createFromItem(classMapping.getEntityName(), alias));
        return this.appendChildren(new JpqlFrom(7), declaration);
    }

    public JpqlFromItem createFromItem(String type, String alias) {
        JpqlAbstractSchemaName schemaName = new JpqlAbstractSchemaName(86);
        return this.appendChildren(new JpqlFromItem(9), this.appendChildren(schemaName, this.createIdentifier(type)), this.createIdentifier(alias));
    }

    public Node createInstanceOf(String path, ClassMappingInformation classMapping) {
        return this.appendChildren(new JpqlExists(52), this.createSubselectById(path, classMapping));
    }

    public JpqlSubselect createSubselectById(String path, ClassMappingInformation classMapping) {
        String alias = classMapping.getEntityName();
        if ((alias = Character.toLowerCase(alias.charAt(0)) + alias.substring(1)).equalsIgnoreCase(path)) {
            alias = alias + '0';
        }
        JpqlSelectClause select = this.createSelectClause(alias);
        JpqlFrom from = this.createFrom(classMapping, alias);
        JpqlWhere where = this.createWhere(this.createEquals(this.createPath(alias), this.createPath(path)));
        return this.appendChildren(new JpqlSubselect(42), select, from, where);
    }

    public JpqlIdentifier createIdentifier(String value) {
        JpqlIdentifier identifier = new JpqlIdentifier(87);
        identifier.setValue(value);
        return identifier;
    }

    public void remove(Node node) {
        if (node.jjtGetParent() != null) {
            for (int i = 0; i < node.jjtGetParent().jjtGetNumChildren(); ++i) {
                if (node.jjtGetParent().jjtGetChild(i) != node) continue;
                node.jjtGetParent().jjtRemoveChild(i);
                node.jjtSetParent(null);
            }
        }
    }

    public void replace(Node oldNode, Node newNode) {
        int index = this.getIndex(oldNode.jjtGetParent(), oldNode);
        oldNode.jjtGetParent().jjtSetChild(newNode, index);
        newNode.jjtSetParent(oldNode.jjtGetParent());
        oldNode.jjtSetParent(null);
    }

    public void replace(Node node, String oldPath, String newPath) {
        node.visit(this.pathReplacer, new ReplaceParameters(oldPath.split("\\."), newPath.split("\\.")));
    }

    private int getIndex(Node parent, Node child) {
        for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
            if (parent.jjtGetChild(i) != child) continue;
            return i;
        }
        return -1;
    }

    private class ReplaceParameters {
        private String[] oldPath;
        private String[] newPath;

        public ReplaceParameters(String[] oldPath, String[] newPath) {
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        public String[] getOldPath() {
            return this.oldPath;
        }

        public String[] getNewPath() {
            return this.newPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathReplacer
    extends JpqlVisitorAdapter<ReplaceParameters> {
        private PathReplacer() {
        }

        @Override
        public boolean visit(JpqlPath path, ReplaceParameters parameters) {
            if (this.canReplace(path, parameters)) {
                this.replace(path, parameters);
            }
            return false;
        }

        private boolean canReplace(JpqlPath path, ReplaceParameters parameters) {
            if (path.jjtGetNumChildren() < parameters.getOldPath().length) {
                return false;
            }
            for (int i = 0; i < parameters.getOldPath().length; ++i) {
                if (parameters.getOldPath()[i].equals(((SimpleNode)path.jjtGetChild(i)).getValue())) continue;
                return false;
            }
            return true;
        }

        private void replace(JpqlPath path, ReplaceParameters parameters) {
            for (int i = 0; i < parameters.getOldPath().length; ++i) {
                path.jjtRemoveChild(0);
            }
            QueryPreparator.this.prepend(parameters.getNewPath(), path);
        }
    }
}

