#!/bin/sh

#################################
# パラメータ
#################################
# 業務名
service="job_test01"
# 業務プログラム
prg_home="/opt/hinemos_agent/jobs"
prg_name="${prg_home}/${service}"
#prg_name_class="${prg_name}.class"
# PIDスファイル
prg_pid="${prg_home}/${service}.pid"
# ログファイル
log="${prg_home}/${service}.out"

#################################
# 環境変数読み込み
#################################
#source ${prg_home}/java.env

#################################
# 引数
#################################
# $1 ${action}  # start/stopの指定
# $2 ${sleep}   # sleep時間

action=$1
sleep=$2

#################################
# 処理
#################################

outlog() {
        datestr=`date '+%Y/%m/%d %T'`
        echo "$datestr [ $$ ] : $1" >> ${log}
}

start() {
        cd ${prg_home}
        outlog "Starting : ${service} action=${action} sleep=${sleep}"

        rval=$?
        if [ $rval != 0 ]; then
                outlog "ステータスファイルの作成に失敗しました"
                exit 1
        fi

        sleep ${sleep} &
        sleep_pid="$!"
        wait "${sleep_pid}"
        rval=$?
        if [ $rval != 0 ]; then
                outlog "${service}プログラムが異常終了しました ret=${rval}"
                exit 1
        fi
        outlog "${service}プログラムが正常に終了しました"

        return ${rval}
}

# .pidファイルを作らなくなったのでstop処理は動かなくなっているので注意
stop() {
        outlog "Stopping : ${service}"
        kill `cat ${prg_pid}`
        sleep ${sleep}
        rval=$?
        if [ ${rval} != 0 ]; then
                outlog "${service}プログラムの停止に失敗しました"
                exit ${rval}
        fi
        rm -f ${prg_pid}
        outlog "${service}プログラムが正常に停止しました"
        return ${rval}
}


case ${action} in
  start)
        start
        ;;
  stop)
        outlog "STOP処理は現在動作しません"
        exit 1
        ;;
  *)
        outlog "操作を指定する引数が不正です。"
        exit 1
esac

exit $?
# End of file.
