/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import sun.print.BackgroundLookupListener;
import sun.print.BackgroundServiceLookup;
import sun.print.CUPSPrinter;
import sun.print.IPPPrintService;
import sun.print.UnixPrintService;
import sun.security.action.GetPropertyAction;

public class UnixPrintServiceLookup
extends PrintServiceLookup
implements BackgroundServiceLookup,
Runnable {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private PrintService[] printServices;
    private Vector lookupListeners = null;
    private static String debugPrefix = "UnixPrintServiceLookup>> ";
    static String osname = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
    static final int UNINITIALIZED = -1;
    static final int BSD_LPD = 0;
    static final int BSD_LPD_NG = 1;
    static int cmdIndex = -1;
    String[] lpcFirstCom = new String[]{"/usr/sbin/lpc status | grep : | sed -ne '1,1 s/://p'", "/usr/sbin/lpc status | grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};
    String[] lpcAllCom = new String[]{"/usr/sbin/lpc status | grep : | sed -e 's/://'", "/usr/sbin/lpc -a status | grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};
    String[] lpcNameCom = new String[]{"| grep : | sed -ne 's/://p'", "| grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};

    static boolean isSysV() {
        return osname.equals("SunOS");
    }

    static boolean isBSD() {
        return osname.equals("Linux");
    }

    static int getBSDCommandIndex() {
        String string = "/usr/sbin/lpc status";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string);
        if (stringArray == null || stringArray.length == 0) {
            return 1;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].indexOf(64) == -1) continue;
            return 1;
        }
        return 0;
    }

    public synchronized PrintService[] getPrintServices() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.printServices == null) {
            int n2;
            ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
            int n3 = -1;
            this.getDefaultPrintService();
            if (CUPSPrinter.isCupsRunning()) {
                String[] stringArray = CUPSPrinter.getAllPrinters();
                if (stringArray == null || stringArray.length == 0) {
                    if (this.defaultPrintService == null) {
                        this.printServices = new PrintService[0];
                    } else {
                        this.printServices = new PrintService[1];
                        this.printServices[0] = this.defaultPrintService;
                    }
                    return this.printServices;
                }
                IPPPrintService.debug_println(debugPrefix + "total# of printers = " + stringArray.length);
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (stringArray[n2] == null) continue;
                    if (this.defaultPrintService != null && stringArray[n2].equals(this.defaultPrintService.getName())) {
                        arrayList.add(this.defaultPrintService);
                        n3 = arrayList.size() - 1;
                        continue;
                    }
                    try {
                        URL uRL = new URL("http://" + CUPSPrinter.getServer() + ":" + CUPSPrinter.getPort() + "/" + stringArray[n2]);
                        arrayList.add(new IPPPrintService(stringArray[n2], uRL));
                        continue;
                    }
                    catch (Exception exception) {
                        IPPPrintService.debug_println(debugPrefix + " getAllPrinters Exception " + exception);
                    }
                }
            } else {
                String[] stringArray = UnixPrintServiceLookup.isSysV() ? this.getAllPrinterNamesSysV() : this.getAllPrinterNamesBSD();
                if (stringArray == null || stringArray.length == 0) {
                    if (this.defaultPrintService == null) {
                        this.printServices = new PrintService[0];
                    } else {
                        this.printServices = new PrintService[1];
                        this.printServices[0] = this.defaultPrintService;
                    }
                    return this.printServices;
                }
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (stringArray[n2] == null) continue;
                    if (this.defaultPrintService != null && stringArray[n2].equals(this.defaultPrintService.getName())) {
                        arrayList.add(this.defaultPrintService);
                        n3 = arrayList.size() - 1;
                        continue;
                    }
                    arrayList.add(new UnixPrintService(stringArray[n2]));
                }
            }
            if (n3 == -1 && this.defaultPrintService != null) {
                arrayList.add(this.defaultPrintService);
                n3 = arrayList.size() - 1;
            }
            this.printServices = arrayList.toArray(new PrintService[0]);
            if (n3 > 0) {
                PrintService printService = this.printServices[0];
                this.printServices[0] = this.printServices[n3];
                this.printServices[n3] = printService;
            }
        }
        return this.printServices;
    }

    private boolean matchesAttributes(PrintService printService, PrintServiceAttributeSet printServiceAttributeSet) {
        Attribute[] attributeArray = printServiceAttributeSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Attribute attribute = printService.getAttribute(attributeArray[i2].getCategory());
            if (attribute != null && attribute.equals(attributeArray[i2])) continue;
            return false;
        }
        return true;
    }

    private boolean checkPrinterName(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '_' || c2 == '.' || c2 == '/') continue;
            return false;
        }
        return true;
    }

    private PrintService getServiceByName(PrinterName printerName) {
        String string = printerName.getValue();
        PrintService printService = null;
        if (string == null || string.equals("") || !this.checkPrinterName(string)) {
            return null;
        }
        printService = UnixPrintServiceLookup.isSysV() ? this.getNamedPrinterNameSysV(string) : this.getNamedPrinterNameBSD(string);
        return printService;
    }

    private PrintService[] getPrintServices(PrintServiceAttributeSet printServiceAttributeSet) {
        int n2;
        if (printServiceAttributeSet == null || printServiceAttributeSet.isEmpty()) {
            return this.getPrintServices();
        }
        PrinterName printerName = (PrinterName)printServiceAttributeSet.get(PrinterName.class);
        if (printerName != null) {
            PrintService printService = this.getDefaultPrintService();
            PrinterName printerName2 = printService.getAttribute(PrinterName.class);
            if (printerName2 != null && printerName.equals(printerName2)) {
                if (this.matchesAttributes(printService, printServiceAttributeSet)) {
                    PrintService[] printServiceArray = new PrintService[]{printService};
                    return printServiceArray;
                }
                return new PrintService[0];
            }
            PrintService printService2 = this.getServiceByName(printerName);
            if (printService2 != null && this.matchesAttributes(printService2, printServiceAttributeSet)) {
                PrintService[] printServiceArray = new PrintService[]{printService2};
                return printServiceArray;
            }
            return new PrintService[0];
        }
        Vector<PrintService> vector = new Vector<PrintService>();
        PrintService[] printServiceArray = this.getPrintServices();
        for (n2 = 0; n2 < printServiceArray.length; ++n2) {
            if (!this.matchesAttributes(printServiceArray[n2], printServiceAttributeSet)) continue;
            vector.add(printServiceArray[n2]);
        }
        printServiceArray = new PrintService[vector.size()];
        for (n2 = 0; n2 < printServiceArray.length; ++n2) {
            printServiceArray[n2] = (PrintService)vector.elementAt(n2);
        }
        return printServiceArray;
    }

    public PrintService[] getPrintServices(DocFlavor docFlavor, AttributeSet attributeSet) {
        Object[] objectArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = null;
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = null;
        if (attributeSet != null && !attributeSet.isEmpty()) {
            hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
            objectArray = attributeSet.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] instanceof PrintRequestAttribute) {
                    hashPrintRequestAttributeSet.add((Attribute)objectArray[i2]);
                    continue;
                }
                if (!(objectArray[i2] instanceof PrintServiceAttribute)) continue;
                hashPrintServiceAttributeSet.add((Attribute)objectArray[i2]);
            }
        }
        if (CUPSPrinter.isCupsRunning()) {
            objectArray = null;
            objectArray = hashPrintServiceAttributeSet != null ? this.getPrintServices(hashPrintServiceAttributeSet) : this.getPrintServices();
            if (objectArray.length == 0) {
                return objectArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                try {
                    if (objectArray[i3].getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) != null) continue;
                    arrayList.add(objectArray[i3]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            objectArray = new PrintService[arrayList.size()];
            return (PrintService[])arrayList.toArray(objectArray);
        }
        objectArray = this.getDefaultPrintService();
        if ((docFlavor == null || objectArray.isDocFlavorSupported(docFlavor)) && objectArray.getUnsupportedAttributes(docFlavor, hashPrintRequestAttributeSet) == null) {
            return this.getPrintServices(hashPrintServiceAttributeSet);
        }
        return new PrintService[0];
    }

    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] docFlavorArray, AttributeSet attributeSet) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    public synchronized PrintService getDefaultPrintService() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        if (this.defaultPrintService == null) {
            IPPPrintService.debug_println("isRunning ? " + CUPSPrinter.isCupsRunning());
            if (CUPSPrinter.isCupsRunning()) {
                this.defaultPrinter = CUPSPrinter.getDefaultPrinter();
                if (this.defaultPrinter != null) {
                    try {
                        IPPPrintService iPPPrintService = new IPPPrintService(this.defaultPrinter, new URL("http://" + CUPSPrinter.getServer() + ":" + CUPSPrinter.getPort() + "/" + this.defaultPrinter));
                        this.defaultPrintService = iPPPrintService;
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.defaultPrinter = UnixPrintServiceLookup.isSysV() ? this.getDefaultPrinterNameSysV() : this.getDefaultPrinterNameBSD();
                if (this.defaultPrinter != null) {
                    this.defaultPrintService = new UnixPrintService(this.defaultPrinter);
                }
            }
        }
        return this.defaultPrintService;
    }

    public synchronized void getServicesInbackground(BackgroundLookupListener backgroundLookupListener) {
        if (this.printServices != null) {
            backgroundLookupListener.notifyServices(this.printServices);
        } else if (this.lookupListeners == null) {
            this.lookupListeners = new Vector();
            this.lookupListeners.add(backgroundLookupListener);
            Thread thread = new Thread(this);
            thread.start();
        } else {
            this.lookupListeners.add(backgroundLookupListener);
        }
    }

    private PrintService[] copyOf(PrintService[] printServiceArray) {
        if (printServiceArray == null || printServiceArray.length == 0) {
            return printServiceArray;
        }
        PrintService[] printServiceArray2 = new PrintService[printServiceArray.length];
        System.arraycopy(printServiceArray, 0, printServiceArray2, 0, printServiceArray.length);
        return printServiceArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PrintService[] printServiceArray = this.getPrintServices();
        UnixPrintServiceLookup unixPrintServiceLookup = this;
        synchronized (unixPrintServiceLookup) {
            for (int i2 = 0; i2 < this.lookupListeners.size(); ++i2) {
                BackgroundLookupListener backgroundLookupListener = (BackgroundLookupListener)this.lookupListeners.elementAt(i2);
                backgroundLookupListener.notifyServices(this.copyOf(printServiceArray));
            }
            this.lookupListeners = null;
        }
    }

    private String getDefaultPrinterNameBSD() {
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(this.lpcFirstCom[cmdIndex])) == null || stringArray.length == 0) {
            return null;
        }
        if (cmdIndex == 1 && stringArray[0].startsWith("missingprinter")) {
            return null;
        }
        return stringArray[0];
    }

    private PrintService getNamedPrinterNameBSD(String string) {
        String string2;
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(string2 = "/usr/sbin/lpc status " + string + this.lpcNameCom[cmdIndex])) == null || !stringArray[0].equals(string)) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesBSD() {
        String[] stringArray;
        if (cmdIndex == -1) {
            cmdIndex = UnixPrintServiceLookup.getBSDCommandIndex();
        }
        if ((stringArray = UnixPrintServiceLookup.execCmd(this.lpcAllCom[cmdIndex])) == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    private String getDefaultPrinterNameSysV() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -d|/usr/bin/expand|/usr/bin/cut -f4 -d' '";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        return stringArray[0];
    }

    private PrintService getNamedPrinterNameSysV(String string) {
        String string2 = "/usr/bin/lpstat -v " + string;
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        if (stringArray == null || stringArray[0].indexOf("unknown printer") > 0) {
            return null;
        }
        return new UnixPrintService(string);
    }

    private String[] getAllPrinterNamesSysV() {
        String string = "lp";
        String string2 = "/usr/bin/lpstat -v|/usr/bin/expand|/usr/bin/cut -f3 -d' ' |/usr/bin/cut -f1 -d':'";
        String[] stringArray = UnixPrintServiceLookup.execCmd(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals("_default") || stringArray[i2].equals(string)) continue;
            arrayList.add(stringArray[i2]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String[] execCmd(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            final String[] stringArray = new String[3];
            if (UnixPrintServiceLookup.isSysV()) {
                stringArray[0] = "/usr/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "env LC_ALL=C " + string;
            } else {
                stringArray[0] = "/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = string;
            }
            BufferedReader bufferedReader = (BufferedReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = File.createTempFile("prn", "xc");
                    stringArray[2] = stringArray[2] + ">" + file.getAbsolutePath();
                    Process process = Runtime.getRuntime().exec(stringArray);
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (process.exitValue() == 0) {
                        FileReader fileReader = new FileReader(file);
                        file.delete();
                        return new BufferedReader(fileReader);
                    }
                    return null;
                }
            });
            if (bufferedReader != null) {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(string2);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

