/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.NativeLibLoader;
import java.io.IOException;
import java.io.ObjectInputStream;

public class MouseEvent
extends InputEvent {
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 507;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    public static final int NOBUTTON = 0;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    int x;
    int y;
    int clickCount;
    int button;
    boolean popupTrigger = false;
    private static final long serialVersionUID = -991214153494842848L;

    private static native void initIDs();

    public MouseEvent(Component component, int n2, long l2, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        super(component, n2, l2, n3);
        this.x = n4;
        this.y = n5;
        this.clickCount = n6;
        this.popupTrigger = bl2;
        if (n7 < 0 || n7 > 3) {
            throw new IllegalArgumentException("Invalid button value");
        }
        this.button = n7;
        if (this.getModifiers() != 0 && this.getModifiersEx() == 0) {
            this.setNewModifiers();
        } else if (this.getModifiers() == 0 && (this.getModifiersEx() != 0 || n7 != 0)) {
            this.setOldModifiers();
        }
    }

    public MouseEvent(Component component, int n2, long l2, int n3, int n4, int n5, int n6, boolean bl2) {
        this(component, n2, l2, n3, n4, n5, n6, bl2, 0);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getPoint() {
        int n2;
        int n3;
        MouseEvent mouseEvent = this;
        synchronized (mouseEvent) {
            n3 = this.x;
            n2 = this.y;
        }
        return new Point(n3, n2);
    }

    public synchronized void translatePoint(int n2, int n3) {
        this.x += n2;
        this.y += n3;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getButton() {
        return this.button;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public static String getMouseModifiersText(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n2 & 8) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.alt", "Alt"));
            stringBuffer.append("+");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.meta", "Meta"));
            stringBuffer.append("+");
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            stringBuffer.append("+");
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.shift", "Shift"));
            stringBuffer.append("+");
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            stringBuffer.append("+");
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.button1", "Button1"));
            stringBuffer.append("+");
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.button2", "Button2"));
            stringBuffer.append("+");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.button3", "Button3"));
            stringBuffer.append("+");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String paramString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        switch (this.id) {
            case 501: {
                stringBuffer.append("MOUSE_PRESSED");
                break;
            }
            case 502: {
                stringBuffer.append("MOUSE_RELEASED");
                break;
            }
            case 500: {
                stringBuffer.append("MOUSE_CLICKED");
                break;
            }
            case 504: {
                stringBuffer.append("MOUSE_ENTERED");
                break;
            }
            case 505: {
                stringBuffer.append("MOUSE_EXITED");
                break;
            }
            case 503: {
                stringBuffer.append("MOUSE_MOVED");
                break;
            }
            case 506: {
                stringBuffer.append("MOUSE_DRAGGED");
                break;
            }
            case 507: {
                stringBuffer.append("MOUSE_WHEEL");
                break;
            }
            default: {
                stringBuffer.append("unknown type");
            }
        }
        stringBuffer.append(",(").append(this.x).append(",").append(this.y).append(")");
        stringBuffer.append(",button=").append(this.getButton());
        if (this.getModifiers() != 0) {
            stringBuffer.append(",modifiers=").append(MouseEvent.getMouseModifiersText(this.modifiers));
        }
        if (this.getModifiersEx() != 0) {
            stringBuffer.append(",extModifiers=").append(MouseEvent.getModifiersExText(this.modifiers));
        }
        stringBuffer.append(",clickCount=").append(this.clickCount);
        return stringBuffer.toString();
    }

    private void setNewModifiers() {
        if ((this.modifiers & 0x10) != 0) {
            this.modifiers |= 0x400;
        }
        if ((this.modifiers & 8) != 0) {
            this.modifiers |= 0x800;
        }
        if ((this.modifiers & 4) != 0) {
            this.modifiers |= 0x1000;
        }
        if (this.id == 501 || this.id == 502 || this.id == 500) {
            if ((this.modifiers & 0x10) != 0) {
                this.button = 1;
                this.modifiers &= 0xFFFFFFF3;
                if (this.id != 501) {
                    this.modifiers &= 0xFFFFFBFF;
                }
            } else if ((this.modifiers & 8) != 0) {
                this.button = 2;
                this.modifiers &= 0xFFFFFFEB;
                if (this.id != 501) {
                    this.modifiers &= 0xFFFFF7FF;
                }
            } else if ((this.modifiers & 4) != 0) {
                this.button = 3;
                this.modifiers &= 0xFFFFFFE7;
                if (this.id != 501) {
                    this.modifiers &= 0xFFFFEFFF;
                }
            }
        }
        if ((this.modifiers & 8) != 0) {
            this.modifiers |= 0x200;
        }
        if ((this.modifiers & 4) != 0) {
            this.modifiers |= 0x100;
        }
        if ((this.modifiers & 1) != 0) {
            this.modifiers |= 0x40;
        }
        if ((this.modifiers & 2) != 0) {
            this.modifiers |= 0x80;
        }
        if ((this.modifiers & 0x20) != 0) {
            this.modifiers |= 0x2000;
        }
    }

    private void setOldModifiers() {
        if (this.id == 501 || this.id == 502 || this.id == 500) {
            switch (this.button) {
                case 1: {
                    this.modifiers |= 0x10;
                    break;
                }
                case 2: {
                    this.modifiers |= 8;
                    break;
                }
                case 3: {
                    this.modifiers |= 4;
                }
            }
        } else {
            if ((this.modifiers & 0x400) != 0) {
                this.modifiers |= 0x10;
            }
            if ((this.modifiers & 0x800) != 0) {
                this.modifiers |= 8;
            }
            if ((this.modifiers & 0x1000) != 0) {
                this.modifiers |= 4;
            }
        }
        if ((this.modifiers & 0x200) != 0) {
            this.modifiers |= 8;
        }
        if ((this.modifiers & 0x100) != 0) {
            this.modifiers |= 4;
        }
        if ((this.modifiers & 0x40) != 0) {
            this.modifiers |= 1;
        }
        if ((this.modifiers & 0x80) != 0) {
            this.modifiers |= 2;
        }
        if ((this.modifiers & 0x2000) != 0) {
            this.modifiers |= 0x20;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getModifiers() != 0 && this.getModifiersEx() == 0) {
            this.setNewModifiers();
        }
    }

    static {
        NativeLibLoader.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MouseEvent.initIDs();
        }
    }
}

