/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.BerDecoder;
import com.sun.jmx.snmp.BerEncoder;
import com.sun.jmx.snmp.BerException;
import com.sun.jmx.snmp.SnmpCounter;
import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpGauge;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpIpAddress;
import com.sun.jmx.snmp.SnmpNull;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpOpaque;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpSecurityParameters;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpString;
import com.sun.jmx.snmp.SnmpTimeticks;
import com.sun.jmx.snmp.SnmpTooBigException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import java.net.InetAddress;
import java.util.Vector;

public abstract class SnmpMsg
implements SnmpDefinitions {
    public int version = 0;
    public byte[] data = null;
    public int dataLength = 0;
    public InetAddress address = null;
    public int port = 0;
    public SnmpSecurityParameters securityParameters = null;

    public static int getProtocolVersion(byte[] byArray) throws SnmpStatusException {
        int n2 = 0;
        BerDecoder berDecoder = null;
        try {
            berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            n2 = berDecoder.fetchInteger();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            // empty catch block
        }
        return n2;
    }

    public abstract int getRequestId(byte[] var1) throws SnmpStatusException;

    public abstract int encodeMessage(byte[] var1) throws SnmpTooBigException;

    public abstract void decodeMessage(byte[] var1, int var2) throws SnmpStatusException;

    public abstract void encodeSnmpPdu(SnmpPdu var1, int var2) throws SnmpStatusException, SnmpTooBigException;

    public abstract SnmpPdu decodeSnmpPdu() throws SnmpStatusException;

    public static String dumpHexBuffer(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(n3 << 1);
        int n4 = 1;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            int n6 = byArray[i2] & 0xFF;
            stringBuffer.append(Character.forDigit(n6 >>> 4, 16));
            stringBuffer.append(Character.forDigit(n6 & 0xF, 16));
            if (++n4 % 16 == 0) {
                stringBuffer.append('\n');
                n4 = 1;
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String printMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: ");
        stringBuffer.append(this.version);
        stringBuffer.append("\n");
        if (this.data == null) {
            stringBuffer.append("Data: null");
        } else {
            stringBuffer.append("Data: {\n");
            stringBuffer.append(SnmpMsg.dumpHexBuffer(this.data, 0, this.dataLength));
            stringBuffer.append("\n}\n");
        }
        return stringBuffer.toString();
    }

    public void encodeVarBindList(BerEncoder berEncoder, SnmpVarBind[] snmpVarBindArray) throws SnmpStatusException, SnmpTooBigException {
        int n2 = 0;
        try {
            berEncoder.openSequence();
            if (snmpVarBindArray != null) {
                for (int i2 = snmpVarBindArray.length - 1; i2 >= 0; --i2) {
                    SnmpVarBind snmpVarBind = snmpVarBindArray[i2];
                    if (snmpVarBind == null) continue;
                    berEncoder.openSequence();
                    this.encodeVarBindValue(berEncoder, snmpVarBind.value);
                    berEncoder.putOid(snmpVarBind.oid.longValue());
                    berEncoder.closeSequence();
                    ++n2;
                }
            }
            berEncoder.closeSequence();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException(n2);
        }
    }

    void encodeVarBindValue(BerEncoder berEncoder, SnmpValue snmpValue) throws SnmpStatusException {
        if (snmpValue == null) {
            berEncoder.putNull();
        } else if (snmpValue instanceof SnmpIpAddress) {
            berEncoder.putOctetString(((SnmpIpAddress)snmpValue).byteValue(), 64);
        } else if (snmpValue instanceof SnmpCounter) {
            berEncoder.putInteger(((SnmpCounter)snmpValue).longValue(), 65);
        } else if (snmpValue instanceof SnmpGauge) {
            berEncoder.putInteger(((SnmpGauge)snmpValue).longValue(), 66);
        } else if (snmpValue instanceof SnmpTimeticks) {
            berEncoder.putInteger(((SnmpTimeticks)snmpValue).longValue(), 67);
        } else if (snmpValue instanceof SnmpOpaque) {
            berEncoder.putOctetString(((SnmpOpaque)snmpValue).byteValue(), 68);
        } else if (snmpValue instanceof SnmpInt) {
            berEncoder.putInteger(((SnmpInt)snmpValue).intValue());
        } else if (snmpValue instanceof SnmpString) {
            berEncoder.putOctetString(((SnmpString)snmpValue).byteValue());
        } else if (snmpValue instanceof SnmpOid) {
            berEncoder.putOid(((SnmpOid)snmpValue).longValue());
        } else if (snmpValue instanceof SnmpCounter64) {
            if (this.version == 0) {
                throw new SnmpStatusException("Invalid value for SNMP v1 : " + snmpValue);
            }
            berEncoder.putInteger(((SnmpCounter64)snmpValue).longValue(), 70);
        } else if (snmpValue instanceof SnmpNull) {
            int n2 = ((SnmpNull)snmpValue).getTag();
            if (this.version == 0 && n2 != 5) {
                throw new SnmpStatusException("Invalid value for SNMP v1 : " + snmpValue);
            }
            if (this.version == 1 && n2 != 5 && n2 != 128 && n2 != 129 && n2 != 130) {
                throw new SnmpStatusException("Invalid value " + snmpValue);
            }
            berEncoder.putNull(n2);
        } else {
            throw new SnmpStatusException("Invalid value " + snmpValue);
        }
    }

    public SnmpVarBind[] decodeVarBindList(BerDecoder berDecoder) throws BerException {
        Object[] objectArray;
        berDecoder.openSequence();
        Vector<Object[]> vector = new Vector<Object[]>();
        while (berDecoder.cannotCloseSequence()) {
            objectArray = new SnmpVarBind();
            berDecoder.openSequence();
            objectArray.oid = new SnmpOid(berDecoder.fetchOid());
            objectArray.setSnmpValue(this.decodeVarBindValue(berDecoder));
            berDecoder.closeSequence();
            vector.addElement(objectArray);
        }
        berDecoder.closeSequence();
        objectArray = new SnmpVarBind[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    SnmpValue decodeVarBindValue(BerDecoder berDecoder) throws BerException {
        SnmpValue snmpValue = null;
        int n2 = berDecoder.getTag();
        switch (n2) {
            case 2: {
                try {
                    snmpValue = new SnmpInt(berDecoder.fetchInteger());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 4: {
                try {
                    snmpValue = new SnmpString(berDecoder.fetchOctetString());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 6: {
                try {
                    snmpValue = new SnmpOid(berDecoder.fetchOid());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 5: {
                berDecoder.fetchNull();
                try {
                    snmpValue = new SnmpNull();
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 64: {
                try {
                    snmpValue = new SnmpIpAddress(berDecoder.fetchOctetString(n2));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 65: {
                try {
                    snmpValue = new SnmpCounter(berDecoder.fetchIntegerAsLong(n2));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 66: {
                try {
                    snmpValue = new SnmpGauge(berDecoder.fetchIntegerAsLong(n2));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 67: {
                try {
                    snmpValue = new SnmpTimeticks(berDecoder.fetchIntegerAsLong(n2));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 68: {
                try {
                    snmpValue = new SnmpOpaque(berDecoder.fetchOctetString(n2));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 70: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                try {
                    snmpValue = new SnmpCounter64(berDecoder.fetchIntegerAsLong(n2));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new BerException();
                }
            }
            case 128: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n2);
                snmpValue = SnmpVarBind.noSuchObject;
                break;
            }
            case 129: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n2);
                snmpValue = SnmpVarBind.noSuchInstance;
                break;
            }
            case 130: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                berDecoder.fetchNull(n2);
                snmpValue = SnmpVarBind.endOfMibView;
                break;
            }
            default: {
                throw new BerException();
            }
        }
        return snmpValue;
    }
}

