/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.corba;

import com.sun.corba.se.impl.corba.TCUtility;
import com.sun.corba.se.impl.corba.TypeCodeImpl;
import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.encoding.EncapsInputStream;
import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.impl.io.ValueUtility;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
import com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class AnyImpl
extends Any {
    private TypeCodeImpl typeCode;
    protected ORB orb;
    private ORBUtilSystemException wrapper;
    private CDRInputStream stream;
    private long value;
    private java.lang.Object object;
    private boolean isInitialized = false;
    private static final int DEFAULT_BUFFER_SIZE = 32;
    static boolean[] isStreamed = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false};

    static AnyImpl convertToNative(ORB oRB, Any any) {
        if (any instanceof AnyImpl) {
            return (AnyImpl)any;
        }
        AnyImpl anyImpl = new AnyImpl(oRB, any);
        anyImpl.typeCode = TypeCodeImpl.convertToNative(oRB, anyImpl.typeCode);
        return anyImpl;
    }

    public AnyImpl(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.presentation");
        this.typeCode = oRB.get_primitive_tc(0);
        this.stream = null;
        this.object = null;
        this.value = 0L;
        this.isInitialized = true;
    }

    public AnyImpl(ORB oRB, Any any) {
        this(oRB);
        if (any instanceof AnyImpl) {
            AnyImpl anyImpl = (AnyImpl)any;
            this.typeCode = anyImpl.typeCode;
            this.value = anyImpl.value;
            this.object = anyImpl.object;
            this.isInitialized = anyImpl.isInitialized;
            if (anyImpl.stream != null) {
                this.stream = anyImpl.stream.dup();
            }
        } else {
            this.read_value(any.create_input_stream(), any.type());
        }
    }

    public TypeCode type() {
        return this.typeCode;
    }

    private TypeCode realType() {
        return this.realType(this.typeCode);
    }

    private TypeCode realType(TypeCode typeCode) {
        TypeCode typeCode2 = typeCode;
        try {
            while (typeCode2.kind().value() == 21) {
                typeCode2 = typeCode2.content_type();
            }
        }
        catch (BadKind badKind) {
            throw this.wrapper.badkindCannotOccur(badKind);
        }
        return typeCode2;
    }

    public void type(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        this.stream = null;
        this.value = 0L;
        this.object = null;
        this.isInitialized = typeCode.kind().value() == 0;
    }

    public boolean equal(Any any) {
        if (any == this) {
            return true;
        }
        if (!this.typeCode.equal(any.type())) {
            return false;
        }
        TypeCode typeCode = this.realType();
        switch (typeCode.kind().value()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == any.extract_short();
            }
            case 3: {
                return this.extract_long() == any.extract_long();
            }
            case 4: {
                return this.extract_ushort() == any.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == any.extract_ulong();
            }
            case 6: {
                return this.extract_float() == any.extract_float();
            }
            case 7: {
                return this.extract_double() == any.extract_double();
            }
            case 8: {
                return this.extract_boolean() == any.extract_boolean();
            }
            case 9: {
                return this.extract_char() == any.extract_char();
            }
            case 26: {
                return this.extract_wchar() == any.extract_wchar();
            }
            case 10: {
                return this.extract_octet() == any.extract_octet();
            }
            case 11: {
                return this.extract_any().equal(any.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(any.extract_TypeCode());
            }
            case 18: {
                return this.extract_string().equals(any.extract_string());
            }
            case 27: {
                return this.extract_wstring().equals(any.extract_wstring());
            }
            case 23: {
                return this.extract_longlong() == any.extract_longlong();
            }
            case 24: {
                return this.extract_ulonglong() == any.extract_ulonglong();
            }
            case 14: {
                return this.extract_Object().equals(any.extract_Object());
            }
            case 13: {
                return this.extract_Principal().equals(any.extract_Principal());
            }
            case 17: {
                return this.extract_long() == any.extract_long();
            }
            case 28: {
                return this.extract_fixed().compareTo(any.extract_fixed()) == 0;
            }
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                org.omg.CORBA.portable.InputStream inputStream = this.create_input_stream();
                org.omg.CORBA.portable.InputStream inputStream2 = any.create_input_stream();
                return this.equalMember(typeCode, inputStream, inputStream2);
            }
            case 29: 
            case 30: {
                return this.extract_Value().equals(any.extract_Value());
            }
            case 21: {
                throw this.wrapper.errorResolvingAlias();
            }
            case 25: {
                throw this.wrapper.tkLongDoubleNotSupported();
            }
        }
        throw this.wrapper.typecodeNotSupported();
    }

    private boolean equalMember(TypeCode typeCode, org.omg.CORBA.portable.InputStream inputStream, org.omg.CORBA.portable.InputStream inputStream2) {
        TypeCode typeCode2 = this.realType(typeCode);
        try {
            switch (typeCode2.kind().value()) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: {
                    return inputStream.read_short() == inputStream2.read_short();
                }
                case 3: {
                    return inputStream.read_long() == inputStream2.read_long();
                }
                case 4: {
                    return inputStream.read_ushort() == inputStream2.read_ushort();
                }
                case 5: {
                    return inputStream.read_ulong() == inputStream2.read_ulong();
                }
                case 6: {
                    return inputStream.read_float() == inputStream2.read_float();
                }
                case 7: {
                    return inputStream.read_double() == inputStream2.read_double();
                }
                case 8: {
                    return inputStream.read_boolean() == inputStream2.read_boolean();
                }
                case 9: {
                    return inputStream.read_char() == inputStream2.read_char();
                }
                case 26: {
                    return inputStream.read_wchar() == inputStream2.read_wchar();
                }
                case 10: {
                    return inputStream.read_octet() == inputStream2.read_octet();
                }
                case 11: {
                    return inputStream.read_any().equal(inputStream2.read_any());
                }
                case 12: {
                    return inputStream.read_TypeCode().equal(inputStream2.read_TypeCode());
                }
                case 18: {
                    return inputStream.read_string().equals(inputStream2.read_string());
                }
                case 27: {
                    return inputStream.read_wstring().equals(inputStream2.read_wstring());
                }
                case 23: {
                    return inputStream.read_longlong() == inputStream2.read_longlong();
                }
                case 24: {
                    return inputStream.read_ulonglong() == inputStream2.read_ulonglong();
                }
                case 14: {
                    return inputStream.read_Object().equals(inputStream2.read_Object());
                }
                case 13: {
                    return inputStream.read_Principal().equals(inputStream2.read_Principal());
                }
                case 17: {
                    return inputStream.read_long() == inputStream2.read_long();
                }
                case 28: {
                    return inputStream.read_fixed().compareTo(inputStream2.read_fixed()) == 0;
                }
                case 15: 
                case 22: {
                    int n2 = typeCode2.member_count();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (this.equalMember(typeCode2.member_type(i2), inputStream, inputStream2)) continue;
                        return false;
                    }
                    return true;
                }
                case 16: {
                    Any any = this.orb.create_any();
                    Any any2 = this.orb.create_any();
                    any.read_value(inputStream, typeCode2.discriminator_type());
                    any2.read_value(inputStream2, typeCode2.discriminator_type());
                    if (!any.equal(any2)) {
                        return false;
                    }
                    TypeCodeImpl typeCodeImpl = TypeCodeImpl.convertToNative(this.orb, typeCode2);
                    int n3 = typeCodeImpl.currentUnionMemberIndex(any);
                    if (n3 == -1) {
                        throw this.wrapper.unionDiscriminatorError();
                    }
                    return this.equalMember(typeCode2.member_type(n3), inputStream, inputStream2);
                }
                case 19: {
                    int n4 = inputStream.read_long();
                    inputStream2.read_long();
                    for (int i3 = 0; i3 < n4; ++i3) {
                        if (this.equalMember(typeCode2.content_type(), inputStream, inputStream2)) continue;
                        return false;
                    }
                    return true;
                }
                case 20: {
                    int n5 = typeCode2.member_count();
                    for (int i4 = 0; i4 < n5; ++i4) {
                        if (this.equalMember(typeCode2.content_type(), inputStream, inputStream2)) continue;
                        return false;
                    }
                    return true;
                }
                case 29: 
                case 30: {
                    InputStream inputStream3 = (InputStream)inputStream;
                    InputStream inputStream4 = (InputStream)inputStream2;
                    return inputStream3.read_value().equals(inputStream4.read_value());
                }
                case 21: {
                    throw this.wrapper.errorResolvingAlias();
                }
                case 25: {
                    throw this.wrapper.tkLongDoubleNotSupported();
                }
            }
            throw this.wrapper.typecodeNotSupported();
        }
        catch (BadKind badKind) {
            throw this.wrapper.badkindCannotOccur();
        }
        catch (Bounds bounds) {
            throw this.wrapper.boundsCannotOccur();
        }
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        return new AnyOutputStream(this.orb);
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (isStreamed[this.realType().kind().value()]) {
            return this.stream.dup();
        }
        org.omg.CORBA.portable.OutputStream outputStream = this.orb.create_output_stream();
        TCUtility.marshalIn(outputStream, this.realType(), this.value, this.object);
        return outputStream.create_input_stream();
    }

    public void read_value(org.omg.CORBA.portable.InputStream inputStream, TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        int n2 = this.realType().kind().value();
        if (n2 >= isStreamed.length) {
            throw this.wrapper.invalidIsstreamedTckind(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n2));
        }
        if (isStreamed[n2]) {
            if (inputStream instanceof AnyInputStream) {
                this.stream = (CDRInputStream)inputStream;
            } else {
                OutputStream outputStream = (OutputStream)this.orb.create_output_stream();
                this.typeCode.copy((InputStream)inputStream, outputStream);
                this.stream = (CDRInputStream)outputStream.create_input_stream();
            }
        } else {
            java.lang.Object[] objectArray = new java.lang.Object[]{this.object};
            long[] lArray = new long[1];
            TCUtility.unmarshalIn(inputStream, this.typeCode, lArray, objectArray);
            this.value = lArray[0];
            this.object = objectArray[0];
            this.stream = null;
        }
        this.isInitialized = true;
    }

    public void write_value(org.omg.CORBA.portable.OutputStream outputStream) {
        if (isStreamed[this.realType().kind().value()]) {
            this.typeCode.copy(this.stream.dup(), outputStream);
        } else {
            TCUtility.marshalIn(outputStream, this.realType(), this.value, this.object);
        }
    }

    public void insert_Streamable(Streamable streamable) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, streamable._type());
        this.object = streamable;
        this.isInitialized = true;
    }

    public Streamable extract_Streamable() {
        return (Streamable)this.object;
    }

    public void insert_short(short s2) {
        this.typeCode = this.orb.get_primitive_tc(2);
        this.value = s2;
        this.isInitialized = true;
    }

    private String getTCKindName(int n2) {
        if (n2 >= 0 && n2 < TypeCodeImpl.kindNames.length) {
            return TypeCodeImpl.kindNames[n2];
        }
        return "UNKNOWN(" + n2 + ")";
    }

    private void checkExtractBadOperation(int n2) {
        if (!this.isInitialized) {
            throw this.wrapper.extractNotInitialized();
        }
        int n3 = this.realType().kind().value();
        if (n3 != n2) {
            String string = this.getTCKindName(n3);
            String string2 = this.getTCKindName(n2);
            throw this.wrapper.extractWrongType(string2, string);
        }
    }

    private void checkExtractBadOperationList(int[] nArray) {
        if (!this.isInitialized) {
            throw this.wrapper.extractNotInitialized();
        }
        int n2 = this.realType().kind().value();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n2 != nArray[i2]) continue;
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            arrayList.add(this.getTCKindName(nArray[i3]));
        }
        String string = this.getTCKindName(n2);
        throw this.wrapper.extractWrongTypeList(arrayList, string);
    }

    public short extract_short() {
        this.checkExtractBadOperation(2);
        return (short)this.value;
    }

    public void insert_long(int n2) {
        int n3 = this.realType().kind().value();
        if (n3 != 3 && n3 != 17) {
            this.typeCode = this.orb.get_primitive_tc(3);
        }
        this.value = n2;
        this.isInitialized = true;
    }

    public int extract_long() {
        this.checkExtractBadOperationList(new int[]{3, 17});
        return (int)this.value;
    }

    public void insert_ushort(short s2) {
        this.typeCode = this.orb.get_primitive_tc(4);
        this.value = s2;
        this.isInitialized = true;
    }

    public short extract_ushort() {
        this.checkExtractBadOperation(4);
        return (short)this.value;
    }

    public void insert_ulong(int n2) {
        this.typeCode = this.orb.get_primitive_tc(5);
        this.value = n2;
        this.isInitialized = true;
    }

    public int extract_ulong() {
        this.checkExtractBadOperation(5);
        return (int)this.value;
    }

    public void insert_float(float f2) {
        this.typeCode = this.orb.get_primitive_tc(6);
        this.value = Float.floatToIntBits(f2);
        this.isInitialized = true;
    }

    public float extract_float() {
        this.checkExtractBadOperation(6);
        return Float.intBitsToFloat((int)this.value);
    }

    public void insert_double(double d2) {
        this.typeCode = this.orb.get_primitive_tc(7);
        this.value = Double.doubleToLongBits(d2);
        this.isInitialized = true;
    }

    public double extract_double() {
        this.checkExtractBadOperation(7);
        return Double.longBitsToDouble(this.value);
    }

    public void insert_longlong(long l2) {
        this.typeCode = this.orb.get_primitive_tc(23);
        this.value = l2;
        this.isInitialized = true;
    }

    public long extract_longlong() {
        this.checkExtractBadOperation(23);
        return this.value;
    }

    public void insert_ulonglong(long l2) {
        this.typeCode = this.orb.get_primitive_tc(24);
        this.value = l2;
        this.isInitialized = true;
    }

    public long extract_ulonglong() {
        this.checkExtractBadOperation(24);
        return this.value;
    }

    public void insert_boolean(boolean bl2) {
        this.typeCode = this.orb.get_primitive_tc(8);
        this.value = bl2 ? 1L : 0L;
        this.isInitialized = true;
    }

    public boolean extract_boolean() {
        this.checkExtractBadOperation(8);
        return this.value != 0L;
    }

    public void insert_char(char c2) {
        this.typeCode = this.orb.get_primitive_tc(9);
        this.value = c2;
        this.isInitialized = true;
    }

    public char extract_char() {
        this.checkExtractBadOperation(9);
        return (char)this.value;
    }

    public void insert_wchar(char c2) {
        this.typeCode = this.orb.get_primitive_tc(26);
        this.value = c2;
        this.isInitialized = true;
    }

    public char extract_wchar() {
        this.checkExtractBadOperation(26);
        return (char)this.value;
    }

    public void insert_octet(byte by) {
        this.typeCode = this.orb.get_primitive_tc(10);
        this.value = by;
        this.isInitialized = true;
    }

    public byte extract_octet() {
        this.checkExtractBadOperation(10);
        return (byte)this.value;
    }

    public void insert_string(String string) {
        if (this.typeCode.kind() == TCKind.tk_string) {
            int n2 = 0;
            try {
                n2 = this.typeCode.length();
            }
            catch (BadKind badKind) {
                throw this.wrapper.badkindCannotOccur();
            }
            if (n2 != 0 && string != null && string.length() > n2) {
                throw this.wrapper.badStringBounds(new Integer(string.length()), new Integer(n2));
            }
        } else {
            this.typeCode = this.orb.get_primitive_tc(18);
        }
        this.object = string;
        this.isInitialized = true;
    }

    public String extract_string() {
        this.checkExtractBadOperation(18);
        return (String)this.object;
    }

    public void insert_wstring(String string) {
        if (this.typeCode.kind() == TCKind.tk_wstring) {
            int n2 = 0;
            try {
                n2 = this.typeCode.length();
            }
            catch (BadKind badKind) {
                throw this.wrapper.badkindCannotOccur();
            }
            if (n2 != 0 && string != null && string.length() > n2) {
                throw this.wrapper.badStringBounds(new Integer(string.length()), new Integer(n2));
            }
        } else {
            this.typeCode = this.orb.get_primitive_tc(27);
        }
        this.object = string;
        this.isInitialized = true;
    }

    public String extract_wstring() {
        this.checkExtractBadOperation(27);
        return (String)this.object;
    }

    public void insert_any(Any any) {
        this.typeCode = this.orb.get_primitive_tc(11);
        this.object = any;
        this.stream = null;
        this.isInitialized = true;
    }

    public Any extract_any() {
        this.checkExtractBadOperation(11);
        return (Any)this.object;
    }

    public void insert_Object(Object object) {
        if (object == null) {
            this.typeCode = this.orb.get_primitive_tc(14);
        } else if (StubAdapter.isStub(object)) {
            String[] stringArray = StubAdapter.getTypeIds(object);
            this.typeCode = new TypeCodeImpl(this.orb, 14, stringArray[0], "");
        } else {
            throw this.wrapper.badInsertobjParam(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)object.getClass().getName());
        }
        this.object = object;
        this.isInitialized = true;
    }

    public void insert_Object(Object object, TypeCode typeCode) {
        try {
            if (!typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") && !object._is_a(typeCode.id())) {
                throw this.wrapper.insertObjectIncompatible();
            }
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
            this.object = object;
        }
        catch (Exception exception) {
            throw this.wrapper.insertObjectFailed(exception);
        }
        this.isInitialized = true;
    }

    public Object extract_Object() {
        if (!this.isInitialized) {
            throw this.wrapper.extractNotInitialized();
        }
        Object object = null;
        try {
            object = (Object)this.object;
            if (this.typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") || object._is_a(this.typeCode.id())) {
                return object;
            }
            throw this.wrapper.extractObjectIncompatible();
        }
        catch (Exception exception) {
            throw this.wrapper.extractObjectFailed(exception);
        }
    }

    public void insert_TypeCode(TypeCode typeCode) {
        this.typeCode = this.orb.get_primitive_tc(12);
        this.object = typeCode;
        this.isInitialized = true;
    }

    public TypeCode extract_TypeCode() {
        this.checkExtractBadOperation(12);
        return (TypeCode)this.object;
    }

    @Deprecated
    public void insert_Principal(Principal principal) {
        this.typeCode = this.orb.get_primitive_tc(13);
        this.object = principal;
        this.isInitialized = true;
    }

    @Deprecated
    public Principal extract_Principal() {
        this.checkExtractBadOperation(13);
        return (Principal)this.object;
    }

    public Serializable extract_Value() {
        this.checkExtractBadOperationList(new int[]{29, 30, 32});
        return (Serializable)this.object;
    }

    public void insert_Value(Serializable serializable) {
        this.object = serializable;
        TypeCode typeCode = serializable == null ? this.orb.get_primitive_tc(TCKind.tk_value) : this.createTypeCodeForClass(serializable.getClass(), (ORB)ORB.init());
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        this.isInitialized = true;
    }

    public void insert_Value(Serializable serializable, TypeCode typeCode) {
        this.object = serializable;
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        this.isInitialized = true;
    }

    public void insert_fixed(BigDecimal bigDecimal) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, this.orb.create_fixed_tc(TypeCodeImpl.digits(bigDecimal), TypeCodeImpl.scale(bigDecimal)));
        this.object = bigDecimal;
        this.isInitialized = true;
    }

    public void insert_fixed(BigDecimal bigDecimal, TypeCode typeCode) {
        try {
            if (TypeCodeImpl.digits(bigDecimal) > typeCode.fixed_digits() || TypeCodeImpl.scale(bigDecimal) > typeCode.fixed_scale()) {
                throw this.wrapper.fixedNotMatch();
            }
        }
        catch (BadKind badKind) {
            throw this.wrapper.fixedBadTypecode(badKind);
        }
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        this.object = bigDecimal;
        this.isInitialized = true;
    }

    public BigDecimal extract_fixed() {
        this.checkExtractBadOperation(28);
        return (BigDecimal)this.object;
    }

    public TypeCode createTypeCodeForClass(Class clazz, ORB oRB) {
        TypeCodeImpl typeCodeImpl = oRB.getTypeCodeForClass(clazz);
        if (typeCodeImpl != null) {
            return typeCodeImpl;
        }
        RepositoryIdStrings repositoryIdStrings = RepositoryIdFactory.getRepIdStringsFactory(oRB);
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            TypeCode typeCode = clazz2.isPrimitive() ? this.getPrimitiveTypeCodeForClass(clazz2, oRB) : this.createTypeCodeForClass(clazz2, oRB);
            TypeCode typeCode2 = oRB.create_sequence_tc(0, typeCode);
            String string = repositoryIdStrings.createForJavaType(clazz);
            return oRB.create_value_box_tc(string, "Sequence", typeCode2);
        }
        if (clazz == String.class) {
            TypeCode typeCode = oRB.create_string_tc(0);
            String string = repositoryIdStrings.createForJavaType(clazz);
            return oRB.create_value_box_tc(string, "StringValue", typeCode);
        }
        typeCodeImpl = (TypeCodeImpl)ValueUtility.createTypeCodeForClass(oRB, clazz, ORBUtility.createValueHandler(oRB));
        typeCodeImpl.setCaching(true);
        oRB.setTypeCodeForClass(clazz, typeCodeImpl);
        return typeCodeImpl;
    }

    private TypeCode getPrimitiveTypeCodeForClass(Class clazz, ORB oRB) {
        if (clazz == Integer.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_long);
        }
        if (clazz == Byte.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_octet);
        }
        if (clazz == Long.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_longlong);
        }
        if (clazz == Float.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_float);
        }
        if (clazz == Double.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_double);
        }
        if (clazz == Short.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_short);
        }
        if (clazz == Character.TYPE) {
            if (ORBVersionFactory.getFOREIGN().compareTo(oRB.getORBVersion()) == 0 || ORBVersionFactory.getNEWER().compareTo(oRB.getORBVersion()) <= 0) {
                return oRB.get_primitive_tc(TCKind.tk_wchar);
            }
            return oRB.get_primitive_tc(TCKind.tk_char);
        }
        if (clazz == Boolean.TYPE) {
            return oRB.get_primitive_tc(TCKind.tk_boolean);
        }
        return oRB.get_primitive_tc(TCKind.tk_any);
    }

    public Any extractAny(TypeCode typeCode, ORB oRB) {
        Any any = oRB.create_any();
        org.omg.CORBA.portable.OutputStream outputStream = any.create_output_stream();
        TypeCodeImpl.convertToNative(oRB, typeCode).copy(this.stream, outputStream);
        any.read_value(outputStream.create_input_stream(), typeCode);
        return any;
    }

    public static Any extractAnyFromStream(TypeCode typeCode, org.omg.CORBA.portable.InputStream inputStream, ORB oRB) {
        Any any = oRB.create_any();
        org.omg.CORBA.portable.OutputStream outputStream = any.create_output_stream();
        TypeCodeImpl.convertToNative(oRB, typeCode).copy(inputStream, outputStream);
        any.read_value(outputStream.create_input_stream(), typeCode);
        return any;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private static final class AnyInputStream
    extends EncapsInputStream {
        public AnyInputStream(EncapsInputStream encapsInputStream) {
            super(encapsInputStream);
        }
    }

    private static final class AnyOutputStream
    extends EncapsOutputStream {
        public AnyOutputStream(ORB oRB) {
            super(oRB);
        }

        public org.omg.CORBA.portable.InputStream create_input_stream() {
            return new AnyInputStream((EncapsInputStream)super.create_input_stream());
        }
    }
}

