/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Cipher
extends CipherSpi {
    private static final int MODE_ECB = 3;
    private static final int MODE_CBC = 4;
    private static final int PAD_NONE = 5;
    private static final int PAD_PKCS5 = 6;
    private final Token token;
    private final String algorithm;
    private final String keyAlgorithm;
    private final long mechanism;
    private Session session;
    private P11Key p11Key;
    private boolean initialized;
    private boolean encrypt;
    private int blockMode;
    private final int blockSize;
    private int paddingType;
    private byte[] iv;
    private int bytesProcessed;

    P11Cipher(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
        this.keyAlgorithm = string.split("/")[0];
        if (this.keyAlgorithm.equals("AES")) {
            this.blockSize = 16;
            this.blockMode = 4;
            this.paddingType = 5;
        } else if (this.keyAlgorithm.equals("RC4") || this.keyAlgorithm.equals("ARCFOUR")) {
            this.blockSize = 0;
            this.blockMode = 3;
            this.paddingType = 5;
        } else {
            this.blockSize = 8;
            this.blockMode = 4;
            this.paddingType = 5;
        }
        this.session = token.getOpSession();
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if ((string = string.toUpperCase()).equals("ECB")) {
            this.blockMode = 3;
        } else if (string.equals("CBC")) {
            if (this.blockSize == 0) {
                throw new NoSuchAlgorithmException("CBC mode not supported with stream ciphers");
            }
            this.blockMode = 4;
        } else {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equalsIgnoreCase("NoPadding")) {
            if (string.equalsIgnoreCase("PKCS5Padding")) {
                if (this.blockSize == 0) {
                    throw new NoSuchPaddingException("PKCS#5 padding not supported with stream ciphers");
                }
                this.paddingType = 6;
                throw new NoSuchPaddingException("pkcs5");
            }
            throw new NoSuchPaddingException("Unsupported padding " + string);
        }
        this.paddingType = 5;
    }

    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected int engineGetOutputSize(int n) {
        return this.doFinalLength(n);
    }

    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.iv == null) {
            return null;
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.keyAlgorithm, P11Util.getSunJceProvider());
            algorithmParameters.init(ivParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException("Could not encode parameters", generalSecurityException);
        }
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.implInit(n, key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("init() failed", invalidAlgorithmParameterException);
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray;
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only IvParameterSpec supported");
            }
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            byArray = ivParameterSpec.getIV();
        } else {
            byArray = null;
        }
        this.implInit(n, key, byArray, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray;
        if (algorithmParameters != null) {
            try {
                IvParameterSpec ivParameterSpec = algorithmParameters.getParameterSpec(IvParameterSpec.class);
                byArray = ivParameterSpec.getIV();
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Could not decode IV", invalidParameterSpecException);
            }
        } else {
            byArray = null;
        }
        this.implInit(n, key, byArray, secureRandom);
    }

    private void implInit(int n, Key key, byte[] byArray, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cancelOperation();
        switch (n) {
            case 1: {
                this.encrypt = true;
                break;
            }
            case 2: {
                this.encrypt = false;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported mode: " + n);
            }
        }
        if (this.blockMode == 3) {
            if (byArray != null) {
                if (this.blockSize == 0) {
                    throw new InvalidAlgorithmParameterException("IV not used with stream ciphers");
                }
                throw new InvalidAlgorithmParameterException("IV not used in ECB mode");
            }
        } else if (byArray == null) {
            if (!this.encrypt) {
                throw new InvalidAlgorithmParameterException("IV must be specified for decryption in CBC mode");
            }
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            byArray = new byte[this.blockSize];
            secureRandom.nextBytes(byArray);
        } else if (byArray.length != this.blockSize) {
            throw new InvalidAlgorithmParameterException("IV length must match block size");
        }
        this.iv = byArray;
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not initialize cipher", pKCS11Exception);
        }
    }

    private void cancelOperation() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        int n = this.doFinalLength(0);
        byte[] byArray = new byte[n];
        try {
            if (this.encrypt) {
                this.token.p11.C_EncryptFinal(this.session.id(), 0L, byArray, 0, n);
            } else {
                this.token.p11.C_DecryptFinal(this.session.id(), 0L, byArray, 0, n);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Cancel failed", pKCS11Exception);
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        if (this.encrypt) {
            this.token.p11.C_EncryptInit(this.session.id(), new CK_MECHANISM(this.mechanism, this.iv), this.p11Key.keyID);
        } else {
            this.token.p11.C_DecryptInit(this.session.id(), new CK_MECHANISM(this.mechanism, this.iv), this.p11Key.keyID);
        }
        this.bytesProcessed = 0;
        this.initialized = true;
    }

    private int bytesBuffered(int n) {
        if (this.paddingType == 5) {
            return n & this.blockSize - 1;
        }
        int n2 = n & this.blockSize - 1;
        if (n2 == 0 && !this.encrypt) {
            n2 = this.blockSize;
        }
        return n2;
    }

    private int updateLength(int n) {
        if (n <= 0) {
            return 0;
        }
        if (this.blockSize == 0) {
            return n;
        }
        int n2 = this.bytesBuffered(this.bytesProcessed);
        int n3 = this.bytesBuffered(this.bytesProcessed + n);
        return n + n2 - n3;
    }

    private int doFinalLength(int n) {
        if (this.paddingType == 5) {
            return this.updateLength(n);
        }
        if (n < 0) {
            return 0;
        }
        int n2 = this.bytesBuffered(this.bytesProcessed);
        int n3 = this.bytesProcessed + n;
        int n4 = n3 + this.blockSize & ~(this.blockSize - 1);
        return n4 - this.bytesProcessed + n2;
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        try {
            byte[] byArray2 = new byte[this.updateLength(n2)];
            int n3 = this.engineUpdate(byArray, n, n2, byArray2, 0);
            return P11Util.convert(byArray2, 0, n3);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = byArray2.length - n3;
        return this.implUpdate(byArray, n, n2, byArray2, n3, n4);
    }

    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        if (!(byteBuffer instanceof DirectBuffer) || !(byteBuffer2 instanceof DirectBuffer)) {
            return super.engineUpdate(byteBuffer, byteBuffer2);
        }
        return this.implUpdate(byteBuffer, byteBuffer2);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] byArray2 = new byte[this.doFinalLength(n2)];
            int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            return P11Util.convert(byArray2, 0, n3);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException {
        int n4 = 0;
        if (n2 != 0 && byArray != null) {
            n4 = this.engineUpdate(byArray, n, n2, byArray2, n3);
            n3 += n4;
        }
        return n4 += this.implDoFinal(byArray2, n3, byArray2.length - n3);
    }

    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!(byteBuffer instanceof DirectBuffer) || !(byteBuffer2 instanceof DirectBuffer)) {
            return super.engineDoFinal(byteBuffer, byteBuffer2);
        }
        int n = this.engineUpdate(byteBuffer, byteBuffer2);
        return n += this.implDoFinal(byteBuffer2);
    }

    private int implUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException {
        if (n4 < this.updateLength(n2)) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            int n5 = this.encrypt ? this.token.p11.C_EncryptUpdate(this.session.id(), 0L, byArray, n, n2, 0L, byArray2, n3, n4) : this.token.p11.C_DecryptUpdate(this.session.id(), 0L, byArray, n, n2, 0L, byArray2, n3, n4);
            this.bytesProcessed += n2;
            return n5;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    private int implUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        try {
            this.ensureInitialized();
            long l = ((DirectBuffer)((Object)byteBuffer)).address();
            long l2 = ((DirectBuffer)((Object)byteBuffer2)).address();
            int n = byteBuffer.position();
            int n2 = byteBuffer2.position();
            int n3 = byteBuffer.remaining();
            int n4 = byteBuffer2.remaining();
            if (n3 <= 0) {
                return 0;
            }
            if (n4 < this.updateLength(n3)) {
                throw new ShortBufferException();
            }
            int n5 = this.encrypt ? this.token.p11.C_EncryptUpdate(this.session.id(), l + (long)n, null, 0, n3, l2 + (long)n2, null, 0, n4) : this.token.p11.C_DecryptUpdate(this.session.id(), l + (long)n, null, 0, n3, l2 + (long)n2, null, 0, n4);
            this.bytesProcessed += n3;
            byteBuffer.position(n + n3);
            byteBuffer2.position(n2 + n5);
            return n5;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    private int implDoFinal(byte[] byArray, int n, int n2) throws ShortBufferException, IllegalBlockSizeException {
        if (n2 < this.doFinalLength(0)) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            if (this.encrypt) {
                int n3 = this.token.p11.C_EncryptFinal(this.session.id(), 0L, byArray, n, n2);
                return n3;
            }
            int n4 = this.token.p11.C_DecryptFinal(this.session.id(), 0L, byArray, n, n2);
            return n4;
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.handleException(pKCS11Exception);
            throw new ProviderException("doFinal() failed", pKCS11Exception);
        }
        finally {
            this.initialized = false;
            this.bytesProcessed = 0;
            this.session = this.token.releaseSession(this.session);
        }
    }

    private int implDoFinal(ByteBuffer byteBuffer) throws ShortBufferException, IllegalBlockSizeException {
        try {
            this.ensureInitialized();
            long l = ((DirectBuffer)((Object)byteBuffer)).address();
            int n = byteBuffer.position();
            int n2 = byteBuffer.remaining();
            if (n2 < this.doFinalLength(0)) {
                throw new ShortBufferException();
            }
            int n3 = this.encrypt ? this.token.p11.C_EncryptFinal(this.session.id(), l + (long)n, null, 0, n2) : this.token.p11.C_DecryptFinal(this.session.id(), l + (long)n, null, 0, n2);
            byteBuffer.position(n + n3);
            int n4 = n3;
            return n4;
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.handleException(pKCS11Exception);
            throw new ProviderException("doFinal() failed", pKCS11Exception);
        }
        finally {
            this.initialized = false;
            this.bytesProcessed = 0;
            this.session = this.token.releaseSession(this.session);
        }
    }

    private void handleException(PKCS11Exception pKCS11Exception) throws IllegalBlockSizeException {
        long l = pKCS11Exception.getErrorCode();
        if (l == 33L) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException(pKCS11Exception.toString()).initCause(pKCS11Exception);
        }
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException("engineWrap()");
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException("engineUnwrap()");
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm).keyLength();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.session != null && this.token.isValid()) {
                this.cancelOperation();
                this.session = this.token.releaseSession(this.session);
            }
        }
        finally {
            super.finalize();
        }
    }
}

