/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.jobmanagement.bean.JobFileInfo;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartTimeMasterUtil;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyJob {
    protected static Log m_log = LogFactory.getLog(ModifyJob.class);

    public void registerJob(JobTreeItem item, String user) throws FinderException, NamingException, RemoveException, CreateException {
        int i;
        int msec = Calendar.getInstance().get(14);
        m_log.debug((Object)("registerJob(): start : " + msec));
        m_log.debug((Object)("registerJob(): AccessLock Start : " + msec));
        AccessLock.lock((String)"JOB");
        m_log.debug((Object)("registerJob(): AccessLock End : " + msec));
        Collection jobList = JobMasterUtil.getLocalHome().findAll();
        if (jobList != null && jobList.size() > 0) {
            Object[] jobArray = jobList.toArray();
            for (i = 0; i < jobArray.length; ++i) {
                int j;
                Collection collection;
                JobStartMasterLocal start;
                JobFileMasterLocal file;
                JobCommandMasterLocal command;
                JobMasterLocal job = (JobMasterLocal)jobArray[i];
                JobRelationMasterLocal relation = job.getJobRelationMaster();
                if (relation != null) {
                    relation.remove();
                }
                if ((command = job.getJobCommandMaster()) != null) {
                    command.remove();
                }
                if ((file = job.getJobFileMaster()) != null) {
                    file.remove();
                }
                if ((start = job.getJobStartMaster()) != null) {
                    JobStartTimeMasterLocal startTime;
                    collection = start.getJobStartJobMaster();
                    if (collection != null && collection.size() > 0) {
                        Object[] startJobArray = collection.toArray();
                        for (j = 0; j < startJobArray.length; ++j) {
                            JobStartJobMasterLocal startJob = (JobStartJobMasterLocal)startJobArray[j];
                            if (startJob == null) continue;
                            startJob.remove();
                        }
                    }
                    if ((startTime = start.getJobStartTimeMaster()) != null) {
                        startTime.remove();
                    }
                    start.remove();
                }
                if ((collection = job.getJobNoticeMaster()) != null && collection.size() > 0) {
                    Object[] noticeArray = collection.toArray();
                    for (j = 0; j < noticeArray.length; ++j) {
                        JobNoticeMasterLocal notice = (JobNoticeMasterLocal)noticeArray[j];
                        if (notice == null) continue;
                        notice.remove();
                    }
                }
                if ((collection = job.getJobEndMaster()) != null && collection.size() > 0) {
                    Object[] endArray = collection.toArray();
                    for (j = 0; j < endArray.length; ++j) {
                        JobEndMasterLocal end = (JobEndMasterLocal)endArray[j];
                        if (end == null) continue;
                        end.remove();
                    }
                }
                job.remove();
            }
        }
        JobTreeItem[] jobItems = item.getChildren(0).getChildren();
        for (i = 0; i < jobItems.length; ++i) {
            this.createJobMaster(jobItems[i], user);
        }
        m_log.debug((Object)("registerJob(): End : " + msec));
    }

    protected void createJobMaster(JobTreeItem item, String user) throws CreateException, NamingException {
        this.createJobMasterData(item, user);
        JobTreeItem[] childrens = item.getChildren();
        for (int i = 0; i < childrens.length; ++i) {
            this.createJobMaster(childrens[i], user);
        }
    }

    protected void createJobMasterData(JobTreeItem item, String user) throws CreateException, NamingException {
        int i;
        JobInfo info = item.getData();
        JobMasterUtil.getLocalHome().create(info.getId(), info.getName(), info.getDescription(), new Integer(info.getType()), new Date(), new Date(), user, user);
        String parentId = null;
        parentId = info.getType() == 0 ? "TOP" : item.getParent().getData().getId();
        JobRelationMasterUtil.getLocalHome().create(info.getId(), parentId);
        if (info.getWaitRule() instanceof JobWaitRuleInfo) {
            JobStartMasterUtil.getLocalHome().create(info.getId(), new Integer(info.getWaitRule().getCondition()), new Integer(info.getWaitRule().getSuspend()), new Integer(info.getWaitRule().getSkip()), new Integer(info.getWaitRule().getSkipEndStatus()), new Integer(info.getWaitRule().getSkipEndValue()), new Integer(info.getWaitRule().getEndCondition()), new Integer(info.getWaitRule().getEndStatus()), new Integer(info.getWaitRule().getEndValue()), new Integer(info.getWaitRule().getCalendar()), info.getWaitRule().getCalendarId(), new Integer(info.getWaitRule().getCalendarEndValue()));
            if (info.getWaitRule().getObject() instanceof ArrayList) {
                for (i = 0; i < info.getWaitRule().getObject().size(); ++i) {
                    if (!(info.getWaitRule().getObject().get(i) instanceof JobObjectInfo)) continue;
                    JobObjectInfo objectInfo = (JobObjectInfo)info.getWaitRule().getObject().get(i);
                    if (objectInfo.getType() == 0) {
                        JobStartJobMasterUtil.getLocalHome().create(info.getId(), objectInfo.getJobId(), new Integer(objectInfo.getValue()));
                        continue;
                    }
                    JobStartTimeMasterUtil.getLocalHome().create(info.getId(), new Time(objectInfo.getTime().getTime()));
                }
            }
        }
        if (info.getCommand() instanceof JobCommandInfo) {
            JobCommandMasterUtil.getLocalHome().create(info.getId(), info.getCommand().getFacilityID(), new Integer(info.getCommand().getProcessingMethod()), info.getCommand().getStartCommand(), info.getCommand().getStopCommand(), info.getCommand().getUser(), new Integer(info.getCommand().getErrorEndFlg()), new Integer(info.getCommand().getErrorEndValue()), "", "");
        }
        if (info.getFile() instanceof JobFileInfo) {
            JobFileMasterUtil.getLocalHome().create(info.getId(), new Integer(info.getFile().getProcessingMethod()), info.getFile().getSrcFacilityID(), info.getFile().getDestFacilityID(), info.getFile().getSrcFile(), info.getFile().getSrcWorkDir(), info.getFile().getDestDirectory(), info.getFile().getDestWorkDir(), new Integer(info.getFile().getCompressionFlg()), new Integer(info.getFile().getCheckFlg()), info.getFile().getUser());
        }
        if (info.getNotifications() instanceof ArrayList) {
            for (i = 0; i < info.getNotifications().size(); ++i) {
                if (!(info.getNotifications().get(i) instanceof JobNotificationsInfo)) continue;
                JobNotificationsInfo notificationsInfo = (JobNotificationsInfo)info.getNotifications().get(i);
                JobNoticeMasterUtil.getLocalHome().create(info.getId(), new Integer(notificationsInfo.getType()), new Integer(notificationsInfo.getPriority()), notificationsInfo.getNotify_id());
            }
        }
        if (info.getEndStatus() instanceof ArrayList) {
            for (i = 0; i < info.getEndStatus().size(); ++i) {
                if (!(info.getEndStatus().get(i) instanceof JobEndStatusInfo)) continue;
                JobEndStatusInfo endInfo = (JobEndStatusInfo)info.getEndStatus().get(i);
                JobEndMasterUtil.getLocalHome().create(info.getId(), new Integer(endInfo.getType()), new Integer(endInfo.getValue()), new Integer(endInfo.getStartRangeValue()), new Integer(endInfo.getEndRangeValue()));
            }
        }
    }
}

