/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.jobmanagement.dao.JobSessionNodeDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobSessionNodeDAOImpl
implements JobSessionNodeDAO {
    protected static Log m_log = LogFactory.getLog(JobSessionNodeDAOImpl.class);

    public void init() {
    }

    public void load(JobSessionNodePK pk, JobSessionNodeBean ejb) throws EJBException {
        block21: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_session_node WHERE session_id = ? AND job_id = ? AND facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                stmt.setString(3, pk.getFacility_id());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setAgent_check(res.getInt("agent_check"));
                    if (res.getTimestamp("check_date") != null) {
                        ejb.setCheck_date(new Date(res.getTimestamp("check_date").getTime()));
                    } else {
                        ejb.setCheck_date(null);
                    }
                    if (res.getTimestamp("end_date") != null) {
                        ejb.setEnd_date(new Date(res.getTimestamp("end_date").getTime()));
                    } else {
                        ejb.setEnd_date(null);
                    }
                    if (res.getString("end_value") != null) {
                        ejb.setEnd_value(res.getInt("end_value"));
                    } else {
                        ejb.setEnd_value(null);
                    }
                    ejb.setFacility_id(res.getString("facility_id"));
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setMessage(res.getString("message"));
                    ejb.setNode_name(res.getString("node_name"));
                    ejb.setResult(res.getString("result"));
                    ejb.setRetry_count(res.getInt("retry_count"));
                    ejb.setSession_id(res.getString("session_id"));
                    if (res.getTimestamp("start_date") != null) {
                        ejb.setStart_date(new Date(res.getTimestamp("start_date").getTime()));
                    } else {
                        ejb.setStart_date(null);
                    }
                    ejb.setStatus(res.getInt("status"));
                    break block21;
                }
                String msg = "JobSessionNode data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobSessionNodeBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_session_node SET ");
            sql.append("node_name = ?, ");
            sql.append("status = ?, ");
            sql.append("start_date = ?, ");
            sql.append("end_date = ?, ");
            sql.append("end_value = ?, ");
            sql.append("message = ?, ");
            sql.append("agent_check = ?, ");
            sql.append("check_date = ?, ");
            sql.append("retry_count = ?, ");
            sql.append("result = ? ");
            sql.append("WHERE session_id = ? ");
            sql.append("AND job_id = ? ");
            sql.append("AND facility_id = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getNode_name());
            stmt.setInt(2, ejb.getStatus());
            if (ejb.getStart_date() instanceof Date) {
                stmt.setTimestamp(3, new Timestamp(ejb.getStart_date().getTime()));
            } else {
                stmt.setTimestamp(3, null);
            }
            if (ejb.getEnd_date() instanceof Date) {
                stmt.setTimestamp(4, new Timestamp(ejb.getEnd_date().getTime()));
            } else {
                stmt.setTimestamp(4, null);
            }
            if (ejb.getEnd_value() instanceof Integer) {
                stmt.setInt(5, ejb.getEnd_value());
            } else {
                stmt.setNull(5, 4);
            }
            stmt.setString(6, ejb.getMessage());
            if (ejb.getAgent_check() instanceof Integer) {
                stmt.setInt(7, ejb.getAgent_check());
            } else {
                stmt.setNull(7, 4);
            }
            if (ejb.getCheck_date() instanceof Date) {
                stmt.setTimestamp(8, new Timestamp(ejb.getCheck_date().getTime()));
            } else {
                stmt.setTimestamp(8, null);
            }
            if (ejb.getRetry_count() instanceof Integer) {
                stmt.setInt(9, ejb.getRetry_count());
            } else {
                stmt.setNull(9, 4);
            }
            stmt.setString(10, ejb.getResult());
            stmt.setString(11, ejb.getSession_id());
            stmt.setString(12, ejb.getJob_id());
            stmt.setString(13, ejb.getFacility_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id()));
    }

    public void remove(JobSessionNodePK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_session_node WHERE session_id = ? AND job_id = ? AND facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getFacility_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobSessionNodePK create(JobSessionNodeBean ejb) throws CreateException, EJBException {
        JobSessionNodePK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_session_node (");
            sql.append("session_id, ");
            sql.append("job_id, ");
            sql.append("facility_id, ");
            sql.append("node_name, ");
            sql.append("status, ");
            sql.append("start_date, ");
            sql.append("end_date, ");
            sql.append("end_value, ");
            sql.append("message, ");
            sql.append("agent_check, ");
            sql.append("check_date, ");
            sql.append("retry_count, ");
            sql.append("result) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getSession_id());
            stmt.setString(2, ejb.getJob_id());
            stmt.setString(3, ejb.getFacility_id());
            stmt.setString(4, ejb.getNode_name());
            stmt.setInt(5, ejb.getStatus());
            if (ejb.getStart_date() instanceof Date) {
                stmt.setTimestamp(6, new Timestamp(ejb.getStart_date().getTime()));
            } else {
                stmt.setTimestamp(6, null);
            }
            if (ejb.getEnd_date() instanceof Date) {
                stmt.setTimestamp(7, new Timestamp(ejb.getEnd_date().getTime()));
            } else {
                stmt.setTimestamp(7, null);
            }
            if (ejb.getEnd_value() instanceof Integer) {
                stmt.setInt(8, ejb.getEnd_value());
            } else {
                stmt.setNull(8, 4);
            }
            stmt.setString(9, ejb.getMessage());
            if (ejb.getAgent_check() instanceof Integer) {
                stmt.setInt(10, ejb.getAgent_check());
            } else {
                stmt.setNull(10, 4);
            }
            if (ejb.getCheck_date() instanceof Date) {
                stmt.setTimestamp(11, new Timestamp(ejb.getCheck_date().getTime()));
            } else {
                stmt.setTimestamp(11, null);
            }
            if (ejb.getRetry_count() instanceof Integer) {
                stmt.setInt(12, ejb.getRetry_count());
            } else {
                stmt.setNull(12, 4);
            }
            stmt.setString(13, ejb.getResult());
            int row = stmt.executeUpdate();
            pk = new JobSessionNodePK(ejb.getSession_id(), ejb.getJob_id(), ejb.getFacility_id());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getFacility_id()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobSessionNodePK> ret = new ArrayList<JobSessionNodePK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_session_node";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobSessionNodePK pk = new JobSessionNodePK(res.getString("session_id"), res.getString("job_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobSessionNodePK findByPrimaryKey(JobSessionNodePK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_session_node WHERE session_id = ? AND job_id = ? AND facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getFacility_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobSessionNodePK jobSessionNodePK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobSessionNodePK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findBySessionIdAndJobId(String sessionId, String jobId) throws FinderException {
        m_log.debug((Object)("findBySessionIdAndJobId() start : " + sessionId + ", " + jobId));
        ArrayList<JobSessionNodePK> ret = new ArrayList<JobSessionNodePK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_session_node WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, sessionId);
            stmt.setString(2, jobId);
            res = stmt.executeQuery();
            while (res.next()) {
                JobSessionNodePK pk = new JobSessionNodePK(res.getString("session_id"), res.getString("job_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findBySessionIdAndJobId() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findBySessionIdAndJobId() end : " + sessionId + ", " + jobId));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        block40: {
            m_log.debug((Object)("makeSession() start : " + sessionId));
            Connection conn = null;
            Connection conn_mst = null;
            Statement stmt = null;
            Statement stmt_mst = null;
            String jobId = null;
            RepositoryControllerLocal repository = null;
            try {
                try {
                    conn = ConnectionManager.getConnectionManager().getConnection();
                    conn_mst = ConnectionManager.getConnectionManager().getConnection();
                    repository = RepositoryControllerUtil.getLocalHome().create();
                    StringBuilder sql = new StringBuilder();
                    sql.append("INSERT INTO cc_job_session_node (");
                    sql.append("session_id, ");
                    sql.append("job_id, ");
                    sql.append("facility_id, ");
                    sql.append("node_name, ");
                    sql.append("status, ");
                    sql.append("start_date, ");
                    sql.append("end_date, ");
                    sql.append("end_value, ");
                    sql.append("message, ");
                    sql.append("agent_check, ");
                    sql.append("check_date, ");
                    sql.append("retry_count, ");
                    sql.append("result) ");
                    sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    stmt = conn.prepareStatement(sql.toString());
                    stmt.setString(1, sessionId);
                    stmt.setInt(5, 0);
                    stmt.setTimestamp(6, null);
                    stmt.setTimestamp(7, null);
                    stmt.setNull(8, 4);
                    stmt.setString(9, null);
                    stmt.setNull(10, 4);
                    stmt.setTimestamp(11, null);
                    stmt.setInt(12, 0);
                    stmt.setString(13, null);
                    StringBuilder sql_mst = new StringBuilder();
                    sql_mst.append("SELECT ");
                    sql_mst.append("cc_job_mst.job_type, ");
                    sql_mst.append("cc_job_command_mst.facility_id ");
                    sql_mst.append("FROM cc_job_mst left join cc_job_command_mst ");
                    sql_mst.append("on  (cc_job_mst.job_id=cc_job_command_mst.job_id) ");
                    sql_mst.append("WHERE  cc_job_mst.job_id= ? ");
                    stmt_mst = conn_mst.prepareStatement(sql_mst.toString());
                    ResultSet res_mst = null;
                    Iterator it = jobs.iterator();
                    Hashtable ht = null;
                    while (it.hasNext()) {
                        ht = (Hashtable)it.next();
                        jobId = (String)ht.get("jobId");
                        stmt_mst.setString(1, jobId);
                        res_mst = stmt_mst.executeQuery();
                        if (res_mst.next()) {
                            stmt.setString(2, jobId);
                            if (res_mst.getInt("job_type") == 2) {
                                ArrayList nodeIdList = null;
                                if (repository.isNode(res_mst.getString("facility_id"))) {
                                    nodeIdList = new ArrayList();
                                    nodeIdList.add(res_mst.getString("facility_id"));
                                } else {
                                    nodeIdList = repository.getNodeFacilityIdList(res_mst.getString("facility_id"), 0);
                                }
                                if (nodeIdList instanceof ArrayList) {
                                    for (int i = 0; i < nodeIdList.size(); ++i) {
                                        ArrayList<String> Attribute = new ArrayList<String>();
                                        Attribute.add("cn");
                                        HashMap map = repository.getNodeDetail((String)nodeIdList.get(i), Attribute);
                                        stmt.setString(3, (String)nodeIdList.get(i));
                                        stmt.setString(4, (String)map.get("cn"));
                                        int row = stmt.executeUpdate();
                                        if (row == 1) continue;
                                        String msg = "result row is not 1";
                                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                                        throw new EJBException(msg);
                                    }
                                }
                            }
                        }
                        res_mst.close();
                    }
                    Object var21_24 = null;
                }
                catch (SQLException e) {
                    if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                    m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                    throw new DuplicateKeyException(e.getMessage());
                }
                catch (CreateException e) {
                    e.printStackTrace();
                    Object var21_25 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        if (stmt_mst != null) {
                            stmt_mst.close();
                        }
                        if (conn_mst != null) {
                            conn_mst.close();
                        }
                    }
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    Object var21_26 = null;
                    try {}
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    if (stmt_mst != null) {
                        stmt_mst.close();
                    }
                    if (conn_mst != null) {
                        conn_mst.close();
                    }
                    break block40;
                }
                catch (FinderException e) {
                    e.printStackTrace();
                    Object var21_27 = null;
                    try {}
                    catch (SQLException e1) {
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(e1.getMessage());
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    if (stmt_mst != null) {
                        stmt_mst.close();
                    }
                    if (conn_mst != null) {
                        conn_mst.close();
                    }
                    break block40;
                }
            }
            catch (Throwable throwable) {
                Object var21_28 = null;
                try {}
                catch (SQLException e1) {
                    m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                    throw new EJBException(e1.getMessage());
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (stmt_mst != null) {
                    stmt_mst.close();
                }
                if (conn_mst == null) throw throwable;
                conn_mst.close();
                throw throwable;
            }
            try {}
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
            if (stmt_mst != null) {
                stmt_mst.close();
            }
            if (conn_mst != null) {
                conn_mst.close();
            }
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

