/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobRelationInfoDAOImpl
implements JobRelationInfoDAO {
    protected static Log m_log = LogFactory.getLog(JobRelationInfoDAOImpl.class);

    public void init() {
    }

    public void load(JobRelationInfoPK pk, JobRelationInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_relation_info WHERE session_id = ? AND job_id = ? AND parent_job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                stmt.setString(3, pk.getParent_job_id());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setParent_job_id(res.getString("parent_job_id"));
                    ejb.setSession_id(res.getString("session_id"));
                    break block13;
                }
                String msg = "JobRelationInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobRelationInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id()));
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id()));
    }

    public void remove(JobRelationInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_relation_info WHERE session_id = ? AND job_id = ? AND parent_job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getParent_job_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobRelationInfoPK create(JobRelationInfoBean ejb) throws CreateException, EJBException {
        JobRelationInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_relation_info (");
            sql.append("session_id, ");
            sql.append("job_id, ");
            sql.append("parent_job_id) ");
            sql.append("VALUES (?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getSession_id());
            stmt.setString(2, ejb.getJob_id());
            stmt.setString(3, ejb.getParent_job_id());
            int row = stmt.executeUpdate();
            pk = new JobRelationInfoPK(ejb.getSession_id(), ejb.getJob_id(), ejb.getParent_job_id());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_relation_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobRelationInfoPK pk = new JobRelationInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("parent_job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobRelationInfoPK findByPrimaryKey(JobRelationInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_relation_info WHERE session_id = ? AND job_id = ? AND parent_job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getParent_job_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobRelationInfoPK jobRelationInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobRelationInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findByParentJobId(String session_id, String parent_job_id) throws FinderException {
        m_log.debug((Object)("findByParentJobId() start : " + session_id + ", " + parent_job_id));
        ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_relation_info WHERE session_id = ? AND parent_job_id = ? ORDER BY job_id ASC";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, session_id);
            stmt.setString(2, parent_job_id);
            res = stmt.executeQuery();
            while (res.next()) {
                JobRelationInfoPK pk = new JobRelationInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("parent_job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findByParentJobId() error : " + session_id + ", " + parent_job_id + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByParentJobId() error : " + session_id + ", " + parent_job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findByParentJobId() end : " + session_id + ", " + parent_job_id));
        return ret;
    }

    public Collection findByStartStatus(String session_id, String parent_job_id) throws FinderException {
        m_log.debug((Object)("findByStartStatus() start : " + session_id + ", " + parent_job_id));
        ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM cc_job_relation_info as a, cc_job_session_job as b ");
            sql.append("WHERE a.session_id = b.session_id AND ");
            sql.append("a.job_id = b.job_id AND ");
            sql.append("a.session_id = ? AND ");
            sql.append("a.parent_job_id = ? AND ");
            sql.append("(b.status = 0 OR b.status = 2 OR b.status = 100)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, session_id);
            stmt.setString(2, parent_job_id);
            res = stmt.executeQuery();
            while (res.next()) {
                JobRelationInfoPK pk = new JobRelationInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("parent_job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findByStartStatus() error : " + session_id + ", " + parent_job_id + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByStartStatus() error : " + session_id + ", " + parent_job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findByStartStatus() end : " + session_id + ", " + parent_job_id));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByStatus(String session_id, String parent_job_id, Integer status) throws FinderException {
        m_log.debug((Object)("findByStatus() start : " + session_id + ", " + parent_job_id + ", " + status));
        ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM cc_job_relation_info as a, cc_job_session_job as b ");
                sql.append("WHERE a.session_id = b.session_id AND ");
                sql.append("a.job_id = b.job_id AND ");
                sql.append("a.session_id = ? AND ");
                sql.append("a.parent_job_id = ? AND ");
                sql.append("b.status = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, session_id);
                stmt.setString(2, parent_job_id);
                stmt.setInt(3, status);
                res = stmt.executeQuery();
                while (res.next()) {
                    JobRelationInfoPK pk = new JobRelationInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("parent_job_id"));
                    ret.add(pk);
                }
                Object var11_11 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("findByStatus() error : " + session_id + ", " + parent_job_id + ", " + status + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByStatus() error : " + session_id + ", " + parent_job_id + ", " + status + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("findByStatus() error : " + session_id + ", " + parent_job_id + ", " + status + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findByStatus() end : " + session_id + ", " + parent_job_id + ", " + status));
        return ret;
    }

    public Collection findByStartDate(String session_id, String parent_job_id) throws FinderException {
        m_log.debug((Object)("findByStartDate() start : " + session_id + ", " + parent_job_id));
        ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM cc_job_relation_info as a, cc_job_session_job as b ");
            sql.append("WHERE a.session_id = b.session_id AND ");
            sql.append("a.job_id = b.job_id AND ");
            sql.append("a.session_id = ? AND ");
            sql.append("a.parent_job_id = ? ");
            sql.append("ORDER BY b.start_date");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, session_id);
            stmt.setString(2, parent_job_id);
            res = stmt.executeQuery();
            while (res.next()) {
                JobRelationInfoPK pk = new JobRelationInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("parent_job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findByStartDate() error : " + session_id + ", " + parent_job_id + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByStartDate() error : " + session_id + ", " + parent_job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findByStartDate() end : " + session_id + ", " + parent_job_id));
        return ret;
    }

    public JobRelationInfoPK findBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            JobRelationInfoPK pk;
            m_log.debug((Object)("findBySessionIdAndJobId() start : " + session_id + ", " + job_id));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_relation_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, session_id);
            stmt.setString(2, job_id);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobRelationInfoPK jobRelationInfoPK = pk = new JobRelationInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("parent_job_id"));
            Object var10_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findBySessionIdAndJobId() end : " + session_id + ", " + job_id));
            return jobRelationInfoPK;
        }
        try {
            try {
                String msg = "id " + session_id + ", " + job_id + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findBySessionIdAndJobId() end : " + session_id + ", " + job_id));
            throw throwable;
        }
    }

    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        m_log.debug((Object)("makeSession() start : " + sessionId));
        Connection conn = null;
        Statement stmt = null;
        String jobId = null;
        Hashtable ht2 = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_relation_info (");
            sql.append("session_id, ");
            sql.append("job_id, ");
            sql.append("parent_job_id) ");
            sql.append("VALUES (?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, sessionId);
            for (Hashtable ht2 : jobs) {
                jobId = (String)ht2.get("jobId");
                stmt.setString(2, jobId);
                stmt.setString(3, (String)ht2.get("parentJobId"));
                int row = stmt.executeUpdate();
                if (row == 1) continue;
                String msg = "result row is not 1";
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + (String)ht2.get("jobId") + ", " + (String)ht2.get("parentJobId") + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + (String)ht2.get("jobId") + ", " + (String)ht2.get("parentJobId") + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + (String)ht2.get("jobId") + ", " + (String)ht2.get("parentJobId") + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"makeSession() end : ");
    }
}

