/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobCommandInfoDAOImpl
implements JobCommandInfoDAO {
    protected static Log m_log = LogFactory.getLog(JobCommandInfoDAOImpl.class);

    public void init() {
    }

    public void load(JobCommandInfoPK pk, JobCommandInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_command_info WHERE session_id = ? AND job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setArgument(res.getString("argument"));
                    ejb.setArgument_job_id(res.getString("argument_job_id"));
                    ejb.setEffective_user(res.getString("effective_user"));
                    ejb.setError_end_flg(res.getInt("error_end_flg"));
                    ejb.setError_end_value(res.getInt("error_end_value"));
                    ejb.setFacility_id(res.getString("facility_id"));
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setProcess_mode(res.getInt("process_mode"));
                    ejb.setSession_id(res.getString("session_id"));
                    ejb.setStart_command(res.getString("start_command"));
                    ejb.setStop_command(res.getString("stop_command"));
                    break block13;
                }
                String msg = "JobCommandInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobCommandInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_command_info SET ");
            sql.append("facility_id = ?, ");
            sql.append("process_mode = ?, ");
            sql.append("start_command = ?, ");
            sql.append("stop_command = ?, ");
            sql.append("effective_user = ?, ");
            sql.append("error_end_flg = ?, ");
            sql.append("error_end_value = ?, ");
            sql.append("argument_job_id = ?, ");
            sql.append("argument = ? ");
            sql.append("WHERE session_id = ? AND ");
            sql.append("job_id = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getFacility_id());
            stmt.setInt(2, ejb.getProcess_mode());
            stmt.setString(3, ejb.getStart_command());
            stmt.setString(4, ejb.getStop_command());
            stmt.setString(5, ejb.getEffective_user());
            stmt.setInt(6, ejb.getError_end_flg());
            stmt.setInt(7, ejb.getError_end_value());
            stmt.setString(8, ejb.getArgument_job_id());
            stmt.setString(9, ejb.getArgument());
            stmt.setString(10, ejb.getSession_id());
            stmt.setString(11, ejb.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
    }

    public void remove(JobCommandInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_command_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobCommandInfoPK create(JobCommandInfoBean ejb) throws CreateException, EJBException {
        JobCommandInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_command_info (");
            sql.append("session_id, ");
            sql.append("job_id, ");
            sql.append("facility_id, ");
            sql.append("process_mode, ");
            sql.append("start_command, ");
            sql.append("stop_command, ");
            sql.append("effective_user, ");
            sql.append("error_end_flg, ");
            sql.append("error_end_value, ");
            sql.append("argument_job_id, ");
            sql.append("argument) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getSession_id());
            stmt.setString(2, ejb.getJob_id());
            stmt.setString(3, ejb.getFacility_id());
            stmt.setInt(4, ejb.getProcess_mode());
            stmt.setString(5, ejb.getStart_command());
            stmt.setString(6, ejb.getStop_command());
            stmt.setString(7, ejb.getEffective_user());
            stmt.setInt(8, ejb.getError_end_flg());
            stmt.setInt(9, ejb.getError_end_value());
            stmt.setString(10, ejb.getArgument_job_id());
            stmt.setString(11, ejb.getArgument());
            int row = stmt.executeUpdate();
            pk = new JobCommandInfoPK(ejb.getSession_id(), ejb.getJob_id());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobCommandInfoPK> ret = new ArrayList<JobCommandInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_command_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobCommandInfoPK pk = new JobCommandInfoPK(res.getString("session_id"), res.getString("job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobCommandInfoPK findByPrimaryKey(JobCommandInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_command_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobCommandInfoPK jobCommandInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobCommandInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        m_log.debug((Object)("makeSession() start : " + sessionId));
        Connection conn = null;
        Connection conn_mst = null;
        Statement stmt = null;
        Statement stmt_mst = null;
        String jobId = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                conn_mst = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_command_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("facility_id, ");
                sql.append("process_mode, ");
                sql.append("start_command, ");
                sql.append("stop_command, ");
                sql.append("effective_user, ");
                sql.append("error_end_flg, ");
                sql.append("error_end_value, ");
                sql.append("argument_job_id, ");
                sql.append("argument) ");
                sql.append("SELECT ");
                sql.append("?, ");
                sql.append("job_id, ");
                sql.append("facility_id, ");
                sql.append("process_mode, ");
                sql.append("start_command, ");
                sql.append("stop_command, ");
                sql.append("effective_user, ");
                sql.append("error_end_flg, ");
                sql.append("error_end_value, ");
                sql.append("argument_job_id, ");
                sql.append("argument ");
                sql.append("FROM cc_job_command_mst WHERE job_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, sessionId);
                String sql_mst = "SELECT job_type FROM cc_job_mst WHERE job_id = ?";
                stmt_mst = conn_mst.prepareStatement(sql_mst);
                ResultSet res_mst = null;
                Iterator it = jobs.iterator();
                Hashtable ht = null;
                while (it.hasNext()) {
                    ht = (Hashtable)it.next();
                    jobId = (String)ht.get("jobId");
                    stmt_mst.setString(1, jobId);
                    res_mst = stmt_mst.executeQuery();
                    if (res_mst.next() && res_mst.getInt("job_type") == 2) {
                        stmt.setString(2, jobId);
                        int row = stmt.executeUpdate();
                        if (row != 1) {
                            String msg = "result row is not 1";
                            m_log.error((Object)("makeSession() error : " + sessionId + ", " + res_mst.getString("job_id") + " SQLException"));
                            throw new EJBException(msg);
                        }
                    }
                    res_mst.close();
                }
                Object var16_16 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (stmt_mst != null) {
                    stmt_mst.close();
                }
                if (conn_mst == null) throw throwable;
                conn_mst.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        if (stmt_mst != null) {
            stmt_mst.close();
        }
        if (conn_mst != null) {
            conn_mst.close();
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

