/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteConstants;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

final class MAC {
    static final MAC NULL = new MAC(CipherSuiteConstants.M_NULL, null, null);
    private CipherSuite.MacAlg macAlg;
    private boolean hmac;
    private MessageDigest digest;
    private int macSize;
    private byte[] writeSecret;
    private byte[] pad1;
    private byte[] pad2;
    private ProtocolVersion protocolVersion;
    private long sequenceNumber;
    private static final byte pad1Byte = 54;
    private static final byte pad2Byte = 92;
    static final byte[] MD5_pad1 = MAC.genPad((byte)54, 48);
    static final byte[] MD5_pad2 = MAC.genPad((byte)92, 48);
    static final byte[] SHA_pad1 = MAC.genPad((byte)54, 40);
    static final byte[] SHA_pad2 = MAC.genPad((byte)92, 40);
    static final byte[] HMAC_ipad = MAC.genPad((byte)54, 64);
    static final byte[] HMAC_opad = MAC.genPad((byte)92, 64);
    private static final byte[] nullMAC = new byte[0];

    MAC(CipherSuite.MacAlg macAlg, ProtocolVersion protocolVersion, byte[] byArray) {
        this.macAlg = macAlg;
        this.protocolVersion = protocolVersion;
        this.macSize = macAlg.size;
        if (macAlg == CipherSuiteConstants.M_NULL) {
            this.digest = null;
        } else if (macAlg == CipherSuiteConstants.M_MD5) {
            this.digest = JsseJce.getMD5();
            if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
                this.hmac = true;
                this.pad1 = (byte[])HMAC_ipad.clone();
                this.pad2 = (byte[])HMAC_opad.clone();
            } else {
                this.hmac = false;
                this.pad1 = MD5_pad1;
                this.pad2 = MD5_pad2;
            }
        } else if (macAlg == CipherSuiteConstants.M_SHA) {
            this.digest = JsseJce.getSHA();
            if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
                this.hmac = true;
                this.pad1 = (byte[])HMAC_ipad.clone();
                this.pad2 = (byte[])HMAC_opad.clone();
            } else {
                this.hmac = false;
                this.pad1 = SHA_pad1;
                this.pad2 = SHA_pad2;
            }
        } else {
            throw new RuntimeException("Unknown MAC: " + macAlg);
        }
        if (this.hmac) {
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                this.pad1[n] = (byte)(this.pad1[n] ^ byArray[i]);
                int n2 = i;
                this.pad2[n2] = (byte)(this.pad2[n2] ^ byArray[i]);
            }
        }
        this.writeSecret = byArray;
        this.sequenceNumber = 0L;
    }

    int MAClen() {
        return this.macSize;
    }

    final byte[] compute(byte by, byte[] byArray, int n, int n2) {
        return this.compute(by, null, byArray, n, n2);
    }

    final byte[] compute(byte by, ByteBuffer byteBuffer) {
        return this.compute(by, byteBuffer, null, 0, byteBuffer.remaining());
    }

    private byte[] compute(byte by, ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        if (this.macSize == 0) {
            return nullMAC;
        }
        if (byteBuffer != null && byArray != null || byteBuffer == null && byArray == null) {
            throw new RuntimeException("MAC compute:  buffers both null or non-null");
        }
        if (this.hmac) {
            return this.computeHMAC(by, byteBuffer, byArray, n, n2);
        }
        return this.computeMAC(by, byteBuffer, byArray, n, n2);
    }

    private final byte[] computeMAC(byte by, ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        this.digest.update(this.writeSecret);
        this.digest.update(this.pad1);
        this.digest.update((byte)(this.sequenceNumber >> 56));
        this.digest.update((byte)(this.sequenceNumber >> 48));
        this.digest.update((byte)(this.sequenceNumber >> 40));
        this.digest.update((byte)(this.sequenceNumber >> 32));
        this.digest.update((byte)(this.sequenceNumber >> 24));
        this.digest.update((byte)(this.sequenceNumber >> 16));
        this.digest.update((byte)(this.sequenceNumber >> 8));
        this.digest.update((byte)(this.sequenceNumber >> 0));
        ++this.sequenceNumber;
        this.digest.update(by);
        this.digest.update((byte)(n2 >> 8));
        this.digest.update((byte)(n2 >> 0));
        if (byteBuffer != null) {
            this.digest.update(byteBuffer);
        } else {
            this.digest.update(byArray, n, n2);
        }
        byte[] byArray2 = this.digest.digest();
        this.digest.update(this.writeSecret);
        this.digest.update(this.pad2);
        this.digest.update(byArray2);
        return this.digest.digest();
    }

    private final byte[] computeHMAC(byte by, ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        this.digest.update(this.pad1);
        this.digest.update((byte)(this.sequenceNumber >> 56));
        this.digest.update((byte)(this.sequenceNumber >> 48));
        this.digest.update((byte)(this.sequenceNumber >> 40));
        this.digest.update((byte)(this.sequenceNumber >> 32));
        this.digest.update((byte)(this.sequenceNumber >> 24));
        this.digest.update((byte)(this.sequenceNumber >> 16));
        this.digest.update((byte)(this.sequenceNumber >> 8));
        this.digest.update((byte)(this.sequenceNumber >> 0));
        ++this.sequenceNumber;
        this.digest.update(by);
        this.digest.update(this.protocolVersion.major);
        this.digest.update(this.protocolVersion.minor);
        this.digest.update((byte)(n2 >> 8));
        this.digest.update((byte)(n2 >> 0));
        if (byteBuffer != null) {
            this.digest.update(byteBuffer);
        } else {
            this.digest.update(byArray, n, n2);
        }
        byte[] byArray2 = this.digest.digest();
        this.digest.update(this.pad2);
        this.digest.update(byArray2);
        return this.digest.digest();
    }

    private static byte[] genPad(byte by, int n) {
        byte[] byArray = new byte[n];
        while (n-- > 0) {
            byArray[n] = by;
        }
        return byArray;
    }
}

