/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateConfigException;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;

public class BadCertificateDialog {
    private static boolean _isHttps = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(CodeSource codeSource, String string, final Exception exception) {
        final Certificate[] certificateArray = codeSource.getCertificates();
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = DeployUIManager.setLookAndFeel();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            MessageFormat messageFormat = null;
            messageFormat = BadCertificateDialog.getHttpsDialog() ? new MessageFormat(BadCertificateDialog.getMessage("security.badcert.https.text")) : (exception instanceof CertificateConfigException ? new MessageFormat(BadCertificateDialog.getMessage("security.badcert.config.text")) : new MessageFormat(BadCertificateDialog.getMessage("security.badcert.text")));
            Object[] objectArray = new Object[]{BadCertificateDialog.getMessage(string)};
            arrayList.add(messageFormat.format(objectArray));
            JButton jButton = new JButton(BadCertificateDialog.getMessage("security.badcert.viewException"));
            jButton.setMnemonic(BadCertificateDialog.getAcceleratorKey("security.badcert.viewException"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogFactory.showExceptionDialog(exception);
                }
            });
            JButton jButton2 = new JButton(BadCertificateDialog.getMessage("security.badcert.viewCert"));
            jButton2.setMnemonic(BadCertificateDialog.getAcceleratorKey("security.badcert.viewCert"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new CertificateDialog(certificateArray, 0, certificateArray.length).DoModal();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.setLayout(new FlowLayout(1));
            arrayList.add(jPanel);
            if (!Trace.isAutomationEnabled()) {
                DialogFactory.showInformationDialog(arrayList.toArray(), BadCertificateDialog.getMessage("security.badcert.caption"));
            } else {
                Trace.msgSecurityPrintln("trustdecider.automation.badcert");
            }
        }
        finally {
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
        }
    }

    private static String getMessage(String string) {
        String string2 = ResourceManager.getMessage(string);
        return string2;
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }

    private static boolean getHttpsDialog() {
        return _isHttps;
    }

    public static void setHttpsDialog(boolean bl) {
        _isHttps = bl;
    }
}

