/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http.ssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.CustomSSLSocketFactory;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.security.SSLSocketBuilderMBean;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
import org.jboss.remoting.transport.http.HTTPClientInvoker;
import org.jboss.remoting.transport.http.ssl.HTTPSSocketFactory;

public class HTTPSClientInvoker
extends HTTPClientInvoker {
    public static final String IGNORE_HTTPS_HOST = "org.jboss.security.ignoreHttpsHost";
    public static final String HOSTNAME_VERIFIER = "hostnameVerifier";

    public HTTPSClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public HTTPSClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected String validateURL(String url) {
        String validatedUrl = url;
        if (validatedUrl.startsWith("servlet")) {
            validatedUrl = "http" + validatedUrl.substring("servlet".length());
        } else if (validatedUrl.startsWith("sslservlet")) {
            validatedUrl = "https" + validatedUrl.substring("sslservlet".length());
        }
        return validatedUrl;
    }

    protected HttpURLConnection createURLConnection(String url, Map metadata) throws IOException {
        HttpURLConnection conn = super.createURLConnection(url, metadata);
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sconn = (HttpsURLConnection)conn;
            SocketFactory socketFactory = this.getSocketFactory();
            if (socketFactory != null && socketFactory instanceof SSLSocketFactory) {
                SSLSocketFactory sslSocketFactory = this.getHandshakeCompatibleFactory((SSLSocketFactory)socketFactory, metadata);
                sconn.setSSLSocketFactory(sslSocketFactory);
            }
            this.setHostnameVerifier(sconn, metadata);
        }
        return conn;
    }

    private SSLSocketFactory getHandshakeCompatibleFactory(SSLSocketFactory socketFactory, Map metadata) {
        SSLSocketFactory sslSocketFactory = socketFactory;
        Object obj = this.configuration.get("handshakeCompletedListener");
        if (obj != null && obj instanceof HandshakeCompletedListener) {
            HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
            sslSocketFactory = new HTTPSSocketFactory(socketFactory, listener);
        }
        return sslSocketFactory;
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (HTTPSClientInvoker.isCompleteSocketFactory(sf)) {
            return sf;
        }
        SocketFactory wrapper = sf;
        try {
            SSLSocketBuilder server = new SSLSocketBuilder(configuration);
            server.setUseSSLSocketFactory(false);
            sf = server.createSSLSocketFactory();
        }
        catch (Exception e) {
            log.error("Error creating SSL Socket Factory for client invoker.", e);
        }
        if (wrapper != null) {
            ((SocketFactoryWrapper)((Object)wrapper)).setSocketFactory(sf);
            return wrapper;
        }
        return sf;
    }

    protected void setHostnameVerifier(HttpsURLConnection conn, Map metadata) {
        CustomSSLSocketFactory sf;
        SSLSocketBuilderMBean builder;
        HostnameVerifier hostnameVerifier = null;
        String hostnameVerifierString = (String)metadata.get(HOSTNAME_VERIFIER);
        if (hostnameVerifierString == null || hostnameVerifierString.length() == 0) {
            hostnameVerifierString = (String)this.configuration.get(HOSTNAME_VERIFIER);
        }
        if (hostnameVerifierString != null && hostnameVerifierString.length() > 0) {
            try {
                Class cl = ClassLoaderUtility.loadClass(hostnameVerifierString, this.getClass());
                Constructor constructor = cl.getConstructor(new Class[0]);
                hostnameVerifier = (HostnameVerifier)constructor.newInstance(new Object[0]);
                log.trace("HostnameVerifier (" + hostnameVerifierString + ") loaded");
            }
            catch (Exception e) {
                log.debug("Could not create server socket factory by classname (" + hostnameVerifierString + ").  Error message: " + e.getMessage());
            }
        }
        if (hostnameVerifier == null) {
            boolean ignoreHTTPSHost = Boolean.getBoolean(IGNORE_HTTPS_HOST);
            String ignoreHost = (String)metadata.get(IGNORE_HTTPS_HOST);
            if (ignoreHost != null && ignoreHost.length() > 0) {
                ignoreHTTPSHost = Boolean.valueOf(ignoreHost);
            } else {
                ignoreHost = (String)this.configuration.get(IGNORE_HTTPS_HOST);
                if (ignoreHost != null && ignoreHost.length() > 0) {
                    ignoreHTTPSHost = Boolean.valueOf(ignoreHost);
                }
            }
            if (ignoreHTTPSHost) {
                hostnameVerifier = new AnyhostVerifier();
            }
        }
        if (hostnameVerifier == null && this.getSocketFactory() instanceof CustomSSLSocketFactory && ((builder = (sf = (CustomSSLSocketFactory)this.getSocketFactory()).getSSLSocketBuilder()).isSocketUseClientMode() && !builder.isServerAuthMode() || !builder.isSocketUseClientMode() && builder.isClientAuthModeNone())) {
            hostnameVerifier = new AnyhostVerifier();
        }
        if (hostnameVerifier != null) {
            conn.setHostnameVerifier(hostnameVerifier);
        }
    }

    protected class AnyhostVerifier
    implements HostnameVerifier {
        protected AnyhostVerifier() {
        }

        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

