/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logagent.util;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggerSyslog {
    static Logger log = Logger.getLogger((String)"hinemos.syslog.transfer");
    private int m_priority = 20000;

    public LoggerSyslog(Properties props) {
        String priorityText = props.getProperty("syslog.message.priority");
        Priority priority = Priority.toPriority((String)priorityText, (Priority)Priority.INFO);
        this.m_priority = priority.toInt();
    }

    public void log(Object message) {
        switch (this.m_priority) {
            case 10000: {
                log.debug(message);
                break;
            }
            case 20000: {
                log.info(message);
                break;
            }
            case 30000: {
                log.warn(message);
                break;
            }
            case 40000: {
                log.error(message);
                break;
            }
            case 50000: {
                log.fatal(message);
                break;
            }
        }
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(args[0]));
            LoggerSyslog sys = new LoggerSyslog(props);
            sys.log("test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

