//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		ModelStateUtility.java
//	DATE:		2003.8.29
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;

public class ModelStateUtility {
	private static final ModelState CLEAR_ALL_STATE = new ModelState() {};
	
	public static boolean isAcceptSolverModelState(ModelState inState) {
		return SolverModelState.isAcceptSolverModelState(inState);
	}
	
	public static ModelState createSolverModelState(final boolean inIsAccept) {
		return SolverModelState.createSolverModelState(inIsAccept);
	}
	
	public static ModelState createClearAllState() {
		return CLEAR_ALL_STATE;
	}
	
	public static boolean isClearAllState(ModelState inState) {
		return (CLEAR_ALL_STATE == inState);
	}
}