// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SolverRendererFactory.java
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.view;

import java.awt.Rectangle;
import java.awt.Graphics;

import jp.gr.java_conf.ktz.puzzle.framework.view.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.view.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.view.RenderEvent;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.RendererFactory;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStartState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverProcessingState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverFinishedState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverIllegalState;

public class SolverRendererFactory {
	private static final int INSET = 1;
	
	public static DefaultRenderer create(final int inWidth, final int inHeight) {
		// Ⓡ̕`nho^
		DefaultRenderer aRenderer = RendererFactory.create(inWidth, inHeight);
		
		// 𓚉ߒ̓̃obN̕`nho^
		
		aRenderer.addRenderListener(SolverProcessingState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				drawIsland(inEvent.getGraphics(), new Rectangle(inEvent.getBounds()), AppColors.SOLVE_PROCESSING_COLOR);
			}
		});
		
		aRenderer.addRenderListener(SolverFinishedState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				drawIsland(inEvent.getGraphics(), new Rectangle(inEvent.getBounds()), AppColors.SOLVE_FINISHED_COLOR);
			}
		});
		
		aRenderer.addRenderListener(SolverIllegalState.class, new RenderListener() {
			public void render(RenderEvent inEvent) {
				drawIsland(inEvent.getGraphics(), new Rectangle(inEvent.getBounds()), AppColors.SOLVE_ILLEGAL_COLOR);
			}
		});
		
		return aRenderer;
	}
	
	private static void drawIsland(Graphics inGra, Rectangle inBounds, java.awt.Color inIslandColor) {
		// ̒`
		inBounds.grow(-INSET, -INSET);
		inGra.setColor(inIslandColor);			
		inGra.fillOval(inBounds.x, inBounds.y, inBounds.width, inBounds.height);
	}
}