//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		SolverStateModel.java
//	DATE:		2003.8.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;

import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ModelStateUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.IllegalSolverStateException;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;

public class SolverStateModel extends AbstractDecoratedModel {
	private static class Entry {
		private final int mMaxNum;
		private int mResidue;
		private AbstractSolverState mState;
		
		Entry(final int inMaxNum) {
			mMaxNum = inMaxNum;
			
			reset();
		}
		
		void reset() {
			mResidue = mMaxNum;
			mState = START_STATE;
		}
		
		void nextState() {
			--mResidue;
			
			if (0 > mResidue) {
				mState = ILLEGAL_STATE;
			}
			
			if (0 < mResidue) {
				mState = PROCESSING_STATE;
			}
			else {
				mState = FINISHED_STATE;
			}
		}
		
		int getMaxNum() {
			return mMaxNum;
		}
		
		AbstractSolverState getState() {
			return mState;
		}
	}
	
	private static final AbstractSolverState START_STATE = new SolverStartState();
	private static final AbstractSolverState PROCESSING_STATE = new SolverProcessingState();
	private static final AbstractSolverState FINISHED_STATE = new SolverFinishedState();
	private static final AbstractSolverState ILLEGAL_STATE = new SolverIllegalState();
	
	private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
	
	private Entry[] mSolverEntries = new Entry[0];
	private java.util.Set mLastModified = new java.util.HashSet();
	
	/**
	 *	Ֆʂ̏Ԃ擾ƂModel擾邩ǂ߂tO
	 */
	private boolean mIsAcceptModel;
	
	/**
	 *	RXgN^
	 */
	public SolverStateModel(final boolean inIsAccept, Model inModel) {
		addModel(inModel);
		mIsAcceptModel = inIsAccept;
	}
	
	/**
	 *	RXgN^
	 */
	public SolverStateModel(final boolean inIsAccept) {
		this (inIsAccept, NullModel.getInstance());
	}
	
	/**
	 *	RXgN^
	 */
	public SolverStateModel(Model inModel) {
		this (true, inModel);
	}
	
	/**
	 *	w肳ꂽTCỸ{[h쐬B
	 *	œ̏s
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	protected void createBoardSelf(final int inWidth, final int inHeight) {
		mSolverEntries = new Entry[inWidth * inHeight];
	}
	
	/**
	 *	ݒ肷B
	 *
	 * 	@param	inProblem	̏
	 *	@return	ǂ݂񂾗vfBǂ݂܂ȂƂInteger.MIN_VALUEԂ
	 */
	public int setProblem(ProblemInfo inInfo) {
		// ̏ƃTCYقȂĂ΃{[h쐬ȂB
		if (getWidth() != inInfo.getWidth() || getHeight() != inInfo.getHeight()) {
			createBoard(inInfo.getWidth(), inInfo.getHeight());
		}
		
		// ܂ǂݍނƂoꍇ
		if (inInfo.isMoreRead()) {
			int aReadPos = 0;
			if (inInfo.isDivideRead()) {
				aReadPos = inInfo.getOffset();
			}
			
			for (int i = aReadPos; i < aReadPos + inInfo.getReadOnce(); ++i) {
				try {
					final int aNum = Integer.parseInt((String)inInfo.getRecordAt(i));
					
					mSolverEntries[i] = new Entry(aNum);
				}
				catch (NumberFormatException e) {
					// empty
				}
			}
		}
				
		return getDecorated().setProblem(inInfo);
	}
	
	public void reset() {		
		for (int y = 0; y < getHeight(); ++y) {
			for (int x = 0; x < getWidth(); ++x) {
				resetAtSelf(x, y);
			}
		}
		
		getDecorated().reset();
	}
	
	protected void resetAtSelf(final int inX, final int inY) {
		if (isNumberAt(inX, inY)) {
			try {
				getEntryAt(inX, inY).reset();
			}
			catch (NullPointerException e) {
				System.out.println("illegal reset at " + new Point(inX, inY));
			}
		}
	}
	
	/**
	 *	w肵ModelStateModelŎ󂯓邱Ƃo邩ǂ`FbN
	 *
	 *	@param	inState `FbN
	 *
	 *	@return	󂯓邱ƂôȂAtrueԂ
	 */
	protected boolean acceptableModelState(ModelState inState) {
		return (ModelStateUtility.isAcceptSolverModelState(inState));
	}

	/*
	 *	Model̏ԂύX(optional operation)
	 *
	 *	@param	inState	ύX̏
	 */
	protected void setModelStateSelf(ModelState inState) {
		mIsAcceptModel = ModelStateUtility.isAcceptSolverModelState(inState);
	}

	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *
	 *	@param inX	XW
	 *	@param	inY	YW
	 *	@return 
	 */
	public State getCurStateAt(final int inX, final int inY) {
		State aState = getDecorated().getCurStateAt(inX, inY);
		
		if (mIsAcceptModel) {
			if (mLastModified.contains(new Point(inX, inY))) {
				if (aState instanceof HashikakeNumberState) {
					HashikakeNumberState aNumState = (HashikakeNumberState)aState;
					AbstractSolverState aSolverState = getEntryAt(inX, inY).getState();
					
					aNumState.setColorState(aSolverState);
				}
			}
		}
		
		return aState;
	}
	
	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	protected boolean isAcceptableEvent(StateEventCode inCode) {
		return (
			UtilityFuncs.isDeterminationType(inCode)
			|| (inCode instanceof HashikakeStateEventCode)
		);
	}
	
	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void nextStateAtSelf(final int inX, final int inY, StateEventCode inCode) {
		// creator̍쐬x[hentry쐬
		if (inCode == UtilityFuncs.createSpaceCode()) {
			mSolverEntries[toIndex(inX, inY)] = null;
		}
		else if (inCode instanceof HashikakeStateEventCode) {
			final int aNum = Integer.parseInt(inCode.getValue());
			
			Entry aEntry = null;			
			if (null != (aEntry = getEntryAt(inX, inY)) && aNum == aEntry.getMaxNum()) {
				aEntry.reset();
			}
			else {
				mSolverEntries[toIndex(inX, inY)] = new Entry(aNum);
			}
		}
		else {
			if (isNumberAt(inX, inY)) {
				try {
					getEntryAt(inX, inY).nextState();
				}
				catch (IllegalStateException e) {
					System.out.println(e);
					throw e;
				}
			}
			
			mLastModified.add(new Point(inX, inY));
		}
	}
	
	private Entry getEntryAt(final int inX, final int inY) {
		if (! contains(inX, inY)) {
			throw new IllegalArgumentException("Specified position is out of the board.");
		}
		
		return mSolverEntries[toIndex(inX, inY)];
	}
	
	private int toIndex(final int inX, final int inY) {
		return inY * getWidth() + inX;
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	protected void prevStateAtSelf(final int inX, final int inY, StateEventCode inCode) {
	}

	/** 
	 *	@return ŌɏCʂ̈ʒuԂ
	 */
	protected Point[] lastModifiedSelf() {
		if (isModifiedSelf()) {
			return (Point[])mLastModified.toArray(new Point[mLastModified.size()]);
		}
		else {
			return NO_MODIFIED;
		}
	}
	
	/**
	 *	gModelύXꂽǂ𒲂ׂB
	 *
	 *	@return	ύXĂtrueԂB
	 */
	protected boolean isModifiedSelf() {
		return (! mLastModified.isEmpty());
	}
		
	/**
	 *	Model̕ύXNA
	 */
	protected void flushSelf() {
		if (! mLastModified.isEmpty()) {
			mLastModified.clear();
//			mLastModified = new java.util.HashSet();
		}
	}
}