//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		NullSolverHandler.java
//	DATE:		2003.9.3
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model;

public final class NullSolverHandler implements SolverHandler {
	private static class Holder {
		static SolverHandler sInstance = new NullSolverHandler();
	}
	
	public static SolverHandler getInstance() {
		return Holder.sInstance;
	}
	
	public void reset() {
	}
	
	public void nextSolute() {
		throw new IllegalStateException("Solver Handler is not construct.");
	}
	
	public boolean nextSoluteAll() throws SolveDiscompleteException {
		throw new IllegalStateException("Solver Handler is not construct.");
	}
	
	public boolean isSolute() {
		return false;
	}
	
	public void addSolvePosAt(final int inX, final int inY) {
	}
}