//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashikakeBenchmarkMediator.java
//	DATE:		2003.9.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.awt.Component;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import jp.gr.java_conf.ktz.puzzle.hashikake.io.XMLProblemReader;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SoluteSeparatedException;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkMediator;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableInsertable;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchReport;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkHandler;

import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.HashikakeBenchmarkHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.ResultTableModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableSortHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.HashikakeBenchResultSorter;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.SortedTableModel;

class HashikakeBenchmarkMediator implements BenchmarkMediator {
	private TableInsertable mModel;
	private XMLProblemReader mReader = new XMLProblemReader();
	private boolean mCanceled;
	private Component mRootComponent;
	
	private java.util.Map mColleagueMap = new java.util.HashMap();
	
	private HashikakeBenchmarkMediator(Component inRoot) {
		mRootComponent = inRoot;
		
		if (inRoot instanceof Colleague) {
			addColleague((Colleague)inRoot);
		}
	}
	
	public static BenchmarkMediator getInstance(Component inRoot) {
		return new HashikakeBenchmarkMediator(inRoot);
	}
	
	private void setTableInsertable(TableInsertable inInsertable) {
		mModel = inInsertable;
	}
	
	private void initColleague(final int inFileCount) {
		// ʃe[u̍\z
		{
			TableSortHandler aHandler = new HashikakeBenchResultSorter();
			ResultTableModel aModel = new ResultTableModel(
				new String[] {"problem name", "width X height", "min time", "max time", "average time", "count", "solved", }
			);	
			SortedTableModel aSortedModel = new SortedTableModel(aModel, aModel, aHandler);
			Colleague aColleague
				 = new BenchmarkResultTableProxy(this, aSortedModel, aHandler);	
			addColleague(aColleague);
			setTableInsertable(aSortedModel);	
		}
		
		// vOXj^[̍\z
		{
			ProgressDialogColleague aColleague = new ProgressDialogColleague(this, mRootComponent, inFileCount);
			addColleague(aColleague);
			addColleague(aColleague.getDetailButtonColleague());
			addColleague(aColleague.getCancelButtonColleague());
		}
	}
	
	public void start(java.io.File inDirectory, final int inSolveCount) {	
		java.io.File[] aFiles = resetMeasureFiles(inDirectory);
		
		initColleague(aFiles.length);
		setUpColleagues();
		
		new Thread(new BenchmarkRunner(aFiles, inSolveCount), "Benchmark").start();
	}
	
	public void addColleague(Colleague inColleague) {
		mColleagueMap.put(inColleague.getClass(), inColleague);
	}
	
	public void terminate() {
		measureCanceled();
	}
	
	private void setUpColleagues() {
		for (java.util.Iterator aIt = mColleagueMap.values().iterator(); aIt.hasNext();) {
			((Colleague)aIt.next()).setUp();
		}
	}
	
	private void cleanUpColleagues() {
		class CleanUpHandler implements Runnable {
			public void run() {
				for (java.util.Iterator aIt = mColleagueMap.values().iterator(); aIt.hasNext();) {
					((Colleague)aIt.next()).cleanUp();
				}
			}
		}
		
		Runnable aHandler = new CleanUpHandler();
		
		if (! java.awt.EventQueue.isDispatchThread()) {
			java.awt.EventQueue.invokeLater(aHandler);
		}
		else {
			aHandler.run();
		}
	}
		
	private synchronized void measureCanceled() {
		mCanceled = true;
	}
	
	private synchronized boolean isCanceled() {
		return mCanceled;
	}
	
	public ProblemInfo getProblemAt(final int inIndex) {
		return mReader.getProblemAt(inIndex);
	}
	
	public int getProblemCount() {
		return  mReader.size();
	}
	
	public void colleagueChanged(Colleague inColleague) {
		if (inColleague instanceof DetailButtonColleague) {
			Colleague aColleague = (Colleague)mColleagueMap.get(BenchmarkResultTableProxy.class);
			aColleague.update();
			
			inColleague.update();
		}
		else if (inColleague instanceof CancelButtonColleague) {
			terminate();
		}
		else if (inColleague instanceof BenchmarkResultTableProxy) {
			Colleague aColleague = (Colleague)mColleagueMap.get(DetailButtonColleague.class);
			aColleague.update();
			
//			inColleague.update();
		}
		else {
			inColleague.update();
		}
	}
	
	private java.io.File[] resetMeasureFiles(java.io.File inDirectory) {
		return inDirectory.listFiles(new java.io.FileFilter() {
			java.util.regex.Pattern mExtPattern = java.util.regex.Pattern.compile(".xml$");
			
			public boolean accept(java.io.File inFile) {
				if (! inFile.isFile()) return false;
				
				return (mExtPattern.matcher(inFile.getName()).find());
			}
		});	
	}
	
	private class BenchmarkRunner implements Runnable {
		private final java.io.File[] mFiles;
		private final int mSolveCount;
		
		public BenchmarkRunner(java.io.File[] inFiles, final int inSolveCount) {
			mFiles = inFiles;
			mSolveCount = inSolveCount;
		}
		
		public void run() {
			SetUpRunner aSetUpAction = new SetUpRunner();
			UpdateRunner aUpdateAction = new UpdateRunner();
			
			java.io.File aFile = null;
			try {
				for(int i = 0; i < mFiles.length; ++i) {
					aFile = mFiles[i];
					mReader.load(aFile);
					
					aSetUpAction.setUp();
					runBenchmark(aUpdateAction);
				}
			}
			catch (java.io.FileNotFoundException e) {
				System.out.println(aFile + " is not found.");
			}
			catch (java.io.InterruptedIOException e) {
				// empty
			}
			catch (java.io.IOException e) {
				System.out.println("IOException occured.");
			}		
			
			cleanUpColleagues();		
		}
		
		private void runBenchmark(UpdateRunner inAction) throws java.io.InterruptedIOException {
			BenchReport aReport = null;
			
			for (int i = 0, aCount = getProblemCount(); i < aCount; ++i) {
				if (isCanceled()) throw new java.io.InterruptedIOException();
				
				ProblemInfo aProblem = null;
				try {
					aProblem = getProblemAt(i);
					BenchmarkHandler aHandler = new HashikakeBenchmarkHandler();
					aHandler.reset(aProblem);
					aReport = aHandler.solve(mSolveCount);
				}
				catch (SoluteSeparatedException e) {
					aReport = BenchReport.illegalBenchReport(aProblem, 0);
				}
				
				inAction.update(aReport);
			}
		}

		private class UpdateRunner implements Runnable {
			private BenchReport mReport;
			
			public void run() {
				mModel.addRow(mReport.flatten());
				colleagueChanged((Colleague)mColleagueMap.get(ProgressDialogColleague.class));
			}
			
			public void update(BenchReport inReport) {
				mReport = inReport;
				
				try {
					java.awt.EventQueue.invokeAndWait(this);
				}
				catch (InterruptedException e) {
				}
				catch (java.lang.reflect.InvocationTargetException e) {
				}
			}
		};
		
		private class SetUpRunner implements Runnable {
			public void run() {
				Colleague aColleague = (Colleague)mColleagueMap.get(ProgressDialogColleague.class);
				aColleague.setUp();
			}
			
			public void setUp() {
				try {
					java.awt.EventQueue.invokeAndWait(this);
				}
				catch (InterruptedException e) {
				}
				catch (java.lang.reflect.InvocationTargetException e) {
				}
			}
		};		
	}
}


