// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Board.java
//	DATE:		2003.5.12
//	CREATOR:	Kazuhiko TAMURA
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app.view;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Point;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseEvent;

import java.util.logging.Logger;
import java.util.logging.Level;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;

import jp.gr.java_conf.ktz.puzzle.framework.view.Renderer;
import jp.gr.java_conf.ktz.puzzle.framework.view.DefaultRenderer;

import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.AWTDispatchCommandQueue;

import jp.gr.java_conf.ktz.puzzle.framework.view.command.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.framework.view.command.PieceSizeCommand;

import jp.gr.java_conf.ktz.puzzle.framework.model.Model;
import jp.gr.java_conf.ktz.puzzle.framework.model.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.model.ModelConstants;

import jp.gr.java_conf.ktz.puzzle.framework.util.Command;

import jp.gr.java_conf.ktz.puzzle.framework.util.marshal.ProblemUnmarshalable;


import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppMenuID;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BridgibleCheckModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.SolutionCheckModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeDispatcher;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeModelChangeHandler;

import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.*;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.command.CheckCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.command.CheckResultCommand;

/**
 *	ՖʂViewKw
 */
public class Board extends java.awt.Canvas implements BoardView {
	/** ̃pbP[Wɑ΂Logger */
	private static final Logger HASHI_LOGGER = Logger.getLogger(Board.class.getPackage().getName());
	
	/** Ֆʂ̃ftHg̕ */
	private static final int DEFAULT_BOARD_WIDTH = 9;

	/** Ֆʂ̃ftHg̍ */
	private static final int DEFAULT_BOARD_HEIGHT = 9;
	
	/** NbNĂȂƂ萔 */
	private static final Point NO_CLICKED = ModelConstants.ILLEGAL_POS;
	
	/** gbvxModelւ̎Q */
	private Model mModel = NullModel.getInstance();
	
	/** gbvxModelChangeDispatcherւ̎Q */
	private ModelChangeDispatcher mDispatcher = new ModelChangeDispatcher() {
		public void processModelChange(ModelChangeEvent inEvent) {}
	};
	
	/** Ֆʂ̕`s_ */
	private DefaultRenderer mRenderer;
	
	/** CommandCommandListenerΉt}bv */
	private java.util.Map mTable;
	
	/** View̐e */
	private BoardView mParent;
	
	/**
	 *	ftHgRXgN^
	 */
	public Board() {
	}
	
	/**
	 *	ViewKw
	 */
	public void initialize() {
		if (HASHI_LOGGER.isLoggable(Level.INFO)) {
			HASHI_LOGGER.info("init");	
		}
		
		// Model̏
		mModel = NullModel.getInstance();
		
		// Rendereȑ
		mRenderer = RendererFactory.create(DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_HEIGHT);
		
		// Canvas̏
		setBackground(AppColors.BACK_COLOR);
		createBoard(DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_HEIGHT);
		
		// Mouse Listener ̓o^
		MouseHandler aHandler = new MouseHandler();
		addMouseListener(aHandler);
		addMouseMotionListener(aHandler);
		
		
		// Piece size]
		PieceSizeCommand aCommand = new PieceSizeCommand(this, getPieceSize());
		AWTDispatchCommandQueue.postCommand(aCommand);
	}
		
	/** 
	 *	Command̏s
	 *	̎ł́ÃvZXŏłȂƂA
	 *	ʂCommandContainerŎw肵CommandƂA
	 *	Command]
	 *
	 *	@param	inCommand	Command
	 */	
	public void processCommand(Command inCommand) {
		// w肵Command̏܂ĂȂ
		// ACommandContainerŏłꍇ
		if (! inCommand.isConsumed()) {
			processCommandImpl(inCommand);
		}
		
		// ̃vZXŏłȂƂA
		// ܂́AʂCommandContainerŎw肵CommandƂ
		if (! inCommand.isConsumed()) {
			if (inCommand instanceof AbstractBottomUpCommand) {
				mParent.processCommand(inCommand);
			}
		}
	}
	
	/**
	 *	Command̎
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == ResetCommand.class) {
			clear();
			inCommand.consume();
		}
		else if (aClass == CheckCommand.class) {
			final boolean aRes = check();
			inCommand.consume();
			
			CheckResultCommand aCommand = new CheckResultCommand(Board.this, aRes);
			AWTDispatchCommandQueue.postCommand(aCommand);
		}
		else if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
			setComponentSize(aWidth, aHeight);
		}
		else if (aClass == LoadCommand.class) {
			ProblemInfo aInfo = ((LoadCommand)inCommand).getProblem();
			load(aInfo);
			inCommand.consume();
		}
	}
	
	/**
	 *	ViewKw̐eݒ肷
	 *
	 *	@param	inBoard	eView
	 */
	public void setParent(BoardView inBoard) {
		mParent = inBoard;
	}
	
	/**
	 *	w肵[h
	 *
	 *	@param	inInfo	蕶
	 *
	 *	@throws	IllegalArgumentException inInfonullnꂽƂ
	 */
	private void load(ProblemInfo inInfo) {
		if (HASHI_LOGGER.isLoggable(Level.INFO)) {
			HASHI_LOGGER.info("load problem");	
		}
		
		if (null == inInfo) throw new IllegalArgumentException("pass null object to inInfo");

		if (mModel instanceof NullModel) {
			mModel = 
				new SolutionCheckModel(new BridgibleCheckModel(new BoardModel(mModel)));
			mDispatcher = new HashikakeModelChangeHandler(mModel);
		}
		
		createBoard(inInfo.getWidth(), inInfo.getHeight());
		mModel.setProblem(inInfo);
			
		if (mModel.isModified()) {
			Rectangle aBounds = getClipBounds();
			repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}
	}
	
	/**
	 *	w肵TCY̔Ֆʂ쐬
	 *
	 *	@param	inWidth		Ֆʂ̕iBoardWnj
	 *	@param	inHeight	Ֆʂ̍iBoardWnj
	 */
	private void createBoard(final int inWidth, final int inHeight) {
		mRenderer.setSize(inWidth, inHeight);
		mModel.createBoard(inWidth, inHeight);
		
		java.awt.Dimension aSize = mRenderer.getBoardSize();
		
		BoardSizeCommand aCommand = new BoardSizeCommand(
								this, aSize.width, aSize.height
		);
		AWTDispatchCommandQueue.postCommand(aCommand);
	}
	
	/**
	 *	͂𓚂ł邩`FbN
	 *
	 *	@return	łꍇAtrueԂ
	 */
	private boolean check() {
		if (HASHI_LOGGER.isLoggable(Level.INFO)) {
			HASHI_LOGGER.info("check solution");
		}
		
		return mModel.check();
	}
	
	/**
	 *	ՖʂύXĂ邩ǂmF
	 *	̎ł͏falseԂ
	 */
	public boolean isModified() {
		return false;
	}
	
	/**
	 *	ViewɊ֘AtꂽR|[lgԂ
	 *
	 *	@return ViewɊ֘AtꂽR|[lg
	 */
	public java.awt.Component getComponent() {
		return this;
	}
	
	/**
	 *	Z̃s[XTCY擾
	 *
	 *	@return	s[XTCY
	 */
	private int getPieceSize() {
		return mRenderer.getPieceSize().width;
	}
	
	private void setComponentSize(final int inWidth, final int inHeight) {
		setSize(inWidth, inHeight);
	}
	
	/**
	 *	̃t[Ɋ֘AtꂽViewɃtH[JX邩ǂ߂
	 *
	 *	@param	inFocused	tH[JXꍇAtruwn
	 */
	public void setFocus(boolean inFocused) {
		mParent.setFocus(inFocused);
	}
	
	/**
	 *	̃t[Ɋ֘AtꂽViewtH[JXǂ`FbN
	 *
	 *	@return	tH[JXꍇAtruwԂ
	 */
	public boolean isFocused() {
		return mParent.isFocused();
	}
	
	/**
	 *	ՖʂԂɖ߂
	 */
	private void clear() {
		if (HASHI_LOGGER.isLoggable(Level.INFO)) {
			HASHI_LOGGER.info("clear problem");
		}
		
		mModel.reset();
		
		MenuManager.currentMenuManager().setEnabledFor(AppMenuID.ITEM_CLEAR, false);
		
		if (mModel.isModified()) {
			Rectangle aBounds = getClipBounds();
			repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}
	}
	
	/**
	 *	w肵ScreenWn̈ʒuBoardWn̈ʒuɕϊ
	 *
	 *	@param	inX	XWiScreenWnj
	 *	@param	inY	YWiScreenWnj
	 *
	 *	@return	ϊ̍WiBoardWnj
	 */
	private Point calcPortToBoardPos(final int inX, final int inY) {
		return mRenderer.calcPortToBoardPos(inX, inY);
	}
	
	/**
	 *	ĕ`悷
	 */
	public void update(Graphics inGra) {
		paint(inGra);
	}
	
	/**
	 *	`悷
	 */
	public void paint(Graphics inGra) {
		Rectangle aBounds = inGra.getClipBounds();

		if (mModel.isModified()) {
			aBounds = new Rectangle();
			
			Point[] aPos = mModel.lastModified();
			
			for (int i = 0; i < aPos.length; ++i) {
				mRenderer.render(aPos[i].x, aPos[i].y, mModel.getCurStateAt(aPos[i].x, aPos[i].y));
			}

			aBounds = getClipBounds();
		}
		
		inGra.drawImage(
				mRenderer.getImage(), 
				0, 0, 
				this
		);
		
		mModel.flush();
	}
	
	/**
	 *	clip̈vZ
	 *
	 *	@return	clip̈
	 */
	private Rectangle getClipBounds() {
		return mRenderer.getClipBounds(mModel.lastModified());
	}
	
	/**
	 *	mousẽnhOǗNX
	 */
	private class MouseHandler implements MouseListener, MouseMotionListener {
		/** BoardWƂĂ̈ʒu */
		private Point mClickedPos = NO_CLICKED;
		
		
		public void mousePressed(MouseEvent inEvent) {
			Point aPos = calcPortToBoardPos(inEvent.getX(), inEvent.getY());
			if (! mModel.isNumberAt(aPos.x, aPos.y)) return;
			mClickedPos = aPos;
			
			ModelChangeEvent aEvent
				 = ModelChangeEvent.createSelectionEvent(mClickedPos.x, mClickedPos.y, Direction.NO);
			mDispatcher.processModelChange(aEvent);
			
// System.out.println(aPos + " : " + mModel.getCurStateAt(aPos.x, aPos.y));
			Rectangle aBounds = getClipBounds();
			repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}
		
		public void mouseReleased(MouseEvent inEvent) {
			Direction aDirection = calcDirection(calcPortToBoardPos(inEvent.getX(), inEvent.getY()));
			ModelChangeEvent aEvent = ModelChangeEvent.createDeterminationEvent(
					mClickedPos.x, mClickedPos.y, aDirection
			);
				 
			// t̊mF
			if (inEvent.getModifiers() == MouseEvent.BUTTON3_MASK
				|| inEvent.getModifiers() == (MouseEvent.BUTTON1_MASK | MouseEvent.SHIFT_MASK))
			{
				aEvent.changeTransit(false);
			}
			
			mDispatcher.processModelChange(aEvent);
			
			mClickedPos = NO_CLICKED;
			
			if (mModel.isModified()) {
				MenuManager.currentMenuManager().setEnabledFor(AppMenuID.ITEM_CLEAR, true);
			
				Rectangle aBounds = getClipBounds();
				repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		}
		
		public void mouseDragged(MouseEvent inEvent) {
			if (NO_CLICKED == mClickedPos) return;
			
			Direction aDirection = calcDirection(calcPortToBoardPos(inEvent.getX(), inEvent.getY()));
			ModelChangeEvent aEvent
					 = ModelChangeEvent.createSelectionEvent(mClickedPos.x, mClickedPos.y, aDirection);
			mDispatcher.processModelChange(aEvent);
			if (mModel.isModified()) {
				Rectangle aBounds = getClipBounds();
				repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		}
		
		public void mouseClicked(MouseEvent inEvent) {}
		public void mouseEntered(MouseEvent inEvent) {}
		public void mouseExited(MouseEvent inEvent) {}
		public void mouseMoved(MouseEvent inEvent) {}
		
		private Direction calcDirection(final Point inToPos) {
			if (mClickedPos.equals(inToPos)) return Direction.NO;
			
			if (inToPos.x == mClickedPos.x) {
				if (inToPos.y > mClickedPos.y) {
					return Direction.SOUTH;
				}
				else {
					return Direction.NORTH;
				}
			}
			else if (inToPos.y == mClickedPos.y) {
				if (inToPos.x > mClickedPos.x) {
					return Direction.EAST;
				}
				else {
					return Direction.WEST;
				}
			}
			
			return Direction.NO;
		}
	}
}