// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME :		Main.java
//	DATE :		2003.7.10
//	MODIFIED	2003.8.10	menu𗛑fǂ݂ނ悤ɕύX
//							menuڂI18N
//	CREATOR	:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.app;

import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;

import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.HashikakeRoot;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Bundle;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ResourceLoader;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.PropertyBundle;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuManager;

/**
 *	Ֆʂi[t[
 *	̃NX́Amain routinecāÂׂẴ\bh폜\ł
 *
 *		initialize\bh -- HashikakeRoot.javaɈڂ\
 *		createMenu\bh -- MenuManager̎NX쐬AɈڂ\
 */
public class Main {
	private static final String MENU_RESOURCE_KEY = "menu_info_resource";
	private static final String LOCALIZE_RESOURCE_KEY = "localize_resource";
	
	static {
		String aPath = Bundle.getString(LOCALIZE_RESOURCE_KEY);
		java.net.URL aResource = ResourceLoader.loadProperty(Main.class, aPath);
		PropertyBundle.initialize(aResource);
	}
	
	/**
	 *	main routine
	 *	
	 *	̃vOentrance point
	 */
	public static void main(String[] inArgs) {
		// ԑJڃ}l[W[̏
		StateManager.initialize(new HashikakeStateManagerImpl());
		
		// menu resourceload
		String aPath = Bundle.getString(MENU_RESOURCE_KEY);
		java.net.URL aResource = ResourceLoader.loadResource(Main.class, aPath);
		MenuManager.initMenuBarInfo(aResource);

		HashikakeRoot.showRootBoard();
	}
}

