/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.framework.util;

import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;

public final class TerminateManager {
    private List mQueue;
    private boolean mIsStopped = true;
    private Thread mTerminateThread;

    public static TerminateManager getInstance() {
        return Holder.sInstance;
    }

    public void start() {
        if (!this.mIsStopped) {
            return;
        }
        this.mQueue = new LinkedList();
        this.mIsStopped = false;
        this.mTerminateThread = new Thread((Runnable)new TerminateLoop(), "Terminate-Thread");
        this.mTerminateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        List list = this.mQueue;
        synchronized (list) {
            this.mIsStopped = true;
            this.mTerminateThread = null;
            this.mQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTermination() {
        List list = this.mQueue;
        synchronized (list) {
            try {
                while (!this.mIsStopped) {
                    this.mQueue.wait();
                }
            }
            catch (InterruptedException e) {
                this.cancel();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvent(WindowEvent inEvent) {
        if (null == inEvent) {
            return;
        }
        List list = this.mQueue;
        synchronized (list) {
            this.mQueue.add(inEvent);
            this.mQueue.notify();
        }
    }

    public boolean isTerminateThread() {
        return Thread.currentThread() == this.mTerminateThread;
    }

    private class TerminateLoop
    implements Runnable {
        private TerminateLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                WindowEvent aEvent = null;
                List list = TerminateManager.this.mQueue;
                synchronized (list) {
                    try {
                        while (TerminateManager.this.mQueue.isEmpty() && !TerminateManager.this.mIsStopped) {
                            TerminateManager.this.mQueue.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        TerminateManager.this.cancel();
                        return;
                    }
                    if (TerminateManager.this.mIsStopped) {
                        return;
                    }
                    aEvent = (WindowEvent)TerminateManager.this.mQueue.remove(0);
                }
                aEvent.getWindow().dispatchEvent(aEvent);
                list = TerminateManager.this.mQueue;
                synchronized (list) {
                    if (TerminateManager.this.mIsStopped) {
                        return;
                    }
                }
            }
        }
    }

    private static class Holder {
        static TerminateManager sInstance = new TerminateManager();

        private Holder() {
        }
    }
}

