/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bcel.generic.InstructionConstants;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.ArrayMap;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.StringConversion;
import org.jibx.runtime.JiBXException;

public class DefinitionContext {
    private final IContainer m_container;
    private final DefinitionContext m_context;
    private NamespaceDefinition m_attributeDefault;
    private NamespaceDefinition m_elementDefault;
    private ArrayList m_namespaces;
    private HashMap m_prefixMap;
    private HashMap m_uriMap;
    private ArrayMap m_classMap;
    private ArrayList m_mappings;
    private HashMap m_convertMap;
    private HashMap m_formatMap;
    private HashMap m_namedStructureMap;

    public DefinitionContext(IContainer contain) {
        this.m_container = contain;
        this.m_context = contain.getDefinitionContext();
        this.m_convertMap = new HashMap();
        this.m_formatMap = new HashMap();
        if (this.m_context == null) {
            this.m_namedStructureMap = new HashMap();
        }
    }

    public void addNamespace(NamespaceDefinition def) throws JiBXException {
        String prefix;
        if (this.m_namespaces == null) {
            this.m_namespaces = new ArrayList();
            this.m_prefixMap = new HashMap();
            this.m_uriMap = new HashMap();
        }
        if (def.isAttributeDefault()) {
            if (this.m_attributeDefault == null) {
                this.m_attributeDefault = def;
            } else {
                throw new JiBXException("Multiple default attribute namespaces at level");
            }
        }
        if (def.isElementDefault()) {
            if (this.m_elementDefault == null) {
                this.m_elementDefault = def;
            } else {
                throw new JiBXException("Multiple default element namespaces at level");
            }
        }
        if (this.m_prefixMap.get(prefix = def.getPrefix()) != null) {
            throw new JiBXException("Namespace prefix conflict");
        }
        String uri = def.getUri();
        Object prior = this.m_uriMap.get(uri);
        if (prior != null && ((NamespaceDefinition)prior).getPrefix() != null) {
            return;
        }
        def.setIndex(this.m_container.getBindingRoot().getNamespaceUriIndex(def.getUri()));
        this.m_namespaces.add(def);
        this.m_prefixMap.put(prefix, def);
        this.m_uriMap.put(uri, def);
    }

    public void addMapping(IMapping def) throws JiBXException {
        String cname;
        int index;
        if (this.m_mappings == null) {
            this.m_classMap = new ArrayMap();
            this.m_mappings = new ArrayList();
        }
        if ((index = this.m_classMap.findOrAdd(cname = def.getBoundClass().getClassFile().getName())) < this.m_mappings.size()) {
            throw new JiBXException("Conflicting mappings for class " + cname);
        }
        this.m_mappings.add(def);
    }

    public void addNamedStructure(String name, IComponent comp) throws JiBXException {
        if (this.m_namedStructureMap == null) {
            this.m_context.addNamedStructure(name, comp);
        } else {
            this.m_namedStructureMap.put(name, comp);
        }
    }

    private NamespaceDefinition getDefaultNamespace(boolean attr) {
        NamespaceDefinition ns = attr ? this.m_attributeDefault : this.m_elementDefault;
        if (ns == null && this.m_context != null) {
            ns = this.m_context.getDefaultNamespace(attr);
        }
        return ns;
    }

    public String getDefaultURI(boolean attr) {
        NamespaceDefinition ns = this.getDefaultNamespace(attr);
        if (ns == null) {
            return null;
        }
        return ns.getUri();
    }

    public int getDefaultIndex(boolean attr) {
        NamespaceDefinition ns = this.getDefaultNamespace(attr);
        if (ns == null) {
            return 0;
        }
        return ns.getIndex();
    }

    public int getNamespaceIndex(String uri, boolean attr) throws JiBXException {
        Object value;
        if (!(this.m_uriMap == null || (value = this.m_uriMap.get(uri)) == null || attr && ((NamespaceDefinition)value).getPrefix() == null)) {
            return ((NamespaceDefinition)value).getIndex();
        }
        if (this.m_context == null) {
            throw new JiBXException("Namespace URI \"" + uri + "\" not defined or not usable");
        }
        return this.m_context.getNamespaceIndex(uri, attr);
    }

    public IMapping getMappingAtLevel(String name) {
        int index;
        if (this.m_classMap != null && (index = this.m_classMap.find(name)) >= 0) {
            return (IMapping)this.m_mappings.get(index);
        }
        return null;
    }

    public IMapping getClassMapping(String name) throws JiBXException {
        IMapping def = this.getMappingAtLevel(name);
        if (def == null) {
            if (this.m_context == null) {
                throw new JiBXException("Mapping for class " + name + " not defined");
            }
            def = this.m_context.getClassMapping(name);
        }
        return def;
    }

    public IComponent getNamedStructure(String name) throws JiBXException {
        if (this.m_namedStructureMap == null) {
            return this.m_context.getNamedStructure(name);
        }
        return (IComponent)this.m_namedStructureMap.get(name);
    }

    public ArrayList getMappings() {
        return this.m_mappings;
    }

    public StringConversion getSpecificConversion(String name) {
        StringConversion conv = (StringConversion)this.m_convertMap.get(name);
        if (conv == null && this.m_context != null) {
            conv = this.m_context.getSpecificConversion(name);
        }
        return conv;
    }

    public StringConversion getConversion(ClassFile clas) {
        StringConversion conv;
        while ((conv = this.getSpecificConversion(clas.getName())) == null) {
            clas = clas.getSuperFile();
        }
        return conv;
    }

    public StringConversion getNamedConversion(String name) {
        StringConversion conv = (StringConversion)this.m_formatMap.get(name);
        if (conv == null && this.m_context != null) {
            conv = this.m_context.getNamedConversion(name);
        }
        return conv;
    }

    public void addConversion(String name, StringConversion conv) throws JiBXException {
        if (this.m_formatMap.put(name, conv) != null) {
            throw new JiBXException("Duplicate conversion defined with name " + name);
        }
    }

    public void setConversion(StringConversion conv) throws JiBXException {
        if (this.m_convertMap.put(conv.getTypeName(), conv) != null) {
            throw new JiBXException("Duplicate conversion defined for type " + conv.getTypeName());
        }
    }

    public void setNamedConversion(String name, StringConversion conv) throws JiBXException {
        this.addConversion(name, conv);
    }

    public void setDefaultConversion(String name, StringConversion conv) throws JiBXException {
        this.addConversion(name, conv);
        this.setConversion(conv);
    }

    public boolean hasNamespace() {
        return this.m_namespaces != null && this.m_namespaces.size() > 0;
    }

    private void genFillNamespaceIndexes(ArrayList nss, MethodBuilder mb) throws JiBXException {
        if (nss != null) {
            int i = 0;
            while (i < nss.size()) {
                mb.append(InstructionConstants.DUP);
                mb.appendLoadConstant(i);
                mb.appendLoadConstant(((NamespaceDefinition)nss.get(i)).getIndex());
                mb.append(InstructionConstants.IASTORE);
                ++i;
            }
        }
    }

    private void genFillNamespacePrefixes(ArrayList nss, MethodBuilder mb) throws JiBXException {
        if (nss != null) {
            int i = 0;
            while (i < nss.size()) {
                mb.append(InstructionConstants.DUP);
                mb.appendLoadConstant(i);
                String prefix = ((NamespaceDefinition)nss.get(i)).getPrefix();
                prefix = prefix == null ? "" : prefix + ":";
                mb.appendLoadConstant(prefix);
                mb.append(InstructionConstants.AASTORE);
                ++i;
            }
        }
    }

    public void genLoadNamespaces(MethodBuilder mb) throws JiBXException {
        int count = this.m_namespaces == null ? 0 : this.m_namespaces.size();
        mb.appendLoadConstant(count);
        mb.appendCreateArray("int");
        this.genFillNamespaceIndexes(this.m_namespaces, mb);
        mb.appendLoadConstant(count);
        mb.appendCreateArray("java.lang.String");
        this.genFillNamespacePrefixes(this.m_namespaces, mb);
    }

    public void generateCode() throws JiBXException {
        if (this.m_mappings != null) {
            int i = 0;
            while (i < this.m_mappings.size()) {
                ((IMapping)this.m_mappings.get(i)).generateCode();
                ++i;
            }
        }
    }

    public void setLinkages() throws JiBXException {
        if (this.m_mappings != null) {
            int i = 0;
            while (i < this.m_mappings.size()) {
                ((MappingDefinition)this.m_mappings.get(i)).setLinkages();
                ++i;
            }
        }
    }

    public void print(int depth) {
        int i;
        BindingDefinition.indent(depth);
        System.out.print("context");
        if (this.m_namespaces != null) {
            System.out.print(" (ns#=" + this.m_namespaces.size() + ')');
        }
        if (this.m_mappings != null) {
            System.out.print(" (mp#=" + this.m_mappings.size() + ')');
        }
        if (this.m_namedStructureMap != null) {
            System.out.print(" (nm#=" + this.m_namedStructureMap.size() + ')');
        }
        if (this.m_convertMap != null) {
            System.out.print(" (cv#=" + this.m_convertMap.size() + ')');
        }
        if (this.m_formatMap != null) {
            System.out.print(" (fm#=" + this.m_formatMap.size() + ')');
        }
        System.out.println();
        if (this.m_namespaces != null) {
            i = 0;
            while (i < this.m_namespaces.size()) {
                NamespaceDefinition ndef = (NamespaceDefinition)this.m_namespaces.get(i);
                ndef.print(depth + 1);
                ++i;
            }
        }
        if (this.m_mappings != null) {
            i = 0;
            while (i < this.m_mappings.size()) {
                MappingDefinition mdef = (MappingDefinition)this.m_mappings.get(i);
                mdef.print(depth + 1);
                ++i;
            }
        }
    }
}

