/* EBhE֌W */

#include "bootpack.h"

void window_open(struct sheet *sht, char *title, char mode)
{
	graphic_box(sht, COLOR_FFFFFF,           0,           0, sht->sx - 2,           0);
	graphic_box(sht, COLOR_FFFFFF,           0,           0,           0, sht->sy - 2);
	graphic_box(sht, COLOR_000000, sht->sx - 1,           0, sht->sx - 1, sht->sy - 1);
	graphic_box(sht, COLOR_000000,           0, sht->sy - 1, sht->sx - 1, sht->sy - 1);
	graphic_box(sht, COLOR_C6C6C6,           1,           1, sht->sx - 2, sht->sy - 2);
	window_title(sht, title, mode);
	return;
}

void window_title(struct sheet *sht, char *title, char mode)
{
	unsigned char tc;

	if(mode != 0) {
		tc = COLOR_000000;
	} else {
		tc = COLOR_848484;
	}
	graphic_box(sht, tc,  6, 6, 14, 14);
	graphic_box(sht, tc, 20, 9, 28, 10);
	graphic_fonts(sht, COLOR_C6C6C6, tc, 26, 2, title);
	return;
}

void window_chtitle(struct sheet *sht, char mode)
{
	int x, y;
	char c, tcn, tco;

	if(mode != 0) {
		tcn = COLOR_000000;
		tco = COLOR_848484;
	} else {
		tcn = COLOR_848484;
		tco = COLOR_000000;
	}
	for(y = 2; y <= 20; y++) {
		for(x = 2; x <= sht->sx - 2; x++) {
			c = sht->buf[y * sht->sx + x];
			if(c == tco && x <= sht->sx - 22) {
				c = tcn;
			}
			sht->buf[y * sht->sx + x] = c;
		}
	}
	sheet_refresh(sht, 2, 2, sht->sx, 21);
	return;
}

void window_tbox(struct sheet *sht, unsigned char c, int x0, int y0, int sx, int sy)
{
	int x1 = x0 + sx, y1 = y0 + sy;

	graphic_box(sht, COLOR_848484, x0-2, y0-3, x1+1, y0-3);
	graphic_box(sht, COLOR_848484, x0-3, y0-3, x1-3, y1+1);
	graphic_box(sht, COLOR_FFFFFF, x0-3, y1+2, x1+1, y1+2);
	graphic_box(sht, COLOR_FFFFFF, x1+2, y0-3, x1+2, y1+2);
	graphic_box(sht, COLOR_000000, x0-1, y0-2,   x1, y0-2);
	graphic_box(sht, COLOR_000000, x0-2, y0-2, x0-2,   y1);
	graphic_box(sht, COLOR_C6C6C6, x0-2, y1+1,   x1, y1+1);
	graphic_box(sht, COLOR_C6C6C6, x1+1, y0-2, x1+1, y1+1);
	graphic_box(sht,            c, x0-1, y0-1,   x1,   y1);
	return;
}

void window_active(struct sheet *snow)
{
	window_chtitle(snow, 1);
	if((snow->flag & SHEET_CONSOLE) != 0) {	/* R\[J[\ON */
		fifo_put(&snow->task->fifo, 2);
	}
	return;
}

void window_passive(struct sheet *snow)
{
	window_chtitle(snow, 0);
	if((snow->flag & SHEET_CONSOLE) != 0) {	/* R\[J[\OFF */
		fifo_put(&snow->task->fifo, 3);
	}
	return;
}
