/* L[{[h֌W */

#include "bootpack.h"

void keyboard_init(void)
{
	kc_rwait();
	outb(PORT_KEYCMD, KEYCMD_MWRITE);
	kc_rwait();
	outb(PORT_KEYDATA, KC_MODE);
	return;
}

void keyboard_ihandle(int *esp)
{
	int data;

	outb(PIC0_OCW2, 0x61);	/* IRQ-01Ɏtʒm */
	data = inb(PORT_KEYDATA);
	fifo_put(&fifo, 512 + data);
	return;
}

void kc_rwait(void)
{
	for(;;) {
		if((inb(PORT_KEYSTAT) & KEYSTAT_NOREADY) == 0) {
			return;
		}
	}
}
