/* FDC */
#include "bootpack.h"

struct fdc fdc;			/* FDC */
struct fifo *fifo_fdc;	/* FDC^XNFIFO */
int fdcbuf[32];			/* FIFÕobt@ */

/*
FDCƂ̂Ƃ𒇉^XNłB
vȂfdc_reqgAʂ擾ɂfdc_stat
gAȂ0AُȂ1AsȖ߂Ȃ2ԂB
*/
void fdc_task(void)
{
	struct task *task = task_now();
	struct timer *timer;
	char mot = 0, ph = 0, err = 1;
	int i;

	/* DMȀ */
	fdc_dmainit();

	/* [^̏ */
	outb(PORT_FDC_MOTOR, 0x0c);	/* [^Xgbv */
	timer = timer_alloc();
	timer_init(timer, fifo_fdc, 1);

start:
	for (;;) {
		cli();
		if (fifo_stat(fifo_fdc) == 0) {
			task_sleep(task);
			sti();
		} else {
			i = fifo_get(fifo_fdc);
			sti();

			if(i == 1) {	/* [^ */
				if(mot != 0) {	/* [^Xgbv */
					outb(PORT_FDC_MOTOR, 0x0c);
					mot = 0;
				} else {	/*@wbh̒ */
					fdc_setdma();
					fdc_sethead();
					mot = 1;
					ph = 0;
				}
			} else if(i == 2) {	/* ǂݏX^[g */
				if(mot == 0) {
					outb(PORT_FDC_MOTOR, 0x1c);	/* [^X^[g */
					timer_set(timer, 300);
				} else {
					timer_cancel(timer);
					fdc_setdma();
					fdc_sethead();
					ph = 0;
				}
			} else if(i == 6) {	/* FDCINT */
				if(ph == 0) {	/* V[N */
					fdc_getint();
					if((fdc.st0 & 0xc0) == 0x00) {	/* I */
						fdc_setcmd();
						ph = 1;
						err = 1;
					} else {	/* ُȃXe[^X */
						fdc.st0 = 2;
						goto end;
					}
				} else {	/* R}h */
					fdc_getrstat();
					if((fdc.st0 & 0xc0) == 0x00) {		/* I */
						fdc.st0 = 0;
						goto end;
					} else if ((fdc.st0 & 0xc0) == 0x40) {	/* ُI */
						if(err > 5) {
							fdc.st0 = 1;
							goto end;
						} else {
							err++;
							fdc_setcmd();
						}
					} else {	/* ُȃXe[^X */
						fdc.st0 = 2;
						goto end;
					}
				}
			}
		}
	}

end:	/* ĊJ */
	outb(PORT_DMAC0_SMR, 0x06);	/* }X^ch2}XN */
	timer_set(timer, 300);
	fdc.mode = IO_EXIT;
	goto start;
}

void fdc_tinit(struct task *task)
{
	/* ^XN̐ݒ */
	task->stack = memory_alloc(mem, 65536);
	task->tss.eip = (int) &fdc_task;
	task->tss.esp = task->stack + 65536;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;

	/* v\̂FIFȌ */
	fdc.mode = 0;
	fifo_fdc = &task->fifo;
	fifo_init(&task->fifo, task, fdcbuf, 32);

	/* ^XN̎s */
	task_run(task, 1, 1);
	return;
}

void fdc_ihandle(int *esp)
{
	inb(PORT_FDC_STAT);		/* IRQCPUCÂƂFDCɋ */
	outb(PIC0_OCW2, 0x66);	/* IRQ-06I */
	fifo_put(fifo_fdc, 6);
	return;
}

void fdc_dmainit(void)
{
	/* DMȀ */
	outb(PORT_DMAC1_MODE, 0xc0);	/* }X^ch0JXP[h[h */
	outb(PORT_DMAC1_CBAR, 0x00);	/* X[uDMA */
	outb(PORT_DMAC0_SMR, 0x06);		/* }X^ch2DMA}XN */
	return;
}

void fdc_setdma(void)
{
	int addr = DISKIMG_ADDR + (fdc.cyl * 36 + fdc.head * 18 + fdc.sect - 1) * 512;

	if(fdc.mode == IO_READ) {
		outb(PORT_DMAC0_MODE, 0x06);	/* f}hEAhXEւ̏݁Ech2 */
	} else if (fdc.mode == IO_WRITE) {
		outb(PORT_DMAC0_MODE, 0x0a);	/* f}hEAhXE̓ǂݍ݁Ech2 */
	}

	outb(PORT_DMAC0_CBAR, addr & 0xff);	/* Ԓn̐ݒ */
	outb(PORT_DMAC0_CBAR, (addr >> 8) & 0xff);
	outb(PORT_DMAP_ADDRUP, (addr >> 16) & 0xff);

	outb(PORT_DMAC0_CBCR, 0xff);	/* oCg̐ݒ */
	outb(PORT_DMAC0_CBCR, fdc.sects * 2 - 1);

	outb(PORT_DMAC0_SMR, 0x02);	/* }X^ch2̃}XN */
	return;
}

void fdc_sethead(void)
{
	fdc_initwait(0x11);
	fdc_sendcmd(0x0f);			/* V[N */
	fdc_sendcmd(fdc.head << 2);	/* wbh */
	fdc_sendcmd(fdc.cyl);		/* V_ */
	return;
}

void fdc_setcmd(void)
{
	fdc_initwait(0x11);

	if(fdc.mode == IO_READ) {
		fdc_sendcmd(0xe6);	/* ǂݍ */
	} else if (fdc.mode == IO_WRITE) {
		fdc_sendcmd(0xc5);	/*  */
	}

	fdc_sendcmd(fdc.head << 2);	/* FDԒn̎w */
	fdc_sendcmd(fdc.cyl);
	fdc_sendcmd(fdc.head);
	fdc_sendcmd(fdc.sect);

	fdc_sendcmd(0x02);	/* ZN^F512B */
	if(fdc.mode == IO_READ) {
		fdc_sendcmd(0x12);	/* gbNF18 */
		fdc_sendcmd(0x01);	/* GAP3 */
	} else if(fdc.mode == IO_WRITE) {
		fdc_sendcmd(0x7f);	/* ? */
		fdc_sendcmd(0x12);	/* ? */
	}
	fdc_sendcmd(0xff);	/* wZN^TCYŜΏ */
	return;
}

void fdc_getint(void)
{
	fdc_initwait(0x10);
	fdc_sendcmd(0x08);	/* 荞ݏԎ擾 */
	fdc.st0 = fdc_getrstatsub();
	fdc_getrstatsub();	/* I̔ԒnFV_ */
	return;
}

void fdc_getrstat(void)
{
	char i;

	fdc.st0 = fdc_getrstatsub();
	i = fdc_getrstatsub();	/* st1 */
	i = fdc_getrstatsub();	/* st2 */
	i = fdc_getrstatsub();	/* I̔ԒnFV_ */
	i = fdc_getrstatsub();	/* I̔ԒnFwbh */
	i = fdc_getrstatsub();	/* I̔ԒnFZN^ */
	i = fdc_getrstatsub();	/* ZN^TCY */
	return;
}

char fdc_getrstatsub(void)
{
	char i;

	for(;;) {
		if((inb(PORT_FDC_STAT) & 0xc0) == 0xc0) {
			i = (char) inb(PORT_FDC_DATA);
			return i;
		}
	}
}

void fdc_initwait(int wait)
{
	for(;;) {
		if((inb(PORT_FDC_STAT) & wait) == 0) {
			return;
		}
	}
}

void fdc_sendcmd(int data)
{
	for(;;) {
		if((inb(PORT_FDC_STAT) & 0xc0) == 0x80) {
			outb(PORT_FDC_DATA, data);
			return;
		}
	}
}

void fdc_req(char mode, char cyl, char head, char sect, char sects)
{
	for(;;) {
		if(fdc.mode == 0) {
			fdc.mode = mode;
			fdc.cyl = cyl;
			fdc.head = head;
			fdc.sect = sect;
			fdc.sects = sects;
			return;
		}
	}
}

int fdc_reqstat(void)
{
	fifo_put(fifo_fdc, 2);
	for(;;) {
		if(fdc.mode == IO_EXIT) {
			fdc.mode = 0;
			return (int) fdc.st0;
		} else {
			timer_sleep(1);
		}
	}
}
