/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.project.EditorUpdataEvent;
import jp.sourceforge.gtibuilder.project.EditorUpdataListener;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class TextFind
extends JInternalFrame
implements EditorUpdataListener {
    public static final int FIND = 1;
    public static final int REPLACE = 2;
    private int type_ = -1;
    private JTextPane tpane = null;
    private JScrollPane scroll = null;
    private JInternalFrame iframe = null;
    private Project project = null;
    private EditorComponent ecomp = null;
    private int index = -1;
    private JButton bNext;
    private JButton bPrevious;
    private JPanel buttonPanel;
    private JTextField fFind;
    private JPanel find;
    private JLabel lFind;
    private JTextField pfFind;
    private JTextField pfReplace;
    private JLabel plFind;
    private JLabel plReplace;
    private JPanel prFind;
    private JPanel prReplace;
    private JButton rAll;
    private JButton rFind;
    private JButton rNext;
    private JPanel replace;
    private JPanel replaceButtons;

    public TextFind(int n, JTextPane jTextPane, JScrollPane jScrollPane, EditorComponent editorComponent, Project project) {
        super(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Find_Panel"), false, true, false, false);
        this.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.tpane = jTextPane;
        this.scroll = jScrollPane;
        this.initComponents();
        this.rNext.setDefaultCapable(true);
        this.bNext.setDefaultCapable(true);
        this.project = project;
        this.ecomp = editorComponent;
        this.ecomp.addEditorUpdataListener(this);
        this.setTitle(editorComponent.getFileName() + " " + ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Find_Panel"));
        if (n == 2) {
            this.getContentPane().add((Component)this.replace, "Center");
            this.getContentPane().add((Component)this.replaceButtons, "South");
            this.getRootPane().setDefaultButton(this.rNext);
            this.type_ = 2;
        } else {
            this.getContentPane().add((Component)this.find, "Center");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.getRootPane().setDefaultButton(this.bNext);
            this.type_ = 1;
        }
        this.pack();
        this.setDefaultCloseOperation(1);
    }

    public void setType(int n) {
        if (n == this.type_) {
            return;
        }
        if (this.type_ == 2) {
            this.remove(this.replace);
            this.remove(this.replaceButtons);
        } else {
            this.remove(this.find);
            this.remove(this.buttonPanel);
        }
        if (n == 2) {
            this.getContentPane().add((Component)this.replace, "Center");
            this.getContentPane().add((Component)this.replaceButtons, "South");
            this.getRootPane().setDefaultButton(this.rNext);
            this.type_ = 2;
        } else {
            this.getContentPane().add((Component)this.find, "Center");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.getRootPane().setDefaultButton(this.bNext);
            this.type_ = 1;
        }
    }

    public int getType() {
        return this.type_;
    }

    public void nextFind() {
        String string = this.tpane.getText();
        String string2 = null;
        string2 = this.type_ == 2 ? this.pfFind.getText() : this.fFind.getText();
        if (string2.length() == 0) {
            return;
        }
        this.index = string.indexOf(string2, this.index + 1);
        if (this.index != -1) {
            this.tpane.setSelectionStart(this.index);
            this.tpane.setSelectionEnd(this.index + string2.length());
            this.tpane.requestFocus();
        } else {
            string2 = this.type_ == 2 ? this.pfFind.getText() : this.fFind.getText();
            this.index = string.indexOf(string2, this.index + 1);
            if (this.index != -1) {
                this.tpane.setSelectionStart(this.index);
                this.tpane.setSelectionEnd(this.index + string2.length());
                this.tpane.requestFocus();
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Not_Found1") + string2 + ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Not_Found2"), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Find"), 1);
            }
        }
    }

    public void previousFind() {
        String string = this.tpane.getText();
        String string2 = null;
        string2 = this.type_ == 2 ? this.pfFind.getText() : this.fFind.getText();
        this.index = string.lastIndexOf(string2, this.index - 1);
        if (this.index != -1) {
            this.tpane.setSelectionStart(this.index);
            this.tpane.setSelectionEnd(this.index + string2.length());
            this.tpane.requestFocus();
        } else {
            this.index = string.length();
            string2 = this.type_ == 2 ? this.pfFind.getText() : this.fFind.getText();
            this.index = string.lastIndexOf(string2, this.index - 1);
            if (this.index != -1) {
                this.tpane.setSelectionStart(this.index);
                this.tpane.setSelectionEnd(this.index + string2.length());
                this.tpane.requestFocus();
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Not_Found_\"") + string2 + ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("\"."), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Find"), 1);
            }
        }
    }

    public void setInternalFrame(JInternalFrame jInternalFrame) {
        this.iframe = jInternalFrame;
    }

    private void initComponents() {
        this.find = new JPanel();
        this.lFind = new JLabel();
        this.fFind = new JTextField();
        this.replace = new JPanel();
        this.prFind = new JPanel();
        this.plFind = new JLabel();
        this.pfFind = new JTextField();
        this.prReplace = new JPanel();
        this.plReplace = new JLabel();
        this.pfReplace = new JTextField();
        this.replaceButtons = new JPanel();
        this.rFind = new JButton();
        this.rNext = new JButton();
        this.rAll = new JButton();
        this.buttonPanel = new JPanel();
        this.bNext = new JButton();
        this.bPrevious = new JButton();
        this.find.setLayout(new FlowLayout(0));
        this.lFind.setText(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Find_Text"));
        this.find.add(this.lFind);
        this.fFind.setColumns(10);
        this.find.add(this.fFind);
        this.replace.setLayout(new BoxLayout(this.replace, 1));
        this.prFind.setLayout(new FlowLayout(0));
        this.plFind.setText(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Find_Text"));
        this.prFind.add(this.plFind);
        this.pfFind.setColumns(10);
        this.prFind.add(this.pfFind);
        this.replace.add(this.prFind);
        this.prReplace.setLayout(new FlowLayout(0));
        this.plReplace.setText(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Replace"));
        this.prReplace.add(this.plReplace);
        this.pfReplace.setColumns(10);
        this.prReplace.add(this.pfReplace);
        this.replace.add(this.prReplace);
        this.rFind.setText(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Find"));
        this.rFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFind.this.replaceFindNext(actionEvent);
            }
        });
        this.replaceButtons.add(this.rFind);
        this.rNext.setText(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Replace&Find"));
        this.rNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFind.this.replaceNext(actionEvent);
            }
        });
        this.replaceButtons.add(this.rNext);
        this.rAll.setText(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Replace_All"));
        this.rAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFind.this.replaceAll(actionEvent);
            }
        });
        this.replaceButtons.add(this.rAll);
        this.bNext.setText(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Next"));
        this.bNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFind.this.findNext(actionEvent);
            }
        });
        this.buttonPanel.add(this.bNext);
        this.bPrevious.setText(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Previous"));
        this.bPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFind.this.findPrevious(actionEvent);
            }
        });
        this.buttonPanel.add(this.bPrevious);
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                TextFind.this.moved(componentEvent);
            }
        });
        this.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                TextFind.this.close(internalFrameEvent);
            }

            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            }
        });
    }

    private void moved(ComponentEvent componentEvent) {
        this.getParent().doLayout();
    }

    private void replaceAll(ActionEvent actionEvent) {
        String string = this.tpane.getText();
        String string2 = this.pfFind.getText();
        String string3 = this.pfReplace.getText();
        string = TextBuffer.replace(string, string2, string3);
        this.tpane.setText(string);
    }

    private void close(InternalFrameEvent internalFrameEvent) {
        this.project.removeSheet();
    }

    private void replaceNext(ActionEvent actionEvent) {
        this.tpane.replaceSelection(this.pfReplace.getText());
        this.index = this.tpane.getSelectionStart();
        this.nextFind();
    }

    private void replaceFindNext(ActionEvent actionEvent) {
        this.index = this.tpane.getSelectionStart();
        this.nextFind();
    }

    private void findPrevious(ActionEvent actionEvent) {
        this.index = this.tpane.getSelectionStart();
        this.previousFind();
    }

    private void findNext(ActionEvent actionEvent) {
        this.index = this.tpane.getSelectionStart();
        this.nextFind();
    }

    public void updateUI() {
        super.updateUI();
        if (this.type_ == 2) {
            if (this.find == null || this.buttonPanel == null) {
                return;
            }
            this.find.updateUI();
            this.buttonPanel.updateUI();
        } else {
            if (this.replace == null || this.replaceButtons == null) {
                return;
            }
            this.replace.updateUI();
            this.replaceButtons.updateUI();
        }
    }

    public void updataEditor(EditorUpdataEvent editorUpdataEvent) {
        this.setTitle(this.ecomp.getFileName() + " " + ResourceBundle.getBundle("jp/sourceforge/gtibuilder/editor/FindPanel").getString("Find_Panel"));
    }
}

