/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.editor.TextColoring;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.UserPreferences;
import jp.sourceforge.gtibuilder.main.Help;
import jp.sourceforge.gtibuilder.main.Main;
import jp.sourceforge.gtibuilder.main.Preference;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.DebugWindow;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;

public class MainWindow
extends JFrame
implements ActionListener,
WindowListener {
    private JMenuBar menuBar = new JMenuBar();
    private ProjectManager pm = null;
    private JMenu mFile = new JMenu();
    private JMenuItem mNew = new JMenuItem();
    private JMenuItem mOpen = new JMenuItem();
    private JMenuItem mSave = new JMenuItem();
    private JMenuItem mSaveAs = new JMenuItem();
    private JMenuItem mClose = new JMenuItem();
    private JMenuItem mPrint = new JMenuItem();
    private JMenuItem mQuit = new JMenuItem();
    private JMenu mEdit = new JMenu();
    private JMenuItem mUndo = new JMenuItem();
    private JMenuItem mRedo = new JMenuItem();
    private JMenuItem mCut = new JMenuItem();
    private JMenuItem mCopy = new JMenuItem();
    private JMenuItem mPaste = new JMenuItem();
    private JMenuItem mDelete = new JMenuItem();
    private JMenu mProject = new JMenu();
    private JMenuItem mProjectPreference = new JMenuItem();
    private JMenuItem mFilePreference = new JMenuItem();
    private JMenuItem mAddFile = new JMenuItem();
    private JMenuItem mRemoveFile = new JMenuItem();
    private JMenu mTools = new JMenu();
    private JMenuItem mPreference = new JMenuItem();
    private JMenu mWindow = new JMenu();
    private JMenu mHelp = new JMenu();
    private JMenuItem mInfomation = new JMenuItem();
    private JMenuItem mLicense = new JMenuItem();
    private JMenu mDebug = new JMenu("Debug");
    private JMenuItem mRestart = new JMenuItem();
    private JMenuItem[] editorMenu = null;
    private JPanel toolbar = new JPanel();
    private JToolBar tFile = new JToolBar();
    private JToolBar tEdit = new JToolBar();
    private JToolBar tHelp = new JToolBar();
    private JButton bNew = new JButton();
    private JButton bOpen = new JButton();
    private JButton bSave = new JButton();
    private JButton bSaveAs = new JButton();
    private JButton bUndo = new JButton();
    private JButton bRedo = new JButton();
    private JButton bCut = new JButton();
    private JButton bCopy = new JButton();
    private JButton bPaste = new JButton();
    private JButton bInfomation = new JButton();
    private JPanel st = new JPanel();
    private JLabel sta = new JLabel();
    private JProgressBar sb = new JProgressBar();
    private static MainWindow mainFrame = null;
    private boolean debug = false;
    private Vector threads = new Vector();
    static /* synthetic */ Class class$jp$sourceforge$gtibuilder$main$Main;

    public MainWindow() {
        super("GTI Builder");
        this.debug = Debug.isDebuging();
        mainFrame = this;
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        boolean bl = false;
        if (System.getProperty("os.name").startsWith("Mac OS X")) {
            dimension.height -= 22;
            bl = true;
        }
        ((Component)this).setSize(dimension);
        ((Component)this).setLocation(0, 0);
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("jp.sourceforge.gtibuilder.main.Bundle");
        }
        catch (MissingResourceException missingResourceException) {
            ErrorDialog.showError(missingResourceException);
            return;
        }
        this.pm = new ProjectManager();
        this.mWindow = this.pm.getWindowManager().getWindowMenu();
        this.mFile.setText(resourceBundle.getString("Menu.file"));
        this.mNew.setText(resourceBundle.getString("Menu.new"));
        this.mOpen.setText(resourceBundle.getString("Menu.open"));
        this.mSave.setText(resourceBundle.getString("Menu.save"));
        this.mSaveAs.setText(resourceBundle.getString("Menu.saveAs"));
        this.mClose.setText(resourceBundle.getString("Menu.close"));
        this.mPrint.setText(resourceBundle.getString("Menu.print"));
        this.mQuit.setText(resourceBundle.getString("Menu.quit"));
        this.mEdit.setText(resourceBundle.getString("Menu.edit"));
        this.mUndo.setText(resourceBundle.getString("Menu.undo"));
        this.mRedo.setText(resourceBundle.getString("Menu.redo"));
        this.mCut.setText(resourceBundle.getString("Menu.cut"));
        this.mCopy.setText(resourceBundle.getString("Menu.copy"));
        this.mPaste.setText(resourceBundle.getString("Menu.paste"));
        this.mDelete.setText(resourceBundle.getString("Menu.delete"));
        this.mProject.setText(resourceBundle.getString("Menu.project"));
        this.mProjectPreference.setText(resourceBundle.getString("Menu.projectPreference"));
        this.mFilePreference.setText(resourceBundle.getString("Menu.filePreference"));
        this.mAddFile.setText(resourceBundle.getString("Menu.addFile"));
        this.mRemoveFile.setText(resourceBundle.getString("Menu.removeFile"));
        this.mTools.setText(resourceBundle.getString("Menu.tools"));
        this.mPreference.setText(resourceBundle.getString("Menu.preference"));
        this.mWindow.setText(resourceBundle.getString("Menu.window"));
        this.mHelp.setText(resourceBundle.getString("Menu.help"));
        this.mInfomation.setText(resourceBundle.getString("Menu.infomation"));
        this.mLicense.setText(resourceBundle.getString("Menu.license"));
        this.mDebug.setText(resourceBundle.getString("Menu.debug"));
        this.mRestart.setText(resourceBundle.getString("Menu.restart"));
        this.bNew.setToolTipText(resourceBundle.getString("Menu.new"));
        this.bOpen.setToolTipText(resourceBundle.getString("Menu.open"));
        this.bSave.setToolTipText(resourceBundle.getString("Menu.save"));
        this.bSaveAs.setToolTipText(resourceBundle.getString("Menu.saveAs"));
        this.bUndo.setToolTipText(resourceBundle.getString("Menu.undo"));
        this.bRedo.setToolTipText(resourceBundle.getString("Menu.redo"));
        this.bCut.setToolTipText(resourceBundle.getString("Menu.cut"));
        this.bCopy.setToolTipText(resourceBundle.getString("Menu.copy"));
        this.bPaste.setToolTipText(resourceBundle.getString("Menu.paste"));
        this.bInfomation.setToolTipText(resourceBundle.getString("Menu.infomation"));
        this.menuBar.add(this.mFile);
        this.menuBar.add(this.mEdit);
        this.menuBar.add(this.mProject);
        this.menuBar.add(this.mTools);
        this.menuBar.add(this.mWindow);
        this.menuBar.add(this.mHelp);
        this.mFile.add(this.mNew);
        this.mNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mFile.addSeparator();
        this.mFile.add(this.mOpen);
        this.mOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mFile.addSeparator();
        this.mFile.add(this.mSave);
        this.mSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mFile.add(this.mSaveAs);
        this.mFile.addSeparator();
        this.mFile.add(this.mClose);
        this.mClose.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        if (!bl) {
            this.mFile.addSeparator();
            this.mFile.add(this.mQuit);
        }
        this.mEdit.add(this.mUndo);
        this.mUndo.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mEdit.add(this.mRedo);
        this.mEdit.addSeparator();
        this.mEdit.add(this.mCut);
        this.mCut.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mEdit.add(this.mCopy);
        this.mCopy.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mEdit.add(this.mPaste);
        this.mPaste.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mEdit.addSeparator();
        this.mEdit.add(this.mDelete);
        this.mProject.add(this.mProjectPreference);
        this.mProject.add(this.mFilePreference);
        this.mProject.addSeparator();
        this.mProject.add(this.mAddFile);
        this.mProject.add(this.mRemoveFile);
        this.mTools.add(this.mPreference);
        this.mPreference.setAccelerator(KeyStroke.getKeyStroke(59, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.mHelp.add(this.mInfomation);
        this.mHelp.add(this.mLicense);
        this.mDebug.add(this.mRestart);
        this.mNew.addActionListener(this);
        this.mOpen.addActionListener(this);
        this.mSave.addActionListener(this);
        this.mSaveAs.addActionListener(this);
        this.mClose.addActionListener(this);
        this.mPrint.addActionListener(this);
        this.mQuit.addActionListener(this);
        this.mUndo.addActionListener(this);
        this.mRedo.addActionListener(this);
        this.mCut.addActionListener(this);
        this.mCopy.addActionListener(this);
        this.mPaste.addActionListener(this);
        this.mDelete.addActionListener(this);
        this.mProjectPreference.addActionListener(this);
        this.mFilePreference.addActionListener(this);
        this.mAddFile.addActionListener(this);
        this.mRemoveFile.addActionListener(this);
        this.mPreference.addActionListener(this);
        this.mInfomation.addActionListener(this);
        this.mLicense.addActionListener(this);
        this.mRestart.addActionListener(this);
        this.bNew.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif")));
        this.bOpen.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.bSave.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        this.bSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif")));
        this.bUndo.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Undo16.gif")));
        this.bRedo.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Redo16.gif")));
        this.bCut.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif")));
        this.bCopy.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif")));
        this.bPaste.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif")));
        this.bInfomation.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/About16.gif")));
        this.mNew.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif")));
        this.mOpen.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.mSave.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        this.mSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif")));
        this.mDelete.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete16.gif")));
        this.mCut.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Cut16.gif")));
        this.mCopy.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Copy16.gif")));
        this.mUndo.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Undo16.gif")));
        this.mRedo.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Redo16.gif")));
        this.mPaste.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Paste16.gif")));
        this.mAddFile.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Add16.gif")));
        this.mPreference.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Properties16.gif")));
        this.mRemoveFile.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Remove16.gif")));
        this.mInfomation.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/About16.gif")));
        this.bNew.addActionListener(this);
        this.bOpen.addActionListener(this);
        this.bSave.addActionListener(this);
        this.bSaveAs.addActionListener(this);
        this.bUndo.addActionListener(this);
        this.bRedo.addActionListener(this);
        this.bCut.addActionListener(this);
        this.bCopy.addActionListener(this);
        this.bPaste.addActionListener(this);
        this.bInfomation.addActionListener(this);
        this.tFile.add(this.bNew);
        this.tFile.add(this.bOpen);
        this.tFile.add(this.bSave);
        this.tFile.add(this.bSaveAs);
        this.tEdit.add(this.bUndo);
        this.tEdit.add(this.bRedo);
        this.tEdit.add(this.bCopy);
        this.tEdit.add(this.bCut);
        this.tEdit.add(this.bPaste);
        this.tHelp.add(this.bInfomation);
        this.toolbar.setLayout(new FlowLayout(0));
        this.toolbar.add(this.tFile);
        this.toolbar.add(this.tEdit);
        this.toolbar.add(this.tHelp);
        this.getContentPane().setLayout(new BorderLayout());
        if ("1".equals(UserPreferences.getSystemPreferences().getData("SHOW_TOOL_BAR"))) {
            this.getContentPane().add((Component)this.toolbar, "North");
        }
        this.setJMenuBar(this.menuBar);
        this.st.setLayout(new BorderLayout());
        this.st.add(this.sta);
        this.getContentPane().add((Component)this.st, "South");
        this.sta.setText("GTI Builder");
        this.mEdit.setEnabled(false);
        this.addWindowListener(this);
        StringArray stringArray = new StringArray();
        stringArray.add("FILE", this.mFile);
        stringArray.add("EDIT", this.mEdit);
        stringArray.add("TOOLS", this.mTools);
        stringArray.add("PROJECT", this.mProject);
        stringArray.add("HELP", this.mHelp);
        this.pm.setKeyMenuItems(stringArray);
        this.pm.setJMenuBar(this.menuBar);
        this.pm.addWindow(this);
        this.getContentPane().add("Center", this.pm);
        if (this.debug) {
            this.menuBar.add(this.mDebug);
            MemoryMonitor memoryMonitor = new MemoryMonitor();
            this.st.add((Component)memoryMonitor.getJProgressBar(), "West");
            this.pm.addWindow(new DebugWindow());
        }
        this.setEditMenuEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object == this.mNew) {
                this.pm.newFile();
            }
            if (object == this.bNew) {
                this.pm.newFile();
            }
            if (object == this.mQuit) {
                this.exit();
            }
            if (object == this.mClose) {
                this.pm.closeProject();
            }
            if (object == this.mFilePreference) {
                this.pm.getProject().showFilePreference();
            }
            if (object == this.mProjectPreference) {
                this.pm.getProject().showProjectPreference();
            }
            if (object == this.mCopy) {
                this.pm.getProject().copy();
            }
            if (object == this.mCut) {
                this.pm.getProject().cut();
            }
            if (object == this.mPaste) {
                this.pm.getProject().paste();
            }
            if (object == this.bCopy) {
                this.pm.getProject().copy();
            }
            if (object == this.bCut) {
                this.pm.getProject().cut();
            }
            if (object == this.bPaste) {
                this.pm.getProject().paste();
            }
            if (object == this.mDelete) {
                this.pm.getProject().delete();
            }
            if (object == this.mUndo) {
                this.pm.getProject().undo();
            }
            if (object == this.mRedo) {
                this.pm.getProject().redo();
            }
            if (object == this.bUndo) {
                this.pm.getProject().undo();
            }
            if (object == this.bRedo) {
                this.pm.getProject().redo();
            }
            if (object == this.mSave) {
                this.pm.getProject().save();
            }
            if (object == this.bSave) {
                this.pm.getProject().save();
            }
            if (object == this.mSaveAs) {
                this.pm.getProject().saveAs();
            }
            if (object == this.bSaveAs) {
                this.pm.getProject().saveAs();
            }
            if (object == this.mPrint) {
                this.pm.getProject().print();
            }
            if (object == this.mOpen) {
                this.pm.openProject();
            }
            if (object == this.bOpen) {
                this.pm.openProject();
            }
            if (object == this.mAddFile) {
                this.pm.getProject().addFile();
            }
            if (object == this.mRemoveFile) {
                this.pm.getProject().removeEditor();
            }
            if (object == this.mPreference) {
                new Preference((Frame)this, true, this.pm).show();
            }
            if (object == this.mRestart) {
                this.restart();
            }
            if (object == this.mInfomation) {
                new Help((Frame)this, true).show();
            }
            if (object == this.bInfomation) {
                new Help((Frame)this, true).show();
            }
            if (object == this.mLicense) {
                this.showLicense();
            }
        }
        catch (Throwable throwable) {
            ErrorDialog.showError(throwable);
        }
    }

    private void showLicense() {
        Object object;
        Object object2;
        Toolkit toolkit = this.getToolkit();
        final JDialog jDialog = new JDialog((Frame)this, true);
        jDialog.setTitle("License");
        ((Component)jDialog).setBounds((toolkit.getScreenSize().width - 800) / 2, (toolkit.getScreenSize().height - 500) / 2, 800, 500);
        jDialog.getContentPane().setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        try {
            object2 = (class$jp$sourceforge$gtibuilder$main$Main == null ? (class$jp$sourceforge$gtibuilder$main$Main = MainWindow.class$("jp.sourceforge.gtibuilder.main.Main")) : class$jp$sourceforge$gtibuilder$main$Main).getResourceAsStream("/License.txt");
            object = new ByteArrayOutputStream();
            int n = 0;
            while ((n = ((InputStream)object2).read()) != -1) {
                ((ByteArrayOutputStream)object).write(n);
            }
            ((InputStream)object2).close();
            ((ByteArrayOutputStream)object).close();
            String string = new String(((ByteArrayOutputStream)object).toByteArray());
            jTextArea.setText(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = new JPanel();
        ((Container)object2).setLayout(new FlowLayout());
        object = new JButton("OK");
        ((Container)object2).add((Component)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
        jDialog.getContentPane().add((Component)object2, "South");
        jDialog.show();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void setStatus(String string) {
        this.sta.setText(string);
    }

    public void showProgressBar() {
        this.st.add((Component)this.sb, "East");
    }

    public void hideProgressBar() {
        this.st.remove(this.sb);
    }

    public JProgressBar getProgressBar() {
        return this.sb;
    }

    public static MainWindow getMainWindow() {
        return mainFrame;
    }

    public void updataLookAndFeel() {
        this.pm.getWindowManager().updataLookAndFeel();
        SwingUtilities.updateComponentTreeUI(this.sb);
    }

    public void restart() {
        if (this.pm.exit()) {
            this.pm.getWindowManager().restart();
            FileDataBase.clear();
            UserPreferences.getSystemPreferences().saveData();
            UserPreferences.clearSystem();
            TextColoring.reset();
            DebugWindow.reset();
            Enumeration enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                Thread thread = (Thread)enumeration.nextElement();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            System.gc();
            Main.main(new String[0]);
        }
    }

    public void exit() {
        if (this.pm.exit()) {
            this.pm.getWindowManager().restart();
            FileDataBase.clear();
            UserPreferences.getSystemPreferences().saveData();
            UserPreferences.clearSystem();
            DebugWindow.reset();
            Enumeration enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                Thread thread = (Thread)enumeration.nextElement();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            System.exit(0);
        }
    }

    public void addBlockExitThread(Thread thread) {
        this.threads.addElement(thread);
    }

    public ProjectManager getProjectManager() {
        return this.pm;
    }

    public void setUndoMenu(String string, boolean bl, EditorComponent editorComponent) {
        if (this.pm.getProject().getSelectedEditor().getEditorComponent() == editorComponent) {
            this.mUndo.setText(string);
            this.mUndo.setEnabled(bl);
        }
    }

    public void setRedoMenu(String string, boolean bl, EditorComponent editorComponent) {
        if (this.pm.getProject().getSelectedEditor().getEditorComponent() == editorComponent) {
            this.mRedo.setText(string);
            this.mRedo.setEnabled(bl);
        }
    }

    public void setEditMenuEnabled(boolean bl) {
        this.mEdit.setEnabled(bl);
        this.bCopy.setEnabled(bl);
        this.bCut.setEnabled(bl);
        this.bPaste.setEnabled(bl);
        this.bUndo.setEnabled(bl);
        this.bRedo.setEnabled(bl);
    }

    public void addEditorMenuItem(JMenuItem[] jMenuItemArray) {
        this.removeEditorMenuItem();
        this.editorMenu = jMenuItemArray;
        this.mEdit.addSeparator();
        for (int i = 0; i < this.editorMenu.length; ++i) {
            this.mEdit.add(this.editorMenu[i]);
        }
    }

    public void removeEditorMenuItem() {
        if (this.editorMenu == null) {
            return;
        }
        for (int i = 0; i < this.editorMenu.length; ++i) {
            this.mEdit.remove(this.editorMenu[i]);
        }
        this.mEdit.remove(this.mEdit.getMenuComponentCount() - 1);
        this.editorMenu = null;
    }

    public void setSaveMenuEnabled(boolean bl) {
        this.mSave.setEnabled(bl);
        this.bSave.setEnabled(bl);
        this.mSaveAs.setEnabled(bl);
        this.bSaveAs.setEnabled(bl);
        this.mProject.setEnabled(bl);
        if (!bl) {
            this.setEditMenuEnabled(false);
        }
    }

    public void startDebug() {
        if (!this.debug) {
            this.menuBar.add(this.mDebug);
            MemoryMonitor memoryMonitor = new MemoryMonitor();
            this.st.add((Component)memoryMonitor.getJProgressBar(), "West");
            this.debug = true;
            Debug.setDebug(this.debug);
            this.pm.addWindow(new DebugWindow());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MemoryMonitor
    implements ActionListener,
    MouseListener {
        private Timer timer = new Timer(200, this);
        private JProgressBar pb = new JProgressBar();
        int count = 0;

        public MemoryMonitor() {
            this.timer.start();
            this.pb.setStringPainted(true);
            this.pb.setMaximum((int)Runtime.getRuntime().totalMemory() / 1024);
            this.pb.addMouseListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runtime runtime = Runtime.getRuntime();
            this.pb.setMaximum((int)runtime.totalMemory() / 1024);
            this.pb.setValue((int)(runtime.freeMemory() / 1024L));
            this.pb.setString("" + (int)(runtime.freeMemory() / 1024L) + "kB/" + runtime.totalMemory() / 1024L + "kB");
            Thread.yield();
            Thread.yield();
            Thread.yield();
            Thread.yield();
            Thread.yield();
            Thread.yield();
        }

        public JProgressBar getJProgressBar() {
            return this.pb;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            System.gc();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

