/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.build;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import jp.sourceforge.gtibuilder.build.BuildPreference;
import jp.sourceforge.gtibuilder.build.Export;
import jp.sourceforge.gtibuilder.io.UserPreferences;
import jp.sourceforge.gtibuilder.main.ProjectFile;
import jp.sourceforge.gtibuilder.plugin.Plugin;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class Build
implements Plugin,
ActionListener {
    private JMenuItem[] menus = new JMenuItem[4];
    private JMenu menu = null;
    private ProjectManager manager = null;
    public final String CLASS_PATH = "CLASS_PATH";

    public Build() {
        this.menus[0] = new JMenuItem(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/build/Bundle").getString("Build.Build"));
        this.menus[1] = new JMenuItem(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/build/Bundle").getString("Build.Run"));
        this.menus[2] = new JMenuItem(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/build/Bundle").getString("Build.Build&Run"));
        this.menus[3] = new JMenuItem(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/build/Bundle").getString("Build.Build&Run_Preference"));
        this.menu = new JMenu(ResourceBundle.getBundle("jp/sourceforge/gtibuilder/build/Bundle").getString("Build.Build"));
        this.menu.add(this.menus[0]);
        this.menu.add(this.menus[1]);
        this.menu.add(this.menus[2]);
        this.menu.add(this.menus[3]);
        this.menus[0].addActionListener(this);
        this.menus[1].addActionListener(this);
        this.menus[2].addActionListener(this);
        this.menus[3].addActionListener(this);
        this.menus[2].setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/development/Application16.gif")));
    }

    public JMenuItem[] getJMenuItem() {
        return this.menus;
    }

    public int getMenuAddPoint() {
        return -1;
    }

    public JMenu getJMenu() {
        return this.menu;
    }

    public String getPluginName() {
        return "Build";
    }

    public String getPluginVersion() {
        return "0.0";
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.manager = projectManager;
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        new Thread(){

            public void run() {
                if (actionEvent.getSource().equals(Build.this.menus[0])) {
                    Build.this.build();
                } else if (actionEvent.getSource().equals(Build.this.menus[1])) {
                    Build.this.exec();
                } else {
                    if (actionEvent.getSource().equals(Build.this.menus[2])) {
                        if (Build.this.build()) {
                            Build.this.exec();
                        }
                        return;
                    }
                    if (actionEvent.getSource().equals(Build.this.menus[3])) {
                        BuildPreference buildPreference = new BuildPreference(Build.this.manager.getProject());
                        buildPreference.show();
                        Build.this.manager.getProject().setMainClass(buildPreference.getMainClass());
                        Build.this.manager.getProject().setInfomation("CLASS_PATH", buildPreference.getClassPath());
                    }
                }
            }
        }.start();
    }

    public boolean build() {
        if (this.manager.getProject() == null) {
            return false;
        }
        Export export = (Export)this.manager.getPluginManager().getPlugin("Export");
        File file = new File(System.getProperty("user.home") + File.separator + ".GTI_BUILDER_OPTION" + File.separator + "Build" + File.separator + TextBuffer.replace(this.manager.getProject().getProjectName(), " ", "_"));
        export.export(file);
        ProjectFile[] projectFileArray = this.manager.getProject().getProjectFiles();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n < projectFileArray.length) {
            if (!projectFileArray[n].getFileType().getExtension().equals("java")) {
                ++n;
                continue;
            }
            if (projectFileArray[n].isCompiled()) {
                ++n;
                continue;
            }
            if ("".equals(projectFileArray[n].getDirectory()) || projectFileArray[n].getDirectory() == null) {
                stringBuffer.append(file.getAbsolutePath() + File.separator + projectFileArray[n].getFileName());
            } else {
                stringBuffer.append(file.getAbsolutePath() + File.separator + TextBuffer.replace(projectFileArray[n].getDirectory(), "/", File.separator) + File.separator + projectFileArray[n].getFileName());
            }
            stringBuffer.append(" ");
            ++n;
            ++n2;
        }
        if (n2 == 0) {
            return true;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("javac");
        stringBuffer2.append(" ");
        stringBuffer2.append("-encoding");
        stringBuffer2.append(" ");
        stringBuffer2.append("UTF-8");
        stringBuffer2.append(" ");
        stringBuffer2.append("-classpath");
        stringBuffer2.append(" ");
        stringBuffer2.append(file.getAbsolutePath());
        if (this.manager.getProject().getInfomation("CLASS_PATH") != null && !this.manager.getProject().getInfomation("CLASS_PATH").equals("")) {
            stringBuffer2.append(File.pathSeparator);
            stringBuffer2.append(this.manager.getProject().getInfomation("CLASS_PATH"));
        }
        stringBuffer2.append(" ");
        stringBuffer2.append(stringBuffer.toString());
        try {
            Process process = Runtime.getRuntime().exec(stringBuffer2.toString());
            OutputFrame outputFrame = new OutputFrame(process, ResourceBundle.getBundle("jp/sourceforge/gtibuilder/build/Bundle").getString("Build.Build"), stringBuffer2.toString());
            this.manager.getProject().addInternalFrame(outputFrame);
            outputFrame.setVisible(true);
            outputFrame.getThread().join();
            if (outputFrame.isSucceed()) {
                for (n2 = 0; n2 < projectFileArray.length; ++n2) {
                    projectFileArray[n2].compiled();
                }
            }
            return outputFrame.isSucceed();
        }
        catch (IOException iOException) {
            ErrorDialog.showError(iOException);
        }
        catch (Exception exception) {
            ErrorDialog.showError(exception);
        }
        return false;
    }

    public void exec() {
        if (this.manager.getProject() == null) {
            return;
        }
        File file = new File(UserPreferences.getPreferenceDirectory() + File.separator + "Build" + File.separator + TextBuffer.replace(this.manager.getProject().getProjectName(), " ", "_"));
        if (!file.exists()) {
            JOptionPane.showInternalMessageDialog((Component)((Object)this.manager.getProject().getProjectFiles()[0]), ResourceBundle.getBundle("jp/sourceforge/gtibuilder/build/Bundle").getString("Build.This_project_is_not_compiled."));
            return;
        }
        String string = "java -classpath " + file.getAbsolutePath() + " " + this.manager.getProject().getMainClass();
        try {
            Process process = Runtime.getRuntime().exec(string);
            OutputFrame outputFrame = new OutputFrame(process, "Run", string);
            this.manager.getProject().addInternalFrame(outputFrame);
            outputFrame.setVisible(true);
        }
        catch (IOException iOException) {
            ErrorDialog.showError(iOException);
        }
        catch (Exception exception) {
            ErrorDialog.showError(exception);
        }
    }

    public void closeProject(Project project) {
        File file = new File(UserPreferences.getPreferenceDirectory() + File.separator + "Build" + File.separator + TextBuffer.replace(project.getProjectName(), " ", "_"));
        this.deleteDirectory(file);
    }

    public void exit() {
        File file = new File(System.getProperty("user.home") + File.separator + ".GTI_BUILDER_OPTION" + File.separator + "Build");
        this.deleteDirectory(file);
    }

    protected void deleteDirectory(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.deleteDirectory(new File(stringArray[i]));
            }
        }
        file.delete();
    }

    class OutputFrame
    extends JInternalFrame
    implements Runnable,
    KeyListener,
    InternalFrameListener {
        BufferedReader sbr = null;
        BufferedReader ebr = null;
        PrintWriter out = null;
        JTextArea ta = null;
        boolean stop = false;
        boolean succeed = false;
        Process process = null;
        Thread thread = null;
        StringBuffer buff = new StringBuffer();

        public OutputFrame(Process process, String string, String string2) {
            super(string, true, true, true, true);
            Thread thread;
            this.sbr = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.ebr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            this.out = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));
            this.ta = new JTextArea(string2 + "\n");
            this.getContentPane().add(new JScrollPane(this.ta));
            this.thread = thread = new Thread(this);
            this.process = process;
            this.setBounds(0, 0, 300, 200);
            this.ta.setEditable(false);
            this.ta.addKeyListener(this);
            thread.start();
            Build.this.manager.getWindowManager().addWindow(this, Build.this.manager.getProject());
        }

        public Thread getThread() {
            return this.thread;
        }

        public boolean isSucceed() throws IllegalThreadStateException {
            if (!this.stop) {
                throw new IllegalThreadStateException();
            }
            return this.succeed;
        }

        public void run() {
            while (!this.stop) {
                int n = 0;
                try {
                    boolean bl = true;
                    try {
                        n = this.process.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        bl = false;
                    }
                    if (!bl) {
                        String string = null;
                        while ((string = this.sbr.readLine()) != null) {
                            this.ta.setText(this.ta.getText() + string + "\n");
                        }
                        string = null;
                        while ((string = this.ebr.readLine()) != null) {
                            this.ta.setText(this.ta.getText() + string + "\n");
                        }
                    } else {
                        this.sbr.close();
                        this.ebr.close();
                        this.out.close();
                        this.stop = true;
                    }
                }
                catch (IOException iOException) {
                    ErrorDialog.showError(iOException);
                }
                try {
                    Thread.sleep(100L);
                    Thread.yield();
                    Thread.yield();
                    Thread.yield();
                    Thread.yield();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.process.exitValue() == 0) {
                this.ta.setText(this.ta.getText() + "Done. " + this.process.exitValue());
                this.succeed = true;
            } else {
                this.ta.setText(this.ta.getText() + "Done. " + this.process.exitValue());
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!this.stop) {
                if (keyEvent.getKeyCode() == 8 && this.buff.length() != 0) {
                    this.buff = new StringBuffer(this.buff.substring(0, this.buff.length() - 1));
                    this.ta.setText(this.ta.getText().substring(0, this.ta.getText().length() - 1));
                }
                if (keyEvent.getKeyCode() == 48 || keyEvent.getKeyCode() == 49 || keyEvent.getKeyCode() == 50 || keyEvent.getKeyCode() == 51 || keyEvent.getKeyCode() == 52 || keyEvent.getKeyCode() == 53 || keyEvent.getKeyCode() == 54 || keyEvent.getKeyCode() == 55 || keyEvent.getKeyCode() == 56 || keyEvent.getKeyCode() == 57 || keyEvent.getKeyCode() == 65 || keyEvent.getKeyCode() == 66 || keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 68 || keyEvent.getKeyCode() == 69 || keyEvent.getKeyCode() == 70 || keyEvent.getKeyCode() == 71 || keyEvent.getKeyCode() == 72 || keyEvent.getKeyCode() == 73 || keyEvent.getKeyCode() == 74 || keyEvent.getKeyCode() == 75 || keyEvent.getKeyCode() == 76 || keyEvent.getKeyCode() == 77 || keyEvent.getKeyCode() == 78 || keyEvent.getKeyCode() == 79 || keyEvent.getKeyCode() == 80 || keyEvent.getKeyCode() == 81 || keyEvent.getKeyCode() == 82 || keyEvent.getKeyCode() == 83 || keyEvent.getKeyCode() == 84 || keyEvent.getKeyCode() == 85 || keyEvent.getKeyCode() == 87 || keyEvent.getKeyCode() == 88 || keyEvent.getKeyCode() == 89 || keyEvent.getKeyCode() == 90 || keyEvent.getKeyCode() == 96 || keyEvent.getKeyCode() == 97 || keyEvent.getKeyCode() == 98 || keyEvent.getKeyCode() == 99 || keyEvent.getKeyCode() == 100 || keyEvent.getKeyCode() == 101 || keyEvent.getKeyCode() == 102 || keyEvent.getKeyCode() == 103 || keyEvent.getKeyCode() == 104 || keyEvent.getKeyCode() == 105 || keyEvent.getKeyCode() == 61 || keyEvent.getKeyCode() == 45 || keyEvent.getKeyCode() == 512 || keyEvent.getKeyCode() == 513 || keyEvent.getKeyCode() == 44 || keyEvent.getKeyCode() == 514 || keyEvent.getKeyCode() == 515 || keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 516 || keyEvent.getKeyCode() == 517 || keyEvent.getKeyCode() == 520 || keyEvent.getKeyCode() == 46 || keyEvent.getKeyCode() == 521 || keyEvent.getKeyCode() == 522 || keyEvent.getKeyCode() == 59 || keyEvent.getKeyCode() == 47 || keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 523) {
                    this.buff.append(keyEvent.getKeyChar());
                    this.ta.setText(this.ta.getText() + keyEvent.getKeyChar());
                    if (keyEvent.getKeyChar() == '\n') {
                        this.out.print(this.buff.toString());
                        this.out.flush();
                    }
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            if (!this.stop) {
                this.process.destroy();
            }
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }
    }
}

