package jp.wda.gpss.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

import jp.wda.gpss.Progress;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.AttributeException;
import jp.wda.gpss.system.AttributeContainer;

/**
 * ɒPXML쐬pNX
 *
 * @version	1.00		2003/07/07
 * @since		1.00007	2003/06/08
 * @author	amoi
 */
public class SimpleXMLCreator implements AttributeContainer {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * m[hw肵ăIuWFNg\zRXgN^
	 * @param name m[h
	 */
	public SimpleXMLCreator(String name) {
		this(name, null);
	}

	/* ***********************************************************************>> */;
	/**
	 * m[hw肵ăIuWFNg\zRXgN^
	 * @param name m[h
	 * @param socklet XMLMSocklet
	 */
	public SimpleXMLCreator(String name, Socklet socklet) {
		super();
		setName(name);
		setText("");
		this.socklet = socklet;

		attr = new Hashtable();
		children = new LinkedList();
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ŗLꗗ
	 */
	private Hashtable attr;
	/**
	 * qm[hꗗ
	 */
	private LinkedList children;
	/**
	 * eLXgm[h
	 */
	private String text;

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Socklet
	 */
	private Socklet socklet;
	/**
	 *	Socklet擾<BR>
	 *	@return Socklet
	 */
	public Socklet getSocklet() {
		return socklet;
	}
	/**
	 *	Sockletݒ肷<BR>
	 *	@param s ݒl<BR>
	 */
	public void setSocklet(Socklet s) {
		socklet = s;
	}

	/* ***********************************************************************>> */;
	/**
	 *	m[h<BR>
	 */
	private String name = null;
	/**
	 *	m[h擾<BR>
	 *	@return m[h
	 */
	public String getName() {
		return name;
	}
	/**
	 *	m[hݒ肷<BR>
	 *	@param s ݒl<BR>
	 */
	public void setName(String s) {
		name = s;
	}

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLlݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, Object)
	 */
	public final void setAttribute(Object key, Object value) {
		attr.put(key, value);
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLl擾܂B<BR>
	 * @param key ŗL
	 * @return ŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttribute(Object)
	 */
	public final Object getAttribute(Object key) {
		return attr.get(key);
	}
	/**
	 * ŗLɊi[ĂSĂ̑ꗗSetr[擾܂B<BR>
	 * @return ꗗSetr[<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributes()
	 */
	public Set getAttributes() {
		return attr.entrySet();
	}
	/**
	 * w肳ꂽ̌ŗLݒ肳Ă邩mF܂B<BR>
	 * @param key ŗL<BR>
	 * @return w肳ꂽݒ肳Ăΐ^<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#containsAttributeKey(Object)
	 */
	public boolean containsAttributeKey(Object key) {
		return attr.containsKey(key);
	}
	/**
	 * ŗLɊi[Ă鑮ꗗSetr[擾܂B<BR>
	 * @return ꗗSetr[<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeKeys()
	 */
	public Set getAttributeKeys() {
		return attr.keySet();
	}
	/**
	 * w肳ꂽ̌ŗL폜܂B<BR>
	 * @param key ŗL<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#removeAttribute(Object)
	 */
	public Object removeAttribute(Object key) {
		return attr.remove(key);
	}

	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLlݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, int)
	 */
	public final void setAttribute(Object key, int value) {
		attr.put(key, new Integer(value));
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLl𐮐lƂĎ擾܂B<BR>
	 * @param key ŗL
	 * @return ŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeInt(Object)
	 */
	public final int getAttributeInt(Object key) throws AttributeException {
		Object ret = attr.get(key);
		if (ret instanceof Integer) {
			return ((Integer) ret).intValue();
		}
		throw new AttributeException("w肳ꂽ(" + key + ")int^ł͂܂B");
	}
	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLl𒷐lƂĐݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, long)
	 */
	public final void setAttribute(Object key, long value) {
		attr.put(key, new Long(value));
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLl𒷐lƂĎ擾܂B<BR>
	 * @param key ŗL
	 * @return ŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeLong(Object)
	 */
	public final long getAttributeLong(Object key) throws AttributeException {
		Object ret = attr.get(key);
		if (ret instanceof Long) {
			return ((Long) ret).longValue();
		}
		throw new AttributeException("w肳ꂽ(" + key + ")long^ł͂܂B");
	}
	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLllƂĐݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗLl<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, double)
	 */
	public final void setAttribute(Object key, double value) {
		attr.put(key, new Double(value));
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLllƂĎ擾܂B<BR>
	 * @param key ŗL
	 * @return ŗLl
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeLong(Object)
	 */
	public final double getAttributeDouble(Object key)
		throws AttributeException {
		Object ret = attr.get(key);
		if (ret instanceof Double) {
			return ((Double) ret).doubleValue();
		}
		throw new AttributeException("w肳ꂽ(" + key + ")double^ł͂܂B");
	}
	/**
	 * ̃IuWFNgɁAw肳ꂽǑŗLl^UlƂĐݒ肵܂<BR>
	 * @param key ŗL<BR>
	 * @param value ŗL^Ul<BR>
	 * @see jp.wda.gpss.system.AttributeContainer#setAttribute(Object, boolean)
	 */
	public final void setAttribute(Object key, boolean value) {
		attr.put(key, new Boolean(value));
	}
	/**
	 * ̃IuWFNgɐݒ肳ĂAw肳ꂽǑŗLl^UlƂĎ擾܂B<BR>
	 * @param key ŗL
	 * @return ŗL^Ul
	 * @see jp.wda.gpss.system.AttributeContainer#getAttributeBoolean(Object)
	 */
	public final boolean getAttributeBoolean(Object key)
		throws AttributeException {
		Object ret = attr.get(key);
		if (ret instanceof Boolean) {
			return ((Boolean) ret).booleanValue();
		}
		throw new AttributeException("w肳ꂽ(" + key + ")boolean^ł͂܂B");
	}

	/* ***********************************************************************>> */;
	/**
	 * ̃m[hɎqm[hǉ܂
	 * @param name qm[h
	 * @return ǉꂽqm[h
	 */
	public SimpleXMLCreator addChild(String name) {
		SimpleXMLCreator child = new SimpleXMLCreator(name, socklet);
		children.add(child);
		return child;
	}
	/**
	 * ̃m[hɎqm[hǉ܂
	 * @param child ǉqm[h
	 */
	public void addChild(SimpleXMLCreator child) {
		children.add(child);
	}
	/**
	 * w肳ꂽqm[h폜܂
	 * @param child 폜qm[h
	 */
	public void removeChild(SimpleXMLCreator child) {
		children.remove(child);
	}
	/**
	 * w肳ꂽO͂߂̎qm[h폜܂
	 * @param name 폜qm[h
	 */
	public void removeChild(String name) {
		Iterator it = children.iterator();
		while (it.hasNext()) {
			SimpleXMLCreator child = (SimpleXMLCreator) it.next();
			if (child.getName().equals(name)) {
				it.remove();
				return;
			}
		}
	}
	/**
	 * w肳ꂽOSĂ̎qm[h폜܂
	 * @param name 폜qm[h
	 */
	public void removeChildren(String name) {
		Iterator it = children.iterator();
		while (it.hasNext()) {
			SimpleXMLCreator child = (SimpleXMLCreator) it.next();
			if (child.getName().equals(name)) {
				it.remove();
			}
		}
	}
	/**
	 * SĂ̎qm[h폜܂
	 */
	public void removeChildren() {
		children = new LinkedList();
	}
	/**
	 * ̃m[hɐݒ肳ĂASĂ̎qm[h擾܂B
	 * @return qm[hꗗ
	 */
	public List getChildren() {
		return new LinkedList(children);
	}
	/**
	 * ̃m[hɐݒ肳ĂAw肵OׂĂ̎qm[h擾܂B
	 * @param name 擾qm[h
	 * @return qm[hꗗ
	 */
	public List getChildren(String name) {
		List list = new LinkedList();
		Iterator it = children.iterator();
		while (it.hasNext()) {
			SimpleXMLCreator child = (SimpleXMLCreator) it.next();
			if (child.getName().equals(name)) {
				list.add(child);
			}
		}
		return list;
	}
	/**
	 * ̃m[hɐݒ肳ĂAqm[h擾܂B
	 * @return qm[h
	 */
	public int sizeOfChildren() {
		return children.size();
	}
	/**
	 * ̃m[hɐݒ肳ĂAw肳ꂽԂ̎qm[h擾܂B
	 * @param idx ݒ菇ԍ ԏ߂ɐݒ肳ꂽm[h0łB
	 * @return qm[h
	 */
	public SimpleXMLCreator getChild(int idx) {
		if (idx >= children.size()) {
			return null;
		}
		return (SimpleXMLCreator) children.get(idx);
	}
	/**
	 * ̃m[hɐݒ肳ĂAw肳ꂽO͂߂̎qm[h擾܂
	 * @param name 폜qm[h
	 * @return qm[h
	 */
	public SimpleXMLCreator getChild(String name) {
		Iterator it = children.iterator();
		while (it.hasNext()) {
			SimpleXMLCreator child = (SimpleXMLCreator) it.next();
			if (child.getName().equals(name)) {
				return child;
			}
		}
		return null;
	}
	/**
	 * eLXgm[hݒ
	 * @param textNode eLXgm[h
	 */
	public void setText(String textNode) {
		text = textNode;
	}
	/**
	 * eLXgm[h擾
	 * @return eLXgm[h
	 */
	public String getText() {
		return text;
	}

	/* ***********************************************************************>> */;
	/**
	 * RXgN^Ŏw肳ꂽSockletɏSNCAgɁA
	 * ̃IuWFNgɐݒ肳ĂXML`̕𑗐M܂B
	 */
	public void send() {
		if (socklet == null) {
			return;
		}
		socklet.sendToAllClients(toString());
	}
	/**
	 * RXgN^Ŏw肳ꂽSockletɏNCAg̓A
	 * w肳ꂽ̃NCAgɂ̂
	 * ̃IuWFNgɐݒ肳ĂXML`̕𑗐M܂B
	 * @param finder MNCAgpIuWFNg
	 */
	public void send(Finder finder) {
		if (socklet == null) {
			return;
		}
		socklet.sendToClients(toString(), finder);
	}
	/**
	 * RXgN^Ŏw肳ꂽSockletɏNCAg̓A
	 * w肳ꂽ̃NCAgɂ̂
	 * ̃IuWFNgɐݒ肳ĂXML`̕𑗐M܂B
	 * @param condition MNCAǧ
	 */
	public void send(String condition) {
		if (socklet == null) {
			return;
		}
		socklet.sendToClients(toString(), condition);
	}
	/**
	 * w肳ꂽNCAg
	 * ̃IuWFNgɐݒ肳ĂXML`̕𑗐M܂B
	 * @param client MNCAg
	 */
	public void send(SocketProcessor client) {
		if (client == null) {
			return;
		}
		client.send(toString());
	}

	/* ***********************************************************************>> */;
	/**
	 * ̃IuWFNgXML`ŕ\ꂽԂ܂B
	 * 
	 * @return ̃IuWFNgXML`ŕ\ꂽ
	 */
	public String toString() {
		StringBuffer ret = new StringBuffer("<");
		ret.append(name);

		Set attributes = getAttributes();
		Iterator it = attributes.iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry) it.next();

			Object value = entry.getValue();
			value = convertEntity(value);

			ret.append(' ');
			ret.append(entry.getKey());
			ret.append("=\"");
			ret.append(value);
			ret.append("\"");
		}
		if (children.size() == 0 && text == "") {
			ret.append(" />");
			return ret.toString();
		}

		ret.append('>');
		ret.append(convertEntity(text));
		for (int i = 0; i < children.size(); i++) {
			ret.append(children.get(i));
		}
		ret.append("</");
		ret.append(name);
		ret.append('>');

		return ret.toString();
	}
	/**
	 * XMLGeBeBQƂւ̕ϊ
	 * @param text ϊÕeLXg
	 * @return ϊ̃eLXg
	 */
	private Object convertEntity(Object text) {
		String str;
		StringBuffer buf;
		char c;
		String entity;

		if (text != null && text instanceof String) {
			str = (String) text;
			buf = new StringBuffer(str.length() + 20);
		} else {
			return text;
		}

		for (int i = 0; i < str.length(); i++) {
			c = str.charAt(i);
			switch (c) {
				case '<' :
					buf.append("&lt;");
					break;
				case '>' :
					buf.append("&gt;");
					break;
				case '\'' :
					buf.append("&apos;");
					break;
				case '\"' :
					buf.append("&quot;");
					break;
				case '&' :
					buf.append("&amp;");
					break;
				default :
					buf.append(c);
					break;
			}
		}
		return buf.toString();
	}

	// NX\bh ///////////////////////////////////////////////////////////////////
	//                                                                   Class Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽXML͂AVSimpleXMLCreatorIuWFNg\z܂B
	 * 
	 * @param xml ͂XML
	 * @param socklet ĂяoSocklet
	 * @return ͂ꂽSimpleXMLCreatorIuWFNg
	 */
	public static SimpleXMLCreator parse(String xml, Socklet socklet) {
		// XML
		StringReader reader = new StringReader(xml);
		Document doc = null;
		try {
			doc = new SAXBuilder().build(reader);
		} catch (JDOMException e) {
			if (socklet != null) {
				socklet.log(
					"w肳ꂽXML͉͂ł܂B\r\nXML:" + xml,
					Progress.ERROR,
					e);
			} else {
				System.out.println("w肳ꂽXML͉͂ł܂B\r\nXML:" + xml);
				System.out.println(e.getMessage());
			}
			return null;
		} catch (IOException e) {
			if (socklet != null) {
				socklet.log(
					"w肳ꂽXML͒IOO܂B\r\nXML:" + xml,
					Progress.ERROR,
					e);
			} else {
				System.out.println("w肳ꂽXML͒IOO܂B\r\nXML:" + xml);
				System.out.println(e.getMessage());
			}
			return null;
		} finally {
			reader.close();
		}
		if (doc == null) {
			if (socklet != null) {
				socklet.log(
					"XML̉͂Ɏs܂B\r\nXML:" + xml,
					Progress.ERROR,
					null);
			} else {
				System.out.println("XML̉͂Ɏs܂B\r\nXML:" + xml);
			}
			return null;
		}

		// XMLIuWFNg쐬
		Element root = doc.getRootElement();
		SimpleXMLCreator ret = new SimpleXMLCreator(root.getName(), socklet);
		setXMLElements(ret, root);
		return ret;
	}

	/**
	 * w肳ꂽXML͂AVSimpleXMLCreatorIuWFNg\z܂B<BR>
	 * ̃\bh́Aparse(String xml, null)Ɠ`łB
	 * 
	 * @param xml ͂XML
	 * @return ͂ꂽSimpleXMLCreatorIuWFNg
	 */
	public static SimpleXMLCreator parse(String xml) {
		return parse(xml, null);
	}

	private static void setXMLElements(SimpleXMLCreator xml, Element element) {
		xml.setText(element.getTextTrim());
		List attrs = element.getAttributes();

		for (int i = 0; i < attrs.size(); i++) {
			Attribute attr = (Attribute) attrs.get(i);
			xml.setAttribute(attr.getName(), attr.getValue());
		}

		List children = element.getChildren();
		for (int i = 0; i < children.size(); i++) {
			Element child = (Element) children.get(i);
			SimpleXMLCreator childxml = xml.addChild(child.getName());
			setXMLElements(childxml, child);
		}
	}

	public static void main(String[] args) {
		SimpleXMLCreator node = new SimpleXMLCreator("node");
		node.setAttribute("attr", "<Test>=\"value\"");
		System.out.println(node);
	}
}

