/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "xlerror.h"

XL_SEXP * xl_gv_flame_initial();
XL_SEXP * xl_default_gbview_url();

L_CHAR * default_peripheral = 0;
L_CHAR * default_parameter = 0;
char gv_flame_initial_done = 0;

void
init_gv_flame_initial(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"default-gbview-url"),
			get_func_prim(xl_default_gbview_url,FO_APPLICATIVE,0,1,1));
	set_env(env, l_string(std_cm,"gv-flame-initial"),
			get_func_prim(xl_gv_flame_initial,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_gv_flame_initial(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a_e,
		XL_SYM_FIELD * sf)
{
L_CHAR * parameter, * peripheral;
	change_pri(0,5);

	parameter = get_sf_attribute(sf,l_string(std_cm,"parameter"));
	if ( ! parameter )
		parameter = default_parameter;
	if ( ! parameter )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"gv-flame-initial"),
			List(n_get_string("parameter is not specified"),
				-1));

ss_printf("parameter = %ls\n",parameter);


	peripheral = get_sf_attribute(sf,l_string(std_cm,"peripheral"));	
	if ( ! peripheral )
		peripheral = default_peripheral;

if ( peripheral )
ss_printf("peripheral = %ls\n",peripheral);


	loading_file(parameter,peripheral,0);
	start_gbview();
	
	gv_flame_initial_done  = 1;
	wakeup_task((int)&gv_flame_initial_done);
	return 0;
}

XL_SEXP *
xl_default_gbview_url(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a_e,
		XL_SYM_FIELD * sf)
{
L_CHAR * str;

	str = get_sf_attribute(sf,l_string(std_cm,"parameter"));
	if ( str )
		default_parameter = ll_copy_str(str);

	str = get_sf_attribute(sf,l_string(std_cm,"peripheral"));
	if ( str )
		default_peripheral = ll_copy_str(str);

	return 0;
}
